/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.CarparkHostReloadListener;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.DBConfigCache;
import com.wovoe.carpark.EquipmentLoader;
import com.wovoe.carpark.ManagedPassChannelChangedListenner;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassChannelManager;
import com.wovoe.carpark.dao.ApplicationDao;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkChannelArea;
import com.wovoe.carpark.dto.CarparkChannelEquipment;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkEquipment;
import com.wovoe.carpark.dto.CarparkEquipmentConfig;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkSpaceAdjustment;
import com.wovoe.carpark.dto.CarparkSpaceType;
import com.wovoe.carpark.dto.CarparkSpaceTypeDefine;
import com.wovoe.carpark.dto.CarparkSpaceTypeQuantity;
import com.wovoe.carpark.dto.CarparkSpecialDate;
import com.wovoe.carpark.dto.CarparkStrategy;
import com.wovoe.carpark.dto.CarparkTranConfig;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.DbTableTrigger;
import com.wovoe.framework.dao.SearchParam;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.session.SqlSession;

public class DefaultDBServiceConfigCache
implements DBConfigCache,
DbTableTrigger {
    private Map<String, CarparkArea> areaMap;
    private Map<String, CarparkChannel> channelMap;
    private Map<String, ChannelArea> channelAreaMap;
    private Map<String, CarparkHost> hostsMap;
    private Map<String, List<String>> areaChanelsMap;
    private Map<String, CarparkDiscountProject> discoutProjectMap;
    private Map<String, String> displaySpaceInfoMap;
    private volatile boolean _init;
    private final Object localPassChannelManagerLock = new Object();
    private Map<String, String> strategyMap;
    private Map<String, CarparkCarType> carTypeMap;
    private Map<String, CarparkPassportType> passportTypesMap;
    private Map<Integer, Map<String, CarparkAttribute>> atrributeTypeMap;
    private Map<Date, Integer> specialDateTypeMap;
    private Map<String, Method[]> updateTablesMap;
    private CopyOnWriteArraySet<CarparkHostReloadListener> carparkHostReloadListeners = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<ManagedPassChannelChangedListenner> managedPassChannelChangedListenners = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, Method[]> delayReloadMethodsMap = new ConcurrentHashMap();
    private Map<String, String> spaceTypeMap;
    private List<CarparkSpaceTypeQuantity> spaceTypeQuantityList;
    private List<CarparkSpaceTypeDefine> spaceTypeDefineList;
    private Map<Integer, String> payMethodMap;
    private Map<Integer, String> paySceneMap;
    private Map<Integer, String> chargeOrgMap;
    private Map<String, List<ChannelEquipmentVo>> channelEquipmentVoListMap;
    private Map<String, KeyValueEntry<Long, AtomicInteger>> adjustTakeSpacesMap = new ConcurrentHashMap<String, KeyValueEntry<Long, AtomicInteger>>();
    private volatile boolean needTriggerServerCameraChage = false;
    private boolean hasETC = false;

    @Override
    public Integer getCarparkId() {
        return ServiceUtil.getServiceContext().getCarparkId();
    }

    @Override
    public Map<String, CarparkArea> getAreasMap() {
        return this.areaMap;
    }

    @Override
    public List<String> getAllSbuArea(String areaNo) {
        LinkedList<String> list = new LinkedList<String>();
        if (areaNo == null || areaNo.length() == 0) {
            return list;
        }
        Map<String, CarparkArea> amap = this.getAreasMap();
        if (amap == null) {
            return list;
        }
        CarparkArea area = amap.get(areaNo);
        if (area == null) {
            return list;
        }
        List<CarparkArea> children = area.getChildren();
        if (children == null || children.isEmpty()) {
            return list;
        }
        for (CarparkArea c : children) {
            this.addSubareaNos(list, c);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> getAllParentArea(String areaNo) {
        list = new LinkedList<String>();
        if (areaNo == null || areaNo.length() == 0) {
            return list;
        }
        amap = this.getAreasMap();
        if (amap == null) {
            return list;
        }
        area = amap.get(areaNo);
        if (area != null) ** GOTO lbl13
        return list;
        while ((area = amap.get(area.getParent_area_no())) != null) {
            list.add(area.getArea_no());
lbl13:
            // 2 sources

            if (area.getParent_area_no() != null && area.getParent_area_no().length() > 0 && !area.getParent_area_no().equals(area.getArea_no())) continue;
        }
        return list;
    }

    private void addSubareaNos(List<String> list, CarparkArea area) {
        if (area != null) {
            list.add(area.getArea_no());
            List<CarparkArea> children = area.getChildren();
            if (children != null && !children.isEmpty()) {
                for (CarparkArea c : children) {
                    this.addSubareaNos(list, c);
                }
            }
        }
    }

    @Override
    public Map<String, CarparkChannel> getChannelsMap() {
        return this.channelMap;
    }

    @Override
    public Map<String, CarparkHost> getHostsMap() {
        return this.hostsMap;
    }

    @Override
    public Map<String, CarparkDiscountProject> getDiscountProjectMap() {
        return this.discoutProjectMap;
    }

    @Override
    public CarparkHost getCarparkServerHost() {
        Map<String, CarparkHost> hMap = this.getHostsMap();
        if (hMap != null) {
            for (Map.Entry<String, CarparkHost> e : hMap.entrySet()) {
                CarparkHost h = e.getValue();
                if (h.getHost_use() == null || h.getHost_use() != 2 && h.getHost_use() != 3) continue;
                return h;
            }
        }
        return null;
    }

    @Override
    public Map<String, ChannelArea> getChannelAreas() {
        return this.channelAreaMap;
    }

    @Override
    public Map<String, String> getStrategyMap() {
        return this.strategyMap;
    }

    @Override
    public Map<String, List<String>> getAreaChannelsMap() {
        return this.areaChanelsMap;
    }

    @Override
    public Map<String, CarparkCarType> getCarTypeMap() {
        return this.carTypeMap;
    }

    @Override
    public Map<String, CarparkPassportType> getPassportTypeMap() {
        return this.passportTypesMap;
    }

    @Override
    public Map<Integer, Map<String, CarparkAttribute>> getAttributeTypeMap() {
        return this.atrributeTypeMap;
    }

    public void loadCache() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this._init) {
            DefaultDBServiceConfigCache defaultDBServiceConfigCache = this;
            synchronized (defaultDBServiceConfigCache) {
                if (!this._init) {
                    this.doInit();
                    this._init = true;
                }
            }
        }
    }

    private void doInit() {
        this.loadAllCarparkArea();
        this.loadAllCarparkHosts();
        this.loadAllChannelAreas();
        this.loadAllChannels();
        this.loadALLChannelEquipmentVos();
        this.loadAllStrategyMap();
        this.loadAllCarTypeMap();
        this.loadAllPassportTypeMap();
        this.loadAllAttributeTypeMap();
        this.loadAllSpecialDateTypeMap();
        this.loadAllSpaceType();
        this.loadAllSpaceTypeQuantityList();
        this.loadAllSpaceTypeDefineList();
        this.loadAllDiscoutProjectMap();
        this.loadDisplaySpaceInfoMap();
        this.loadAllTranConfigMap();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List adjList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()), CarparkSpaceAdjustment.class, null);
        if (adjList != null && !adjList.isEmpty()) {
            for (CarparkSpaceAdjustment adj : adjList) {
                if (!this.areaMap.containsKey(adj.getArea_no())) {
                    commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkSpaceAdjustment.class)).addEQ("id", (Object)adj.getId()));
                    continue;
                }
                if (adj.getSpace_type_no() != null && adj.getSpace_type_no().length() > 0) {
                    List<CarparkSpaceTypeQuantity> spaceTypeQuantityList0 = this.spaceTypeQuantityList;
                    boolean exist = false;
                    if (spaceTypeQuantityList0 != null) {
                        for (CarparkSpaceTypeQuantity q : spaceTypeQuantityList0) {
                            if (!adj.getArea_no().equals(q.getArea_no()) || !adj.getSpace_type_no().equals(q.getSpace_type_no())) continue;
                            exist = true;
                            break;
                        }
                    }
                    if (!exist) {
                        commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkSpaceAdjustment.class)).addEQ("id", (Object)adj.getId()));
                        continue;
                    }
                }
                AtomicInteger a = new AtomicInteger();
                a.set(adj.getPresent_adjust());
                this.adjustTakeSpacesMap.put(this.getAdjustTakeSpacesKey(adj.getArea_no(), adj.getSpace_type_no()), (KeyValueEntry<Long, AtomicInteger>)new KeyValueEntry((Object)adj.getId(), (Object)a));
            }
        }
    }

    public void loadCarpark() {
        ServiceUtil.getServiceContext().reloadCarpark();
    }

    public void loadCarparkLocalConfig() {
        ServiceUtil.getServiceContext().reloadCarparkLocalConfig();
    }

    private Map<String, CarparkArea> loadAllCarparkArea() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List areaList = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("area_level,id"), CarparkArea.class, null);
        LinkedHashMap<String, CarparkArea> areaMap0 = new LinkedHashMap<String, CarparkArea>();
        if (areaList != null) {
            Integer topLevel = null;
            for (CarparkArea area : areaList) {
                CarparkArea a;
                areaMap0.put(area.getArea_no(), area);
                if (topLevel == null) {
                    topLevel = area.getArea_level();
                }
                if (topLevel.intValue() == area.getArea_level().intValue() || (a = (CarparkArea)areaMap0.get(area.getParent_area_no())) == null) continue;
                List<CarparkArea> l = a.getChildren();
                if (l == null) {
                    l = new LinkedList<CarparkArea>();
                    a.setChildren(l);
                }
                l.add(area);
            }
        }
        Map<String, CarparkArea> mm = Collections.unmodifiableMap(areaMap0);
        this.areaMap = mm;
        if (this.displaySpaceInfoMap != null) {
            this.loadDisplaySpaceInfoMap();
        }
        return mm;
    }

    private static Queue<CarparkArea> newQueue(final boolean z) {
        return new PriorityQueue<CarparkArea>(10, new Comparator<CarparkArea>(){

            @Override
            public int compare(CarparkArea o1, CarparkArea o2) {
                if (z) {
                    return o1.getArea_level().compareTo(o2.getArea_level());
                }
                return 0 - o1.getArea_level().compareTo(o2.getArea_level());
            }
        });
    }

    private List<CarparkArea> toUnmodifyList(Queue<?> queue) {
        if (queue != null && !queue.isEmpty()) {
            CarparkArea x;
            ArrayList<CarparkArea> list = new ArrayList<CarparkArea>(queue.size());
            while ((x = (CarparkArea)queue.poll()) != null) {
                list.add(x);
            }
            return Collections.unmodifiableList(list);
        }
        return null;
    }

    private void loadAllChannelAreas() {
        HashMap areaChanelsMap0 = new HashMap();
        LinkedHashMap<String, ChannelArea0> channelAreaMap0 = new LinkedHashMap<String, ChannelArea0>();
        Map<String, CarparkArea> areaMap0 = this.areaMap;
        if (areaMap0 == null) {
            areaMap0 = this.loadAllCarparkArea();
        }
        if (areaMap0 != null && !areaMap0.isEmpty()) {
            ArrayList<String> area_nos = new ArrayList<String>(areaMap0.keySet());
            HashMap<String, Queue[]> cache = new HashMap<String, Queue[]>();
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List carparkChannelAreaList = daoService.selectList(new SearchParam().addINList("area_no", area_nos).setOrerbySql("area_no"), CarparkChannelArea.class, null);
            if (carparkChannelAreaList != null && !carparkChannelAreaList.isEmpty()) {
                for (CarparkChannelArea row : carparkChannelAreaList) {
                    Queue[] x;
                    String channelNo = row.getChannel_no();
                    if (channelNo == null) continue;
                    CarparkArea area = areaMap0.get(row.getArea_no());
                    if (area == null) {
                        ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u533a\u57df\u7f16\u53f7\u4e3a:" + row.getArea_no() + " \u533a\u57df\uff0c\u901a\u9053\u4e0e\u533a\u57df\u5173\u8054\u8868!"));
                        continue;
                    }
                    LinkedList<String> chids = (LinkedList<String>)areaChanelsMap0.get(row.getArea_no());
                    if (chids == null) {
                        chids = new LinkedList<String>();
                        areaChanelsMap0.put(row.getArea_no(), chids);
                    }
                    if (!chids.contains(channelNo)) {
                        chids.add(channelNo);
                    }
                    if ((x = (Queue[])cache.get(channelNo)) == null) {
                        x = new Queue[]{DefaultDBServiceConfigCache.newQueue(true), DefaultDBServiceConfigCache.newQueue(false)};
                        cache.put(channelNo, x);
                    }
                    if (row.getChannel_direction() == 0) {
                        x[0].offer(area);
                        continue;
                    }
                    x[1].offer(area);
                }
            }
            for (Map.Entry e : cache.entrySet()) {
                ChannelArea0 c = new ChannelArea0();
                c.channelNo = (String)e.getKey();
                c.carparkId = this.getCarparkId();
                c.enterAreas = this.toUnmodifyList(((Queue[])e.getValue())[0]);
                c.exitAreas = this.toUnmodifyList(((Queue[])e.getValue())[1]);
                channelAreaMap0.put(c.channelNo, c);
            }
        }
        this.channelAreaMap = Collections.unmodifiableMap(channelAreaMap0);
        this.areaChanelsMap = Collections.unmodifiableMap(areaChanelsMap0);
    }

    private void loadAllCarparkHosts() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List hostlist = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkHost.class, null);
        LinkedHashMap<String, CarparkHost> hostsMap0 = new LinkedHashMap<String, CarparkHost>();
        if (hostlist != null) {
            for (CarparkHost host : hostlist) {
                hostsMap0.put(host.getHost_no(), host);
            }
        }
        this.hostsMap = Collections.unmodifiableMap(hostsMap0);
        try {
            if (hostlist != null) {
                for (CarparkHost host : hostlist) {
                    for (CarparkHostReloadListener l : this.carparkHostReloadListeners) {
                        try {
                            l.onReload(host);
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
        }
        finally {
            ServiceUtil.getServiceContext().getPermissionManager().checkHostLoginPermission(this.hostsMap);
        }
        if (!hostsMap0.containsKey(ServiceUtil.getServiceContext().getLocalHostNo())) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u81f4\u547d\u9519\u8bef\uff1a\u672c\u673a\u5df2\u7ecf\u88ab\u7ba1\u7406\u5458\u79fb\u9664\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u7cfb\u7edf\u5c06\u5728\u4e00\u5206\u949f\u540e\u9000\u51fa\uff01", 4, 120000));
            ServiceUtil.getServiceContext().delay(new JobTask(){

                protected void doRun() throws Exception {
                    if (DefaultDBServiceConfigCache.this.getHostsMap() != null && DefaultDBServiceConfigCache.this.getHostsMap().get(ServiceUtil.getServiceContext().getLocalHostNo()) == null) {
                        System.exit(0);
                    }
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }

    void loadAllEquipment() {
        Enumeration<PassChannel> hvs;
        String localHostNo;
        CarparkHost localhost;
        if (this.hostsMap == null) {
            this.loadAllCarparkHosts();
        }
        String hostName = (localhost = this.hostsMap.get(localHostNo = ServiceUtil.getServiceContext().getLocalHostNo())) != null ? localhost.getHost_name() : "";
        EquipmentLoader.loadEquipment(localHostNo, hostName, true, false, null);
        if (this.needTriggerServerCameraChage) {
            EquipmentLoader.loadServerAllCamreaIfParkingServer(false);
        }
        if ((hvs = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
            while (hvs.hasMoreElements()) {
                CarparkHost host;
                PassChannel ch = hvs.nextElement();
                if (!ch.isOtherHostChannel() || (host = ch.getManagerHost()) == null) continue;
                EquipmentLoader.loadEquipment(host.getHost_no(), host.getHost_name(), false, false, null);
            }
        }
    }

    void unRegisterNotExistHostEquipment() {
        EquipmentLoader.destoryNotExsitHostEq();
    }

    private void loadALLChannelEquipmentVos() {
        LinkedHashMap map = new LinkedHashMap();
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession sqlSession = daoService.openSqlSession();){
            ApplicationDao applicationDao = (ApplicationDao)sqlSession.getMapper(ApplicationDao.class);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("carparkId", ServiceUtil.getServiceContext().getCarparkId());
            paramMap.put("projectId", ServiceUtil.getServiceContext().getProjectId());
            List<ChannelEquipmentVo> list = applicationDao.queryChannelEqVoList(paramMap);
            HashSet<String> cameraNoSet = new HashSet<String>();
            LinkedList<ChannelEquipmentVo> cameraList = new LinkedList<ChannelEquipmentVo>();
            if (list != null && !list.isEmpty()) {
                for (ChannelEquipmentVo vo : list) {
                    if (vo.getChannel_no() == null || vo.getChannel_no().length() == 0) continue;
                    LinkedList<ChannelEquipmentVo> l = (LinkedList<ChannelEquipmentVo>)map.get(vo.getChannel_no());
                    if (l == null) {
                        l = new LinkedList<ChannelEquipmentVo>();
                        map.put(vo.getChannel_no(), l);
                    }
                    if (vo.getEquipment_no() != null && vo.getEquipment_no().length() > 0) {
                        l.add(vo);
                    }
                    if (vo.getEquipment_type() == null || vo.getEquipment_type() != 33) continue;
                    cameraList.add(vo);
                    cameraNoSet.add(vo.getEquipment_no());
                }
            }
            if (!cameraList.isEmpty()) {
                LinkedList<String> configKeyList = new LinkedList<String>();
                configKeyList.add("login_user");
                configKeyList.add("login_pwd");
                configKeyList.add("userName");
                configKeyList.add("userPwd_secret_key");
                configKeyList.add("userPwd");
                configKeyList.add("port");
                configKeyList.add("internetMediaStreamType");
                SearchParam sp = new SearchParam(daoService.getTableName(CarparkEquipmentConfig.class));
                sp.setQueryFields(new String[]{"equipment_no", "config_key", "config_value"});
                sp.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                if (cameraNoSet.size() == 1) {
                    sp.addEQ("equipment_no", ServiceUtil.getFirstElement(cameraNoSet));
                } else {
                    sp.addINList("equipment_no", cameraNoSet);
                }
                sp.addINList("config_key", configKeyList);
                List configList = daoService.selectList(sp, CarparkEquipmentConfig.class, null);
                if (configList != null && !configList.isEmpty()) {
                    HashMap<String, HashMap<String, String>> configMap = new HashMap<String, HashMap<String, String>>();
                    for (CarparkEquipmentConfig config : configList) {
                        HashMap<String, String> m = (HashMap<String, String>)configMap.get(config.getEquipment_no());
                        if (m == null) {
                            m = new HashMap<String, String>();
                            configMap.put(config.getEquipment_no(), m);
                        }
                        m.put(config.getConfig_key(), config.getConfig_value());
                    }
                    for (ChannelEquipmentVo vo : cameraList) {
                        if (vo.getEquipment_type() == null || vo.getEquipment_type() != 33) continue;
                        this.setChannelEquipmentVoCameraConfig(vo, (Map)configMap.get(vo.getEquipment_no()));
                    }
                }
            }
        }
        this.channelEquipmentVoListMap = Collections.unmodifiableMap(map);
        this.checkETC();
    }

    @Override
    public ChannelEquipmentVo getChannelEquipmentVo(String equipmentNo) {
        Map<String, List<ChannelEquipmentVo>> channelEquipmentVoListMap;
        if (equipmentNo != null && equipmentNo.length() > 0 && (channelEquipmentVoListMap = this.getChannelEquipmentVoListMap()) != null && !channelEquipmentVoListMap.isEmpty()) {
            for (List<ChannelEquipmentVo> list : channelEquipmentVoListMap.values()) {
                if (list == null) continue;
                for (ChannelEquipmentVo vo : list) {
                    if (!equipmentNo.equals(vo.getEquipment_no())) continue;
                    return vo;
                }
            }
        }
        return null;
    }

    private void setChannelEquipmentVoCameraConfig(ChannelEquipmentVo vo, Map<String, String> config) {
        if (vo == null) {
            return;
        }
        if (config == null) {
            config = Collections.emptyMap();
        }
        if ("wlyk_hikvision_ip_regplate_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(8000);
            vo.setOnvifPort(80);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd_secret_key");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "";
            } else {
                try {
                    userPwd = new String(BytesTool.unCompress((String)userPwd), "UTF-8");
                }
                catch (Exception ex) {
                    userPwd = "";
                }
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wovoe_Hikvision_sxczjklx_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(8000);
            vo.setOnvifPort(80);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "";
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wlyk_uniview_ip_regplate_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(80);
            vo.setOnvifPort(8000);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd_secret_key");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "";
            } else {
                try {
                    userPwd = new String(BytesTool.unCompress((String)userPwd), "UTF-8");
                }
                catch (Exception ex) {
                    userPwd = "";
                }
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wovoe_zhenshi_ip_camera_driver".equals(vo.getEquipment_driver()) || "wlyk_zsrg_ip_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(80);
            vo.setOnvifPort(8000);
            String userName = config.get("login_user");
            String userPwd = config.get("login_pwd");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "admin";
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wovoe_ice_ip_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(8000);
            vo.setOnvifPort(8080);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "123456";
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wovoe_qy_ip_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(80);
            vo.setOnvifPort(8080);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd");
            if (userName == null || userName.length() == 0) {
                userName = "admin";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "admin";
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else if ("wlyk_onvif_common_ip_camera_driver".equals(vo.getEquipment_driver())) {
            vo.setHttpPort(80);
            String _port = config.get("port");
            int onfPort = 80;
            if (_port != null && _port.length() > 0) {
                try {
                    onfPort = Integer.parseInt(_port);
                    if (onfPort <= 0 || onfPort >= 65535) {
                        onfPort = 80;
                    }
                }
                catch (Exception internetMediaStreamType) {
                    // empty catch block
                }
            }
            vo.setOnvifPort(onfPort);
            String userName = config.get("userName");
            String userPwd = config.get("userPwd_secret_key");
            if (userName == null || userName.length() == 0) {
                userName = "";
            }
            if (userPwd == null || userPwd.length() == 0) {
                userPwd = "";
            } else {
                try {
                    userPwd = new String(BytesTool.unCompress((String)userPwd), "UTF-8");
                }
                catch (Exception ex) {
                    userPwd = "";
                }
            }
            vo.setOnvifUserName(userName);
            vo.setOnvifUserPwd(userPwd);
            String internetMediaStreamType = config.get("internetMediaStreamType");
            if (internetMediaStreamType == null || internetMediaStreamType.length() == 0) {
                internetMediaStreamType = "main_stream";
            }
            vo.setInternetMediaStreamType(internetMediaStreamType);
        } else {
            ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + vo.getEquipment_name() + ", " + vo.getEquipment_driver() + ", \u4e3a\u5b8c\u6210 onvif\u8bbe\u7f6e\uff0c\u8fd9\u4f1a\u5bfc\u81f4\u6b64\u76f8\u673a\u5916\u7f51\u63a8\u6d41\u5f02\u5e38"));
        }
    }

    @Override
    public Map<String, List<ChannelEquipmentVo>> getChannelEquipmentVoListMap() {
        return this.channelEquipmentVoListMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllChannels() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List channelList = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkChannel.class, null);
        LinkedHashMap<String, CarparkChannel> channelMap0 = new LinkedHashMap<String, CarparkChannel>();
        LinkedHashMap<String, CarparkChannel> localManagerChanelMap = new LinkedHashMap<String, CarparkChannel>();
        if (channelList != null) {
            for (CarparkChannel c : channelList) {
                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 2 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_type() == 1 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                    String x = c.getSlave_managed_host_no();
                    String x1 = c.getManaged_host_no();
                    c.setSlave_managed_host_no(x1);
                    c.setManaged_host_no(x);
                }
                channelMap0.put(c.getChannel_no(), c);
                if (c.getManaged_host_no() == null || c.getManaged_host_no().length() <= 0 || !c.getManaged_host_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) continue;
                localManagerChanelMap.put(c.getChannel_no(), c);
            }
        }
        this.channelMap = Collections.unmodifiableMap(channelMap0);
        Object object = this.localPassChannelManagerLock;
        synchronized (object) {
            PassChannelManager manager = ServiceUtil.getServiceContext().getPassChannelManager();
            Enumeration<PassChannel> channels = manager.getChannels();
            LinkedList<String> deleteList = null;
            while (channels.hasMoreElements()) {
                PassChannel c = channels.nextElement();
                if (localManagerChanelMap.containsKey(c.getChannelNo()) || c.isOtherHostChannel()) continue;
                if (deleteList == null) {
                    deleteList = new LinkedList<String>();
                }
                deleteList.add(c.getChannelNo());
            }
            boolean addOrRemove = false;
            if (deleteList != null && !deleteList.isEmpty()) {
                addOrRemove = true;
                for (String t : deleteList) {
                    manager.unregister(t);
                }
            }
            for (CarparkChannel channel : localManagerChanelMap.values()) {
                if (!addOrRemove && manager.getPassChannel(channel.getChannel_no()) == null) {
                    addOrRemove = true;
                }
                manager.regisger(channel);
            }
            if (addOrRemove) {
                for (ManagedPassChannelChangedListenner l : this.managedPassChannelChangedListenners) {
                    try {
                        l.onManageChannelChanged(manager.getChannels());
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public String getGlobalStrategyValue(String key) {
        return this.getStrategyValue(key, null, null, null, null, null);
    }

    @Override
    public String getCarparkStrategyValue(String key) {
        return this.getStrategyValue(key, this.getCarparkId(), null, null, null, null);
    }

    @Override
    public String getAreaStrategyValue(String areaNo, String key) {
        return this.getStrategyValue(key, this.getCarparkId(), areaNo, null, null, null);
    }

    @Override
    public String getChannelStrategyValue(String channelNo, String key) {
        return this.getStrategyValue(key, this.getCarparkId(), null, channelNo, null, null);
    }

    @Override
    public String getPassportTypeStrategyValue(String passportTypeNo, String key) {
        return this.getStrategyValue(key, this.getCarparkId(), null, null, passportTypeNo, null);
    }

    @Override
    public String getChannelPassportTypeStrategyValue(String channelNo, String passportTypeNo, String key) {
        return this.getStrategyValue(key, this.getCarparkId(), null, channelNo, passportTypeNo, null);
    }

    @Override
    public String getCarTypeStrategyValue(String carTypeNo, String key) {
        return this.getStrategyValue(key, this.getCarparkId(), null, null, null, carTypeNo);
    }

    @Override
    public String getStrategyValue(String key, Integer carparkId, String areaNo, String channelNo, String passportTypeNo, String carTypeNo) {
        return this.strategyMap.get(this.getStrategyName(key, carparkId, areaNo, channelNo, passportTypeNo, carTypeNo));
    }

    private String getStrategyName(String key, Integer carparkId, String areaNo, String channelNo, String passportTypeNo, String carTypeNo) {
        int strategy_type = 0;
        StringBuilder sb = new StringBuilder(64);
        char a = '_';
        if (carparkId != null && carparkId > 0) {
            strategy_type |= 1;
            sb.append(carparkId);
        } else {
            sb.append('0');
        }
        sb.append(a);
        if (areaNo != null && areaNo.length() > 0) {
            strategy_type |= 2;
            sb.append(areaNo);
        }
        sb.append(a);
        if (channelNo != null && channelNo.length() > 0) {
            strategy_type |= 4;
            sb.append(channelNo);
        }
        sb.append(a);
        if (passportTypeNo != null && passportTypeNo.length() > 0) {
            strategy_type |= 8;
            sb.append(passportTypeNo);
        }
        sb.append(a);
        if (carTypeNo != null && carTypeNo.length() > 0) {
            strategy_type |= 0x10;
            sb.append(carTypeNo);
        }
        sb.append(a);
        sb.append(strategy_type);
        sb.append(a);
        sb.append(key);
        return sb.toString();
    }

    private void loadAllStrategyMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List strategyList = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkStrategy.class, null);
        LinkedHashMap<String, String> strategyMap0 = new LinkedHashMap<String, String>();
        if (strategyList != null && !strategyList.isEmpty()) {
            for (CarparkStrategy g : strategyList) {
                if (g.getStrategy_value() == null || g.getStrategy_value().length() <= 0) continue;
                strategyMap0.put(this.getStrategyName(g.getStrategy_name(), g.getCarpark_id(), g.getArea_no(), g.getChannel_no(), g.getPassport_type_no(), g.getCar_type_no()), g.getStrategy_value());
            }
        }
        this.strategyMap = Collections.unmodifiableMap(strategyMap0);
    }

    private void loadAllCarTypeMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkCarType.class, null);
        LinkedHashMap<String, CarparkCarType> carTypeMap0 = new LinkedHashMap<String, CarparkCarType>();
        if (list != null && !list.isEmpty()) {
            for (CarparkCarType t : list) {
                carTypeMap0.put(t.getCar_type_no(), t);
            }
        }
        this.carTypeMap = Collections.unmodifiableMap(carTypeMap0);
        if (this.displaySpaceInfoMap != null) {
            this.loadDisplaySpaceInfoMap();
        }
    }

    private void loadAllDiscoutProjectMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkDiscountProject.class, null);
        LinkedHashMap<String, CarparkDiscountProject> discoutProjectMap0 = new LinkedHashMap<String, CarparkDiscountProject>();
        if (list != null && !list.isEmpty()) {
            for (CarparkDiscountProject t : list) {
                discoutProjectMap0.put(t.getDiscount_project_no(), t);
            }
        }
        this.discoutProjectMap = Collections.unmodifiableMap(discoutProjectMap0);
    }

    private void loadAllPassportTypeMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("id"), CarparkPassportType.class, null);
        LinkedHashMap<String, CarparkPassportType> map0 = new LinkedHashMap<String, CarparkPassportType>();
        if (list != null && !list.isEmpty()) {
            for (CarparkPassportType t : list) {
                map0.put(t.getPassport_type_no(), t);
            }
        }
        this.passportTypesMap = Collections.unmodifiableMap(map0);
        if (this.displaySpaceInfoMap != null) {
            this.loadDisplaySpaceInfoMap();
        }
    }

    private void loadAllAttributeTypeMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("attribute_type,id"), CarparkAttribute.class, null);
        LinkedHashMap<Integer, LinkedHashMap<String, CarparkAttribute>> map0 = new LinkedHashMap<Integer, LinkedHashMap<String, CarparkAttribute>>();
        if (list != null && !list.isEmpty()) {
            for (CarparkAttribute t : list) {
                LinkedHashMap<String, CarparkAttribute> x = (LinkedHashMap<String, CarparkAttribute>)map0.get(t.getAttribute_type());
                if (x == null) {
                    x = new LinkedHashMap<String, CarparkAttribute>();
                    map0.put(t.getAttribute_type(), x);
                }
                x.put(t.getAttribute_key(), t);
            }
        }
        this.atrributeTypeMap = Collections.unmodifiableMap(map0);
    }

    private void checkETC() {
        Map<String, List<ChannelEquipmentVo>> channelEquipmentVoListMap = this.channelEquipmentVoListMap;
        if (channelEquipmentVoListMap != null) {
            boolean hasEtc = false;
            for (List<ChannelEquipmentVo> voList : channelEquipmentVoListMap.values()) {
                for (ChannelEquipmentVo v : voList) {
                    if (v.getEquipment_type() == null || v.getEquipment_type() != 34) continue;
                    hasEtc = true;
                    break;
                }
                if (hasEtc) break;
            }
            if (hasEtc) {
                this.hasETC = true;
            }
        }
        if (this.hasETC) {
            Map<Integer, String> paySceneMap0;
            Map<Integer, String> payMethodMap0 = this.payMethodMap;
            if (payMethodMap0 != null && !payMethodMap0.isEmpty() && !payMethodMap0.containsKey(6)) {
                LinkedHashMap<Integer, String> payMethodMap1 = new LinkedHashMap<Integer, String>();
                payMethodMap1.putAll(payMethodMap0);
                payMethodMap1.put(6, "ETC");
                this.payMethodMap = Collections.unmodifiableMap(payMethodMap1);
            }
            if ((paySceneMap0 = this.paySceneMap) != null && !paySceneMap0.isEmpty() && !paySceneMap0.containsKey(5)) {
                LinkedHashMap<Integer, String> paySceneMap1 = new LinkedHashMap<Integer, String>();
                paySceneMap1.putAll(paySceneMap0);
                paySceneMap1.put(5, "\u65e0\u611f/\u514d\u5bc6\u652f\u4ed8");
                this.paySceneMap = Collections.unmodifiableMap(paySceneMap1);
            }
        }
    }

    private void loadAllTranConfigMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()).setOrerbySql("tran_config_type,id"), CarparkTranConfig.class, null);
        LinkedHashMap<Integer, String> payMethodMap0 = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, String> paySceneMap0 = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, String> chargeOrgMap0 = new LinkedHashMap<Integer, String>();
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            payMethodMap0.put(0, "\u73b0\u91d1");
            payMethodMap0.put(1, "\u50a8\u503c\u5361\u6263\u8d39");
            payMethodMap0.put(2, "POS\u673a\u5237\u5361");
            payMethodMap0.put(3, "\u7269\u4e1aAPP");
            payMethodMap0.put(8, "\u5176\u5b83");
            paySceneMap0.put(0, "\u5c97\u4ead\u5904\u6536\u8d39");
            paySceneMap0.put(1, "\u7ba1\u7406\u5904\u6536\u8d39");
            chargeOrgMap0.put(0, "\u8f66\u573a\u7ecf\u8425\u65b9");
        }
        if (list != null && !list.isEmpty()) {
            for (CarparkTranConfig c : list) {
                if (c.getTran_config_type() == 0) {
                    payMethodMap0.put(c.getTran_config_key(), c.getTran_config_value());
                    continue;
                }
                if (c.getTran_config_type() == 1) {
                    paySceneMap0.put(c.getTran_config_key(), c.getTran_config_value());
                    continue;
                }
                if (c.getTran_config_type() != 2) continue;
                chargeOrgMap0.put(c.getTran_config_key(), c.getTran_config_value());
            }
        }
        if (this.hasETC) {
            if (!payMethodMap0.containsKey(6)) {
                payMethodMap0.put(6, "ETC");
            }
            if (!paySceneMap0.containsKey(5)) {
                paySceneMap0.put(5, "\u65e0\u611f/\u514d\u5bc6\u652f\u4ed8");
            }
        }
        this.payMethodMap = Collections.unmodifiableMap(payMethodMap0);
        this.paySceneMap = Collections.unmodifiableMap(paySceneMap0);
        this.chargeOrgMap = Collections.unmodifiableMap(chargeOrgMap0);
    }

    @Override
    public void addCarparkHostReloadListener(CarparkHostReloadListener l) {
        this.carparkHostReloadListeners.add(l);
    }

    @Override
    public void removeCarparkHostReloadListener(CarparkHostReloadListener l) {
        this.carparkHostReloadListeners.remove(l);
    }

    public void onUpdate(int op, final String physicalTableName, Object paramData, int updateCount) throws Exception {
        Method[] old;
        Method[] ms;
        if (this.updateTablesMap == null) {
            this.getInterestedTableNames();
        }
        if ((ms = this.updateTablesMap.get(physicalTableName)) != null && ms.length > 0 && (old = this.delayReloadMethodsMap.putIfAbsent(physicalTableName, ms)) == null) {
            int delayx = 5;
            try {
                int hostUse = ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use();
                if (hostUse == 2 || hostUse == 3) {
                    delayx = 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServiceUtil.getServiceContext().delay(new JobTask(){

                protected void doRun() throws Exception {
                    Method[] ms = (Method[])DefaultDBServiceConfigCache.this.delayReloadMethodsMap.remove(physicalTableName);
                    if (ms != null && ms.length > 0) {
                        Method[] methodArray = ms;
                        int n = ms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method m = methodArray[n2];
                            if (!m.isAccessible()) {
                                m.setAccessible(true);
                            }
                            m.invoke((Object)DefaultDBServiceConfigCache.this, new Object[0]);
                            ++n2;
                        }
                    }
                }
            }, delayx, TimeUnit.SECONDS);
        }
    }

    private Method getMethod(String methodName) {
        try {
            return this.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String[] getInterestedTableNames() {
        if (this.updateTablesMap == null) {
            LinkedHashMap<String, Method[]> maps = new LinkedHashMap<String, Method[]>();
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            maps.put(daoService.getTableName(CarparkLocalConfig.class), new Method[]{this.getMethod("loadCarparkLocalConfig")});
            maps.put(daoService.getTableName(Carpark.class), new Method[]{this.getMethod("loadCarpark")});
            String carparkArea = daoService.getTableName(CarparkArea.class);
            maps.put(carparkArea, new Method[]{this.getMethod("loadAllCarparkArea")});
            String carparkChannelArea = daoService.getTableName(CarparkChannelArea.class);
            maps.put(carparkChannelArea, new Method[]{this.getMethod("loadAllCarparkArea"), this.getMethod("loadAllChannelAreas")});
            String carparkHost = daoService.getTableName(CarparkHost.class);
            maps.put(carparkHost, new Method[]{this.getMethod("loadAllCarparkHosts"), this.getMethod("unRegisterNotExistHostEquipment")});
            String carparkChannel = daoService.getTableName(CarparkChannel.class);
            maps.put(carparkChannel, new Method[]{this.getMethod("loadAllChannels"), this.getMethod("loadAllEquipment")});
            String carparkChannelEquipment = daoService.getTableName(CarparkChannelEquipment.class);
            maps.put(carparkChannelEquipment, new Method[]{this.getMethod("loadAllChannels"), this.getMethod("loadALLChannelEquipmentVos"), this.getMethod("loadAllEquipment")});
            String carparkEquipment = daoService.getTableName(CarparkEquipment.class);
            maps.put(carparkEquipment, new Method[]{this.getMethod("loadALLChannelEquipmentVos"), this.getMethod("loadAllEquipment")});
            String carparkEquipmentConfig = daoService.getTableName(CarparkEquipmentConfig.class);
            maps.put(carparkEquipmentConfig, new Method[]{this.getMethod("loadALLChannelEquipmentVos"), this.getMethod("loadAllEquipment")});
            String carparkStrategy = daoService.getTableName(CarparkStrategy.class);
            maps.put(carparkStrategy, new Method[]{this.getMethod("loadAllStrategyMap")});
            String carparkCarType = daoService.getTableName(CarparkCarType.class);
            maps.put(carparkCarType, new Method[]{this.getMethod("loadAllCarTypeMap")});
            String carparkPassportType = daoService.getTableName(CarparkPassportType.class);
            maps.put(carparkPassportType, new Method[]{this.getMethod("loadAllPassportTypeMap")});
            String carparkAttribute = daoService.getTableName(CarparkAttribute.class);
            maps.put(carparkAttribute, new Method[]{this.getMethod("loadAllAttributeTypeMap")});
            String carparkSpecialDate = daoService.getTableName(CarparkSpecialDate.class);
            maps.put(carparkSpecialDate, new Method[]{this.getMethod("loadAllSpecialDateTypeMap")});
            maps.put(daoService.getTableName(CarparkSpaceType.class), new Method[]{this.getMethod("loadAllSpaceType")});
            maps.put(daoService.getTableName(CarparkSpaceTypeQuantity.class), new Method[]{this.getMethod("loadAllSpaceTypeQuantityList")});
            maps.put(daoService.getTableName(CarparkSpaceTypeDefine.class), new Method[]{this.getMethod("loadAllSpaceTypeDefineList")});
            maps.put(daoService.getTableName(CarparkDiscountProject.class), new Method[]{this.getMethod("loadAllDiscoutProjectMap")});
            maps.put(daoService.getTableName(CarparkTranConfig.class), new Method[]{this.getMethod("loadAllTranConfigMap")});
            this.updateTablesMap = maps;
        }
        return this.updateTablesMap.keySet().toArray(new String[this.updateTablesMap.size()]);
    }

    public int getInterestedOps() {
        return 7;
    }

    @Override
    public void addManagedPassChannelChangedListenner(ManagedPassChannelChangedListenner l) {
        this.managedPassChannelChangedListenners.add(l);
    }

    @Override
    public void removeManagedPassChannelChangedListenner(ManagedPassChannelChangedListenner l) {
        this.managedPassChannelChangedListenners.remove(l);
    }

    private Map<Date, Integer> loadAllSpecialDateTypeMap() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Calendar cl = Calendar.getInstance();
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        cl.add(1, -1);
        Date beginDate = new Date(cl.getTimeInMillis());
        cl.add(1, 2);
        Date endDate = new Date(cl.getTimeInMillis());
        LinkedHashMap<Date, Integer> returnMap = new LinkedHashMap<Date, Integer>();
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addGTE("special_date", (Object)beginDate).addLTE("special_date", (Object)endDate).setOrerbySql("special_date").addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)this.getCarparkId()), CarparkSpecialDate.class, null);
        if (list != null) {
            for (CarparkSpecialDate d : list) {
                returnMap.put(d.getSpecial_date(), d.getDate_type());
            }
        }
        Map<Date, Integer> returnMap0 = Collections.unmodifiableMap(returnMap);
        this.specialDateTypeMap = returnMap0;
        return returnMap0;
    }

    @Override
    public Map<Date, Integer> getSpecialDateTypeMap() {
        return this.specialDateTypeMap;
    }

    private void loadAllSpaceType() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).addEQ("project_id", (Object)projectId).setOrerbySql("id"), CarparkSpaceType.class, null);
        LinkedHashMap<String, String> spaceTypeMap0 = new LinkedHashMap<String, String>();
        if (list != null && !list.isEmpty()) {
            for (CarparkSpaceType t : list) {
                spaceTypeMap0.put(t.getSpace_type_no(), t.getSpace_type_name());
            }
        }
        this.spaceTypeMap = Collections.unmodifiableMap(spaceTypeMap0);
        if (this.displaySpaceInfoMap != null) {
            this.loadDisplaySpaceInfoMap();
        }
    }

    @Override
    public Map<String, String> getSpaceTypeMap() {
        return this.spaceTypeMap;
    }

    private void loadAllSpaceTypeQuantityList() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        ArrayList list = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).addEQ("project_id", (Object)projectId).setOrerbySql("id"), CarparkSpaceTypeQuantity.class, null);
        if (list == null) {
            list = new ArrayList();
        }
        this.spaceTypeQuantityList = Collections.unmodifiableList(list);
        if (this.displaySpaceInfoMap != null) {
            this.loadDisplaySpaceInfoMap();
        }
    }

    @Override
    public List<CarparkSpaceTypeQuantity> getSpaceTypeQuantities() {
        return this.spaceTypeQuantityList;
    }

    @Override
    public int getSpaceQuantity(String spaceTypeNo, String areaNo) {
        if (spaceTypeNo == null || spaceTypeNo.length() == 0 || areaNo == null || areaNo.length() == 0) {
            return -1;
        }
        List<CarparkSpaceTypeQuantity> list = this.spaceTypeQuantityList;
        if (list == null || list.isEmpty()) {
            return -1;
        }
        for (CarparkSpaceTypeQuantity q : list) {
            if (!spaceTypeNo.equals(q.getSpace_type_no()) || !areaNo.equals(q.getArea_no())) continue;
            Integer x = q.getQuantity();
            if (x == null || x < 0) break;
            return x;
        }
        return -1;
    }

    private void loadAllSpaceTypeDefineList() {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        ArrayList list = daoService.selectList(new SearchParam().addEQ("carpark_id", (Object)this.getCarparkId()).addEQ("project_id", (Object)projectId).setOrerbySql("id"), CarparkSpaceTypeDefine.class, null);
        if (list == null) {
            list = new ArrayList();
        }
        this.spaceTypeDefineList = list;
    }

    @Override
    public List<CarparkSpaceTypeDefine> getSpaceTypeDefineList() {
        return this.spaceTypeDefineList;
    }

    private void loadDisplaySpaceInfoMap() {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        returnMap.put("r-a_0", "\u8f66\u573a\u603b\u4f59\u4f4d");
        Map<String, CarparkArea> areaMap = this.getAreasMap();
        if (areaMap != null) {
            for (CarparkArea area : areaMap.values()) {
                if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                    returnMap.put("r-a_" + area.getArea_no(), String.valueOf(area.getArea_name()) + "\u603b\u4f59\u4f4d");
                    returnMap.put("r-as_" + area.getArea_no(), String.valueOf(area.getArea_name()) + "\u4f59\u4f4d");
                    continue;
                }
                returnMap.put("r-a_" + area.getArea_no(), String.valueOf(area.getArea_name()) + "\u4f59\u4f4d");
            }
        }
        Map<String, CarparkPassportType> passportTypeMap = this.getPassportTypeMap();
        Map<String, CarparkCarType> carTypeMap = this.getCarTypeMap();
        Map<String, String> spaceTypeMap = this.getSpaceTypeMap();
        if (spaceTypeMap != null && !spaceTypeMap.isEmpty()) {
            for (Map.Entry entry : spaceTypeMap.entrySet()) {
                if (areaMap == null || areaMap.isEmpty()) continue;
                for (CarparkArea area : areaMap.values()) {
                    int spaceCount = this.getSpaceQuantity((String)entry.getKey(), area.getArea_no());
                    if (spaceCount > 0) {
                        if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                            returnMap.put("r-a_" + area.getArea_no() + "-d_" + (String)entry.getKey(), String.valueOf(area.getArea_name()) + (String)entry.getValue() + "\u603b\u4f59\u4f4d");
                            returnMap.put("r-a_" + area.getArea_no() + "-s_" + (String)entry.getKey(), String.valueOf(area.getArea_name()) + (String)entry.getValue() + "\u4f59\u4f4d");
                        } else {
                            returnMap.put("r-a_" + area.getArea_no() + "-d_" + (String)entry.getKey(), String.valueOf(area.getArea_name()) + (String)entry.getValue() + "\u4f59\u4f4d");
                        }
                    }
                    returnMap.put("t-a_" + area.getArea_no() + "-d_" + (String)entry.getKey(), String.valueOf(area.getArea_name()) + (String)entry.getValue() + "\u8f66\u8f86");
                }
            }
        }
        if (passportTypeMap != null) {
            for (CarparkPassportType carparkPassportType : passportTypeMap.values()) {
                returnMap.put("t-a_0-b_" + carparkPassportType.getPassport_type_no(), "\u573a\u5185" + carparkPassportType.getPassport_type_name() + "\u8f66\u8f86");
                if (areaMap == null) continue;
                for (CarparkArea area : areaMap.values()) {
                    returnMap.put("t-a_" + area.getArea_no() + "-b_" + carparkPassportType.getPassport_type_no(), String.valueOf(area.getArea_name()) + carparkPassportType.getPassport_type_name() + "\u8f66\u8f86");
                }
            }
        }
        if (carTypeMap != null) {
            for (CarparkCarType carparkCarType : carTypeMap.values()) {
                returnMap.put("t-a_0-c_" + carparkCarType.getCar_type_no(), "\u573a\u5185" + carparkCarType.getCar_type_name() + "\u8f66\u8f86");
                if (areaMap == null) continue;
                for (CarparkArea area : areaMap.values()) {
                    returnMap.put("t-a_" + area.getArea_no() + "-c_" + carparkCarType.getCar_type_name(), String.valueOf(area.getArea_name()) + carparkCarType.getCar_type_name() + "\u8f66\u8f86");
                }
            }
        }
        this.displaySpaceInfoMap = Collections.unmodifiableMap(returnMap);
    }

    @Override
    public Map<String, String> getDisplaySpaceInfoMap() {
        if (this.displaySpaceInfoMap == null) {
            this.loadDisplaySpaceInfoMap();
        }
        return this.displaySpaceInfoMap;
    }

    @Override
    public Map<Integer, String> getPayMethodMap() {
        return this.payMethodMap;
    }

    @Override
    public Map<Integer, String> getPaySceneMap() {
        return this.paySceneMap;
    }

    @Override
    public Map<Integer, String> getChargeOrgMap() {
        return this.chargeOrgMap;
    }

    @Override
    public void setNeedTriggerServerCameraChage(boolean v) {
        this.needTriggerServerCameraChage = v;
    }

    @Override
    public boolean isSupportSelfOnlinePay() {
        Map<Integer, String> m = this.paySceneMap;
        return m != null && (m.containsKey(3) || m.containsKey(4));
    }

    @Override
    public int getAdjustTakeSpaces(String areaNo, String spaceTypeNo) {
        KeyValueEntry<Long, AtomicInteger> en = this.adjustTakeSpacesMap.get(this.getAdjustTakeSpacesKey(areaNo, spaceTypeNo));
        if (en != null) {
            return ((AtomicInteger)en.getValue()).get();
        }
        return 0;
    }

    @Override
    public String getAdjustTakeSpacesKey(String areaNo, String spaceTypeNo) {
        if (areaNo == null) {
            areaNo = "";
        }
        if (spaceTypeNo == null) {
            spaceTypeNo = "";
        }
        return String.valueOf(areaNo) + "-" + spaceTypeNo;
    }

    @Override
    public Map<String, KeyValueEntry<Long, AtomicInteger>> getAdjustTakeSpaces() {
        return this.adjustTakeSpacesMap;
    }

    @Override
    public void loadAdjustTakeValue(String areaNo, String spaceTypeNo) {
        if (areaNo != null && !areaNo.isEmpty() && this.getAreasMap().containsKey(areaNo)) {
            CarparkSpaceAdjustment a;
            CommonDaoService commonDaoService;
            List adjList;
            if (spaceTypeNo == null) {
                spaceTypeNo = "";
            }
            if (spaceTypeNo.length() > 0) {
                List<CarparkSpaceTypeQuantity> spaceTypeQuantityList0 = this.spaceTypeQuantityList;
                boolean exist = false;
                if (spaceTypeQuantityList0 != null) {
                    for (CarparkSpaceTypeQuantity q : spaceTypeQuantityList0) {
                        if (!areaNo.equals(q.getArea_no()) || !spaceTypeNo.equals(q.getSpace_type_no())) continue;
                        exist = true;
                        break;
                    }
                }
                if (!exist) {
                    return;
                }
            }
            if ((adjList = (commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class)).selectList(new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("area_no", (Object)areaNo).addEQ("space_type_no", (Object)spaceTypeNo).setOrerbySql("id DESC"), CarparkSpaceAdjustment.class, null)) != null && !adjList.isEmpty() && (a = (CarparkSpaceAdjustment)adjList.get(0)) != null) {
                String key = this.getAdjustTakeSpacesKey(areaNo, spaceTypeNo);
                KeyValueEntry en = this.adjustTakeSpacesMap.get(key);
                if (en == null) {
                    en = new KeyValueEntry((Object)a.getId(), (Object)new AtomicInteger(a.getPresent_adjust()));
                    this.adjustTakeSpacesMap.put(key, (KeyValueEntry<Long, AtomicInteger>)en);
                } else {
                    ((AtomicInteger)en.getValue()).set(a.getPresent_adjust());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAdjustTakeValue(String areaNo, int type, int addValue) {
        KeyValueEntry<Long, AtomicInteger> en;
        if (areaNo != null && !areaNo.isEmpty() && this.getAreasMap().containsKey(areaNo) && addValue != 0 && (en = this.adjustTakeSpacesMap.get(this.getAdjustTakeSpacesKey(areaNo, ""))) != null) {
            KeyValueEntry<Long, AtomicInteger> keyValueEntry = en;
            synchronized (keyValueEntry) {
                int old;
                int newCout = old = ((AtomicInteger)en.getValue()).get();
                if (type == 0) {
                    newCout = old + addValue;
                } else if (old < 0 && addValue > 0 && (newCout = old + addValue) > 0) {
                    newCout = 0;
                }
                if (newCout != old) {
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    CommonParam updatp = new CommonParam(commonDaoService.getTableName(CarparkSpaceAdjustment.class));
                    updatp.addUpdate("present_adjust", (Object)newCout);
                    updatp.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                    updatp.addEQ("id", en.getKey());
                    commonDaoService.update(updatp);
                    ((AtomicInteger)en.getValue()).set(newCout);
                }
            }
        }
    }

    @Override
    public int getMinPlateCharLength() {
        try {
            int h;
            String v = this.getCarparkStrategyValue("MIN_PLATE_CHAR_LENGTH");
            if (v != null && v.length() > 0 && (h = Integer.parseInt(v)) > 0) {
                return h;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 7;
    }

    @Override
    public String getDefaultInputPlate() {
        try {
            String v1 = this.getCarparkStrategyValue("DEFAULT_PLATE_PREFIX");
            if (v1 == null || v1.length() == 0) {
                v1 = "\u7ca4B";
            }
            return v1;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static class ChannelArea0
    implements ChannelArea {
        private String channelNo;
        private Integer carparkId;
        private List<CarparkArea> enterAreas;
        private List<CarparkArea> exitAreas;

        private ChannelArea0() {
        }

        @Override
        public String getChannelNo() {
            return this.channelNo;
        }

        @Override
        public Integer getCarparkId() {
            return this.carparkId;
        }

        @Override
        public List<CarparkArea> getEnterAreas() {
            return this.enterAreas;
        }

        @Override
        public List<CarparkArea> getExitAreas() {
            return this.exitAreas;
        }
    }
}

