/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.DocumentTemplate;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class DefaultDocumentTemplate
implements DocumentTemplate {
    public static final String DEFAULT_ENCODEING = "UTF-8";
    private Configuration cfg = new Configuration();

    public DefaultDocumentTemplate(Class<?> clazz, String pathPrefix) {
        this.cfg.setClassForTemplateLoading(clazz, pathPrefix);
        this.cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        this.cfg.setDefaultEncoding(DEFAULT_ENCODEING);
        this.cfg.setOutputEncoding(DEFAULT_ENCODEING);
        this.cfg.setNumberFormat("#.##");
        this.cfg.setDateFormat("yyyy-MM-dd");
        this.cfg.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        this.cfg.setTimeFormat("HH:mm:ss");
    }

    public DefaultDocumentTemplate(File dirctory) throws IOException {
        this.cfg.setDirectoryForTemplateLoading(dirctory);
        this.cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        this.cfg.setDefaultEncoding(DEFAULT_ENCODEING);
        this.cfg.setOutputEncoding(DEFAULT_ENCODEING);
        this.cfg.setNumberFormat("#.##");
        this.cfg.setDateFormat("yyyy-MM-dd");
        this.cfg.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        this.cfg.setTimeFormat("HH:mm:ss");
    }

    @Override
    public StringBuffer createDocumentString(String templateName, Map<?, ?> rootData) throws IOException {
        return this.createDocumentString(templateName, this.cfg.getLocale(), this.cfg.getDefaultEncoding(), rootData);
    }

    @Override
    public StringBuffer createDocumentString(String templateName, Locale locale, String encoding, Map<?, ?> rootData) throws IOException {
        Template t = this.cfg.getTemplate(templateName, locale, encoding);
        StringWriter writer = new StringWriter();
        try {
            t.process(rootData, (Writer)writer);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
        return writer.getBuffer();
    }

    @Override
    public StringBuffer createTextString(String templateString, Map<?, ?> rootData) throws IOException {
        Template t = new Template("", (Reader)new StringReader(templateString), this.cfg, DEFAULT_ENCODEING);
        StringWriter writer = new StringWriter();
        try {
            t.process(rootData, (Writer)writer);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
        StringBuffer db = writer.getBuffer();
        return db;
    }

    @Override
    public StringBuffer createOneLineString(String templateString, Map<?, ?> rootData) throws IOException {
        StringBuffer db = this.createTextString(templateString, rootData);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < db.length()) {
            char c = db.charAt(i);
            if (c != ' ' && c != '\n' && c != '\t') {
                buffer.append(c);
            }
            ++i;
        }
        return buffer;
    }
}

