/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.HostEquipmentSateManager;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassChannelManager;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentManager;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.HostEquipmentSate;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultHostEquipmentSateManager
implements HostEquipmentSateManager {
    private ConcurrentHashMap<String, HostEquipmentSate> sMap = new ConcurrentHashMap();

    @Override
    public void setHostOnline(HostEquipmentSate hostEquipmentSate) {
        if (hostEquipmentSate == null) {
            return;
        }
        if (hostEquipmentSate.getHostNo() == null || hostEquipmentSate.getHostNo().length() == 0) {
            return;
        }
        hostEquipmentSate.setLastConnectedMills(ServiceUtil.getServiceContext().currentTimeMillis());
        this.sMap.put(hostEquipmentSate.getHostNo(), hostEquipmentSate);
    }

    @Override
    public void setHostOffline(String hostNo) {
        if (hostNo != null) {
            this.sMap.remove(hostNo);
        }
    }

    @Override
    public boolean isHostOnline(String hostNo) {
        if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
            return true;
        }
        return this.getHostEquipmentSate(hostNo) != null;
    }

    public boolean isLocalManagerEquipment(Equipment eq) {
        if (eq == null) {
            return false;
        }
        String awHost = (String)eq.getAttribute("EQ_OWNER_HOST_NO");
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        if (localHostNo != null && localHostNo.equals(awHost)) {
            return true;
        }
        List<String> chlist = eq.getChannelNos();
        if (chlist != null && !chlist.isEmpty()) {
            for (String channelNo : chlist) {
                if (ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getEquipmentSate(String equipmentNo) {
        Equipment eq;
        if (equipmentNo == null) {
            return EquipmentState.DISCONNECTED.name();
        }
        EquipmentManager mer = ServiceUtil.getServiceContext().getEquipmentManager();
        if (mer != null && this.isLocalManagerEquipment(eq = mer.getByEquipmentNo(equipmentNo))) {
            EquipmentState s = eq.getEquipmentState();
            if (s == null) {
                s = EquipmentState.DISCONNECTED;
            }
            return s.name();
        }
        for (HostEquipmentSate s1 : this.sMap.values()) {
            String xl;
            Map<String, String> mp;
            long lv = 0L;
            if (s1.getLastConnectedMills() != null) {
                lv = s1.getLastConnectedMills();
            }
            if (ServiceUtil.getServiceContext().currentTimeMillis() - lv > 20000L || (mp = s1.getEqSates()) == null || (xl = mp.get(equipmentNo)) == null) continue;
            return xl;
        }
        return EquipmentState.DISCONNECTED.name();
    }

    @Override
    public HostEquipmentSate getHostEquipmentSate(String hostNo) {
        if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
            return this.getLocalHostEquipmentSate();
        }
        HostEquipmentSate s1 = this.sMap.get(hostNo);
        if (s1 == null) {
            return null;
        }
        long lv = 0L;
        if (s1.getLastConnectedMills() != null) {
            lv = s1.getLastConnectedMills();
        }
        if (ServiceUtil.getServiceContext().currentTimeMillis() - lv > 20000L) {
            this.sMap.remove(hostNo);
            return null;
        }
        return s1;
    }

    @Override
    public HostEquipmentSate getLocalHostEquipmentSate() {
        Enumeration<Equipment> eqs;
        Enumeration<PassChannel> equs;
        HostEquipmentSate s = new HostEquipmentSate();
        s.setVersion(ServiceUtil.getServiceContext().getVersion());
        File f1 = new File(PathFinder.findLocalDir(), "upgrade/download/" + s.getVersion() + ".zip");
        if (f1.exists() && f1.isFile()) {
            s.setExistUpgradeFile(1);
        }
        s.setHostNo(ServiceUtil.getServiceContext().getLocalHostNo());
        LinkedList<String> selfChNos = null;
        LinkedList<String> proxyChNos = null;
        PassChannelManager channelManager = ServiceUtil.getServiceContext().getPassChannelManager();
        if (channelManager != null && (equs = channelManager.getChannels()) != null) {
            while (equs.hasMoreElements()) {
                PassChannel ch = equs.nextElement();
                if (ch == null) continue;
                if (ch.isLocalHostChannel()) {
                    if (selfChNos == null) {
                        selfChNos = new LinkedList<String>();
                    }
                    selfChNos.add(ch.getChannelNo());
                    continue;
                }
                if (proxyChNos == null) {
                    proxyChNos = new LinkedList<String>();
                }
                proxyChNos.add(ch.getChannelNo());
            }
        }
        s.setSelfChNos(selfChNos);
        s.setProxyChNos(proxyChNos);
        HashMap<String, String> eqSates = new HashMap<String, String>();
        EquipmentManager mer = ServiceUtil.getServiceContext().getEquipmentManager();
        if (mer != null && (eqs = mer.getAllEquipments()) != null) {
            while (eqs.hasMoreElements()) {
                Equipment eq = eqs.nextElement();
                if (!this.isLocalManagerEquipment(eq)) continue;
                EquipmentState es = eq.getEquipmentState();
                if (es == null) {
                    es = EquipmentState.DISCONNECTED;
                }
                eqSates.put(eq.getEquipmentNo(), es.name());
            }
        }
        s.setEqSates(eqSates);
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() != 1) {
            s.setSupportSenselessPay(ServiceUtil.getServiceContext().isSupportSenselessPay());
            Map<Integer, Map<String, String>> allConfig = ServiceUtil.getServiceContext().getAllSenselessConfig();
            if (allConfig == null || allConfig.isEmpty()) {
                s.setSenselessPayConfig(null);
            } else {
                HashMap<Integer, Map<String, String>> vMap = new HashMap<Integer, Map<String, String>>();
                for (Map.Entry<Integer, Map<String, String>> t : allConfig.entrySet()) {
                    Map<String, String> m = t.getValue();
                    if (m == null || m.isEmpty()) continue;
                    HashMap<String, String> xMap = new HashMap<String, String>();
                    vMap.put(t.getKey(), xMap);
                    String a = m.get("WL_SCA");
                    if (a == null) {
                        a = Constants.NO_STR;
                    }
                    xMap.put("WL_SCA", a);
                    a = m.get("WL_CCA");
                    if (a == null) {
                        a = Constants.NO_STR;
                    }
                    xMap.put("WL_CCA", a);
                    a = m.get("WL_PRI");
                    if (a == null) {
                        a = Constants.NO_STR;
                    }
                    xMap.put("WL_PRI", a);
                    a = m.get("WL_NAM");
                    if (a == null) {
                        a = "";
                    }
                    xMap.put("WL_NAM", a);
                }
                s.setSenselessPayConfig(vMap);
            }
        }
        return s;
    }

    @Override
    public String findProxyChannelHost(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return null;
        }
        for (Map.Entry<String, HostEquipmentSate> entry : this.sMap.entrySet()) {
            long lv = 0L;
            HostEquipmentSate s1 = entry.getValue();
            if (s1.getLastConnectedMills() != null) {
                lv = s1.getLastConnectedMills();
            }
            if (ServiceUtil.getServiceContext().currentTimeMillis() - lv > 12000L || s1.getProxyChNos() == null || !s1.getProxyChNos().contains(channelNo)) continue;
            return entry.getKey();
        }
        return null;
    }
}

