/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.MessageLog;
import com.wovoe.carpark.MessageLogHandler;
import com.wovoe.framework.LogUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DefaultMessageLog
implements MessageLog {
    private ConcurrentLinkedQueue<MessageLogHandler> handlers = new ConcurrentLinkedQueue();

    @Override
    public boolean hasHandlers() {
        return !this.handlers.isEmpty();
    }

    @Override
    public void register(MessageLogHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void remove(MessageLogHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    @Override
    public Enumeration<MessageLogHandler> getHandlers() {
        return Collections.enumeration(this.handlers);
    }

    @Override
    public void debug(Object message) {
        this.debug(null, message);
    }

    @Override
    public void debug(String channelId, Object message) {
        this.debug(channelId, message, null);
    }

    @Override
    public void debug(String channelId, Object message, Throwable e) {
        this.log((byte)1, channelId, message, e);
    }

    @Override
    public void info(Object message) {
        this.info(null, message);
    }

    @Override
    public void info(String channelId, Object message) {
        this.info(channelId, message, null);
    }

    @Override
    public void info(String channelId, Object message, Throwable e) {
        this.log((byte)2, channelId, message, e);
    }

    @Override
    public void warn(Object message) {
        this.warn(null, message);
    }

    @Override
    public void warn(String channelId, Object message) {
        this.warn(channelId, message, null);
    }

    @Override
    public void warn(String channelId, Object message, Throwable e) {
        this.log((byte)3, channelId, message, e);
    }

    @Override
    public void error(Object message) {
        this.error(null, message);
    }

    @Override
    public void error(String channelId, Object message) {
        this.error(channelId, message, null);
    }

    @Override
    public void error(String channelId, Object message, Throwable e) {
        this.log((byte)4, channelId, message, e);
    }

    private void log(byte level, String channelId, Object message, Throwable e) {
        for (MessageLogHandler h : this.handlers) {
            try {
                h.handle(level, channelId, message, e);
            }
            catch (Exception ex) {
                LogUtil.getLog().error((Object)"", (Throwable)ex);
            }
        }
    }
}

