/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassChannelManager;
import com.wovoe.carpark.PassChannelManagerListener;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.framework.JobTask;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultPassChannelManager
extends JobTask
implements PassChannelManager {
    private ConcurrentHashMap<String, PassChannel> passChannelMap = new ConcurrentHashMap();
    private CopyOnWriteArrayList<PassChannelManagerListener> passChannelManagerListeners = new CopyOnWriteArrayList();

    @Override
    public Enumeration<PassChannel> getChannels() {
        return this.passChannelMap.elements();
    }

    @Override
    public PassChannel getPassChannel(String channelNo) {
        if (channelNo == null) {
            return null;
        }
        return this.passChannelMap.get(channelNo);
    }

    @Override
    public PassChannel unregister(String channelNo) {
        if (channelNo == null) {
            return null;
        }
        PassChannel old = this.passChannelMap.remove(channelNo);
        if (old != null) {
            for (PassChannelManagerListener l : this.passChannelManagerListeners) {
                try {
                    l.onRemovePassChannel(old);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return old;
    }

    @Override
    public void regisger(CarparkChannel channel) {
        PassChannel passChannel = this.passChannelMap.get(channel.getChannel_no());
        if (passChannel != null) {
            passChannel.setCarparkChannel(channel);
        } else {
            passChannel = new PassChannel(channel);
            PassChannel old = this.passChannelMap.putIfAbsent(channel.getChannel_no(), passChannel);
            if (old != null) {
                old.setCarparkChannel(channel);
            } else {
                for (PassChannelManagerListener l : this.passChannelManagerListeners) {
                    try {
                        l.onAddPassChannel(passChannel);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public void addPassChannelManagerListener(PassChannelManagerListener l) {
        if (!this.passChannelManagerListeners.contains(l)) {
            this.passChannelManagerListeners.add(l);
        }
    }

    @Override
    public void removePassChannelManagerListener(PassChannelManagerListener l) {
        this.passChannelManagerListeners.remove(l);
    }

    @Override
    public List<PassChannel> getChannelList() {
        ArrayList<PassChannel> list = new ArrayList<PassChannel>(this.passChannelMap.size());
        list.addAll(this.passChannelMap.values());
        return list;
    }

    @Override
    public int getChannelSize() {
        return this.passChannelMap.size();
    }

    protected void doRun() throws Exception {
        for (PassChannel ch : this.passChannelMap.values()) {
            ch.checkSessionAndConfirmTimout();
        }
    }
}

