/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.framework.transfer.SecurityGetter;
import com.wovoe.framework.transfer.connection.HttpRemoteServiceProxy;

public class DefaultRpcReomtecServiceFactory
implements RpcReomtecServiceFactory {
    private String gateway;
    private int connectTimeoutMills;
    private int readTimeoutMills;
    private SecurityGetter securityGetter;

    public DefaultRpcReomtecServiceFactory(String gateway, SecurityGetter securityGetter, int connectTimeoutMills, int readTimeoutMills) {
        this.gateway = gateway;
        this.connectTimeoutMills = connectTimeoutMills;
        this.readTimeoutMills = readTimeoutMills;
        this.securityGetter = securityGetter;
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass) {
        String className = remoteServiceClass.getSimpleName();
        String remoteSerivceName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1);
        return this.crateRemoteService(remoteServiceClass, remoteSerivceName);
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass, String remoteSerivceName) {
        Object t = HttpRemoteServiceProxy.newProxy(remoteServiceClass, (String)this.getGateway(), (String)remoteSerivceName, (SecurityGetter)this.getSecurityGetter(), (int)this.getConnectTimeoutMills(), (int)this.getReadTimeoutMills());
        return (T)t;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Override
    public int getConnectTimeoutMills() {
        return this.connectTimeoutMills;
    }

    @Override
    public void setConnectTimeoutMills(int connectTimeoutMills) {
        this.connectTimeoutMills = connectTimeoutMills;
    }

    @Override
    public int getReadTimeoutMills() {
        return this.readTimeoutMills;
    }

    @Override
    public void setReadTimeoutMills(int readTimeoutMills) {
        this.readTimeoutMills = readTimeoutMills;
    }

    public void setSecurityGetter(SecurityGetter securityGetter) {
        this.securityGetter = securityGetter;
    }

    public SecurityGetter getSecurityGetter() {
        return this.securityGetter;
    }
}

