/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DelRecordJob
extends JobTask {
    protected void doRun() throws Exception {
        File picDir;
        int x2;
        String picDaysName;
        String rdaysName;
        LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
        recordMap.put("ck_carpark_cancel_pass_record", "pass_time");
        recordMap.put("ck_carpark_cloud_order_message", "created_time");
        recordMap.put("ck_carpark_discount_record", "discount_time");
        recordMap.put("ck_carpark_illegal_pass_record", "pass_time");
        recordMap.put("ck_carpark_invoice_order", "created_time");
        recordMap.put("ck_carpark_pass_record", "pass_time");
        recordMap.put("ck_carpark_pass_self_pay", "created_time");
        recordMap.put("ck_carpark_regplate_record", "reg_time");
        recordMap.put("ck_carpark_transaction", "tran_time");
        recordMap.put("ck_carpark_visit_auth_record", "created_time");
        recordMap.put("ck_carpark_operation_log", "op_time");
        int recordRemainDays = 730;
        int picRemainDays = 365;
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
            rdaysName = "CLIENT_RECORD_MAX_DAY";
            picDaysName = "CLIENT_PICTURE_MAX_DAY";
        } else {
            rdaysName = "SERVER_RECORD_MAX_DAY";
            picDaysName = "SERVER_PICTURE_MAX_DAY";
        }
        String rdays = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue(rdaysName);
        String picDays = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue(picDaysName);
        if (rdays != null && rdays.length() > 0) {
            try {
                x2 = Integer.parseInt(rdays);
                if (x2 > 0) {
                    recordRemainDays = x2;
                }
            }
            catch (Exception x2) {
                // empty catch block
            }
        }
        if (recordRemainDays <= 0) {
            recordRemainDays = 730;
        }
        if (picDays != null && picDays.length() > 0) {
            try {
                x2 = Integer.parseInt(picDays);
                if (x2 > 0) {
                    picRemainDays = x2;
                }
            }
            catch (Exception x3) {
                // empty catch block
            }
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        DelRecordJob.deleteRecords(daoService, "ck_carpark_query_fee", "query_time", 7);
        DelRecordJob.deleteRecords(daoService, "ck_carpark_plate_car_type", "last_updated_time", 365);
        for (Map.Entry en : recordMap.entrySet()) {
            DelRecordJob.deleteRecords(daoService, (String)en.getKey(), (String)en.getValue(), recordRemainDays);
        }
        DelRecordJob.deleteCarparkEscapeOrderRecords(daoService, recordRemainDays);
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 2 || ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 3) {
            DelRecordJob.deleteRecords(daoService, "ck_cloud_upload_pic", "upload_time", recordRemainDays);
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            DelRecordJob.deleteLanOnlineDispatchTask(daoService);
        } else {
            DelRecordJob.deleteRecords(daoService, "ck_carpark_dispatch_task", "created_time", 180);
        }
        DelRecordJob.delPassSelfPay(daoService);
        DelRecordJob.delPassDsicount(daoService);
        if (picRemainDays <= 0) {
            picRemainDays = 365;
        }
        Calendar cl = Calendar.getInstance();
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        cl.add(6, 0 - picRemainDays);
        final Date delPictureDate = cl.getTime();
        String[] picFieldNames = new String[]{"enter_car_pic", "enter_plate_pic", "enter_face_pic"};
        List piclist = daoService.selectList(new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).setQueryFields(picFieldNames).addLT("enter_time", (Object)delPictureDate), null);
        final HashSet<String> notDelPic = new HashSet<String>();
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        if (piclist != null && !piclist.isEmpty()) {
            for (Map en : piclist) {
                if (en == null) continue;
                String[] stringArray = picFieldNames;
                int n = picFieldNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String path;
                    File f1;
                    String s = stringArray[n2];
                    String dbpath = (String)en.get(s);
                    if (dbpath != null && dbpath.length() > 0 && (f1 = new File(path = recordSaveService.getLocalPicPath(dbpath))).exists() && f1.isFile()) {
                        notDelPic.add(f1.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        if ((picDir = PathFinder.findLocalPicDir()).exists() && picDir.isDirectory()) {
            picDir.listFiles(new FileFilter(){
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");

                @Override
                public boolean accept(File dir) {
                    if (dir.isDirectory()) {
                        String dirName = dir.getName();
                        try {
                            Date d1 = this.df.parse(dirName);
                            if (d1.before(delPictureDate)) {
                                DelRecordJob.delteFile(dir, notDelPic);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            });
        }
    }

    private static void delPassSelfPay(CommonDaoService daoService) {
        Long gtId = null;
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        cl.add(6, -7);
        Date dt = cl.getTime();
        int fetchSize = 1000;
        block0: while (true) {
            SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassSelfPay.class));
            sp.setQueryFields(new String[]{"id", "paid_time", "passport_number", "medium_type", "enter_time", "enter_record_no", "carpark_id"});
            sp.addLT("paid_time", (Object)dt);
            if (gtId != null) {
                sp.addGT("id", gtId);
            }
            sp.setOrder_by("id ASC");
            Pagination pagination = new Pagination();
            pagination.setNeedQueryCount(false);
            pagination.setRecordsCount((long)fetchSize);
            pagination.setPageSize(fetchSize);
            pagination.setGotoFirstPage(true);
            List list = daoService.selectList(sp, CarparkPassSelfPay.class, pagination);
            if (list == null || list.isEmpty()) break;
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                CarparkPassSelfPay s = (CarparkPassSelfPay)iterator.next();
                gtId = (long)s.getId();
                long count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).addEQ("passport_number", (Object)s.getPassport_number()).addEQ("medium_type", (Object)s.getMedium_type()).addEQ("carpark_id", (Object)s.getCarpark_id()).addEQ("enter_time", (Object)s.getEnter_time()));
                if (count != 0L) continue;
                daoService.delete(new SearchParam(daoService.getTableName(CarparkPassSelfPay.class)).addEQ("id", (Object)s.getId()));
            }
            break;
        }
    }

    private static void delPassDsicount(CommonDaoService daoService) {
        Long gtId = null;
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        Date now = cl.getTime();
        cl.add(6, -7);
        Date dt = cl.getTime();
        int fetchSize = 1000;
        cl.set(2018, 0, 1, 0, 0, 0);
        int minute = (int)TimeUnit.MILLISECONDS.toMinutes(now.getTime() - cl.getTimeInMillis());
        block0: while (true) {
            SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassDiscount.class));
            sp.setQueryFields(new String[]{"id", "discount_time", "enter_record_no", "palte_number", "enter_time", "passport_number", "medium_type", "discount_method", "discount_value", "carpark_id"});
            sp.addLT("discount_time", (Object)dt);
            if (gtId != null) {
                sp.addGT("id", gtId);
            }
            sp.setOrder_by("id ASC");
            Pagination pagination = new Pagination();
            pagination.setNeedQueryCount(false);
            pagination.setRecordsCount((long)fetchSize);
            pagination.setPageSize(fetchSize);
            pagination.setGotoFirstPage(true);
            List list = daoService.selectList(sp, CarparkPassDiscount.class, pagination);
            if (list == null || list.isEmpty()) break;
            Iterator iterator = list.iterator();
            while (true) {
                long count;
                if (!iterator.hasNext()) continue block0;
                CarparkPassDiscount s = (CarparkPassDiscount)iterator.next();
                gtId = (long)s.getId();
                if (s.getDiscount_method() == 3) {
                    count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).addEQ("passport_number", (Object)s.getPassport_number()).addEQ("medium_type", (Object)s.getMedium_type()).addEQ("carpark_id", (Object)s.getCarpark_id()));
                    if (count != 0L || s.getDiscount_value() > minute) continue;
                    daoService.delete(new SearchParam(daoService.getTableName(CarparkPassDiscount.class)).addEQ("id", (Object)s.getId()));
                    continue;
                }
                count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).addEQ("passport_number", (Object)s.getPassport_number()).addEQ("medium_type", (Object)s.getMedium_type()).addEQ("carpark_id", (Object)s.getCarpark_id()).addEQ("enter_time", (Object)s.getEnter_time()));
                if (count != 0L) continue;
                daoService.delete(new SearchParam(daoService.getTableName(CarparkPassDiscount.class)).addEQ("id", (Object)s.getId()));
            }
            break;
        }
    }

    private static void deleteLanOnlineDispatchTask(CommonDaoService daoService) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.set(11, 0);
            cl.set(12, 0);
            cl.set(13, 0);
            cl.set(14, 0);
            cl.add(6, -15);
            Date delTime1 = cl.getTime();
            cl.add(6, -75);
            Date delTime2 = cl.getTime();
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            for (CarparkHost host : hostMap.values()) {
                SearchParam p;
                if (host.getHost_use() == 1) {
                    p = new SearchParam(daoService.getTableName(CarparkDispatchTask.class)).addEQ("host_no", (Object)host.getHost_no()).addLT("created_time", (Object)delTime1);
                    daoService.delete(p);
                    continue;
                }
                p = new SearchParam(daoService.getTableName(CarparkDispatchTask.class)).addEQ("host_no", (Object)host.getHost_no()).addLT("created_time", (Object)delTime2);
                daoService.delete(p);
            }
        }
        catch (Throwable ex) {
            try {
                ServiceLog.getLog().warn((Object)"\u5220\u9664\u8868ck_carpark_dispatch_task\u6570\u636e\u5f02\u5e38\uff01", ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void deleteRecords(CommonDaoService daoService, String tableName, String dateFieldName, int remayDays) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.set(11, 0);
            cl.set(12, 0);
            cl.set(13, 0);
            cl.set(14, 0);
            cl.add(6, 0 - remayDays);
            daoService.delete(new SearchParam(tableName).addLT(dateFieldName, (Object)cl.getTime()));
        }
        catch (Throwable ex) {
            try {
                ServiceLog.getLog().warn((Object)("\u5220\u9664\u8868" + tableName + "\u6570\u636e\u5f02\u5e38\uff01"), ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void deleteCarparkEscapeOrderRecords(CommonDaoService daoService, int remayDays) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.set(11, 0);
            cl.set(12, 0);
            cl.set(13, 0);
            cl.set(14, 0);
            cl.add(6, 0 - remayDays);
            daoService.delete(new SearchParam(daoService.getTableName(CarparkEscapeOrder.class)).addLT("exit_time", (Object)cl.getTime()).addGT("order_state", (Object)0));
        }
        catch (Throwable ex) {
            try {
                ServiceLog.getLog().warn((Object)"\u5220\u9664\u8868ck_carpark_escape_order\u6570\u636e\u5f02\u5e38\uff01", ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void delteFile(File file, final Set<String> notDelFilePathSet) {
        if (file.isDirectory()) {
            file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    DelRecordJob.delteFile(pathname, notDelFilePathSet);
                    return false;
                }
            });
            final boolean[] x = new boolean[1];
            file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (!x[0]) {
                        x[0] = true;
                    }
                    return false;
                }
            });
            if (!x[0]) {
                file.delete();
            }
        } else if (file.isFile() && !notDelFilePathSet.contains(file.getAbsolutePath())) {
            file.delete();
        }
    }
}

