/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DispatchDataTaskJob
implements Runnable {
    private ConcurrentHashMap<String, Runnable> taskMap = new ConcurrentHashMap();
    private static final DispatchDataTaskJob instance = new DispatchDataTaskJob();

    public static DispatchDataTaskJob getInstance() {
        return instance;
    }

    private DispatchDataTaskJob() {
    }

    @Override
    public void run() {
        block6: {
            CarparkHost localhost;
            Map<String, CarparkHost> hostsMap;
            block7: {
                block8: {
                    block5: {
                        hostsMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                        if (hostsMap == null || hostsMap.isEmpty()) {
                            return;
                        }
                        localhost = hostsMap.get(ServiceUtil.getServiceContext().getLocalHostNo());
                        if (localhost == null) {
                            return;
                        }
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) break block5;
                        if (localhost.getHost_use() != 1) break block6;
                        for (CarparkHost host : hostsMap.values()) {
                            if (host.getHost_no().equals(localhost.getHost_no())) continue;
                            this.runByHostNo(host.getHost_no());
                        }
                        break block6;
                    }
                    if (localhost.getHost_use() != 1) break block7;
                    if (localhost.getNet_mode() != 2) break block8;
                    CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
                    if (serverHost == null) break block6;
                    this.runByHostNo(serverHost.getHost_no());
                    break block6;
                }
                for (CarparkHost host : hostsMap.values()) {
                    if (host.getHost_no().equals(localhost.getHost_no()) || host.getHost_use() == 1 && host.getNet_mode() != 1) continue;
                    this.runByHostNo(host.getHost_no());
                }
                break block6;
            }
            for (CarparkHost host : hostsMap.values()) {
                if (host.getHost_no().equals(localhost.getHost_no())) continue;
                this.runByHostNo(host.getHost_no());
            }
        }
    }

    private void runByHostNo(String hostNo) {
        Runnable r;
        Runnable r1;
        if (ServiceUtil.getServiceContext().isConected(hostNo) && this.taskMap.get(hostNo) == null && (r1 = this.taskMap.putIfAbsent(hostNo, r = this.createTaskRunnable(hostNo))) == null) {
            try {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(r);
            }
            catch (Throwable ex) {
                this.taskMap.remove(hostNo);
                ServiceLog.getLog().warn((Object)"", ex);
            }
        }
    }

    private void doRun(String hostNo) throws Exception {
        ApplicationService service = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long lastid = 0L;
        block2: while (ServiceUtil.getServiceContext().isConected(hostNo)) {
            Pagination p = new Pagination();
            int fetchSize = 100;
            p.setGotoPage(1);
            p.setRecordsCount((long)fetchSize);
            p.setPageSize(fetchSize);
            p.setNeedQueryCount(false);
            List list = commonDaoService.selectList(new SearchParam().addEQ("host_no", (Object)hostNo).addGT("id", (Object)lastid).setOrerbySql("id ASC"), CarparkDispatchTask.class, p);
            if (list == null || list.isEmpty()) {
                return;
            }
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                CarparkDispatchTask t = (CarparkDispatchTask)iterator.next();
                lastid = t.getId();
                if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                    return;
                }
                if (System.currentTimeMillis() - t.getCreated_time().getTime() < 30000L) continue;
                try {
                    service.exeDispatchTask(t);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
            break;
        }
        return;
    }

    private Runnable createTaskRunnable(final String hostNo) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        DispatchDataTaskJob.this.doRun(hostNo);
                    }
                    catch (Throwable ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
                        DispatchDataTaskJob.this.taskMap.remove(hostNo);
                    }
                }
                finally {
                    DispatchDataTaskJob.this.taskMap.remove(hostNo);
                }
            }
        };
    }
}

