/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;

public class HttpContextUtil {
    public static void registerWebFilter(ServletContext servletContext, Class<? extends Filter> filter) {
        WebInitParam[] param;
        FilterRegistration.Dynamic f;
        WebFilter webFilter = filter.getAnnotation(WebFilter.class);
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.copyOf(Arrays.asList(webFilter.dispatcherTypes()));
        String filterName = webFilter.filterName();
        if (filterName.length() == 0) {
            filterName = filter.getSimpleName();
        }
        try {
            f = servletContext.addFilter(filterName, filter.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String[] urlPatterns = webFilter.urlPatterns();
        if (urlPatterns.length == 0) {
            urlPatterns = webFilter.value();
        }
        if (urlPatterns.length > 0) {
            f.addMappingForUrlPatterns(dispatcherTypes, true, urlPatterns);
        }
        f.setAsyncSupported(webFilter.asyncSupported());
        String[] servletNames = webFilter.servletNames();
        if (servletNames.length > 0) {
            f.addMappingForServletNames(dispatcherTypes, true, servletNames);
        }
        if ((param = webFilter.initParams()).length > 0) {
            WebInitParam[] webInitParamArray = param;
            int n = param.length;
            int n2 = 0;
            while (n2 < n) {
                WebInitParam w = webInitParamArray[n2];
                f.setInitParameter(w.name(), w.value());
                ++n2;
            }
        }
    }

    public static void registerFilter(ServletContext servletContext, Filter filter, String ... path) {
        String s = filter.getClass().getSimpleName();
        if (s == null || s.length() == 0) {
            s = filter.getClass().getName();
            int v = s.lastIndexOf(46);
            if (v != -1) {
                s = s.substring(v + 1);
            }
            s = s.replaceAll("\\$", "-");
        }
        FilterRegistration.Dynamic f = servletContext.addFilter(s, filter);
        f.setAsyncSupported(true);
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.copyOf(Arrays.asList(DispatcherType.REQUEST));
        f.addMappingForUrlPatterns(dispatcherTypes, true, path);
    }

    public static void registerEventListener(EventListener l, ServletContext servletContext) {
        servletContext.addListener(l);
    }

    public static void registerServlet(ServletContext servletContext, Servlet servlet, String ... path) {
        String s = servlet.getClass().getSimpleName();
        if (s == null || s.length() == 0) {
            s = servlet.getClass().getName();
            int v = s.lastIndexOf(46);
            if (v != -1) {
                s = s.substring(v + 1);
            }
            s = s.replaceAll("\\$", "-");
        }
        ServletRegistration.Dynamic f = servletContext.addServlet(s, servlet);
        f.setAsyncSupported(true);
        f.addMapping(path);
    }

    public static void registerWebServlet(ServletContext servletContext, Class<? extends Servlet> servlet) {
        WebServlet webServlet = servlet.getAnnotation(WebServlet.class);
        if (webServlet != null) {
            ServletRegistration.Dynamic f;
            String servletName = webServlet.name();
            if (servletName.length() == 0) {
                servletName = servlet.getSimpleName();
            }
            try {
                f = servletContext.addServlet(servletName, servlet.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            String[] urlPatterns = webServlet.urlPatterns();
            if (urlPatterns.length == 0) {
                urlPatterns = webServlet.value();
            }
            if (urlPatterns.length > 0) {
                f.addMapping(urlPatterns);
            }
            f.setAsyncSupported(webServlet.asyncSupported());
            f.setLoadOnStartup(webServlet.loadOnStartup());
            WebInitParam[] param = webServlet.initParams();
            if (param.length > 0) {
                WebInitParam[] webInitParamArray = param;
                int n = param.length;
                int n2 = 0;
                while (n2 < n) {
                    WebInitParam w = webInitParamArray[n2];
                    f.setInitParameter(w.name(), w.value());
                    ++n2;
                }
            }
        }
    }
}

