/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.internel.HttpContextUtil;
import com.wovoe.carpark.internel.OSGiServletContext;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.web.CarparkActionFilter;
import com.wovoe.carpark.web.HttpDataSyncServlet;
import com.wovoe.carpark.web.StaticResourceServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.comet.CometAddOn;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.websockets.WebSocketAddOn;

public class HttpServiceServer {
    private int port;
    private volatile boolean started = false;
    private HttpServer httpServer;
    private OSGiServletContext context;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        try {
            this.httpServer = new HttpServer();
            NetworkListener networkListener = this.newHttpNetworkListener();
            this.httpServer.addListener(networkListener);
            this.httpServer.start();
            this.context = new OSGiServletContext();
            CarparkActionFilter f = new CarparkActionFilter();
            f.setRequestActionManager(ServiceUtil.getServiceContext().getRequestActionManager());
            HttpContextUtil.registerFilter((ServletContext)this.context, (Filter)f, "/*");
            HttpContextUtil.registerServlet((ServletContext)this.context, (Servlet)new StaticResourceServlet("/manage/index.action"), "/");
            HttpContextUtil.registerServlet((ServletContext)this.context, (Servlet)new HttpDataSyncServlet(ServiceUtil.getServiceContext().getDataSyncWebHelper()), "/syncTableData");
            this.context.deploy(this.httpServer);
            this.started = true;
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)"\u542f\u52a8http\u670d\u52a1\u5f02\u5e38", (Throwable)ex);
            throw ex;
        }
    }

    private NetworkListener newHttpNetworkListener() {
        NetworkListener networkListener = new NetworkListener("carpark-http-listener", "0.0.0.0", this.port);
        networkListener.registerAddOn((AddOn)new CometAddOn());
        networkListener.registerAddOn((AddOn)new WebSocketAddOn());
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        int coresCount = Runtime.getRuntime().availableProcessors();
        if (coresCount <= 1) {
            coresCount = 2;
        } else if (coresCount < 4) {
            coresCount = 4;
        }
        TCPNIOTransport transport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)builder.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance())).setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setPoolName("Grizzly-http-worker").setCorePoolSize(coresCount).setMaxPoolSize(coresCount).setMemoryManager(builder.getMemoryManager()))).setReadBufferSize(0x100000)).setWriteBufferSize(0x100000)).build();
        networkListener.setTransport(transport);
        return networkListener;
    }

    public synchronized void stop() {
        try {
            try {
                if (this.context != null) {
                    try {
                        this.context.undeploy();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    this.context = null;
                }
                if (this.httpServer != null && this.httpServer.isStarted()) {
                    this.httpServer.shutdownNow();
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                this.started = false;
            }
        }
        finally {
            this.started = false;
        }
    }

    public synchronized void reStart() throws Exception {
        this.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.start();
    }
}

