/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.HttpServiceServer;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import java.net.BindException;
import java.util.Set;

public class LocalInetAddressPortCheckJob
extends JobTask {
    protected void doRun() throws Exception {
        boolean isWanClient;
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent((Object)this, "\u81f4\u547d\u9519\u8bef\uff1a\u672c\u5c97\u4ead\u4e3b\u673a\u914d\u7f6e\u4e22\u5931\uff01\u53ef\u80fd\u5df2\u88ab\u7ba1\u7406\u5458\u4ece\u914d\u7f6e\u4e2d\u5220\u9664\uff01\u7cfb\u7edf\u9700\u8981\u91cd\u65b0\u521d\u59cb\u5316\u914d\u7f6e\uff01", 4, 60000));
            return;
        }
        boolean bl = isWanClient = localHost.getHost_use() == 1 && localHost.getNet_mode() == 2;
        if (!isWanClient) {
            this.checkHttpStarted();
            Set<String> ipSet = ServiceUtil.getServiceContext().getLocalIpv4(false);
            this.checkLocalHostPort(ipSet, localHost);
        } else if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            this.checkHttpStarted();
            ServiceUtil.getServiceContext().getLocalIpv4(false);
        }
    }

    private void checkLocalHostPort(Set<String> ipSet, CarparkHost localHost) {
        if (!ipSet.contains(localHost.getHost_ip())) {
            ServiceLog.getLog().warn((Object)("\u9519\u8bef\uff1a\u914d\u7f6eIP\u4e0e\u672c\u673aIP\u4e0d\u4e00\u81f4! \u914d\u7f6eIP\uff1a" + localHost.getHost_ip() + " \u672c\u673aIP:" + ipSet));
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent((Object)this, "\u81f4\u547d\u9519\u8bef\uff1a\u7ba1\u7406\u7cfb\u7edf\u914d\u7f6e\u672c\u673a(" + localHost.getHost_name() + ")IP\uff1a" + localHost.getHost_ip() + "\uff0c\u4e0e\u672c\u673a\u64cd\u4f5c\u7cfb\u7edf\u8bbe\u7f6eIP" + ipSet + "\u4e0d\u4e00\u81f4\uff01\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u4fee\u590d\u6b64\u95ee\u9898\uff01", 4, 60000));
        }
    }

    private void checkHttpStarted() {
        HttpServiceServer server = ServiceUtil.getServiceContext().getHttpServiceServer();
        if (server != null && !server.isStarted()) {
            try {
                server.start();
            }
            catch (Exception ex) {
                String msg;
                String errMsg = ex instanceof BindException ? ((msg = ex.getMessage()) != null && msg.indexOf("Address already in use") != -1 ? "\u7aef\u53e3:" + server.getPort() + "\u5df2\u88ab\u5360\u7528,\u65e0\u6cd5\u542f\u52a8\u670d\u52a1\u6a21\u5757" : "\u7aef\u53e3:" + server.getPort() + "\u4e0d\u53ef\u7528,\u65e0\u6cd5\u542f\u52a8\u670d\u52a1\u6a21\u5757") : ((msg = ex.getMessage()) != null ? (msg.indexOf("Permission denied") != -1 ? "\u7aef\u53e3:" + server.getPort() + "\u65e0\u6743\u9650\u8bbf\u95ee!" : "\u65e0\u6cd5\u542f\u52a8\u5728\u7aef\u53e3:" + server.getPort() + "\u7684\u670d\u52a1!\u539f\u56e0\uff1a" + msg) : "\u65e0\u6cd5\u542f\u52a8\u5728\u7aef\u53e3:" + server.getPort() + "\u7684\u670d\u52a1!");
                ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u542f\u52a8HTTP\u670d\u52a1\u5668\u5728\u7aef\u53e3\u53f7:" + server.getPort() + " \u539f\u56e0\uff1a" + errMsg));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent((Object)this, "\u81f4\u547d\u9519\u8bef\uff1a\u672c\u673a\u7f51\u7edc\u670d\u52a1\u65e0\u6cd5\u542f\u52a8\uff01\u539f\u56e0:" + errMsg + "\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u4fee\u590d\u6b64\u95ee\u9898\uff01", 4, 60000));
            }
        }
    }
}

