/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.UpgradeService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SendLanEquipmentStateJob
implements Runnable {
    @Override
    public void run() {
        try {
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            if (hostMap == null) {
                return;
            }
            CarparkHost localHost = hostMap.get(ServiceUtil.getServiceContext().getLocalHostNo());
            if (localHost == null) {
                return;
            }
            if (localHost.getNet_mode() == 1) {
                boolean localIsClient;
                final HashMap<String, String> requestMap = new HashMap<String, String>();
                requestMap.put("hostNo", localHost.getHost_no());
                boolean bl = localIsClient = localHost.getHost_use() == 1;
                if (!localIsClient) {
                    requestMap.put("serverHostIp", localHost.getHost_ip());
                    requestMap.put("serverHostPort", String.valueOf(localHost.getHost_port()));
                    requestMap.put("cloudConnected", String.valueOf(ServiceUtil.getServiceContext().isConnectedCloud()));
                    LinkedList<HostEquipmentSate> wanhostSateList = new LinkedList<HostEquipmentSate>();
                    long crl = ServiceUtil.getServiceContext().currentTimeMillis();
                    for (CarparkHost h : hostMap.values()) {
                        HostEquipmentSate wanHostSate;
                        if (h.getHost_use() != 1 || localHost.getHost_no().equals(h.getHost_no()) || h.getNet_mode() != 2 || (wanHostSate = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getHostEquipmentSate(h.getHost_no())) == null) continue;
                        HostEquipmentSate so = wanHostSate.simpleCopy();
                        if (so.getLastConnectedMills() == null) {
                            so.setLastConnectedMills(0L);
                        } else {
                            long a1 = crl - so.getLastConnectedMills();
                            if (a1 < 0L) {
                                a1 = 0L;
                            }
                            so.setLastConnectedMills(a1);
                        }
                        wanhostSateList.add(so);
                    }
                    if (wanhostSateList != null && !wanhostSateList.isEmpty()) {
                        requestMap.put("wanSateList", GsonBuilder.create().toJson(wanhostSateList));
                    }
                }
                for (final CarparkHost h : hostMap.values()) {
                    if (localHost.getHost_no().equals(h.getHost_no()) || h.getNet_mode() != 1) continue;
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(h.getHost_no(), false);
                                if (rpc == null) {
                                    throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5c40\u57df\u7f51\u8fdc\u7a0b\u670d\u52a1\u63a5\u53e3\u5de5\u5382!");
                                }
                                rpc.setConnectTimeoutMills(3400);
                                rpc.setReadTimeoutMills(3400);
                                CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                                long t1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                HostEquipmentSate remoteState = rpcService.getHostEquipmentSate(requestMap, null);
                                long t2 = ServiceUtil.getServiceContext().currentTimeMillis();
                                if (remoteState == null || remoteState.getHostNo() == null) {
                                    throw new Exception("\u8fd4\u56de\u9519\u8bef\u6570\u636e");
                                }
                                Long remoteTime = remoteState.getLastConnectedMills();
                                ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(remoteState);
                                try {
                                    if (remoteTime != null && localIsClient && (h.getHost_use() == 2 || h.getHost_use() == 3)) {
                                        long now1 = remoteTime + (t2 - t1) / 2L;
                                        long now = System.currentTimeMillis();
                                        if (Math.abs(now - now1) > 6000L) {
                                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                            ServiceLog.getLog().warn((Object)("\u53d1\u73b0\u505c\u8f66\u573a\u670d\u52a1\u5668\u65f6\u95f4\uff1a" + df.format(new Date(now1)) + ",\u4e0e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a" + df.format(new Date(now)) + "\u5b58\u5728\u8bef\u5dee\uff0c\u8fd9\u5c06\u540c\u6b65\u670d\u52a1\u5668\u65f6\u95f4"));
                                            ServiceUtil.setSystemTime(new Date(now1));
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    LogUtil.getLog().warn((Object)"\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38", (Throwable)ex);
                                }
                                try {
                                    CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                                    if (localConfig.getCarpark_deploy_type() != 1 && localIsClient && (h.getHost_use() == 2 || h.getHost_use() == 3)) {
                                        ServiceUtil.getServiceContext().setSupportSenselessPay(remoteState.isSupportSenselessPay());
                                        ServiceUtil.getServiceContext().setSenselessConfigAll(remoteState.getSenselessPayConfig());
                                    }
                                }
                                catch (Exception ex) {
                                    LogUtil.getLog().warn((Object)"\u8bbe\u7f6e\u65e0\u611f\u652f\u4ed8\u5f02\u5e38", (Throwable)ex);
                                }
                                try {
                                    if (localIsClient && (h.getHost_use() == 2 || h.getHost_use() == 3) && remoteState.getVersion() != null && remoteState.getVersion().length() > 0) {
                                        String key;
                                        String localVersion = ServiceUtil.getServiceContext().getVersion();
                                        String severVersion = remoteState.getVersion();
                                        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                                        int vl = upgradeService.compareVersion(localVersion, severVersion);
                                        if (vl < 0) {
                                            if (remoteState.getExistUpgradeFile() != null && remoteState.getExistUpgradeFile() == 1) {
                                                upgradeService.hanleLocalUpgrade(severVersion, h, null);
                                            } else {
                                                key = "adviceNeedUpgrdeTootip2";
                                                if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
                                                    ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 120L, TimeUnit.SECONDS);
                                                    String msg = "\u8b66\u544a\uff1a\u8f6f\u4ef6\u7248\u672c\u4e0d\u4e00\u81f4\u9519\u8bef\uff01\u672c\u673a\u5c97\u4ead\u5ba2\u6237\u7aef\u8f6f\u4ef6\u7248\u672c\uff1a" + localVersion + "\uff0c\u4f4e\u4e8e \u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\uff1a" + severVersion + "\uff0c\u9700\u8981\u5347\u7ea7\uff0c\u4f46\u65e0\u6cd5\u5728\u670d\u52a1\u5668\u627e\u5230\u5347\u7ea7\u8f6f\u4ef6\u5305\uff0c\u65e0\u6cd5\u81ea\u52a8\u5347\u7ea7\uff0c\u8bf7\u624b\u52a8\u5c06\u8f6f\u4ef6\u5347\u7ea7\u5230 " + severVersion + "\uff01\u5426\u5219\u53ef\u80fd\u4f1a\u51fa\u73b0\u6570\u636e\u9519\u8bef\u3002 ";
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 60000));
                                                }
                                            }
                                        } else if (vl > 0) {
                                            key = "adviceNeedUpgrdeTootip1";
                                            if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
                                                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 120L, TimeUnit.SECONDS);
                                                String msg = "\u8b66\u544a\uff1a\u8f6f\u4ef6\u7248\u672c\u4e0d\u4e00\u81f4\u9519\u8bef\uff01\u672c\u673a\u5c97\u4ead\u5ba2\u6237\u7aef\u8f6f\u4ef6\u7248\u672c\uff1a" + localVersion + "\uff0c\u9ad8\u4e8e \u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\uff1a" + severVersion + "\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u5c06\u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\u5347\u7ea7\u5230\uff1a" + localVersion + "\uff01\u5426\u5219\u53ef\u80fd\u4f1a\u51fa\u73b0\u6570\u636e\u9519\u8bef\u3002 ";
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 60000));
                                            }
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    LogUtil.getLog().warn((Object)"\u68c0\u6d4b\u66f4\u65b0\u662f\u5426\u5f02\u5e38", (Throwable)ex);
                                }
                            }
                            catch (Throwable ex) {
                                Throwable ex1 = ServiceUtil.getRPCInvokeException(ex);
                                ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOffline(h.getHost_no());
                                LogUtil.getLog().warn((Object)("\u5411\u4e3b\u673a:" + h.getHost_no() + "[" + h.getHost_ip() + ":" + h.getHost_port() + "]\u53d1\u9001\u5fc3\u8df3\u5f02\u5e38! \u539f\u56e0:" + ex1.getMessage()));
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)"", ex);
        }
    }
}

