/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.cloud.CloudContext;
import com.wovoe.carpark.cloud.CloudSyncDataJob;
import com.wovoe.carpark.cloud.DefaultCarparkCloudConnection;
import com.wovoe.carpark.cloud.SenselessPayJob;
import com.wovoe.carpark.cloud.client.CarparkHostCloudConnection;
import com.wovoe.carpark.cloud.client.CloudCarparkDataSyncService;
import com.wovoe.carpark.conn.udp.CaraprkDatatransferRPCAction;
import com.wovoe.carpark.conn.udp.CaraprkDownloadFileAction;
import com.wovoe.carpark.conn.udp.CarparkSyncTableDataAction;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.conn.udp.CarparkUploadPicAction;
import com.wovoe.carpark.event.listener.CarChannelPassProcessEventListener;
import com.wovoe.carpark.event.listener.ChannelPayCodeEventListener;
import com.wovoe.carpark.event.listener.EquipmentEventListener;
import com.wovoe.carpark.event.listener.RoadBarrierControlBoxListener;
import com.wovoe.carpark.internel.AutoDelPlateJob;
import com.wovoe.carpark.internel.CarparkTranFeeReportJob;
import com.wovoe.carpark.internel.CheckAuthJob;
import com.wovoe.carpark.internel.CheckLocalPassDataCacheTask;
import com.wovoe.carpark.internel.DefaultBlackWhiteListCache;
import com.wovoe.carpark.internel.DefaultStrategyDefine;
import com.wovoe.carpark.internel.DelRecordJob;
import com.wovoe.carpark.internel.DelTempFileJob;
import com.wovoe.carpark.internel.DispatchDataTaskJob;
import com.wovoe.carpark.internel.LocalInetAddressPortCheckJob;
import com.wovoe.carpark.internel.SendLanEquipmentStateJob;
import com.wovoe.carpark.internel.SyncServerDataJob;
import com.wovoe.carpark.internel.VacuumdbJob;
import com.wovoe.carpark.internel.VisitAuthRecordDbTableTrigger;
import com.wovoe.carpark.internel.WanNetConnectCheckJob;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.ServiceContext;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.Schedule;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.DbTableTrigger;
import com.wovoe.framework.dao.DbTableTriggerManager;
import com.wovoe.framework.db.sync.DeleteSyncLogJob;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ServiceActivator {
    private ConcurrentLinkedQueue<ScheduledFuture<?>> jobs = new ConcurrentLinkedQueue();
    private SyncServerDataJob syncDataJob;

    public void start(ServiceContext context) throws Exception {
        DefaultCarparkCloudConnection conn;
        CloudContext cloudContext;
        CarparkUdpP2pConnection connection22;
        if (this.syncDataJob == null) {
            this.syncDataJob = new SyncServerDataJob();
        }
        context.setAttribute(SyncServerDataJob.class.getName(), (Object)this.syncDataJob);
        if (context.getCarparkLocalConfig().getHost_use() == 1 && context.getCarparkLocalConfig().getCarpark_deploy_type() != 1 && (connection22 = context.getCarparkUdpP2pConnection()) != null && !connection22.isStarted()) {
            connection22.start();
        }
        context.getServiceActionManager().register("/CaraprkDatatransferRPCAction", (ServiceAction)new CaraprkDatatransferRPCAction());
        context.getServiceActionManager().register("/CaraprkDownloadFileAction", (ServiceAction)new CaraprkDownloadFileAction());
        context.getServiceActionManager().register("/CarparkSyncTableDataAction", (ServiceAction)new CarparkSyncTableDataAction());
        context.getServiceActionManager().register("/CarparkUploadPicAction", (ServiceAction)new CarparkUploadPicAction());
        context.getCarparkEventListenerManager().registerParkingEventListener(new EquipmentEventListener());
        context.getCarparkEventListenerManager().registerParkingEventListener(new CarChannelPassProcessEventListener());
        context.getCarparkEventListenerManager().registerParkingEventListener(new RoadBarrierControlBoxListener());
        context.getCarparkEventListenerManager().registerParkingEventListener(new ChannelPayCodeEventListener());
        try {
            ParkingSpace.getInstance().refresh();
        }
        catch (Throwable connection22) {
            // empty catch block
        }
        this.jobs.add(context.schedule(ParkingSpace.getInstance(), 5L, 5L, TimeUnit.SECONDS));
        context.getStrategyDefineRegister().register(new DefaultStrategyDefine());
        if (context.getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
            this.jobs.add(context.getScheduledExecutorService().scheduleAtFixedRate(new SendLanEquipmentStateJob(), 1500L, 3500L, TimeUnit.MILLISECONDS));
        }
        this.jobs.add(context.getScheduledExecutorService().scheduleAtFixedRate(DispatchDataTaskJob.getInstance(), 6000L, 30000L, TimeUnit.MILLISECONDS));
        this.jobs.add(context.getScheduledExecutorService().scheduleAtFixedRate((Runnable)((Object)WanNetConnectCheckJob.getInstance()), 500L, 8500L, TimeUnit.MILLISECONDS));
        this.jobs.add(context.schedule(new LocalInetAddressPortCheckJob(), 1L, 2L, TimeUnit.MINUTES));
        this.jobs.add(context.schedule(new CheckAuthJob(), 60L, 60L, TimeUnit.SECONDS));
        Schedule sa1 = Schedule.createEveryDayAtTime((int)3, (int)0, (int)0);
        this.jobs.add(context.schedule(new VacuumdbJob(), sa1.getInitialDelay(), sa1.getPeriod(), sa1.getTimeUnit()));
        Schedule desl = Schedule.createEveryDayAtTime((int)2, (int)0, (int)0);
        this.jobs.add(context.schedule(new DelRecordJob(), desl.getInitialDelay(), desl.getPeriod(), desl.getTimeUnit()));
        if (context.getCarparkLocalConfig().getHost_use() == 1) {
            if (context.getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
                this.jobs.add(context.getScheduledExecutorService().scheduleAtFixedRate((Runnable)((Object)this.syncDataJob), 30000L, 30000L, TimeUnit.MILLISECONDS));
            }
        } else {
            DbTableTriggerManager.getInstance().register((DbTableTrigger)this.syncDataJob);
            this.jobs.add(context.schedule(CarparkTranFeeReportJob.getInstance(), 5L, 3600L, TimeUnit.SECONDS));
            VisitAuthRecordDbTableTrigger visitAuthRecordDbTableTrigger = new VisitAuthRecordDbTableTrigger();
            DbTableTriggerManager.getInstance().register((DbTableTrigger)visitAuthRecordDbTableTrigger);
            this.jobs.add(context.schedule(visitAuthRecordDbTableTrigger, 8L, 3600L, TimeUnit.SECONDS));
            RecordSaveService recordSaveService = (RecordSaveService)context.getService(RecordSaveService.class);
            recordSaveService.addPassRecordListener(visitAuthRecordDbTableTrigger);
        }
        DeleteSyncLogJob deleteSyncLogJob = new DeleteSyncLogJob("ck_ddl_sync_log", (CommonDaoService)context.getService(CommonDaoService.class));
        Schedule sa = Schedule.createEveryDayAtTime((int)1, (int)0, (int)0);
        this.jobs.add(context.schedule((JobTask)deleteSyncLogJob, sa.getInitialDelay(), sa.getPeriod(), sa.getTimeUnit()));
        if (context.getCarparkLocalConfig().getHost_use() != 1) {
            cloudContext = context.getCloudContext();
            conn = new DefaultCarparkCloudConnection(cloudContext);
            cloudContext.setCarparkCloudConnection(conn);
            conn.start();
            this.jobs.add(context.schedule(new CloudSyncDataJob(), 20L, 20L, TimeUnit.SECONDS));
            sa = Schedule.createEveryDayAtTime((int)0, (int)30, (int)0);
            AutoDelPlateJob sjobn = new AutoDelPlateJob();
            this.jobs.add(context.schedule(sjobn, sa.getInitialDelay(), sa.getPeriod(), sa.getTimeUnit()));
            sjobn.run();
        } else if (context.getCarparkLocalConfig().getHost_type() == 1 && context.getCarparkLocalConfig().getNet_mode() == 2 && context.getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            cloudContext = context.getCloudContext();
            conn = new CarparkHostCloudConnection(cloudContext);
            cloudContext.setCarparkCloudConnection(conn);
            conn.start();
            context.loadServiceClass(CloudCarparkDataSyncService.class);
            CloudCarparkDataSyncService cloudCarparkDataSyncService = (CloudCarparkDataSyncService)context.getService("cloudCarparkDataSyncService");
            this.jobs.add(context.schedule(cloudCarparkDataSyncService, 15L, 60L, TimeUnit.SECONDS));
        }
        DefaultBlackWhiteListCache defaultBlackWhiteListCache = new DefaultBlackWhiteListCache();
        DbTableTriggerManager.getInstance().register((DbTableTrigger)defaultBlackWhiteListCache);
        this.jobs.add(context.schedule(defaultBlackWhiteListCache, 15L, 60L, TimeUnit.SECONDS));
        context.setBlackWhiteListCache(defaultBlackWhiteListCache);
        sa1 = Schedule.createEveryDayAtTime((int)1, (int)10, (int)0);
        this.jobs.add(context.schedule(new DelTempFileJob(), sa1.getInitialDelay(), sa1.getPeriod(), sa1.getTimeUnit()));
        SenselessPayJob senselessPayJob = new SenselessPayJob();
        this.jobs.add(context.schedule(senselessPayJob, 11L, 20L, TimeUnit.SECONDS));
        RecordSaveService recordSaveService = (RecordSaveService)context.getService(RecordSaveService.class);
        recordSaveService.addPassRecordListener(senselessPayJob);
        CheckLocalPassDataCacheTask.handleAll();
    }

    public void stop(ServiceContext context) throws Exception {
        ScheduledFuture<?> job;
        CloudContext cloudContext = context.getCloudContext();
        if (cloudContext != null && cloudContext.getCarparkCloudConnection() != null) {
            cloudContext.getCarparkCloudConnection().destroy();
        }
        while ((job = this.jobs.poll()) != null) {
            job.cancel(true);
        }
        CarChannelPassProcessEventListener.closeAllChannelEx();
        if (this.syncDataJob != null && context.getCarparkLocalConfig().getHost_use() != 1) {
            DbTableTriggerManager.getInstance().removeDbTableTrigger((DbTableTrigger)this.syncDataJob);
        }
        this.syncDataJob = null;
    }
}

