/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.AuthInfo;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.internel.ProductLicense;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.UsbDog;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.ServiceContext;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.RsaUtil;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.lib.start.LibStartService;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ServiceUtil {
    private static final String OBTAIN_CONNECT_DOMAIN = "park.wlyk.com";
    private static final String OBTAIN_UPGRADE_DOMAIN = "release.wlyk.com";
    public static final String OBTAIN_PAY_DOMAIN = "cloud.wlyk.com";
    private static ServiceContext serviceContext;
    private static PublicKey cloudPublicKey;
    private static AtomicBoolean setSystemRunning;
    private static LibStartService libStartService;
    private static volatile boolean zvalid;
    private static volatile Integer softRemainDays;
    private static Gson htmlEscapingGson;
    private static Properties enableAdminWatchFeeConf;
    private static final String enableAdminWatchFeeConf_fileName = "d777.conf";

    static {
        setSystemRunning = new AtomicBoolean(false);
        zvalid = true;
        enableAdminWatchFeeConf = null;
    }

    static void setServiceContext(ServiceContext context) {
        serviceContext = context;
    }

    public static ServiceContext getServiceContext() {
        return serviceContext;
    }

    public static boolean isEnableNonAdminWatchFee() {
        String v;
        if (ServiceUtil.getServiceContext() == null) {
            return true;
        }
        if (enableAdminWatchFeeConf == null) {
            enableAdminWatchFeeConf = ServiceUtil.getServiceContext().readLocalRuntimeData(null, enableAdminWatchFeeConf_fileName, enableAdminWatchFeeConf_fileName);
        }
        return (v = enableAdminWatchFeeConf.getProperty("av")) == null || !Constants.NO_STR.equals(v);
    }

    public static void setEnableNonAdminWatchFee(boolean enable) {
        if (ServiceUtil.getServiceContext() == null) {
            return;
        }
        if (enableAdminWatchFeeConf == null) {
            enableAdminWatchFeeConf = ServiceUtil.getServiceContext().readLocalRuntimeData(null, enableAdminWatchFeeConf_fileName, enableAdminWatchFeeConf_fileName);
        }
        String newV = enable ? Constants.YES_STR : Constants.NO_STR;
        String v = enableAdminWatchFeeConf.getProperty("av");
        if (v == null || !newV.equals(v)) {
            enableAdminWatchFeeConf.setProperty("av", newV);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile(null, enableAdminWatchFeeConf_fileName, enableAdminWatchFeeConf_fileName, enableAdminWatchFeeConf);
        }
    }

    public static boolean isEnableGuiFee() {
        if (ServiceUtil.isEnableNonAdminWatchFee()) {
            return true;
        }
        if (ServiceUtil.getServiceContext() == null) {
            return false;
        }
        ApplicationService appSerivce = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        UserSession userSession = appSerivce.getUserSession();
        return userSession != null && userSession.getUser() != null && "admin".equals(userSession.getUser().getUser_code());
    }

    public static List<KeyValueEntry<Integer, Integer>> getPaginationList(int totalSize, int pageSize) {
        if (pageSize <= 0 || totalSize <= 0) {
            return new ArrayList<KeyValueEntry<Integer, Integer>>(0);
        }
        int totalPages = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        ArrayList<KeyValueEntry<Integer, Integer>> list = new ArrayList<KeyValueEntry<Integer, Integer>>(totalPages);
        int offset = 0;
        int i = 0;
        while (i < totalPages) {
            offset = pageSize * i;
            int endIndex = offset + pageSize;
            int limitCount = endIndex > totalSize ? totalSize - offset : pageSize;
            list.add((KeyValueEntry<Integer, Integer>)new KeyValueEntry((Object)offset, (Object)limitCount));
            ++i;
        }
        return list;
    }

    public static String getCloudConnectDomain() {
        boolean dev = Boolean.parseBoolean(System.getProperty("CARPARK_DEV_MODE", "true"));
        if (dev) {
            String domain = System.getProperty("dev.domian", "localhost:8080");
            return domain;
        }
        return ServiceUtil.getCloudDomain();
    }

    public static String getCloudPayDomain() {
        boolean dev = Boolean.parseBoolean(System.getProperty("CARPARK_DEV_MODE", "true"));
        if (dev) {
            String host = null;
            Set<String> set = ServiceUtil.getServiceContext().getLocalIpv4(true);
            if (set != null && !set.isEmpty()) {
                host = ServiceUtil.getFirstElement(set);
                if (set.size() > 1) {
                    for (String s : set) {
                        if (!s.startsWith("192.168.1.")) continue;
                        host = s;
                    }
                }
                host = String.valueOf(host) + ":8080";
            }
            if (host == null || host.length() == 0) {
                host = OBTAIN_PAY_DOMAIN;
            }
            String domain = System.getProperty("dev.domian", host);
            return domain;
        }
        return OBTAIN_PAY_DOMAIN;
    }

    public static String getCloudDomain() {
        return OBTAIN_CONNECT_DOMAIN;
    }

    public static String getCheckUpgradeDomain() {
        return OBTAIN_UPGRADE_DOMAIN;
    }

    public static PublicKey getCloudPublicKey() {
        if (cloudPublicKey == null) {
            boolean isDevelop = false;
            String keyStr = null;
            InputStream in = null;
            try {
                try {
                    in = ServiceUtil.class.getResourceAsStream(isDevelop ? "a_develop" : "a");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
                    keyStr = reader.readLine();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            byte[] bytes = isDevelop ? BytesTool.hexStringToByteArray((String)keyStr) : BytesTool.unCompress((String)keyStr);
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                cloudPublicKey = factory.generatePublic(keySpec);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return cloudPublicKey;
    }

    public static String getAuthSignKey() {
        try {
            LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
            HardWareInfo info = HardWareUtils.getHardWareInfo();
            infoMap.put("motherboardSn", info.getMotherboardSn());
            infoMap.put("cpuSn", info.getCpuSn());
            infoMap.put("hardDiskSn", info.getHardDiskSn());
            infoMap.put("mac", info.getMac());
            String va = new Gson().toJson(infoMap);
            byte[] input = va.getBytes();
            byte[] v1 = RsaUtil.encrypt((byte[])input, (int)0, (int)input.length, (Key)ServiceUtil.getCloudPublicKey());
            return BytesTool.compressBytes((byte[])v1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getPassportNumber(String cardNo) {
        String passportNumber;
        if (cardNo == null) {
            return null;
        }
        if (cardNo.length() == 0) {
            return cardNo;
        }
        int minLength = 10;
        if (cardNo.length() < minLength) {
            StringBuilder sbr = new StringBuilder(minLength);
            char a = '0';
            int rLen = minLength - cardNo.length();
            int i = 0;
            while (i < rLen) {
                sbr.append(a);
                ++i;
            }
            sbr.append(cardNo);
            passportNumber = sbr.toString();
        } else {
            passportNumber = cardNo;
        }
        return passportNumber;
    }

    public static boolean compressPic(File imageFile, File outputFile, int width, int height, float quality) {
        if (imageFile == null || !imageFile.exists() || !imageFile.isFile()) {
            return false;
        }
        try {
            BufferedImage image = ImageIO.read(imageFile);
            boolean resize = false;
            int rw = image.getWidth();
            if (width > 0 && rw > width) {
                rw = width;
                resize = true;
            }
            int rh = image.getHeight();
            if (height > 0 && rh > height) {
                rh = height;
                resize = true;
            }
            if (resize) {
                image = SwingUtil.resizeImage(image, rw, rh);
            }
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(0.7f);
            FileImageOutputStream outputStream = new FileImageOutputStream(outputFile);
            jpgWriter.setOutput(outputStream);
            IIOImage outputImage = new IIOImage(image, null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            outputStream.close();
            return true;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage());
            return false;
        }
    }

    public static byte[] compressPic(File picFile, int width, int height, float quality) {
        if (picFile == null) {
            return null;
        }
        if (!picFile.exists()) {
            return null;
        }
        if (!picFile.isFile()) {
            return null;
        }
        try {
            BufferedImage image = ImageIO.read(picFile);
            return ServiceUtil.compressPic(image, width, height, quality);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] compressPic(InputStream picIn, int width, int height, float quality) {
        try {
            BufferedImage image = ImageIO.read(picIn);
            return ServiceUtil.compressPic(image, width, height, quality);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] compressPic(BufferedImage image, int width, int height, float quality) {
        block6: {
            try {
                if (image != null) break block6;
                return null;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return null;
            }
        }
        boolean resize = false;
        int rw = image.getWidth();
        if (width > 0 && rw > width) {
            rw = width;
            resize = true;
        }
        int rh = image.getHeight();
        if (height > 0 && rh > height) {
            rh = height;
            resize = true;
        }
        if (resize) {
            image = SwingUtil.resizeImage(image, rw, rh);
        }
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(0.7f);
        ByteArrayOutputStream outP = new ByteArrayOutputStream(2048);
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(outP);
        jpgWriter.setOutput(outputStream);
        IIOImage outputImage = new IIOImage(image, null, null);
        jpgWriter.write(null, outputImage, jpgWriteParam);
        jpgWriter.dispose();
        outputStream.close();
        return outP.toByteArray();
    }

    public static final AuthInfo readAuthInfoFormDog(ProductLicense license) {
        if (license == null) {
            return null;
        }
        UsbDog dog = UsbDog.read(license.getAuth_dog_read_key(), license);
        if (dog == null) {
            return null;
        }
        AuthInfo info = new AuthInfo(dog.getEndTimeMills(), dog.getSn(), true, HardWareUtils.getHardWareInfo(), dog.getOrgId(), dog.getKeyType(), 1, license.getId(), license.getCamera_crypto_key(), license.getAuth_sign_key(), license.getUse_camera_sign_type() == 1, license.getUse_encrypt_camera() == 1, license.getNeed_auth_host_sign() == 1, license.isUseDefault(), license.getAuth_ui_code());
        return info;
    }

    public static Gson getHtmlEscapingGson() {
        if (htmlEscapingGson == null) {
            com.google.gson.GsonBuilder buider = new com.google.gson.GsonBuilder();
            buider.registerTypeAdapter(Time.class, (Object)GsonBuilder.sqlTimeJsonSerializer);
            buider.registerTypeAdapter(java.sql.Date.class, (Object)GsonBuilder.sqlDateJsonSerializer);
            buider.registerTypeAdapter(Timestamp.class, (Object)GsonBuilder.sqlTimestampJsonSerializer);
            buider.registerTypeAdapter(Time.class, (Object)GsonBuilder.sqlTimeJsonDeserializer);
            buider.registerTypeAdapter(java.sql.Date.class, (Object)GsonBuilder.sqlDateJsonDeserializer);
            buider.registerTypeAdapter(Timestamp.class, (Object)GsonBuilder.sqlTimestampJsonDeserializer);
            buider.setDateFormat("yyyy-MM-dd HH:mm:ss");
            buider.disableHtmlEscaping();
            htmlEscapingGson = buider.create();
        }
        return htmlEscapingGson;
    }

    public static final AuthInfo parseAuthInfo(String licenseCode) {
        ProductLicense productLicense;
        int orgId;
        String keyType;
        HardWareInfo hardWareInfo;
        Map authInfoMap;
        block15: {
            int lid;
            block14: {
                String org;
                block13: {
                    block12: {
                        try {
                            if (licenseCode != null && licenseCode.length() != 0) break block12;
                            return null;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    byte[] license = BytesTool.unCompress((String)licenseCode);
                    byte[] buf = RsaUtil.decryptToBytes((byte[])license, (Key)ServiceUtil.getCloudPublicKey());
                    String jsonStr = new String(buf, "UTF-8");
                    Gson gson = new Gson();
                    authInfoMap = (Map)gson.fromJson(jsonStr, new TypeToken<Map<String, String>>(){}.getType());
                    Map hardwareInfoMap = (Map)gson.fromJson((String)authInfoMap.get("hardWareInfo"), new TypeToken<Map<String, String>>(){}.getType());
                    hardWareInfo = new HardWareInfo((String)hardwareInfoMap.get("motherboardSn"), (String)hardwareInfoMap.get("cpuSn"), (String)hardwareInfoMap.get("hardDiskSn"), (String)hardwareInfoMap.get("mac"));
                    org = (String)authInfoMap.get("org");
                    if (org == null || org.length() == 0) {
                        org = "1";
                    }
                    if ((keyType = (String)authInfoMap.get("keyType")) == null) {
                        keyType = "1";
                    }
                    if ("1".equals(keyType)) break block13;
                    return null;
                }
                orgId = 0;
                try {
                    orgId = Integer.parseInt(org);
                }
                catch (Exception ex) {
                    return null;
                }
                productLicense = ProductLicense.read();
                String _lid = (String)authInfoMap.get("lid");
                lid = _lid != null && _lid.length() > 0 ? Integer.parseInt(_lid) : 20001;
                if (lid == productLicense.getId()) break block14;
                ServiceLog.getLog().error((Object)"\u6388\u6743\u8bb8\u53ef\u6587\u4ef6\u4e0e\u8bc1\u4e66\u4e0d\u7f16\u53f7\u4e00\u81f4");
                return null;
            }
            if (lid == 20001) {
                orgId = productLicense.getOrg_id();
            }
            if (orgId == productLicense.getOrg_id()) break block15;
            ServiceLog.getLog().error((Object)"\u6388\u6743\u8bb8\u53ef\u6587\u4ef6\u4e0e\u8bc1\u4e66\u4e3b\u4f53\u4e0d\u4e00\u81f4");
            return null;
        }
        AuthInfo authInfo = new AuthInfo(Long.parseLong((String)authInfoMap.get("validTime")), (String)authInfoMap.get("sn"), "Y".equals(authInfoMap.get("official")), hardWareInfo, orgId, Integer.parseInt(keyType), 0, productLicense.getId(), productLicense.getCamera_crypto_key(), productLicense.getAuth_sign_key(), productLicense.getUse_camera_sign_type() == 1, productLicense.getUse_encrypt_camera() == 1, productLicense.getNeed_auth_host_sign() == 1, productLicense.isUseDefault(), productLicense.getAuth_ui_code());
        return authInfo;
    }

    public static final int checkAuthInfo(AuthInfo info) {
        block6: {
            block5: {
                try {
                    if (info != null && info.getHardWareInfo() != null) break block5;
                    return 1;
                }
                catch (Exception ex) {
                    return 1;
                }
            }
            boolean vlk = HardWareUtils.getHardWareInfo().equalWhith(info.getHardWareInfo());
            if (vlk) break block6;
            return 1;
        }
        if (info.isValid()) {
            return 0;
        }
        return 2;
    }

    public static String toString(ByteBuffer buf) {
        return ServiceUtil.toString(buf, "UTF-8");
    }

    public static String toString(ByteBuffer buf, String charset) {
        byte[] array;
        int length;
        int offset;
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        if (charset == null) {
            return new String(array, offset, length);
        }
        try {
            return new String(array, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T getFirstElement(Collection<T> cl) {
        Iterator<T> iterator;
        if (cl != null && (iterator = cl.iterator()).hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    public static <K, V> Map<K, V> toMap(List<V> dataList, String keyName) {
        if (dataList == null) {
            return new LinkedHashMap();
        }
        if (dataList.isEmpty()) {
            return new LinkedHashMap();
        }
        LinkedHashMap<Object, V> map = new LinkedHashMap<Object, V>();
        for (V v : dataList) {
            Object key = new JavaBeanMap(v).get((Object)keyName);
            map.put(key, v);
        }
        return map;
    }

    public static Date getNow() {
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        return cl.getTime();
    }

    public static Date getDatetime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        cl.set(14, 0);
        return cl.getTime();
    }

    public static String getString(String a, int len) {
        return ServiceUtil.getString(a, len, "UTF-8");
    }

    public static String getDBString(String a, int len) {
        if (a == null || a.length() == 0) {
            return a;
        }
        if (len <= 0) {
            return a;
        }
        if (a.length() <= len) {
            return a;
        }
        return a.substring(0, len);
    }

    public static <E> Set<E> toSet(E ... e) {
        LinkedHashSet<E> st = new LinkedHashSet<E>();
        if (e != null && e.length > 0) {
            E[] EArray = e;
            int n = e.length;
            int n2 = 0;
            while (n2 < n) {
                E e1 = EArray[n2];
                st.add(e1);
                ++n2;
            }
        }
        return st;
    }

    public static <E> List<E> toList(E ... e) {
        if (e == null || e.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<E> st = new ArrayList<E>(e.length);
        E[] EArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            E e1 = EArray[n2];
            st.add(e1);
            ++n2;
        }
        return st;
    }

    public static String getString(String a, int len, String charset) {
        byte[] a1;
        if (a == null) {
            return null;
        }
        if (a.length() == 0) {
            return a;
        }
        if (len <= 0) {
            return "";
        }
        try {
            a1 = charset == null || charset.length() == 0 ? a.getBytes() : a.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (a1.length <= len) {
            return a;
        }
        String n = a;
        int leng = n.length();
        int i = leng - 1;
        while (i > 0) {
            n = n.substring(0, i);
            try {
                a1 = charset == null || charset.length() == 0 ? n.getBytes() : n.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (a1.length <= len) {
                return n;
            }
            --i;
        }
        return "";
    }

    public static Throwable getRPCInvokeException(Throwable ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof UndeclaredThrowableException || ex instanceof InvocationTargetException) {
            Throwable ex1 = ex.getCause();
            if (ex1 != null) {
                if (ex1 == ex) {
                    return ex;
                }
                return ServiceUtil.getRPCInvokeException(ex1);
            }
            return ex;
        }
        return ex;
    }

    public static void setSystemTime(Date dateTime) {
        if (OSUtil.isWindows()) {
            ServiceUtil.doSetWidnowTime(dateTime);
        } else if (OSUtil.isLinux()) {
            ServiceUtil.doSetLinuxTime(dateTime);
        }
    }

    private static void doSetWidnowTime(final Date dateTime) {
        if (setSystemRunning.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                private void doCammand(final String command) throws IOException, InterruptedException {
                    if (command.length() == 0) {
                        throw new IllegalArgumentException("Empty command");
                    }
                    StringTokenizer st = new StringTokenizer(command);
                    String[] cmdarray = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        cmdarray[i] = st.nextToken();
                        ++i;
                    }
                    ProcessBuilder p = new ProcessBuilder(cmdarray);
                    p.redirectErrorStream(true);
                    final Process process = p.start();
                    try {
                        final CountDownLatch l = new CountDownLatch(1);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean success = l.await(5L, TimeUnit.SECONDS);
                                    if (!success) {
                                        ServiceLog.getLog().warn((Object)("\u6267\u884c\u547d\u4ee4 " + command + " 5s \u90fd\u6ca1\u6267\u884c\u5b8c\u6210! \u9000\u51fa!"));
                                        process.destroy();
                                    } else {
                                        ServiceLog.getLog().info((Object)("\u6267\u884c\u547d\u4ee4:" + command + " \u5b8c\u6210!"));
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }).start();
                        InputStream xa = process.getInputStream();
                        while (xa.read() != -1) {
                        }
                        xa.close();
                        process.waitFor();
                        l.countDown();
                    }
                    finally {
                        try {
                            process.destroy();
                        }
                        catch (Exception exception) {}
                    }
                }

                @Override
                public void run() {
                    try {
                        try {
                            boolean needSetTime;
                            SimpleDateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");
                            SimpleDateFormat timeDF = new SimpleDateFormat("HH:mm:ss");
                            Date systemDate = new Date();
                            String date1 = dateDF.format(systemDate);
                            String date2 = dateDF.format(dateTime);
                            String time1 = timeDF.format(systemDate);
                            String time2 = timeDF.format(dateTime);
                            boolean needSetDate = !date1.equals(date2);
                            boolean bl = needSetTime = !time1.equals(time2);
                            if (needSetDate) {
                                ServiceLog.getLog().info((Object)("\u8fd9\u5c06\u8bbe\u7f6eWidows\u7684\u65e5\u671f,\u5f53\u524d\u7cfb\u7edf\u65e5\u671f: " + date1 + ", \u5c06\u8bbe\u7f6e\u6210\u65b0\u65e5\u671f: " + date2));
                                this.doCammand("cmd /c date " + date2);
                            }
                            if (needSetTime) {
                                ServiceLog.getLog().info((Object)("\u8fd9\u5c06\u8bbe\u7f6eWidows\u7684\u65f6\u95f4,\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4: " + time1 + ", \u5c06\u8bbe\u7f6e\u6210\u65b0\u65f6\u95f4: " + time2));
                                this.doCammand("cmd /c time " + time2);
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)"\u8bbe\u7f6ewindows \u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38\uff01", (Throwable)ex);
                            setSystemRunning.set(false);
                        }
                    }
                    finally {
                        setSystemRunning.set(false);
                    }
                }
            }).start();
        }
    }

    private static void doSetLinuxTime(final Date dateTime) {
        if (setSystemRunning.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                private void doCammand(final String command) throws IOException, InterruptedException {
                    if (command.length() == 0) {
                        throw new IllegalArgumentException("Empty command");
                    }
                    StringTokenizer st = new StringTokenizer(command);
                    String[] cmdarray = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        cmdarray[i] = st.nextToken();
                        ++i;
                    }
                    ProcessBuilder p = new ProcessBuilder(cmdarray);
                    p.redirectErrorStream(true);
                    final Process process = p.start();
                    try {
                        final CountDownLatch l = new CountDownLatch(1);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean success = l.await(5L, TimeUnit.SECONDS);
                                    if (!success) {
                                        ServiceLog.getLog().warn((Object)("\u6267\u884c\u547d\u4ee4 " + command + " 5s \u90fd\u6ca1\u6267\u884c\u5b8c\u6210! \u9000\u51fa!"));
                                        process.destroy();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }).start();
                        InputStream xa = process.getInputStream();
                        while (xa.read() != -1) {
                        }
                        process.waitFor();
                        l.countDown();
                    }
                    finally {
                        try {
                            process.destroy();
                        }
                        catch (Exception exception) {}
                    }
                }

                @Override
                public void run() {
                    try {
                        try {
                            boolean needSetTime;
                            SimpleDateFormat dateDF = new SimpleDateFormat("yyyyMMdd");
                            SimpleDateFormat timeDF = new SimpleDateFormat("HH:mm:ss");
                            Date systemDate = new Date();
                            String date1 = dateDF.format(systemDate);
                            String date2 = dateDF.format(dateTime);
                            String time1 = timeDF.format(systemDate);
                            String time2 = timeDF.format(dateTime);
                            boolean needSetDate = !date1.equals(date2);
                            boolean bl = needSetTime = !time1.equals(time2);
                            if (needSetDate) {
                                ServiceLog.getLog().info((Object)("\u8fd9\u5c06\u8bbe\u7f6eWidows\u7684\u65e5\u671f,\u5f53\u524d\u7cfb\u7edf\u65e5\u671f: " + date1 + ", \u5c06\u8bbe\u7f6e\u6210\u65b0\u65e5\u671f: " + date2));
                                this.doCammand("date -s " + date2);
                                ServiceLog.getLog().info((Object)("\u8bbe\u7f6eWindow\u65e5\u671f:" + date2 + " \u5b8c\u6210!"));
                            }
                            if (needSetTime) {
                                ServiceLog.getLog().info((Object)("\u8fd9\u5c06\u8bbe\u7f6eWidows\u7684\u65f6\u95f4,\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4: " + time1 + ", \u5c06\u8bbe\u7f6e\u6210\u65b0\u65f6\u95f4: " + time2));
                                this.doCammand("date -s " + time2);
                                ServiceLog.getLog().info((Object)("\u8bbe\u7f6eWindow\u65f6\u95f4:" + time2 + " \u5b8c\u6210!"));
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)"\u8bbe\u7f6ewindows \u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38\uff01", (Throwable)ex);
                            setSystemRunning.set(false);
                        }
                    }
                    finally {
                        setSystemRunning.set(false);
                    }
                }
            }).start();
        }
    }

    public static String getRemainDays(int days) {
        if (days < 0) {
            days = 0;
        }
        return String.valueOf(ServiceUtil.getNumber(String.valueOf(days))) + "\u5929";
    }

    public static String getTimeLenMins(int mins) {
        int hour;
        int parkingTimes;
        if (mins <= 0) {
            mins = 1;
        }
        int tminite = parkingTimes = mins;
        int minite = tminite % 60;
        int thour = tminite / 60;
        int day = 0;
        if (thour > 24) {
            day = thour / 24;
            hour = thour % 24;
        } else {
            hour = thour;
        }
        StringBuffer b = new StringBuffer();
        if (day > 0) {
            b.append(ServiceUtil.getNumber(String.valueOf(day))).append("\u5929");
        }
        if (hour > 0) {
            b.append(ServiceUtil.getNumber(String.valueOf(hour))).append("\u65f6");
        }
        if (minite > 0) {
            b.append(ServiceUtil.getNumber(String.valueOf(minite)));
            b.append("\u5206");
        }
        return b.toString();
    }

    public static String getMoneyYun(BigDecimal money) {
        String moneyStr;
        String x;
        if (money == null || money.doubleValue() < 0.0) {
            money = Constants.MONEY_ZERO;
        }
        if ((x = ServiceUtil.getNumber(moneyStr = (double)money.intValue() == money.doubleValue() ? String.valueOf(money.intValue()) : money.toString())) == null) {
            return null;
        }
        return String.valueOf(x) + "\u5143";
    }

    public static String getNumberChina(String number) {
        String str = ServiceUtil.getNumber(number);
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sbr = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            sbr.append(ServiceUtil.getNumberx(str.charAt(i)));
            ++i;
        }
        return sbr.toString();
    }

    public static String getRemainDaysChina(int days) {
        if (days < 0) {
            days = 0;
        }
        return String.valueOf(ServiceUtil.getNumberChina(String.valueOf(days))) + "\u5929";
    }

    public static String getMoneyYunChina(BigDecimal money) {
        String moneyStr;
        String x;
        if (money == null || money.doubleValue() < 0.0) {
            money = Constants.MONEY_ZERO;
        }
        if ((x = ServiceUtil.getNumberChina(moneyStr = (double)money.intValue() == money.doubleValue() ? String.valueOf(money.intValue()) : money.toString())) == null) {
            return null;
        }
        return String.valueOf(x) + "\u5143";
    }

    private static char getNumberx(char c) {
        if (c == '1') {
            return '\u4e00';
        }
        if (c == '2') {
            return '\u4e8c';
        }
        if (c == '3') {
            return '\u4e09';
        }
        if (c == '4') {
            return '\u56db';
        }
        if (c == '5') {
            return '\u4e94';
        }
        if (c == '6') {
            return '\u516d';
        }
        if (c == '7') {
            return '\u4e03';
        }
        if (c == '8') {
            return '\u516b';
        }
        if (c == '9') {
            return '\u4e5d';
        }
        if (c == '0') {
            return '\u96f6';
        }
        return c;
    }

    public static String getNumber(String number) {
        try {
            double money0 = Double.parseDouble(number);
            String money = number;
            StringBuffer b = new StringBuffer(money.length() * 2);
            if (money0 < 1.0) {
                int zh = -1;
                int i = 0;
                while (i < money.length()) {
                    char v = money.charAt(i);
                    if (v == '.') {
                        b.append('\u70b9');
                        zh = 0;
                    } else {
                        b.append(v);
                        if (zh != -1) {
                            ++zh;
                        }
                    }
                    if (zh != 2) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                char v;
                String newI;
                int h = money.indexOf(46);
                String di = null;
                if (h == -1) {
                    newI = money;
                } else {
                    newI = money.substring(0, h);
                    di = money.substring(h, money.length());
                }
                StringBuilder nj = null;
                LinkedList<StringBuilder> grpList = new LinkedList<StringBuilder>();
                int i = newI.length() - 1;
                int o = 0;
                int u = 1;
                while (i >= 0) {
                    if (o % 4 == 0) {
                        nj = new StringBuilder();
                        grpList.offerFirst(nj);
                        if (o != 0) {
                            int l = 0;
                            while (l < u) {
                                nj.append(',');
                                ++l;
                            }
                            ++u;
                        }
                    }
                    v = newI.charAt(i);
                    nj.append(v);
                    --i;
                    ++o;
                }
                nj = null;
                while ((nj = (StringBuilder)grpList.pollFirst()) != null) {
                    StringBuilder za = new StringBuilder(nj.length());
                    StringBuilder za1 = new StringBuilder(nj.length());
                    boolean all0 = true;
                    int i2 = nj.length() - 1;
                    while (i2 >= 0) {
                        v = nj.charAt(i2);
                        if (v == ',') {
                            za1.append('\u4e07');
                        } else {
                            if (v != '0') {
                                all0 = false;
                            }
                            za.append(v);
                        }
                        --i2;
                    }
                    if (all0) {
                        if (b.length() <= 0 || b.charAt(b.length() - 1) == '0') continue;
                        b.append(0);
                        continue;
                    }
                    if (za.length() > 0) {
                        if (za.length() == 4) {
                            v = za.charAt(0);
                            if (v == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u5343');
                            }
                            if ((v = za.charAt(1)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u767e');
                            }
                            if ((v = za.charAt(2)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u5341');
                            }
                            if ((v = za.charAt(3)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                            }
                        } else if (za.length() == 3) {
                            v = za.charAt(0);
                            if (v == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u767e');
                            }
                            if ((v = za.charAt(1)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u5341');
                            }
                            if ((v = za.charAt(2)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                            }
                        } else if (za.length() == 2) {
                            v = za.charAt(0);
                            if (v == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                                b.append('\u5341');
                            }
                            if ((v = za.charAt(1)) == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                            }
                        } else if (za.length() == 1) {
                            v = za.charAt(0);
                            if (v == '0') {
                                if (b.charAt(b.length() - 1) != '0') {
                                    b.append(v);
                                }
                            } else {
                                b.append(v);
                            }
                        }
                    }
                    if (b.charAt(b.length() - 1) == '0') {
                        b.deleteCharAt(b.length() - 1);
                    }
                    if (za1.length() <= 0) continue;
                    b.append((CharSequence)za1);
                }
                if (b.charAt(b.length() - 1) == '0') {
                    b.deleteCharAt(b.length() - 1);
                }
                int zh = -1;
                if (di != null && di.length() > 0) {
                    int i3 = 0;
                    while (i3 < di.length()) {
                        v = di.charAt(i3);
                        if (v == '.') {
                            b.append('\u70b9');
                            zh = 0;
                        } else {
                            b.append(v);
                            if (zh != -1) {
                                ++zh;
                            }
                        }
                        if (zh != 2) {
                            ++i3;
                            continue;
                        }
                        break;
                    }
                }
            }
            String x = b.toString();
            if (x.startsWith("\u4e00\u5341")) {
                x = x.substring(1);
            }
            return b.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getBlankExePath(String s) {
        char bla = ' ';
        int blankIndex = s.indexOf(bla);
        if (blankIndex != -1) {
            StringBuilder sbr = new StringBuilder(2 * s.length());
            int beginIndex = -1;
            int i = 0;
            while (i < s.length()) {
                char a = s.charAt(i);
                if (a == bla) {
                    if (beginIndex == -1) {
                        sbr.append('\"');
                        beginIndex = i;
                    }
                } else if (beginIndex != -1) {
                    sbr.append('\"');
                    beginIndex = -1;
                }
                sbr.append(a);
                ++i;
            }
            return sbr.toString();
        }
        return s;
    }

    public static LibStartService getLibStartService() {
        return libStartService;
    }

    public static void setLibStartService(LibStartService libStartService0) {
        libStartService = libStartService0;
    }

    public static String getBindCloudSeqUrl() {
        return "http://" + ServiceUtil.getCloudDomain() + "/core/common/bindCarparkSoftSeq.do";
    }

    public static KeyValueEntry<Integer, String> dirbindSeq(String sn) {
        String result;
        CloudConnectTransferCrypto crypto = new CloudConnectTransferCrypto(false);
        String url = ServiceUtil.getBindCloudSeqUrl();
        String p = ServiceUtil.getSnString(sn, crypto);
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("p", p);
        try {
            Proxy proxy = WanNetHostSelector.getWanProxyHost(url).getProxy();
            result = HttpUtil.doRequest((String)url, null, postMap, (int)8000, (int)8000, (Proxy)proxy);
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)-1, (Object)"\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
        }
        return ServiceUtil.getBindSeqResult(crypto, result);
    }

    private static KeyValueEntry<Integer, String> getBindSeqResult(CloudConnectTransferCrypto crypto, String result) {
        if (result == null || result.length() == 0) {
            return new KeyValueEntry((Object)-1, (Object)"\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
        }
        try {
            String json = crypto.decrypt(result);
            Map map = (Map)GsonBuilder.create().fromJson(json, Map.class);
            Integer key = Integer.valueOf((String)map.get("key"));
            String value = (String)map.get("value");
            return new KeyValueEntry((Object)key, (Object)value);
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)-2, (Object)"\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u9519\u8bef");
        }
    }

    public static KeyValueEntry<Integer, String> bindSeqProxy(String sn, String serverHostport) {
        String result;
        String url = "http://" + serverHostport + "/carparkbindcloudseq.action";
        CloudConnectTransferCrypto crypto = new CloudConnectTransferCrypto(false);
        String p = ServiceUtil.getSnString(sn, crypto);
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("p", p);
        try {
            result = HttpUtil.doRequest((String)url, null, postMap);
        }
        catch (Exception ex) {
            return new KeyValueEntry((Object)-1, (Object)"\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
        }
        return ServiceUtil.getBindSeqResult(crypto, result);
    }

    private static String getSnString(String sn, CloudConnectTransferCrypto crypto) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sn", sn);
        paramMap.put("osName", System.getProperty("os.name"));
        LinkedHashMap<String, String> infoMap = new LinkedHashMap<String, String>();
        HardWareInfo info = HardWareUtils.getHardWareInfo();
        infoMap.put("motherboardSn", info.getMotherboardSn());
        infoMap.put("cpuSn", info.getCpuSn());
        infoMap.put("hardDiskSn", info.getHardDiskSn());
        infoMap.put("mac", info.getMac());
        paramMap.put("hardWareInfo", infoMap);
        ProductLicense l = ProductLicense.read();
        paramMap.put("l_org_id", String.valueOf(l.getOrg_id()));
        paramMap.put("l_license_id", String.valueOf(l.getId()));
        return crypto.encrypt(GsonBuilder.create().toJson(paramMap));
    }

    public static Map<String, Object> toStringMap(Object pojo, String nullValue) {
        LinkedHashMap<String, Object> returnMap;
        block26: {
            SimpleDateFormat df3;
            SimpleDateFormat df2;
            SimpleDateFormat df1;
            SimpleDateFormat df;
            block25: {
                if (pojo == null) {
                    return null;
                }
                returnMap = new LinkedHashMap<String, Object>();
                df = null;
                df1 = null;
                df2 = null;
                df3 = null;
                if (!(pojo instanceof Map)) break block25;
                Map x = (Map)pojo;
                for (Map.Entry e : x.entrySet()) {
                    Object zv;
                    if (e.getKey() == null || !(e.getKey() instanceof String)) continue;
                    Object va = e.getValue();
                    if (va != null) {
                        if (va instanceof java.sql.Date) {
                            if (df1 == null) {
                                df1 = new SimpleDateFormat("yyyy-MM-dd");
                            }
                            df = df1;
                        } else if (va instanceof Time) {
                            if (df3 == null) {
                                df3 = new SimpleDateFormat("HH:mm:ss");
                            }
                            df = df3;
                        } else if (va instanceof Date) {
                            if (df2 == null) {
                                df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            }
                            df = df2;
                        }
                    }
                    if ((zv = ServiceUtil.toStringObject(va, df)) == null) {
                        zv = nullValue;
                    }
                    returnMap.put(e.getKey().toString(), zv);
                }
                break block26;
            }
            Map methodMap = JavaBeanUtil.getGetSetMethods(pojo.getClass());
            if (methodMap == null) break block26;
            Object[] t = new Object[]{};
            for (Map.Entry x1 : methodMap.entrySet()) {
                if (x1.getKey() == null || x1.getValue() == null || ((JavaBeanUtil.GetSetMethod)x1.getValue()).getGetMethod() == null) continue;
                try {
                    Object zv;
                    Object va = ((JavaBeanUtil.GetSetMethod)x1.getValue()).getGetMethod().invoke(pojo, t);
                    if (va != null) {
                        if (va instanceof java.sql.Date) {
                            if (df1 == null) {
                                df1 = new SimpleDateFormat("yyyy-MM-dd");
                            }
                            df = df1;
                        } else if (va instanceof Time) {
                            if (df3 == null) {
                                df3 = new SimpleDateFormat("HH:mm:ss");
                            }
                            df = df3;
                        } else if (va instanceof Date) {
                            if (df2 == null) {
                                df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            }
                            df = df2;
                        }
                    }
                    if ((zv = ServiceUtil.toStringObject(va, df)) == null) {
                        zv = nullValue;
                    }
                    returnMap.put((String)x1.getKey(), zv);
                }
                catch (Exception ex) {
                    throw new RuntimeException("\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38:\u7c7b\uff1a" + pojo.getClass() + ",\u5c5e\u6027:" + (String)x1.getKey() + ",\u539f\u56e0:" + ex.getMessage());
                }
            }
        }
        return returnMap;
    }

    private static Object toStringObject(Object value, SimpleDateFormat df) {
        if (value == null) {
            return null;
        }
        Object v = value instanceof Date ? df.format((Date)value) : (value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Boolean ? value.toString() : value);
        return v;
    }

    public static boolean isZvalid() {
        return zvalid;
    }

    public static void setZvalid(boolean zvalid0) {
        zvalid = zvalid0;
    }

    public static Integer getSoftRemainDays() {
        return softRemainDays;
    }

    public static void setSoftRemainDays(Integer softRemainDays0) {
        softRemainDays = softRemainDays0;
    }

    public static Object getConfirmDialogHandelrLock(KeyLockManager keyLockManager, String channelNo, long sessionId) {
        return keyLockManager.getLock("ConfirmDialog.PassSession." + channelNo + "." + sessionId);
    }

    public static Process exec(String command) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        ProcessBuilder p = new ProcessBuilder(cmdarray);
        p.redirectErrorStream(true);
        return p.start();
    }

    public static boolean isFloorMins() {
        String value = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("DURATION_SECONS_TO_MINUTES");
        return value == null || value.length() <= 0 || !"1".equals(value);
    }

    public static long getMins(long secs) {
        long a = secs / 60L;
        if (ServiceUtil.isFloorMins()) {
            return a;
        }
        return secs % 60L == 0L ? a : a + 1L;
    }

    public static int getMins(Date beginTime, Date endTime) {
        if (beginTime == null || endTime == null) {
            return 0;
        }
        if (beginTime.after(endTime)) {
            return 0;
        }
        return (int)ServiceUtil.getMins((endTime.getTime() - beginTime.getTime()) / 1000L);
    }
}

