/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.DbTableTrigger;
import com.wovoe.framework.db.sync.DataSyncService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SyncServerDataJob
extends JobTask
implements DbTableTrigger {
    private ConcurrentLinkedQueue<String> adviceQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean adving = new AtomicBoolean(false);

    protected void doRun() throws Exception {
        CarparkUdpP2pConnection conn;
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
            return;
        }
        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
        if (serverHost == null) {
            return;
        }
        LinkedList<DataSyncService.SyncTable> syncTables = new LinkedList<DataSyncService.SyncTable>();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Enumeration ents = commonDaoService.getAllTableNames();
        while (ents.hasMoreElements()) {
            Class cl;
            String tableName = (String)ents.nextElement();
            if (!tableName.endsWith("_sync") || (cl = commonDaoService.getPoClass(tableName)) == null) continue;
            DataSyncService.SyncTable t = new DataSyncService.SyncTable(tableName, cl);
            syncTables.add(t);
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 1) {
            if (!ServiceUtil.getServiceContext().isConected(serverHost.getHost_no())) {
                return;
            }
            DataSyncService dataSyncService = (DataSyncService)ServiceUtil.getServiceContext().getService(DataSyncService.class);
            String url = "http://" + ServiceUtil.getServiceContext().getCarparkLocalConfig().getServer_host_port() + "/syncTableData";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("hostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            dataSyncService.doSyncRemoteData(url, 5000, null, 1, syncTables, paramMap, "ck_ddl_sync_table_log");
        } else if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode() == 2 && (conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection()).isServerConnected()) {
            conn.doSyncRemoteData(null, 1, syncTables);
        }
    }

    public int getInterestedOps() {
        return 7;
    }

    public String[] getInterestedTableNames() {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        ArrayList<String> syncTables = new ArrayList<String>(60);
        Enumeration ents = commonDaoService.getAllTableNames();
        while (ents.hasMoreElements()) {
            String tableName = (String)ents.nextElement();
            if (!tableName.endsWith("_sync")) continue;
            syncTables.add(tableName);
        }
        return syncTables.toArray(new String[syncTables.size()]);
    }

    public void onUpdate(int op, String physicalTableName, Object paramData, int updateCount) throws Exception {
        if (!this.adviceQueue.contains(physicalTableName)) {
            this.adviceQueue.offer(physicalTableName);
        }
        this.doxRun();
    }

    private void doxRun() {
        if (this.adving.compareAndSet(false, true)) {
            try {
                ServiceUtil.getServiceContext().delay(new JobTask(){

                    protected void doRun() throws Exception {
                        try {
                            Map<String, CarparkHost> hostMap;
                            String tableName;
                            HashMap<String, String> tableList = new HashMap<String, String>();
                            while ((tableName = (String)SyncServerDataJob.this.adviceQueue.poll()) != null) {
                                tableList.put(tableName, tableName);
                            }
                            if (!tableList.isEmpty() && (hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap()) != null && !hostMap.isEmpty()) {
                                for (CarparkHost h : hostMap.values()) {
                                    InetSocketAddress clientAddress;
                                    if (h.getHost_no().equals(ServiceUtil.getServiceContext().getLocalHostNo()) || h.getHost_use() != 1) continue;
                                    if (h.getNet_mode() == 1) {
                                        if (!ServiceUtil.getServiceContext().isConected(h.getHost_no())) continue;
                                        try {
                                            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(h.getHost_no(), true);
                                            if (rpc == null) continue;
                                            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                                            rpcService.syncServerConfigData(tableList, null);
                                        }
                                        catch (Exception ex) {
                                            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                                        }
                                        continue;
                                    }
                                    CarparkUdpClient client = CarparkUdpClientManager.getInstance().getCarparkUdpClient(h.getHost_no());
                                    if (client == null || !client.isConnected() || (clientAddress = client.getClientAddress()) == null) continue;
                                    try {
                                        RequestSender sender = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpRequestSender(client);
                                        sender.setRequestActionName("/CarparkUdpHeatBeatAction");
                                        sender.setHeader("op", "syncServerData");
                                        sender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
                                        sender.setHeader("destHostNo", h.getHost_no());
                                        sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
                                        sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
                                        sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
                                        sender.doRequest(null, null);
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)ex.getMessage());
                                    }
                                }
                            }
                        }
                        finally {
                            SyncServerDataJob.this.adving.set(false);
                            if (SyncServerDataJob.this.adviceQueue.peek() != null) {
                                SyncServerDataJob.this.doxRun();
                            }
                        }
                    }
                }, 3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                this.adving.set(false);
                this.adviceQueue.clear();
            }
        }
    }
}

