/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.internel.ProductLicense;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.RsaUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;

public class UsbDog {
    private static final String CHECK_FILE_PublicKey = "30819f300d06092a864886f70d010101050003818d0030818902818100a1c6df95f1e4cddf057b832098d2d9b00df6648efb2fc124537d65059eb8840771c16b41b9f59db5087a5a7f7df1bf9086d860543b314723216ca1cb313906d0e296cbde88054ddaa70ddc1c691ba23a62d924def9896d55b2efe3183aed37ed7648a1536c61d29acfaad40b4f5ec2dd602e9726fb98ed5242d06ca56ff8d38d0203010001";
    private static final String AUTHJARSIGN = "28274ed442db5065217000d514af22acb4deb528a94d65f44157888feeb8770a93f656c9e1314e015c586845912e104dbd32b6f2bed842e33d5d08c01e6c34348f2d79b5b5f04a031f62568e984503a626304a3f515853354702a1683e11165d5247bcac54c98071922b85ca900c3021cc32f6c725ce28f09119f987ef5a8faf";
    private static final String WIN32jsyunew3SIGN = "241047138c75368f3e218d14386f2f863da8024199ba80747c4837ff2fc7527531b704b93406b992479e0618c013612b83ee2923471385c5c4b4ef6e7c8b80535447d65b2477c9d815ecd84b67e0a034d5dac11e923111e897e5d7d38e17d2e55be0ebe7a921a19c8fa87572270ec82a809e51b9be43672ae762f2e0829703d2";
    private static final String WIN64jsyunew3SIGN = "9b60cac8bb62cc5a54cffcd56f264824699dceaa03bfc1680160e089aaa3dfd570661927aadf7db958818e10dce5794fd503b4731d8daf1dce12c6d9c6bfbfecc827344d37e3381dcca78b0fd6743f4657e7d2b2f3474a42c0d20cb43a246770a3bdb90ff662aa766cee013d9c606db71e40ff6b36fbdedf5ff911423795f3a9";
    private String id;
    private String sn;
    private int orgId;
    private long startTimeMills;
    private long endTimeMills;
    private short keyType;
    private int ctd;
    private short uic;
    private String ask;
    private String cky;
    private int ucst;
    private int nahs;
    private int nao;
    private int uec;

    public static UsbDog parse(byte[] encryptData) {
        try {
            StringBuilder bsr;
            UsbDog dog = new UsbDog();
            ByteBuffer data = RsaUtil.decrypt((byte[])encryptData, (Key)ServiceUtil.getCloudPublicKey());
            byte[] idbytes = new byte[16];
            data.get(idbytes);
            dog.id = BytesTool.byteArrayToHexString((byte[])idbytes, (int)0, (int)idbytes.length);
            int snLen = data.get() & 0xFF;
            if (snLen == 16 || snLen == 8) {
                data.get(idbytes, 0, snLen);
                String hex = BytesTool.byteArrayToHexString((byte[])idbytes, (int)0, (int)snLen).toUpperCase();
                bsr = new StringBuilder();
                char a = '-';
                int i = 0;
                while (i < hex.length()) {
                    if (i > 0 && i % 4 == 0) {
                        bsr.append(a);
                    }
                    bsr.append(hex.charAt(i));
                    ++i;
                }
            }
            dog.sn = bsr.toString();
            dog.orgId = data.getInt();
            dog.startTimeMills = data.getLong();
            dog.endTimeMills = data.getLong();
            dog.keyType = data.getShort();
            if (data.remaining() >= 42) {
                dog.ctd = data.getInt();
                dog.uic = data.getShort();
                byte[] auth_sign_keyBytes = new byte[32];
                data.get(auth_sign_keyBytes);
                byte[] camera_crypto_keyBytes = new byte[data.get() & 0xFF];
                data.get(camera_crypto_keyBytes);
                dog.ucst = data.get() & 0xFF;
                dog.nahs = data.get() & 0xFF;
                dog.nao = data.get() & 0xFF;
                dog.uec = data.get() & 0xFF;
                dog.ask = UsbDog.getM(dog.ctd, dog.orgId, auth_sign_keyBytes, false);
                dog.cky = UsbDog.getM(dog.ctd, dog.orgId, camera_crypto_keyBytes, false);
            }
            return dog;
        }
        finally {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public long getStartTimeMills() {
        return this.startTimeMills;
    }

    public void setStartTimeMills(long startTimeMills) {
        this.startTimeMills = startTimeMills;
    }

    public long getEndTimeMills() {
        return this.endTimeMills;
    }

    public void setEndTimeMills(long endTimeMills) {
        this.endTimeMills = endTimeMills;
    }

    public short getKeyType() {
        return this.keyType;
    }

    public void setKeyType(short keyType) {
        this.keyType = keyType;
    }

    private static PublicKey getCheckFilePublicKey(String pk) throws Exception {
        byte[] bytes = BytesTool.hexStringToByteArray((String)pk);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey key = factory.generatePublic(keySpec);
        return key;
    }

    private static boolean checkFile(File file, String sign, PublicKey key) {
        try {
            if (file.length() > 0xA00000L) {
                ServiceLog.getLog().warn((Object)(String.valueOf(file.getAbsolutePath()) + " File too large"));
            }
            if (file.length() == 0L) {
                ServiceLog.getLog().warn((Object)(String.valueOf(file.getAbsolutePath()) + " File damaged"));
            }
            byte[] data = UsbDog.getFileBytes(file);
            return RsaUtil.verify((byte[])data, (PublicKey)key, (String)sign);
        }
        finally {
            return false;
        }
    }

    private static byte[] getFileBytes(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        try (FileInputStream in = new FileInputStream(file);){
            int r;
            byte[] cache = new byte[8192];
            while ((r = in.read(cache)) != -1) {
                out.write(cache, 0, r);
            }
        }
        byte[] data = out.toByteArray();
        return data;
    }

    public static UsbDog read(String readKey, ProductLicense license) {
        String readResult;
        block28: {
            String line;
            PublicKey pk;
            File jarFile;
            File libFile;
            File javaBinDir;
            block27: {
                String libSign;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (OSUtil.isWindows()) break block22;
                                    return null;
                                }
                                if (OSUtil.isOS32()) {
                                    javaBinDir = new File(PathFinder.findHomeDir(), "bin/jre32/bin");
                                    libFile = new File(PathFinder.findHomeDir(), "native/YT699/win32/jsyunew3.dll");
                                    libSign = WIN32jsyunew3SIGN;
                                } else {
                                    javaBinDir = new File(PathFinder.findHomeDir(), "bin/jre64/bin");
                                    libFile = new File(PathFinder.findHomeDir(), "native/YT699/win64/jsyunew3.dll");
                                    libSign = WIN64jsyunew3SIGN;
                                }
                                if (javaBinDir.exists() && javaBinDir.isDirectory()) break block23;
                                ServiceLog.getLog().warn((Object)(String.valueOf(javaBinDir.getAbsolutePath()) + " Directory not found!"));
                                return null;
                            }
                            if (libFile.exists() && libFile.isFile()) break block24;
                            ServiceLog.getLog().warn((Object)(String.valueOf(libFile.getAbsolutePath()) + " File not found!"));
                            return null;
                        }
                        jarFile = new File(PathFinder.findHomeDir(), "bin/lib/auth.jar");
                        if (jarFile.exists() && jarFile.isFile()) break block25;
                        ServiceLog.getLog().warn((Object)(String.valueOf(jarFile.getAbsolutePath()) + " File not found!"));
                        return null;
                    }
                    pk = UsbDog.getCheckFilePublicKey(CHECK_FILE_PublicKey);
                    if (UsbDog.checkFile(jarFile, AUTHJARSIGN, pk)) break block26;
                    ServiceLog.getLog().warn((Object)(String.valueOf(jarFile.getAbsolutePath()) + " The file has been tampered or damaged"));
                    return null;
                }
                if (UsbDog.checkFile(libFile, libSign, pk)) break block27;
                ServiceLog.getLog().warn((Object)(String.valueOf(libFile.getAbsolutePath()) + " The file has been tampered or damaged"));
                return null;
            }
            String javaExe = String.valueOf(javaBinDir.getAbsolutePath()) + File.separator + "java";
            if (readKey == null || readKey.length() == 0) {
                String ax = "4e2039e67540a45fcd1d47a55d7b0c682db1e3b9ac2805b2dfbf22422b6dbc4a3578c49bba9838015eda64d6c3d05f8f694cfdc1e7716871c4e20ee769ecbf861fbf69aca96e7c8ffa5b14466fc04a8811236600971273f5d7dfa4363667421908310722d0c3b263ae7b28ba7c92bac9903d3bbc056cae5400ee535b0a194ead";
                readKey = new String(RsaUtil.decryptToBytes((byte[])BytesTool.hexStringToByteArray((String)ax), (Key)pk));
            }
            StringBuilder _command = new StringBuilder(128).append(javaExe);
            _command.append(" -jar ").append(jarFile.getAbsolutePath());
            _command.append(" ").append(readKey);
            _command.append(" ").append(BytesTool.byteArrayToHexString((byte[])libFile.getAbsolutePath().getBytes("UTF-8")));
            String command = _command.toString();
            Process p = UsbDog.exec(command);
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            String ars = "read_data:";
            readResult = null;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(ars)) continue;
                readResult = line;
                break;
            }
            try {
                if (p.isAlive()) {
                    p.destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (readResult != null && readResult.length() != 0) break block28;
            return null;
        }
        try {
            if (readResult.startsWith("read_data:0,")) {
                readResult = readResult.substring("read_data:".length());
                String[] rs = readResult.split(";");
                UsbDog rDog = null;
                String[] stringArray = rs;
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    UsbDog dog;
                    String r = stringArray[n2];
                    if (r.length() > 0 && (dog = UsbDog.readFrom(r, license)) != null) {
                        if (rDog == null) {
                            rDog = dog;
                        } else if (rDog.getEndTimeMills() < dog.getEndTimeMills()) {
                            rDog = dog;
                        }
                    }
                    ++n2;
                }
                return rDog;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static UsbDog readFrom(String data, ProductLicense license) {
        UsbDog dog;
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            String[] stes;
                            block13: {
                                block12: {
                                    block11: {
                                        try {
                                            stes = data.split(",");
                                            dog = UsbDog.parse(BytesTool.hexStringToByteArray((String)stes[2]));
                                            if (dog != null) break block11;
                                            return null;
                                        }
                                        catch (Exception ex) {
                                            return null;
                                        }
                                    }
                                    if (dog.getKeyType() == 1) break block12;
                                    ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7ed1\u5b9a\u7684\u4ea7\u54c1\u578b\u9519\u8bef"));
                                    return null;
                                }
                                if (dog.getSn() != null && dog.getSn().length() != 0) break block13;
                                ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7ed1\u5b9a\u7684\u5e8f\u5217\u53f7\u9519\u8bef"));
                                return null;
                            }
                            if (stes[1].equals(dog.getId())) break block14;
                            ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7ed1\u5b9a\u7684\u8bbe\u5907id\u9519\u8bef"));
                            return null;
                        }
                        if (license == null) break block15;
                        if (dog.getCtd() == 0 && license.isUseDefault()) {
                            dog.setCtd(license.getId());
                            dog.setOrgId(license.getOrg_id());
                            dog.setUic((short)license.getAuth_ui_code());
                            dog.setAsk(license.getAuth_sign_key());
                            dog.setCky(license.getCamera_crypto_key());
                            dog.setUcst(license.getUse_camera_sign_type());
                            dog.setNahs(license.getNeed_auth_host_sign());
                            dog.setNao(license.getNeed_auth_org());
                            dog.setUec(license.getUse_encrypt_camera());
                        }
                        if (dog.getCtd() == license.getId()) break block16;
                        ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7684\u8bc1\u4e66id\u4e0d\u4e00\u81f4\uff0c\u65e0\u6548\u72d7"));
                        return null;
                    }
                    if (dog.getKeyType() == license.getProduct_type()) break block17;
                    ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7684\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6548\u72d7"));
                    return null;
                }
                if (dog.getOrgId() == license.getOrg_id()) break block18;
                ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7684\u4e3b\u4f53\u4e0d\u4e00\u81f4\uff0c\u65e0\u6548\u72d7"));
                return null;
            }
            if (license.getAuth_sign_key().equals(dog.getAsk())) break block15;
            ServiceLog.getLog().error((Object)(String.valueOf(dog.getId()) + ": \u72d7\u7684\u7b7e\u540d\u9519\u8bef\uff0c\u65e0\u6548\u72d7"));
            return null;
        }
        return dog;
    }

    private static Process exec(String command) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        ProcessBuilder p = new ProcessBuilder(cmdarray);
        p.redirectErrorStream(true);
        return p.start();
    }

    static String getM(int id, int orgId, byte[] key, boolean hex) {
        byte[] idBytes = BytesTool.intToBytes((int)id);
        byte[] orgTypes = BytesTool.intToBytes((int)orgId);
        byte[] keyXbytes = new byte[4];
        int i = 0;
        while (i < 4) {
            keyXbytes[i] = (byte)(idBytes[i] ^ orgTypes[i]);
            ++i;
        }
        byte[] mx = new byte[key.length];
        int i2 = 0;
        while (i2 < key.length) {
            mx[i2] = (byte)(key[i2] ^ keyXbytes[i2 % keyXbytes.length]);
            ++i2;
        }
        if (hex) {
            return BytesTool.byteArrayToHexString((byte[])mx).toUpperCase();
        }
        try {
            return new String(mx, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            try {
                return new String(mx, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                return new String(mx);
            }
        }
    }

    public int getCtd() {
        return this.ctd;
    }

    public void setCtd(int ctd) {
        this.ctd = ctd;
    }

    public short getUic() {
        return this.uic;
    }

    public void setUic(short uic) {
        this.uic = uic;
    }

    public String getAsk() {
        return this.ask;
    }

    public void setAsk(String ask) {
        this.ask = ask;
    }

    public String getCky() {
        return this.cky;
    }

    public void setCky(String cky) {
        this.cky = cky;
    }

    public int getUcst() {
        return this.ucst;
    }

    public void setUcst(int ucst) {
        this.ucst = ucst;
    }

    public int getNahs() {
        return this.nahs;
    }

    public void setNahs(int nahs) {
        this.nahs = nahs;
    }

    public int getNao() {
        return this.nao;
    }

    public void setNao(int nao) {
        this.nao = nao;
    }

    public int getUec() {
        return this.uec;
    }

    public void setUec(int uec) {
        this.uec = uec;
    }
}

