/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class VacuumdbJob
extends JobTask {
    protected void doRun() throws Exception {
        try {
            String winD;
            Calendar cl = Calendar.getInstance();
            if (cl.get(7) != 2) {
                return;
            }
            String string = winD = OSUtil.isOS32() ? "_win32" : "_win64";
            if (!OSUtil.isOS32() && "true".equals(System.getProperty("useDb32", "false"))) {
                winD = "_win32";
            }
            File pgsqlHome = new File(PathFinder.findHomeDir(), "installation/pgsql" + winD);
            Properties db = ServiceUtil.getServiceContext().getDbconfig();
            String istanllPath = pgsqlHome.getAbsolutePath();
            VacuumdbJob.doVacuumdb(istanllPath, db.getProperty("host"), Integer.parseInt(db.getProperty("port")), db.getProperty("dbname"), db.getProperty("user"), db.getProperty("pwd"));
        }
        catch (Exception ex) {
            LogUtil.getLog().error((Object)"", (Throwable)ex);
        }
    }

    public static CountDownLatch doVacuumdb(String postgresInstallPath, final String host, final int port, final String dbName, final String userName, String password) {
        File binDir;
        CountDownLatch countdown;
        block35: {
            countdown = new CountDownLatch(1);
            if (postgresInstallPath == null || host == null || dbName == null || userName == null) {
                LogUtil.getLog().warn((Object)"\u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef\uff01\u7f3a\u5c11\u5c5e\u6027! \u8fd9\u5c06\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u4f18\u5316\u64cd\u4f5c!!!!!");
                countdown.countDown();
                return countdown;
            }
            if (!OSUtil.isWindows()) break block35;
            String user_dir = System.getProperty("user.home");
            if (user_dir == null || user_dir.length() == 0) {
                LogUtil.getLog().warn((Object)"\u65e0\u6cd5\u627e\u5230\u7cfb\u7edf\u7684\u4e3b\u76ee\u5f55, \u8fd9\u5c06\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u4f18\u5316\u64cd\u4f5c!!!!!");
                countdown.countDown();
                return countdown;
            }
            String[] xmames = new String[]{"AppData", "Application Data"};
            boolean exist = false;
            String[] stringArray = xmames;
            int n = xmames.length;
            int n2 = 0;
            while (n2 < n) {
                block34: {
                    File postgresql;
                    block37: {
                        File AppData;
                        block36: {
                            String zlname = stringArray[n2];
                            if (!"AppData".equals(zlname)) break block36;
                            AppData = new File(user_dir, "AppData");
                            if (!AppData.exists() || !AppData.isDirectory()) break block34;
                            postgresql = new File(AppData, "Roaming/postgresql");
                            if (!postgresql.exists() || !postgresql.isDirectory()) {
                                postgresql.mkdirs();
                            }
                            exist = true;
                            break block37;
                        }
                        AppData = new File(user_dir, "Application Data");
                        if (!AppData.exists() || !AppData.isDirectory()) break block34;
                        postgresql = new File(AppData, "postgresql");
                        if (!postgresql.exists() || !postgresql.isDirectory()) {
                            postgresql.mkdirs();
                        }
                        exist = true;
                    }
                    String keyxn = String.valueOf(host) + ":" + port + ":*:" + userName + ":" + password;
                    File xf = new File(postgresql, "pgpass.conf");
                    boolean create = false;
                    if (!xf.exists() || !xf.isFile()) {
                        create = true;
                    } else {
                        BufferedReader in = null;
                        try {
                            try {
                                in = new BufferedReader(new FileReader(xf));
                                String line1 = in.readLine();
                                if (line1 == null || !keyxn.equals(line1)) {
                                    create = true;
                                }
                            }
                            catch (IOException e) {
                                LogUtil.getLog().error((Object)e.getMessage());
                                countdown.countDown();
                                CountDownLatch countDownLatch = countdown;
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e2) {
                                        LogUtil.getLog().error((Object)("close excepiton " + e2.getMessage()));
                                    }
                                }
                                return countDownLatch;
                            }
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    LogUtil.getLog().error((Object)("close excepiton " + e.getMessage()));
                                }
                            }
                        }
                    }
                    if (create) {
                        try (PrintWriter pw = null;){
                            try {
                                pw = new PrintWriter(new FileWriter(xf));
                                pw.println(keyxn);
                            }
                            catch (IOException e) {
                                LogUtil.getLog().error((Object)e.getMessage());
                                countdown.countDown();
                                CountDownLatch countDownLatch = countdown;
                                if (pw != null) {
                                    pw.close();
                                }
                                return countDownLatch;
                            }
                        }
                    }
                }
                ++n2;
            }
            if (!exist) {
                LogUtil.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u76ee\u5f55:" + new File(user_dir, "Application Data") + "\u6216" + new File(user_dir, "AppData") + " \u8fd9\u5c06\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u4f18\u5316\u64cd\u4f5c!!!!!"));
                countdown.countDown();
                return countdown;
            }
        }
        if (!(binDir = new File(postgresInstallPath, "bin")).exists() || !binDir.isDirectory()) {
            LogUtil.getLog().warn((Object)("\u914d\u7f6e\u9519\u8bef\uff01\u7f3a\u5c11\u6587\u4ef6" + binDir + "! \u8fd9\u5c06\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u4f18\u5316\u64cd\u4f5c!!!!!"));
            countdown.countDown();
            return countdown;
        }
        new Thread(new Runnable(){

            private void doCammand(final String command) throws IOException, InterruptedException {
                if (command.length() == 0) {
                    throw new IllegalArgumentException("Empty command");
                }
                StringTokenizer st = new StringTokenizer(command);
                String[] cmdarray = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    cmdarray[i] = st.nextToken();
                    ++i;
                }
                ProcessBuilder p = new ProcessBuilder(cmdarray);
                p.redirectErrorStream(true);
                final String[] firstout = new String[1];
                final Process process = p.start();
                final CountDownLatch l = new CountDownLatch(1);
                try {
                    String line;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean success = false;
                                int i = 0;
                                while (i < 60) {
                                    success = l.await(1L, TimeUnit.MINUTES);
                                    if (success) break;
                                    if (firstout[0] == null && i >= 30) {
                                        LogUtil.getLog().warn((Object)"\u53ef\u80fd\u786e\u5c11\u6587\u4ef6: pgpass.conf \u6216\u8005 ~/.pgpass \u8bf7\u68c0\u67e5!");
                                        break;
                                    }
                                    ++i;
                                }
                                if (!success) {
                                    LogUtil.getLog().warn((Object)("\u6267\u884c\u547d\u4ee4 " + command + " 1\u5c0f\u65f6\u90fd\u6ca1\u6267\u884c\u5b8c\u6210! \u9000\u51fa!"));
                                    process.destroy();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }).start();
                    InputStream xa = process.getInputStream();
                    BufferedReader sbr = new BufferedReader(new InputStreamReader(xa));
                    while ((line = sbr.readLine()) != null) {
                        if (firstout[0] == null) {
                            firstout[0] = line;
                        }
                        if (!LogUtil.getLog().isInfoEnabled()) continue;
                        LogUtil.getLog().info((Object)line);
                    }
                    sbr.close();
                    process.waitFor();
                }
                finally {
                    try {
                        process.destroy();
                    }
                    catch (Exception exception) {}
                    l.countDown();
                }
            }

            @Override
            public void run() {
                try {
                    try {
                        StringBuilder sbrv = new StringBuilder(128);
                        sbrv.append(binDir.getAbsolutePath()).append(File.separator).append("vacuumdb").append(" -h ").append(host).append(" -p ").append(port);
                        sbrv.append(" -U ").append(userName).append(" -d ").append(dbName).append(" -f -z -v");
                        String command = sbrv.toString();
                        LogUtil.getLog().info((Object)command);
                        this.doCammand(command);
                        sbrv = new StringBuilder(128);
                        sbrv.append(binDir.getAbsolutePath()).append(File.separator).append("reindexdb").append(" -h ").append(host).append(" -p ").append(port);
                        sbrv.append(" -U ").append(userName).append(" -d ").append(dbName);
                        command = sbrv.toString();
                        LogUtil.getLog().info((Object)command);
                        this.doCammand(command);
                    }
                    catch (Exception ex) {
                        LogUtil.getLog().error((Object)"", (Throwable)ex);
                        countdown.countDown();
                    }
                }
                finally {
                    countdown.countDown();
                }
            }
        }).start();
        return countdown;
    }
}

