/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.internel;

import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.WanProxyHost;
import com.wovoe.carpark.conn.udp.net.LanBroadcastServiceAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpResponseLineStringCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.http.UrlResolution;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class WanNetConnectCheckJob
extends JobTask
implements UrlResolution {
    private static WanNetConnectCheckJob instance = new WanNetConnectCheckJob();
    private volatile boolean wanNetOk = false;
    private volatile boolean dirWanOk = false;
    private volatile boolean searchProxy = false;
    private Map<String, KeyValueEntry<String, Long>> hostsMap = new ConcurrentHashMap<String, KeyValueEntry<String, Long>>();
    private static final ThreadLocal<WanProxyHost> proxyHostLocal = new ThreadLocal();

    public static WanNetConnectCheckJob getInstance() {
        return instance;
    }

    private WanNetConnectCheckJob() {
        HttpUtil.setUrlResolution((UrlResolution)this);
    }

    public void enableProxySearcher(boolean enable) {
        this.searchProxy = enable;
        if (!enable) {
            WanNetHostSelector.setWanProxyHost(WanNetHostSelector.SELF_HOST);
        }
    }

    public boolean isWanNetOk() {
        return this.wanNetOk;
    }

    public boolean isDirectWanOk() {
        return this.dirWanOk;
    }

    protected void doRun() throws Exception {
        this.checkRun();
    }

    public synchronized void checkRun() {
        try {
            LanBroadcastServiceAction.LanWanProxyHost host;
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            long timeoutMills = TimeUnit.MINUTES.toMillis(10L);
            Iterator<Map.Entry<String, KeyValueEntry<String, Long>>> it = this.hostsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, KeyValueEntry<String, Long>> entry = it.next();
                if (currentMills - (Long)entry.getValue().getValue() < timeoutMills) continue;
                it.remove();
            }
            try {
                String checkHost = null;
                if (!this.dirWanOk) {
                    KeyValueEntry<String, Long> en = this.hostsMap.get("www.baidu.com");
                    if (en != null) {
                        checkHost = (String)en.getKey();
                    } else {
                        final OperationFutureHandler ops = ServiceUtil.getServiceContext().createOperationFuture();
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String x = InetAddress.getByName("www.baidu.com").getHostAddress();
                                    ops.setResult((Object)x);
                                }
                                catch (Exception ex) {
                                    ops.setResult(null);
                                }
                            }
                        });
                        try {
                            checkHost = (String)ops.get(2000L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    checkHost = "www.baidu.com";
                }
                if (checkHost == null) {
                    this.dirWanOk = false;
                } else {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(checkHost, 443), 5000);
                    socket.close();
                    this.dirWanOk = true;
                }
            }
            catch (Exception ex) {
                this.dirWanOk = false;
            }
            if (this.dirWanOk) {
                WanNetHostSelector.setWanProxyHost(WanNetHostSelector.SELF_HOST);
                this.wanNetOk = true;
                return;
            }
            if (!this.searchProxy) {
                WanNetHostSelector.setWanProxyHost(WanNetHostSelector.SELF_HOST);
                this.wanNetOk = false;
                return;
            }
            WanProxyHost proxyHost = WanNetHostSelector.getWanProxyHost();
            if (WanNetHostSelector.isProxyMode(proxyHost)) {
                try {
                    HttpUtil.doRequest((String)("http://" + ServiceUtil.getCloudDomain() + "/core/test.do"), null, null, (int)6000, (int)8000, (Proxy)proxyHost.getProxy());
                    this.wanNetOk = true;
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            long waitMills = 3000L;
            BlockingQueue<LanBroadcastServiceAction.LanWanProxyHost> q = LanBroadcastServiceAction.findLanWanProxyHosts(waitMills);
            HashSet<WanProxyHost> rvHost = new HashSet<WanProxyHost>();
            long x = ServiceUtil.getServiceContext().currentTimeMillis();
            while ((host = q.poll(waitMills, TimeUnit.MILLISECONDS)) != null) {
                WanProxyHost proxyHost0 = new WanProxyHost(host.lanAddress, host.httpPort, host.socks5Port, host.sn, host.name);
                if (!rvHost.contains(proxyHost0)) {
                    rvHost.add(proxyHost0);
                    proxyHostLocal.set(proxyHost0);
                    try {
                        HttpUtil.doRequest((String)("http://" + ServiceUtil.getCloudDomain() + "/core/test.do"), null, null, (int)6000, (int)8000, (Proxy)proxyHost0.getProxy());
                        this.wanNetOk = true;
                        WanNetHostSelector.setWanProxyHost(proxyHost0);
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        proxyHostLocal.remove();
                    }
                }
                if (waitMills > 0L) {
                    long x1 = ServiceUtil.getServiceContext().currentTimeMillis() - x;
                    waitMills = x1 >= waitMills ? 0L : (waitMills -= x1);
                }
                if (waitMills <= 0L && q.peek() == null) break;
            }
            this.wanNetOk = false;
            WanNetHostSelector.setWanProxyHost(WanNetHostSelector.SELF_HOST);
        }
        catch (Throwable ex) {
            this.wanNetOk = false;
        }
    }

    public String resolution(String requestUrl, int requestType, Proxy proxy) {
        String domainPortLast;
        String domain;
        if (proxy == null || proxy.type() != Proxy.Type.SOCKS) {
            return requestUrl;
        }
        if (requestUrl.indexOf("/proxy/domainResolution") != -1 || requestUrl.indexOf("/domainResolution.jsp") != -1) {
            return requestUrl;
        }
        WanProxyHost proxyHost = WanNetHostSelector.getWanProxyHost();
        if (!WanNetHostSelector.isProxyMode(proxyHost)) {
            WanProxyHost h = proxyHostLocal.get();
            if (h != null && WanNetHostSelector.isProxyMode(h)) {
                proxyHost = h;
            } else {
                return requestUrl;
            }
        }
        int x = requestUrl.indexOf("://");
        StringBuilder newUrl = new StringBuilder(requestUrl.length() + 16);
        newUrl.append(requestUrl.substring(0, x += 3));
        String url = requestUrl.substring(x);
        x = url.indexOf(47);
        if (x == -1) {
            domain = url;
            domainPortLast = null;
        } else {
            domain = url.substring(0, x);
            domainPortLast = url.substring(x);
        }
        x = domain.indexOf(58);
        if (x != -1) {
            domainPortLast = domainPortLast == null ? domain.substring(x) : String.valueOf(domain.substring(x)) + domainPortLast;
            domain = domain.substring(0, x);
        }
        if ((x = domain.lastIndexOf(46)) == -1) {
            return requestUrl;
        }
        if (WanNetHostSelector.isIpV4(domain)) {
            return requestUrl;
        }
        String ip = this.getIpAddress(domain, proxyHost);
        if (ip == null || ip.length() == 0) {
            return requestUrl;
        }
        String urlss = newUrl.append(ip).append(domainPortLast).toString();
        return urlss;
    }

    private String getIpAddress(String domain, WanProxyHost proxyHost) {
        KeyValueEntry<String, Long> entry = this.hostsMap.get(domain);
        if (entry != null) {
            return (String)entry.getKey();
        }
        String ip = null;
        try {
            String url = "http://" + proxyHost.getProxyHost() + ":" + proxyHost.getHttpPort() + "/proxy/domainResolution";
            Map<String, String> map = WanNetConnectCheckJob.getDomainMapFromServer(url, null, domain);
            ip = map.get(domain);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4ee3\u7406\u670d\u52a1\u5668\u89e3\u6790\u57df\u540d" + domain + "\u5931\u8d25\uff01" + ex));
        }
        if (ip != null && ip.length() > 0) {
            this.hostsMap.put(domain, (KeyValueEntry<String, Long>)new KeyValueEntry((Object)ip, (Object)ServiceUtil.getServiceContext().currentTimeMillis()));
            return ip;
        }
        return null;
    }

    public static Map<String, String> getDomainsFromCloudServerByIp(Proxy proxy, String ... domians) throws Exception {
        return WanNetConnectCheckJob.getDomainsFromCloudServer("106.55.219.127", proxy, domians);
    }

    public static Map<String, String> getDomainsFromCloudServerByDomian(Proxy proxy, String ... domians) throws Exception {
        return WanNetConnectCheckJob.getDomainsFromCloudServer(ServiceUtil.getCloudDomain(), proxy, domians);
    }

    public static Map<String, String> getDomainsFromCloudServer(String httpDnsDomain, Proxy proxy, String ... domians) throws Exception {
        return WanNetConnectCheckJob.getDomainMapFromServer("http://" + httpDnsDomain + "/domainResolution.jsp", proxy, domians);
    }

    public static Map<String, String> getDomainMapFromServer(String url, Proxy proxy, String ... domians) throws Exception {
        HashMap<String, String> postMap = new HashMap<String, String>();
        StringBuilder sbr = new StringBuilder();
        String[] stringArray = domians;
        int n = domians.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (sbr.length() > 0) {
                sbr.append(',');
            }
            sbr.append(s);
            ++n2;
        }
        postMap.put("domains", sbr.toString());
        final LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        HttpUtil.doRequest((String)url, null, postMap, null, null, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
            String SUCCESS = "SUCCESS:";

            public String onComplete() {
                return null;
            }

            public void onException(Throwable ex) {
            }

            public boolean callback(String line) {
                if (line != null && (line = line.trim()).length() > 0) {
                    if (line.startsWith(this.SUCCESS)) {
                        int x = (line = line.substring(this.SUCCESS.length())).indexOf(58);
                        if (x == -1) {
                            ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u9519\u8bef\u7684\u89e3\u6790\u5730\u5740\uff01" + line));
                        } else {
                            String domian = line.substring(0, x);
                            String ip = line.substring(x + 1);
                            returnMap.put(domian, ip);
                        }
                    } else {
                        ServiceLog.getLog().warn((Object)("\u67e5\u8be2\u57df\u540d\u5931\u8d25\uff01" + line));
                    }
                }
                return true;
            }

            public boolean onHeaders(HttpResponse response) {
                return true;
            }
        }, (int)(proxy == null ? 5000 : 3000), (int)5000, (Proxy)proxy);
        return returnMap;
    }
}

