/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.launcher;

import com.wovoe.carpark.gui.MacOptionDialog;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.launcher.Launcher;
import com.wovoe.carpark.launcher.SlashUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class DefaultSlashUI
implements SlashUI {
    private JWindow slashWindow;
    private JProgressBar loadProgressBar;
    private JLabel jLabel2;
    private int totalProcessCount;
    private AtomicInteger finishCount = new AtomicInteger(0);

    @Override
    public void setprocessMessage(final String processMessage) {
        if (processMessage != null && this.jLabel2 != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSlashUI.this.jLabel2.setText(processMessage);
                    }
                });
            } else {
                this.jLabel2.setText(processMessage);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadImage(Image[] images) {
        try {
            File skin = new File(Launcher.findHomeDir(), "skin");
            if (!skin.exists()) return;
            if (!skin.isDirectory()) {
                return;
            }
            File feature = new File(skin, "feature.skin");
            if (!feature.exists()) return;
            if (!feature.isFile()) {
                return;
            }
            int dataIndex = 0;
            byte[] data = null;
            byte[] buf = new byte[0x100000];
            boolean state = false;
            byte[] dataLenBytes = new byte[4];
            int dataLenIndexx = 0;
            FileInputStream in = new FileInputStream(feature);
            int maxLen = 0xF00000;
            boolean run = true;
            try {
                block8: while (true) {
                    if (!run) return;
                    int len = in.read(buf, 0, buf.length);
                    if (len == -1) {
                        return;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= len) continue block8;
                        if (!state) {
                            dataLenBytes[dataLenIndexx++] = buf[i];
                            if (dataLenIndexx == dataLenBytes.length) {
                                int x = DefaultSlashUI.bytesToInt(dataLenBytes);
                                if (x <= 0 || x > maxLen) {
                                    System.err.println("\u6587\u4ef6:feature.skin\u5df2\u635f\u574f!");
                                    return;
                                }
                                state = true;
                                data = new byte[x];
                                dataIndex = 0;
                            }
                        } else if (state) {
                            data[dataIndex++] = buf[i];
                            if (dataIndex == data.length) {
                                Object[] imageInfo = this.parseImage(data = this.decodeData(dataLenBytes, data));
                                if (imageInfo == null) {
                                    return;
                                }
                                String imageName = (String)imageInfo[0];
                                if (!imageName.startsWith("slash_start.")) {
                                    if (!imageName.startsWith("logo.")) return;
                                    images[1] = (Image)imageInfo[1];
                                    return;
                                }
                                data = null;
                                dataIndex = 0;
                                dataLenIndexx = 0;
                                state = false;
                                images[0] = (Image)imageInfo[1];
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    private Object[] parseImage(byte[] data) {
        String name;
        int nameLen;
        byte flag;
        if (data.length == 0) {
            return null;
        }
        int index = 0;
        if ((flag = data[index++]) != 1) {
            return null;
        }
        if ((nameLen = data[index++] & 0xFF) + index > data.length) {
            return null;
        }
        try {
            name = new String(data, index, nameLen, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            name = new String(data, index, nameLen);
        }
        if ((index += nameLen) + 4 > data.length) {
            return null;
        }
        int valueLen = DefaultSlashUI.bytesToInt(data, index);
        index += 4;
        if (valueLen <= 0) {
            return null;
        }
        if (index + valueLen != data.length) {
            return null;
        }
        Object[] objs = new Object[2];
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data, index, valueLen);
            BufferedImage image = ImageIO.read(in);
            objs[0] = name;
            objs[1] = image;
            return objs;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private byte[] decodeData(byte[] dataLenBytes, byte[] data) {
        byte c = dataLenBytes[0];
        int i = 1;
        while (i < dataLenBytes.length) {
            c = (byte)(c ^ dataLenBytes[i]);
            ++i;
        }
        i = 0;
        while (i < data.length) {
            data[i] = (byte)(c ^ data[i]);
            ++i;
        }
        return data;
    }

    private static int bytesToInt(byte[] b) {
        return DefaultSlashUI.makeInt(b[0], b[1], b[2], b[3]);
    }

    private static int bytesToInt(byte[] b, int offset) {
        return DefaultSlashUI.makeInt(b[offset], b[offset + 1], b[offset + 2], b[offset + 3]);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    @Override
    public CountDownLatch showSlashWindow(String LookAndFeel2) {
        final Image[] skinImage = new Image[2];
        this.loadImage(skinImage);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSlashUI.this.slashWindow = new JWindow();
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    int windowWidth = (int)Math.round(screenSize.getWidth() * 600.0 / 1024.0);
                    int windowHeight = (int)Math.round(screenSize.getHeight() * 400.0 / 768.0);
                    DefaultSlashUI.this.slashWindow.setSize(windowWidth, windowHeight);
                    DefaultSlashUI.this.slashWindow.setLocation((screenSize.width - windowWidth) / 2, (screenSize.height - windowHeight) / 2);
                    JProgressBar progressbar = new JProgressBar();
                    DefaultSlashUI.this.loadProgressBar = progressbar;
                    progressbar.setOrientation(0);
                    progressbar.setMinimum(0);
                    progressbar.setMaximum(100);
                    progressbar.setValue(0);
                    progressbar.setStringPainted(true);
                    DefaultSlashUI.this.jLabel2 = new JLabel();
                    Image logoImage = skinImage[1];
                    if (logoImage == null) {
                        logoImage = CarparkGuiSkinUtil.getCarparkGuiSkin().newImageFromClassPath("logo");
                    }
                    DefaultSlashUI.this.slashWindow.setIconImage(logoImage);
                    JPanel p1 = new JPanel(new BorderLayout());
                    int pHeight = (int)Math.round(screenSize.getHeight() * 15.0 / 768.0);
                    Dimension processBarSize = new Dimension(windowWidth, pHeight);
                    DefaultSlashUI.this.loadProgressBar.setPreferredSize(processBarSize);
                    int picWidth = windowWidth;
                    int picHeight = windowHeight - pHeight;
                    Image originalImage = skinImage[0];
                    if (originalImage == null) {
                        originalImage = CarparkGuiSkinUtil.getCarparkGuiSkin().newImageFromClassPath("slash_start");
                    }
                    Image rmag = originalImage.getScaledInstance(picWidth, picHeight, 4);
                    ImageIcon inmgIcon = new ImageIcon(rmag);
                    int fontSize13 = (int)Math.round(screenSize.getHeight() * 11.0 / 768.0);
                    String fontNames = "\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53";
                    String fontName = DefaultSlashUI.getFontFamily(fontNames);
                    DefaultSlashUI.this.loadProgressBar.setFont(new Font(fontName, 0, fontSize13));
                    p1.add((Component)DefaultSlashUI.this.loadProgressBar, "South");
                    DefaultSlashUI.this.jLabel2.setText("\u6b63\u5728\u542f\u52a8...");
                    DefaultSlashUI.this.jLabel2.setForeground(Color.WHITE);
                    DefaultSlashUI.this.jLabel2.setIcon(inmgIcon);
                    int fontSize = (int)Math.round(screenSize.getHeight() * 12.0 / 768.0);
                    DefaultSlashUI.this.jLabel2.setFont(new Font(fontName, 0, fontSize));
                    int marginLeft = (int)Math.round(screenSize.getWidth() * 8.0 / 1024.0);
                    DefaultSlashUI.this.jLabel2.setIconTextGap(marginLeft - windowWidth);
                    DefaultSlashUI.this.jLabel2.setVerticalTextPosition(3);
                    p1.add((Component)DefaultSlashUI.this.jLabel2, "Center");
                    DefaultSlashUI.this.slashWindow.getContentPane().add((Component)p1, "Center");
                    DefaultSlashUI.this.slashWindow.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                            countDownLatch.countDown();
                        }
                    });
                    DefaultSlashUI.this.slashWindow.setVisible(true);
                    DefaultSlashUI.this.slashWindow.toFront();
                }
                catch (Exception ex) {
                    countDownLatch.countDown();
                }
            }
        });
        return countDownLatch;
    }

    private static String getFontFamily(String familyNames) {
        String[] vs;
        HashSet<String> fontFamilyNames = new HashSet<String>();
        String[] stringArray = vs = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            fontFamilyNames.add(v);
            ++n2;
        }
        if (!fontFamilyNames.contains("Dialog")) {
            fontFamilyNames.add("Dialog");
        }
        if (familyNames != null) {
            StringTokenizer token = new StringTokenizer(familyNames, ",");
            while (token.hasMoreTokens()) {
                String v = token.nextToken().trim();
                if (!fontFamilyNames.contains(v)) continue;
                return v;
            }
        }
        return "Dialog";
    }

    @Override
    public CountDownLatch alert(final String message, final String title) {
        final CountDownLatch cl = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MacOptionDialog.showAlertDialog(DefaultSlashUI.this.slashWindow, title, message, new Runnable(){

                    @Override
                    public void run() {
                        cl.countDown();
                    }
                }, "\u5173\u95ed");
            }
        });
        return cl;
    }

    @Override
    public CountDownLatch disposeWindow() {
        final CountDownLatch cl = new CountDownLatch(1);
        if (this.slashWindow != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DefaultSlashUI.this.slashWindow.dispose();
                            DefaultSlashUI.this.slashWindow = null;
                        }
                        finally {
                            cl.countDown();
                        }
                    }
                });
            } else {
                try {
                    this.slashWindow.dispose();
                    this.slashWindow = null;
                }
                finally {
                    cl.countDown();
                }
            }
        } else {
            cl.countDown();
        }
        return cl;
    }

    @Override
    public void addProcessCount(final int count, final String processMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            int v;
            int pecent;
            int totalCount;
            int fcount = this.finishCount.addAndGet(count);
            int n = totalCount = this.totalProcessCount == 0 ? 1 : this.totalProcessCount;
            if (fcount >= totalCount) {
                pecent = 99;
            } else {
                pecent = Math.round((float)fcount / (float)totalCount * 100.0f);
                if (pecent >= 100) {
                    pecent = 99;
                }
            }
            if (this.loadProgressBar != null && (v = this.loadProgressBar.getValue()) != pecent) {
                this.loadProgressBar.setValue(pecent);
            }
            if (processMessage != null && this.jLabel2 != null) {
                this.jLabel2.setText(processMessage);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int v;
                    int pecent;
                    int totalCount;
                    int fcount = DefaultSlashUI.this.finishCount.addAndGet(count);
                    int n = totalCount = DefaultSlashUI.this.totalProcessCount == 0 ? 1 : DefaultSlashUI.this.totalProcessCount;
                    if (fcount >= totalCount) {
                        pecent = 99;
                    } else {
                        pecent = Math.round((float)fcount / (float)totalCount * 100.0f);
                        if (pecent >= 100) {
                            pecent = 99;
                        }
                    }
                    if (DefaultSlashUI.this.loadProgressBar != null && (v = DefaultSlashUI.this.loadProgressBar.getValue()) != pecent) {
                        DefaultSlashUI.this.loadProgressBar.setValue(pecent);
                    }
                    if (processMessage != null && DefaultSlashUI.this.jLabel2 != null) {
                        DefaultSlashUI.this.jLabel2.setText(processMessage);
                    }
                }
            });
        }
    }

    @Override
    public void setTotalPlugins(int total) {
        this.totalProcessCount = total + 7;
    }

    @Override
    public Object getSlashWindow() {
        return this.slashWindow;
    }
}

