/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.launcher;

import com.wovoe.carpark.launcher.DefaultSlashUI;
import com.wovoe.carpark.launcher.SlashUI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Launcher {
    private static File startupDir;
    private static SlashUI startSlashUI;
    static FileLock fileLock;
    static RandomAccessFile lockFile;
    private static Object stopLock;

    static {
        fileLock = null;
        lockFile = null;
        stopLock = new Object();
    }

    private static File findConfDir() {
        File conf = new File(Launcher.findHomeDir(), "conf");
        if (!conf.exists() || !conf.isDirectory()) {
            conf.mkdir();
        }
        return conf;
    }

    public static SlashUI getStartSlashUI() {
        return startSlashUI;
    }

    public static SlashUI getStopSlashUI() {
        return null;
    }

    static File findHomeDir() {
        if (startupDir == null) {
            ProtectionDomain pd = Launcher.class.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            String result = url.toString();
            if (!result.endsWith(".jar")) {
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.endsWith("/bin")) {
                    result = result.substring(0, result.lastIndexOf(47));
                }
            } else {
                result = result.substring(0, result.lastIndexOf(47));
            }
            if ((result = result.substring(0, result.lastIndexOf(47))) == null) {
                throw new RuntimeException("Can not find the app boot path.");
            }
            if (Character.isUpperCase(result.charAt(0))) {
                char[] chars = result.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                result = new String(chars);
            }
            try {
                startupDir = new File(new URI(result));
                System.setProperty("CARPARK_HOME", startupDir.getAbsolutePath());
            }
            catch (URISyntaxException e) {
                new RuntimeException(e);
            }
        }
        return startupDir;
    }

    public static void main(String[] args) throws Exception {
        boolean startGui;
        System.setProperty("parking.launcher.class", Launcher.class.getName());
        Properties conf = new Properties();
        File carparkconf = new File(Launcher.findConfDir(), "carpark.conf");
        if (carparkconf.exists() && carparkconf.isFile()) {
            try (FileInputStream in = new FileInputStream(carparkconf);){
                conf.load(in);
            }
        }
        if (conf.getProperty("no_logo") != null) {
            System.setProperty("no_logo", conf.getProperty("no_logo"));
        }
        if (startGui = Boolean.parseBoolean(conf.getProperty("startGui", "true"))) {
            System.setProperty("startGui", "true");
            startSlashUI = new DefaultSlashUI();
        } else {
            System.setProperty("startGui", "false");
            System.setProperty("java.awt.headless", "true");
        }
        boolean useDb32 = Boolean.parseBoolean(conf.getProperty("useDb32", "false"));
        boolean os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
        if (os32) {
            useDb32 = true;
        }
        System.setProperty("useDb32", String.valueOf(useDb32));
        try {
            Launcher.start(conf, args);
        }
        catch (Exception ex) {
            Exception ex1 = ex;
            if (startGui && startSlashUI != null) {
                String message = "\u62b1\u6b49!\u542f\u52a8\u53d1\u751f\u4e86\u81f4\u547d\u9519\u8bef\uff01\n\u5f02\u5e38\u4fe1\u606f:\n" + ex1.getMessage();
                String title = "\u542f\u52a8\u9519\u8bef";
                startSlashUI.alert(message, title).await();
                startSlashUI.disposeWindow().await();
                System.exit(-1);
            }
            throw ex;
        }
    }

    private static void start(Properties conf, String[] args) throws Exception {
        if (Launcher.canLaunch()) {
            if (startSlashUI != null) {
                startSlashUI.showSlashWindow(conf.getProperty("LookAndFeel")).await();
            }
            Launcher.initProperty(conf);
            EclipseStarter.run((String[])args, null);
            BundleContext context = EclipseStarter.getSystemBundleContext();
            Bundle[] bs = context.getBundles();
            String fragmentKeyWord = conf.getProperty("fragment.keyword", ".fragment.");
            LinkedList<String> errlist = new LinkedList<String>();
            Bundle[] bundleArray = bs;
            int n = bs.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (b.getSymbolicName().indexOf(fragmentKeyWord) == -1 && b.getState() != 32) {
                    errlist.add(b.getSymbolicName());
                }
                ++n2;
            }
            if (!errlist.isEmpty()) {
                StringBuilder sbr = new StringBuilder(128);
                sbr.append("\u65e0\u6cd5\u542f\u52a8\u4ee5\u4e0b\u6a21\u5757:\n");
                for (String s : errlist) {
                    sbr.append("\u542f\u52a8").append(s).append("\u6a21\u5757\u5f02\u5e38\uff01\n");
                }
                throw new Exception(sbr.toString());
            }
            System.out.println("carpark system has been launched!");
            boolean isWindows = System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
            if (isWindows && "true".equals(conf.getProperty("autoRun", "false").trim())) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Launcher.setAutoRun(new File(Launcher.findHomeDir(), "carpark.exe").getAbsolutePath(), "carpark", true);
                    }
                }).start();
            }
        } else {
            throw new Exception("\u7cfb\u7edf\u5df2\u7ecf\u542f\u52a8!\u8bf7\u4e0d\u8981\u91cd\u65b0\u542f\u52a8\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Runnable run) {
        Object object = stopLock;
        synchronized (object) {
            block17: {
                System.out.println("\u6b63\u5728\u5173\u95ed\u5e94\u7528...");
                try {
                    System.out.println("\u6b63\u5728\u5173\u95ed\u6240\u6709\u63d2\u4ef6...");
                    EclipseStarter.shutdown();
                    System.out.println("\u6240\u6709\u63d2\u4ef6\u5df2\u7ecf\u5173\u95ed");
                }
                catch (Throwable e) {
                    System.err.println("\u505c\u6b62equinox\u5bb9\u5668\u65f6\u51fa\u73b0\u9519\u8bef:");
                    e.printStackTrace();
                }
                try {
                    if (fileLock != null && fileLock.isValid()) {
                        fileLock.release();
                    }
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
                try {
                    if (lockFile != null) {
                        lockFile.close();
                    }
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
                try {
                    try {
                        if (run != null) {
                            run.run();
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        System.out.println("\u51c6\u5907\u9000\u51fa\u5e94\u7528\u7a0b\u5e8f");
                        System.exit(0);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    System.out.println("\u51c6\u5907\u9000\u51fa\u5e94\u7528\u7a0b\u5e8f");
                    System.exit(0);
                    throw throwable;
                }
                System.out.println("\u51c6\u5907\u9000\u51fa\u5e94\u7528\u7a0b\u5e8f");
                System.exit(0);
            }
        }
    }

    private static File findLocalDir() {
        File findLocalDir = new File(Launcher.findHomeDir(), "local");
        if (!findLocalDir.exists() || !findLocalDir.isDirectory()) {
            findLocalDir.mkdir();
        }
        return findLocalDir;
    }

    private static File findLogsDir() {
        File logs = new File(Launcher.findLocalDir(), "logs");
        if (!logs.exists() || !logs.isDirectory()) {
            logs.mkdir();
        }
        return logs;
    }

    private static File findOsgiCacheDir() {
        File osgiDir = new File(Launcher.findLocalDir(), "runtime/osgi");
        if (!osgiDir.exists() || !osgiDir.isDirectory()) {
            osgiDir.mkdirs();
        }
        return osgiDir;
    }

    private static boolean canLaunch() {
        FileLock lock;
        RandomAccessFile lockFile1;
        block4: {
            File runtimeFile = new File(Launcher.findLocalDir(), "runtime");
            if (!runtimeFile.exists() || !runtimeFile.isDirectory()) {
                runtimeFile.mkdirs();
            }
            File fileLockPath = new File(runtimeFile, "runtime.lock");
            lockFile1 = new RandomAccessFile(fileLockPath, "rw");
            FileChannel fc = lockFile1.getChannel();
            lock = fc.tryLock();
            if (lock != null) break block4;
            lockFile1.close();
            return false;
        }
        try {
            fileLock = lock;
            lockFile = lockFile1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void initProperty(Properties conf) throws Exception {
        try {
            File f = new File(Launcher.findLogsDir(), "launcher.log");
            if (f.exists() && f.isFile()) {
                f.delete();
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        String PROP_BUNDLES = "osgi.bundles";
        String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
        String PROP_SYSPATH = "osgi.syspath";
        String PROP_LOGFILE = "osgi.logfile";
        String PROP_NOSHUTDOWN = "osgi.noShutdown";
        String PROP_IGNOREAPP = "eclipse.ignoreApp";
        String DEFAULT_BUNDLES_STARTLEVEL = "4";
        String USING_SYSTEM_PROPERTIES_KEY = "osgi.framework.useSystemProperties";
        String PROP_INSTALL_AREA = "osgi.install.area";
        String PROP_PLUGINS_DIRNAME = "plugins";
        String PROP_CONFIG_AREA = "osgi.configuration.area";
        String PROP_CONIFG_BUNDLE_PARENT = "org.osgi.framework.bundle.parent";
        System.setProperty("osgi.logfile", new File(Launcher.findLogsDir(), "launcher.log").getAbsolutePath());
        System.setProperty("osgi.configuration.area", Launcher.findOsgiCacheDir().getAbsolutePath());
        System.setProperty("osgi.framework.useSystemProperties", "true");
        System.setProperty("org.osgi.framework.bundle.parent", conf.getProperty("org.osgi.framework.bundle.parent", "app"));
        System.setProperty("osgi.noShutdown", conf.getProperty("osgi.noShutdown", "true"));
        System.setProperty("eclipse.ignoreApp", conf.getProperty("eclipse.ignoreApp", "true"));
        File pluginDir = new File(Launcher.findHomeDir(), "plugins");
        URL pluginsURL = pluginDir.toURI().toURL();
        System.setProperty("osgi.install.area", conf.getProperty("osgi.install.area", pluginsURL.toExternalForm()));
        System.setProperty("osgi.syspath", conf.getProperty("osgi.syspath", new File(pluginsURL.getFile()).getAbsolutePath()));
        Launcher.setInitbundles(conf.getProperty("osgi.bundles"), pluginDir, conf, "osgi.bundles");
        System.setProperty("osgi.bundles.defaultStartLevel", conf.getProperty("osgi.bundles.defaultStartLevel", "4"));
        System.setProperty("CARPARK_DEV_MODE", "false");
    }

    private static Set<String> loadProperty(String value) {
        String[] sx;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (value != null && value.trim().length() > 0 && (sx = value.split(",")) != null) {
            String[] stringArray = sx;
            int n = sx.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                set.add(s1.trim());
                ++n2;
            }
        }
        return set;
    }

    private static void setInitbundles(String propBundles0, File pluginsDir, Properties conf, String PROP_BUNDLES) throws Exception {
        String v;
        if (propBundles0 == null) {
            propBundles0 = "";
        }
        final String propBundles = propBundles0;
        final TreeSet bundlesEntries = new TreeSet();
        final Set<String> allUnload = Launcher.loadProperty(conf.getProperty("parking.all.notloaded.jars.prefix", "org.eclipse.osgi_"));
        String fragmentKeyWord = conf.getProperty("fragment.keyword", ".fragment.");
        pluginsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName();
                if (pathname.isFile() && fileName != null && fileName.endsWith(".jar")) {
                    boolean loaded = true;
                    if (propBundles.indexOf(fileName) == -1) {
                        if (loaded) {
                            for (String x : allUnload) {
                                if (!fileName.startsWith(x)) continue;
                                loaded = false;
                                break;
                            }
                        }
                        if (loaded) {
                            bundlesEntries.add(fileName);
                        }
                    }
                }
                return false;
            }
        });
        StringBuilder buffer = new StringBuilder();
        boolean index = false;
        String[] firstStart = new String[2];
        String[] lastStart = new String[1];
        int hx = 0;
        for (String _bundles : bundlesEntries) {
            if (_bundles.startsWith("com.wovoe.framework.log_")) {
                firstStart[0] = String.valueOf(_bundles) + "@1:start";
                ++hx;
                continue;
            }
            if (_bundles.startsWith("com.wovoe.javacv_")) {
                firstStart[1] = String.valueOf(_bundles) + "@1:start";
                ++hx;
                continue;
            }
            if (!index) {
                index = true;
            } else {
                buffer.append(",");
            }
            buffer.append(_bundles);
            if (_bundles == null || _bundles.indexOf(fragmentKeyWord) > -1) continue;
            buffer.append("@:start");
            ++hx;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = firstStart;
        int n = firstStart.length;
        int n2 = 0;
        while (n2 < n) {
            v = stringArray[n2];
            if (v != null) {
                sb.append(v);
                if (buffer.length() > 0) {
                    sb.append(',');
                }
            }
            ++n2;
        }
        sb.append((CharSequence)buffer);
        stringArray = lastStart;
        n = lastStart.length;
        n2 = 0;
        while (n2 < n) {
            v = stringArray[n2];
            if (v != null && sb.length() > 0) {
                sb.append(',');
                sb.append(v);
            }
            ++n2;
        }
        String pBundles = propBundles.trim();
        if (pBundles.length() > 0) {
            if (!pBundles.endsWith(",")) {
                pBundles = String.valueOf(pBundles) + ",";
            }
            pBundles = String.valueOf(pBundles) + sb.toString();
        } else {
            pBundles = sb.toString();
        }
        if (startSlashUI != null) {
            startSlashUI.setTotalPlugins(hx);
        }
        System.setProperty(PROP_BUNDLES, pBundles);
    }

    private static void setAutoRun(String runPath, String keyName, boolean autoRun) {
        try {
            boolean isWindows = System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
            if (isWindows) {
                Launcher.setWindowsAutoRun(runPath, keyName, autoRun);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void setWindowsAutoRun(String runPath, final String keyName, boolean autoRun) throws IOException, InterruptedException {
        File file = new File(runPath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        final StringBuilder okInfo = new StringBuilder(128);
        final StringBuilder errInfo = new StringBuilder(64);
        String keyPath = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
        String cmd = "REG QUERY " + keyPath + " /v " + keyName;
        Process pocess = Runtime.getRuntime().exec(cmd);
        final BufferedReader outin = new BufferedReader(new InputStreamReader(pocess.getInputStream(), "GBK"));
        final BufferedReader errin = new BufferedReader(new InputStreamReader(pocess.getErrorStream(), "GBK"));
        final CountDownLatch counter = new CountDownLatch(2);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String s;
                    while ((s = outin.readLine()) != null) {
                        String s1;
                        int h;
                        if ((s = s.trim()).length() <= 0 || !s.contains(keyName) || (h = s.indexOf(s1 = "REG_SZ")) <= 0) continue;
                        okInfo.append(s.substring(s1.length() + h).trim());
                    }
                    counter.countDown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String s;
                    while ((s = errin.readLine()) != null) {
                        if ((s = s.trim()).length() <= 0) continue;
                        errInfo.append((CharSequence)okInfo);
                    }
                    counter.countDown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            counter.await(1L, TimeUnit.SECONDS);
        }
        finally {
            try {
                errin.close();
            }
            catch (Exception exception) {}
            try {
                outin.close();
            }
            catch (Exception exception) {}
            try {
                pocess.destroy();
            }
            catch (Exception exception) {}
        }
        boolean del = false;
        boolean add = false;
        String s1 = okInfo.toString().trim();
        String s2 = errInfo.toString().trim();
        if (autoRun) {
            if (s1.length() == 0 && s2.length() == 0 || s2.length() > 0) {
                add = true;
            } else if (s1.length() > 0 && !s1.equals(runPath)) {
                del = true;
                add = true;
            }
        } else if (s1.length() > 0 && s1.equals(runPath)) {
            del = true;
        }
        if (del) {
            cmd = "REG DELETE " + keyPath + " /v " + keyName + " /f";
            Launcher.doCommand(cmd);
        }
        if (add) {
            cmd = "REG ADD " + keyPath + " /v " + keyName + " /t REG_SZ /d " + runPath;
            Launcher.doCommand(cmd);
        }
    }

    private static void doCommand(String cmd) throws IOException, InterruptedException {
        final CountDownLatch counter1 = new CountDownLatch(1);
        final Process pocess1 = Runtime.getRuntime().exec(cmd);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        pocess1.waitFor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        counter1.countDown();
                    }
                }
                finally {
                    counter1.countDown();
                }
            }
        }).start();
        try {
            counter1.await(1L, TimeUnit.SECONDS);
        }
        finally {
            try {
                pocess1.destroy();
            }
            catch (Exception exception) {}
        }
    }
}

