/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p;

import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.p2p.P2pLocalHost;
import com.wovoe.carpark.p2p.P2pReverseConnection;
import com.wovoe.carpark.p2p.media.P2pCameraLiveDataAction;
import com.wovoe.carpark.service.ServiceContext;
import com.wovoe.framework.CommonCrypto;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.RsaCrypto;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPServiceActionManager;
import com.wovoe.framework.communication.tcp.DispathConnectIoHandler;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import com.wovoe.framework.p2p.DefaultP2pConnSessionManager;
import com.wovoe.framework.p2p.LocalHost;
import com.wovoe.framework.p2p.P2PUDPConnectionFactory;
import com.wovoe.framework.p2p.P2pConnSessionManager;
import com.wovoe.framework.p2p.P2pContext;
import com.wovoe.framework.p2p.action.P2pConnectionAction;
import com.wovoe.framework.p2p.action.P2pDigHoleAction;
import com.wovoe.framework.p2p.action.P2pHandshakeAction;
import com.wovoe.framework.p2p.action.P2pHeartbeatAction;
import com.wovoe.framework.p2p.action.P2pReverseConnectAction;
import com.wovoe.framework.p2p.action.P2pSessionCloseAction;
import java.io.IOException;
import java.security.Key;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class CarparkP2pContext
implements P2pContext {
    private ServiceContext serviceContext;
    private ServiceActionManager serviceActionManager;
    private DefaultP2pConnSessionManager p2pConnSessionManager;
    private ConcurrentLinkedQueue<ScheduledFuture<?>> jobScheduledFutures;
    private P2PUDPConnectionFactory p2pUDPConnectionFactory;
    private P2pLocalHost p2pLocalHost;
    private RsaCrypto cloudConnectTransferCrypto;
    private NioSocketConnector connector;

    public CarparkP2pContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this.jobScheduledFutures = new ConcurrentLinkedQueue();
        this.serviceActionManager = new HMPServiceActionManager();
        this.p2pConnSessionManager = new DefaultP2pConnSessionManager();
        this.registerServiceAction();
    }

    private void registerServiceAction() {
        this.serviceActionManager.register((ServiceAction)new P2pDigHoleAction());
        this.serviceActionManager.register((ServiceAction)new P2pHandshakeAction());
        this.serviceActionManager.register((ServiceAction)new P2pHeartbeatAction());
        this.serviceActionManager.register((ServiceAction)new P2pReverseConnectAction());
        this.serviceActionManager.register((ServiceAction)new P2pSessionCloseAction());
        this.serviceActionManager.register((ServiceAction)new P2pConnectionAction());
        this.serviceActionManager.register((ServiceAction)new P2pCameraLiveDataAction());
    }

    public long currentTimeMillis() {
        return this.serviceContext.currentTimeMillis();
    }

    public CommonCrypto getCloudConnectTransferCrypto() {
        if (this.cloudConnectTransferCrypto == null) {
            this.cloudConnectTransferCrypto = new RsaCrypto((Key)CloudConnectTransferCrypto.getCloudPublicKey());
        }
        return this.cloudConnectTransferCrypto;
    }

    public LocalHost getLocalHost() {
        return this.p2pLocalHost;
    }

    public P2PUDPConnectionFactory getP2PUDPConnectionFactory() {
        return this.p2pUDPConnectionFactory;
    }

    public P2pConnSessionManager getP2pConnSessionManager() {
        return this.p2pConnSessionManager;
    }

    public ServiceActionManager getP2pServiceActionManager() {
        return this.serviceActionManager;
    }

    public TimeoutObjectPool getTimeoutObjectPool() {
        return this.serviceContext.getTimeoutObjectPool();
    }

    public ExecutorService getWorkThreadPool() {
        return this.serviceContext.getWorkThreadPool();
    }

    public void start() {
        this.p2pLocalHost = new P2pLocalHost();
        this.jobScheduledFutures.add(this.serviceContext.schedule(this.getP2pConnSessionManager().getCheckConnectJob(), 3L, 3L, TimeUnit.SECONDS));
        this.jobScheduledFutures.add(this.serviceContext.schedule(P2pReverseConnection.newCheckTimeoutJob(), 5L, 5L, TimeUnit.SECONDS));
        this.connector = new NioSocketConnector();
        this.connector.setConnectTimeoutMillis(8000L);
        this.connector.getSessionConfig().setReadBufferSize(8192);
        this.connector.getSessionConfig().setMaxReadBufferSize(65536);
        this.connector.getSessionConfig().setReceiveBufferSize(65536);
        this.connector.getSessionConfig().setSendBufferSize(65536);
        this.connector.setHandler((IoHandler)new DispathConnectIoHandler());
        int[] tx = new int[]{6234, 6235, 6236, 6237, 6238, 6239, 6241, 6242, 6243, 6244, 6245, 6246, 6247};
        int index = Math.abs(new Random().nextInt()) % tx.length;
        try {
            this.p2pUDPConnectionFactory = P2PUDPConnectionFactory.createInstance((UDPEndpoint)this.serviceContext.getUDPEndpoint(), (ServiceActionManager)this.getP2pServiceActionManager(), (int)6001, (int)20000, (int)tx[index], null);
        }
        catch (IOException e) {
            LogUtil.getLog().info((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        if (this.jobScheduledFutures != null) {
            ScheduledFuture<?> job;
            while ((job = this.jobScheduledFutures.poll()) != null) {
                try {
                    job.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            P2pReverseConnection.closeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.p2pConnSessionManager.closeAllSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connector != null) {
                this.connector.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NioSocketConnector getNioSocketConnector() {
        return this.connector;
    }
}

