/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CommonCrypto;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.RsaCrypto;
import com.wovoe.framework.RsaUtil;
import com.wovoe.framework.SymmetricCrypto;
import com.wovoe.framework.p2p.LocalHost;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class P2pLocalHost
extends LocalHost {
    protected SymmetricCrypto symmetricCrypto;
    protected String signKey = RandomStringGenerator.getDefaultInstance().getNewString(32);
    protected Key publicKey;
    protected RsaCrypto rsaPrivateCrypto;

    public P2pLocalHost() {
        Key aesKey;
        try {
            aesKey = CryptoUtil.createRandomAESKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.symmetricCrypto = new SymmetricCrypto(aesKey);
        Map rsaKeyMap = RsaUtil.generator();
        this.publicKey = (Key)rsaKeyMap.get("RSAPublicKey");
        Key privateKey = (Key)rsaKeyMap.get("RSAPrivateKey");
        this.rsaPrivateCrypto = new RsaCrypto(privateKey);
    }

    public String getAppId() {
        if (ServiceUtil.getServiceContext() == null) {
            return "";
        }
        if (ServiceUtil.getServiceContext().getCloudContext() == null) {
            return "";
        }
        if (ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
            return "";
        }
        String id = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getId();
        if (id == null) {
            return "";
        }
        return id;
    }

    public String getAppName() {
        if (ServiceUtil.getServiceContext() == null) {
            return "";
        }
        if (ServiceUtil.getServiceContext().getCloudContext() == null) {
            return "";
        }
        if (ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
            return "";
        }
        String n = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getName();
        if (n == null) {
            return "";
        }
        return n;
    }

    public CommonCrypto getRsaPrivateCrypto() {
        return this.rsaPrivateCrypto;
    }

    public Key getRsaPrivateKey() {
        return this.rsaPrivateCrypto.getRsaKey();
    }

    public Key getRsaPublicKey() {
        return this.publicKey;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public CommonCrypto getTransferCrypto() {
        return this.symmetricCrypto;
    }

    public Key getTransferKey() {
        return this.symmetricCrypto.getSymmetricKey();
    }
}

