/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p;

import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.SymmetricCrypto;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.ActionMapping;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.PlainCryptoFactory;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.p2p.DefaultP2pConnSession;
import com.wovoe.framework.p2p.P2pAcceptUseKey;
import com.wovoe.framework.p2p.P2pConnCloudEntry;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pSessionId;
import com.wovoe.framework.p2p.WaitReverseConnectSessionKey;
import com.wovoe.framework.p2p.action.P2pDigHoleAction;
import com.wovoe.framework.p2p.action.P2pHandshakeAction;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class P2pPeerConnector {
    public static OperationFuture<P2pConnSession> reverseConnect(final String peerId, final String peerName) {
        final OperationFutureHandler connectHander = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (peerId == null || peerId.length() == 0 || peerName == null || peerName.length() == 0) {
                connectHander.setException((Throwable)new NullPointerException("\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a"));
                return connectHander;
            }
            if (ServiceUtil.getServiceContext() == null || ServiceUtil.getServiceContext().getCloudContext() == null || ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5, \u6216\u7f3a\u5c11\u8fde\u63a5\u670d\u52a1\u5668\u5730\u5740!"));
                return connectHander;
            }
            boolean cloudConnected = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected();
            if (!cloudConnected) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5!"));
                return connectHander;
            }
            final P2pConnCloudEntry entry = new P2pConnCloudEntry(ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getConnectCloudDomin());
            if (entry == null || entry.getCloudAddress() == null || entry.getCloudAddress().length() == 0) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5, \u6216\u7f3a\u5c11\u8fde\u63a5\u670d\u52a1\u5668\u5730\u5740!"));
                return connectHander;
            }
            InetSocketAddress cloudAddress = new InetSocketAddress(entry.getCloudAddress(), entry.getCloudUdpPort());
            RemoteConnection conn = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createConnection((SocketAddress)cloudAddress);
            RequestSender requetSender = conn.createRequest();
            String localPeerId = P2pContextUtil.getContext().getLocalHost().getAppId();
            String localPeerName = P2pContextUtil.getContext().getLocalHost().getAppName();
            requetSender.setRequestActionName(entry.getActionName());
            requetSender.setHeader("op", "reverseConnect");
            requetSender.setHeader("cd", peerId);
            requetSender.setHeader("cn", peerName);
            requetSender.setHeader("ad", localPeerId);
            requetSender.setHeader("an", localPeerName);
            requetSender.setHeader("as", String.valueOf(P2pContextUtil.getContext().getP2PUDPConnectionFactory().getAcceport()));
            String uniqId = String.valueOf(ServiceUtil.getServiceContext().createLongSeq()) + "-" + RandomStringGenerator.getDefaultInstance().getNewString(16);
            requetSender.setHeader("gd", uniqId);
            final WaitReverseConnectSessionKey waitKey = new WaitReverseConnectSessionKey(peerId, peerName, localPeerId, localPeerName, uniqId);
            ObjectCreateCallback<P2pConnSession> callback = new ObjectCreateCallback<P2pConnSession>(){

                public void onException(Throwable ex) {
                    P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                    connectHander.setException(ex);
                }

                public void createSuccess(P2pConnSession e) {
                    P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                    if (connectHander.isDone()) {
                        if (connectHander.isCancelled() || connectHander.getException() != null || connectHander.getResult() != e) {
                            e.close();
                        }
                    } else {
                        connectHander.setResult((Object)e);
                        if (connectHander.isCancelled() || connectHander.getException() != null || connectHander.getResult() != e) {
                            e.close();
                        } else {
                            P2pSessionId sessionKey = new P2pSessionId((InetSocketAddress)e.getRemoteAddress(), e.getSessionId(), ((InetSocketAddress)e.getLocalAddress()).getPort());
                            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)new P2pAcceptUseKey(sessionKey));
                        }
                    }
                }
            };
            requetSender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            requetSender.setAttribute("send.attempt.times", (Object)5);
            requetSender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
            requetSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)P2pContextUtil.getContext().getCloudConnectTransferCrypto());
            P2pContextUtil.getContext().getTimeoutObjectPool().addObject((Object)waitKey, (Object)callback, new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object key, Object value) throws Exception {
                    if (!connectHander.isDone()) {
                        connectHander.setException((Throwable)new ConnectException("connect timeout!"));
                    }
                }
            }, 15L, TimeUnit.SECONDS);
            try {
                requetSender.doRequest(new SendCallback(){

                    public void onException(Throwable exception) {
                        LogUtil.getLog().warn((Object)("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25 , \u4e91\u7aef\u65e0ACK\u54cd\u5e94! " + entry.getCloudAddress() + ":" + entry.getCloudUdpPort() + ", " + exception.getMessage()));
                        P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                        connectHander.setException((Throwable)new IOException("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u53d1\u9001\u5f02\u5e38", exception));
                    }

                    public void onCompleted() {
                    }
                }, new ReceiveCallback(){

                    public void onWaitTimeout() throws Exception {
                        LogUtil.getLog().warn((Object)("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25 ,\u7b49\u5f85\u8d85\u65f6! " + entry.getCloudAddress() + ":" + entry.getCloudUdpPort()));
                        P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                        connectHander.setException((Throwable)new IOException("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u8d85\u65f6"));
                    }

                    public long getWaitTimeoutMills() {
                        return 7000L;
                    }

                    public void doReceiver(Receiver receiver, int sendId) throws Exception {
                        String result = receiver.getHeaderValue("result");
                        if (!"SUCCESS".equals(result)) {
                            LogUtil.getLog().warn((Object)("\u8fde\u63a5" + peerName + ":" + peerId + ", \u5931\u8d25! " + receiver.getHeaderValue("msg")));
                            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! code: " + result + ", msg:" + receiver.getHeaderValue("msg")));
                        }
                    }
                });
            }
            catch (Throwable ex) {
                P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                throw ex;
            }
        }
        catch (Throwable ex) {
            LogUtil.getLog().warn((Object)("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25, " + peerName + ":" + peerId + ", " + ex.getMessage()));
            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25", ex));
        }
        return connectHander;
    }

    public static OperationFuture<P2pConnSession> connect(final String peerId, final String peerName) {
        final OperationFutureHandler connectHander = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (peerId == null || peerId.length() == 0 || peerName == null || peerName.length() == 0) {
                connectHander.setException((Throwable)new NullPointerException("\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a"));
                return connectHander;
            }
            if (ServiceUtil.getServiceContext() == null || ServiceUtil.getServiceContext().getCloudContext() == null || ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5, \u6216\u7f3a\u5c11\u8fde\u63a5\u670d\u52a1\u5668\u5730\u5740!"));
                return connectHander;
            }
            boolean cloudConnected = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected();
            if (!cloudConnected) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5!"));
                return connectHander;
            }
            P2pConnCloudEntry entry = new P2pConnCloudEntry(ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getConnectCloudDomin());
            if (entry == null || entry.getCloudAddress() == null || entry.getCloudAddress().length() == 0) {
                connectHander.setException((Throwable)new IOException("\u4e91\u7aef\u672a\u8fde\u63a5, \u6216\u7f3a\u5c11\u8fde\u63a5\u670d\u52a1\u5668\u5730\u5740!"));
                return connectHander;
            }
            byte[] localPublicKey = P2pContextUtil.getContext().getLocalHost().getRsaPublicKey().getEncoded();
            InetSocketAddress cloudAddress = new InetSocketAddress(entry.getCloudAddress(), entry.getCloudUdpPort());
            RemoteConnection conn = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createConnection((SocketAddress)cloudAddress);
            RequestSender requetSender = conn.createRequest();
            final String localPeerId = P2pContextUtil.getContext().getLocalHost().getAppId();
            final String localPeerName = P2pContextUtil.getContext().getLocalHost().getAppName();
            requetSender.setRequestActionName(entry.getActionName());
            requetSender.setHeader("op", entry.getOp());
            requetSender.setHeader("pd", peerId);
            requetSender.setHeader("pn", peerName);
            requetSender.setHeader("sd", localPeerId);
            requetSender.setHeader("sn", localPeerName);
            requetSender.setHeader("sr", String.valueOf(P2pContextUtil.getContext().getP2PUDPConnectionFactory().getAcceport()));
            requetSender.setSendData(localPublicKey);
            requetSender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            requetSender.setAttribute("send.attempt.times", (Object)5);
            requetSender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
            requetSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)P2pContextUtil.getContext().getCloudConnectTransferCrypto());
            requetSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    connectHander.setException((Throwable)new IOException("\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25", exception));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    connectHander.setException((Throwable)new IOException("\u521b\u5efap2p\u8fde\u63a5\u8d85\u65f6, \u65e0\u5e94\u7b54"));
                }

                public long getWaitTimeoutMills() {
                    return 12000L;
                }

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    String result = receiver.getHeaderValue("result");
                    if ("SUCCESS".equals(result)) {
                        InetSocketAddress destSocektAddress;
                        int port;
                        String sessionId = receiver.getHeaderValue("se");
                        if (sessionId == null || sessionId.length() == 0) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u7f3a\u5c11sessionId"));
                            return;
                        }
                        String remoteAddress = receiver.getHeaderValue("pa");
                        String remoteUdpP2pPort = receiver.getHeaderValue("pp");
                        String remoteHostId = receiver.getHeaderValue("pd");
                        String remoteHostName = receiver.getHeaderValue("pn");
                        String sd0 = receiver.getHeaderValue("sd");
                        String sn0 = receiver.getHeaderValue("sn");
                        String localNetAddress = receiver.getHeaderValue("sa");
                        String localNetUdpPort = receiver.getHeaderValue("sp");
                        if (!peerId.equals(remoteHostId)) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! peerId\u4e0d\u4e00\u81f4"));
                            return;
                        }
                        if (!peerName.equals(remoteHostName)) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! peerName\u4e0d\u4e00\u81f4"));
                            return;
                        }
                        if (!localPeerId.equals(sd0)) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! localPeerId\u4e0d\u4e00\u81f4"));
                            return;
                        }
                        if (!localPeerName.equals(sn0)) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! localPeerName\u4e0d\u4e00\u81f4"));
                            return;
                        }
                        if (remoteAddress == null || remoteAddress.length() == 0) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u672a\u77e5\u8fdc\u7aef\u7f51\u7edc\u5730\u5740"));
                            return;
                        }
                        if (remoteUdpP2pPort == null || remoteUdpP2pPort.length() == 0) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u672a\u77e5\u8fdc\u7aef\u7f51\u7edc\u4e3b\u673a\u7aef\u53e3"));
                            return;
                        }
                        try {
                            port = Integer.parseInt(remoteUdpP2pPort);
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u8fdc\u7aef\u7f51\u7edc\u4e3b\u673a\u7aef\u53e3\u9519\u8bef"));
                            return;
                        }
                        if (port <= 0 || port > 65535) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u8fdc\u7aef\u7f51\u7edc\u4e3b\u673a\u7aef\u53e3\u9519\u8bef"));
                            return;
                        }
                        try {
                            destSocektAddress = new InetSocketAddress(remoteAddress, port);
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u8fdc\u7aef\u7f51\u7edc\u4e3b\u673a\u7aef\u53e3\u9519\u8bef"));
                            return;
                        }
                        if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() <= 0) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u516c\u94a5\u672a\u8fd4\u56de"));
                            return;
                        }
                        InetSocketAddress destAddress2 = null;
                        try {
                            int h;
                            String pr = receiver.getHeaderValue("pr");
                            if (pr != null && pr.length() > 0 && (h = Integer.parseInt(pr)) > 0 && h < 65535 && h != port) {
                                destAddress2 = new InetSocketAddress(destSocektAddress.getAddress(), h);
                            }
                        }
                        catch (Exception pr) {
                            // empty catch block
                        }
                        InetSocketAddress[] destAddresses = destAddress2 != null ? new InetSocketAddress[]{destSocektAddress, destAddress2} : new InetSocketAddress[]{destSocektAddress};
                        try {
                            byte[] dataBytes;
                            if (receiver.getData().length == receiver.getDataLength() && receiver.getDataOffset() == 0) {
                                dataBytes = receiver.getData();
                            } else {
                                dataBytes = new byte[receiver.getDataLength()];
                                System.arraycopy(receiver.getData(), receiver.getDataOffset(), dataBytes, 0, receiver.getDataLength());
                            }
                            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(dataBytes);
                            KeyFactory factory = KeyFactory.getInstance("RSA");
                            PublicKey publicKey = factory.generatePublic(keySpec);
                            P2pPeerConnector.doDigHole(peerId, peerName, sessionId, destAddresses, publicKey, (OperationFutureHandler<P2pConnSession>)connectHander, localNetAddress, localNetUdpPort);
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! \u516c\u94a5\u9519\u8bef"));
                            return;
                        }
                    }
                    connectHander.setException((Throwable)new IOException("\u8fde\u63a5\u5931\u8d25! " + result + ": " + receiver.getHeaderValue("msg")));
                }
            });
        }
        catch (Exception ex) {
            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u8bf7\u6c42\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25", ex));
        }
        return connectHander;
    }

    protected static void doDigHole(String peerId, String peerName, String sessionId, InetSocketAddress[] destSocektAddresses, PublicKey publicKey, OperationFutureHandler<P2pConnSession> connectHander, String localNetAddress, String localNetUdpPort) {
        try {
            if (destSocektAddresses == null || destSocektAddresses.length == 0) {
                throw new NullPointerException("destSocektAddresses is empty!");
            }
            if (connectHander.isDone()) {
                return;
            }
            DigHoleEntry entry = new DigHoleEntry();
            entry.peerId = peerId;
            entry.peerName = peerName;
            entry.sessionId = sessionId;
            entry.publicKey = publicKey;
            entry.connectHander = connectHander;
            entry.taskCount = destSocektAddresses.length;
            InetSocketAddress[] inetSocketAddressArray = destSocektAddresses;
            int n = destSocektAddresses.length;
            int n2 = 0;
            while (n2 < n) {
                InetSocketAddress destSocektAddress = inetSocketAddressArray[n2];
                P2pPeerConnector.doDigHole0(entry, destSocektAddress, 6);
                ++n2;
            }
        }
        catch (Exception ex) {
            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, P2P\u7a7f\u900f\u5931\u8d25", ex));
        }
    }

    protected static void doDigHole0(final DigHoleEntry entry, final InetSocketAddress destSocektAddress, final int sendTimes) {
        try {
            if (sendTimes <= 0) {
                return;
            }
            String p2pDigHoleActionName = P2pDigHoleAction.class.getAnnotation(ActionMapping.class).value()[0];
            RemoteConnection conn = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createConnection((SocketAddress)destSocektAddress);
            RequestSender requetSender = conn.createRequest();
            requetSender.setRequestActionName(p2pDigHoleActionName);
            requetSender.setHeader("a", "1");
            requetSender.setAttribute("transfer.session.id", (Object)entry.sessionId);
            requetSender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            requetSender.setAttribute("send.attempt.times", (Object)1);
            requetSender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            requetSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)PlainCryptoFactory.getInstance());
            requetSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    if (entry.connectHander.isDone()) {
                        return;
                    }
                    int a = sendTimes - 1;
                    if (a > 0) {
                        if (entry.finishRun) {
                            return;
                        }
                    } else {
                        entry.onFinish(destSocektAddress, false, exception);
                        return;
                    }
                    P2pPeerConnector.doDigHole0(entry, destSocektAddress, a);
                }

                public void onCompleted() {
                    entry.onFinish(destSocektAddress, true, null);
                }
            }, null);
        }
        catch (Exception ex) {
            entry.onFinish(destSocektAddress, false, ex);
        }
    }

    protected static void doHandshake(final String peerId, final String peerName, final String sessionId, final InetSocketAddress destSocektAddress, PublicKey publicKey, final OperationFutureHandler<P2pConnSession> connectHander) {
        try {
            if (connectHander.isDone()) {
                return;
            }
            Key key = P2pContextUtil.getContext().getLocalHost().getTransferKey();
            byte[] keyBytes = CryptoUtil.wrapKey((Key)publicKey, (Key)key);
            String signKey = P2pContextUtil.getContext().getLocalHost().getSignKey();
            String nonce = RandomStringGenerator.getDefaultInstance().getNewString(32);
            final String appId = P2pContextUtil.getContext().getLocalHost().getAppId();
            final String localPeerName = P2pContextUtil.getContext().getLocalHost().getAppName();
            HashMap<String, String> jsonHashMap = new HashMap<String, String>();
            jsonHashMap.put("pd", peerId);
            jsonHashMap.put("pn", peerName);
            jsonHashMap.put("sd", appId);
            jsonHashMap.put("sn", localPeerName);
            jsonHashMap.put("nc", nonce);
            jsonHashMap.put("se", sessionId);
            jsonHashMap.put("sk", P2pContextUtil.getContext().getLocalHost().getTransferCrypto().encrypt(signKey));
            P2pContextUtil.getContext().getLocalHost().setSign(jsonHashMap, signKey, "s");
            String paramJson = GsonBuilder.create().toJson(jsonHashMap);
            String param = P2pContextUtil.getContext().getLocalHost().getTransferCrypto().encrypt(paramJson);
            final String p2pHandshakeActionName = P2pHandshakeAction.class.getAnnotation(ActionMapping.class).value()[0];
            RemoteConnection conn = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createConnection((SocketAddress)destSocektAddress);
            RequestSender requetSender = conn.createRequest();
            requetSender.setRequestActionName(p2pHandshakeActionName);
            requetSender.setHeader("p", param);
            requetSender.setHeader("op", "1");
            requetSender.setSendData(keyBytes);
            requetSender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            requetSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)PlainCryptoFactory.getInstance());
            requetSender.setAttribute("transfer.session.id", (Object)sessionId);
            requetSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u65e0ACK\u54cd\u5e94"));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u65e0\u54cd\u5e94"));
                }

                public long getWaitTimeoutMills() {
                    return 8000L;
                }

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    DefaultP2pConnSession connSession;
                    String result = receiver.getHeaderValue("result");
                    if (!"SUCCESS".equals(result)) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!"1".equals(receiver.getHeaderValue("op"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    String p = receiver.getHeaderValue("p");
                    if (p == null || p.length() == 0) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() == 0) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    try {
                        String remoteSignKey;
                        Map paramMap;
                        Key remoteAeskey;
                        try {
                            byte[] wrappedKey = new byte[receiver.getDataLength()];
                            System.arraycopy(receiver.getData(), receiver.getDataOffset(), wrappedKey, 0, receiver.getDataLength());
                            remoteAeskey = CryptoUtil.unWrapKey((Key)P2pContextUtil.getContext().getLocalHost().getRsaPrivateKey(), (byte[])wrappedKey, (String)"AES");
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                            return;
                        }
                        SymmetricCrypto remoteCrypto = new SymmetricCrypto(remoteAeskey);
                        try {
                            String json = remoteCrypto.decrypt(p);
                            paramMap = (Map)GsonBuilder.create().fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                            return;
                        }
                        if (!"SUCCESS".equals(paramMap.get("result"))) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        String sk = (String)paramMap.get("sk");
                        if (sk == null || sk.length() == 0) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        try {
                            remoteSignKey = remoteCrypto.decrypt(sk);
                        }
                        catch (Exception ex) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                            return;
                        }
                        if (!P2pContextUtil.getContext().getLocalHost().checkSign(paramMap, remoteSignKey, "s")) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        if (!sessionId.equals(paramMap.get("se"))) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        String rpd = (String)paramMap.get("pd");
                        String rpn = (String)paramMap.get("pn");
                        String rsd = (String)paramMap.get("sd");
                        String rsn = (String)paramMap.get("sn");
                        if (!peerId.equals(rpd)) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        if (!peerName.equals(rpn)) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        if (!appId.equals(rsd)) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        if (!localPeerName.equals(rsn)) {
                            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                            return;
                        }
                        connSession = new DefaultP2pConnSession(0, sessionId);
                        connSession.setRemotePeerId(peerId);
                        connSession.setRemotePeerName(peerName);
                        connSession.setLocalPeerId(appId);
                        connSession.setLocalPeerName(localPeerName);
                        connSession.setRemoteSignKey(remoteSignKey);
                        connSession.setRemoteTransferCrypto((CryptoFactory)remoteCrypto);
                        connSession.setRemoteAddress((SocketAddress)destSocektAddress);
                        connSession.setLocalAddress(receiver.getLocalAddress());
                    }
                    catch (Exception ex) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25"));
                        return;
                    }
                    P2pPeerConnector.doHandshakeFinish((P2pConnSession)connSession, (OperationFutureHandler<P2pConnSession>)connectHander, p2pHandshakeActionName);
                }
            });
        }
        catch (Exception ex) {
            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25", ex));
        }
    }

    protected static void doHandshakeFinish(final P2pConnSession connSession, final OperationFutureHandler<P2pConnSession> connectHander, String p2pHandshakeActionName) {
        try {
            byte[] array;
            int length;
            int offset;
            if (connectHander.isDone()) {
                return;
            }
            RemoteConnection conn = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createConnection(connSession.getRemoteAddress());
            RequestSender sender = conn.createRequest();
            sender.setRequestActionName(p2pHandshakeActionName);
            sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            sender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)PlainCryptoFactory.getInstance());
            sender.setAttribute("transfer.session.id", (Object)connSession.getSessionId());
            HashMap<String, String> jsonHashMap = new HashMap<String, String>();
            jsonHashMap.put("pd", connSession.getRemotePeerId());
            jsonHashMap.put("pn", connSession.getRemotePeerName());
            jsonHashMap.put("sd", connSession.getLocalPeerId());
            jsonHashMap.put("sn", connSession.getLocalPeerName());
            jsonHashMap.put("nc", RandomStringGenerator.getDefaultInstance().getNewString(16));
            jsonHashMap.put("se", connSession.getSessionId());
            P2pContextUtil.getContext().getLocalHost().setSign(jsonHashMap, connSession.getRemoteSignKey(), "s");
            String paramJson = GsonBuilder.create().toJson(jsonHashMap);
            ByteBuffer encryptBuf = connSession.getRemoteTransferCrypto().encrypt(ByteBuffer.wrap(paramJson.getBytes("UTF-8")));
            if (encryptBuf.hasArray()) {
                offset = encryptBuf.position() + encryptBuf.arrayOffset();
                length = encryptBuf.remaining();
                array = encryptBuf.array();
            } else {
                offset = 0;
                length = encryptBuf.remaining();
                array = new byte[length];
                encryptBuf.get(array);
            }
            sender.setHeader("op", "2");
            sender.setSendData(array, offset, length);
            sender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u65e0\u54cd\u5e94"));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                private void handleSuccess() {
                    if (connectHander.isCancelled()) {
                        connSession.close();
                        return;
                    }
                    connSession.updateActiveMills();
                    P2pContextUtil.getContext().getP2pConnSessionManager().addP2pSession(connSession);
                    connectHander.setResult((Object)connSession);
                    if (connectHander.isCancelled()) {
                        connSession.close();
                    }
                }

                public void onWaitTimeout() throws Exception {
                    connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u65e0\u54cd\u5e94"));
                }

                public long getWaitTimeoutMills() {
                    return 8000L;
                }

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    Map responseMap;
                    String result = receiver.getHeaderValue("result");
                    if (!"SUCCESS".equals(result)) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!"2".equals(receiver.getHeaderValue("op"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() == 0) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    try {
                        byte[] jsonBytes = P2pContextUtil.getContext().getLocalHost().getTransferCrypto().decryptToBytes(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength());
                        String json = new String(jsonBytes, "UTF-8");
                        responseMap = (Map)GsonBuilder.create().fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
                    }
                    catch (Exception ex) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!"SUCCESS".equals(responseMap.get("result"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!P2pContextUtil.getContext().getLocalHost().checkSign(responseMap, P2pContextUtil.getContext().getLocalHost().getSignKey(), "s")) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!connSession.getRemotePeerId().equals(responseMap.get("pd"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!connSession.getRemotePeerName().equals(responseMap.get("pn"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!connSession.getLocalPeerId().equals(responseMap.get("sd"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!connSession.getLocalPeerName().equals(responseMap.get("sn"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    if (!connSession.getSessionId().equals(responseMap.get("se"))) {
                        connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u54cd\u5e94\u9519\u8bef"));
                        return;
                    }
                    this.handleSuccess();
                }
            });
        }
        catch (Exception ex) {
            connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u63e1\u624b\u5931\u8d25", ex));
            return;
        }
    }

    private static class DigHoleEntry {
        String peerId;
        String peerName;
        String sessionId;
        PublicKey publicKey;
        OperationFutureHandler<P2pConnSession> connectHander;
        volatile boolean finishRun = false;
        volatile int taskCount;
        List<String> errMessageList;

        private DigHoleEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFinish(InetSocketAddress destSocektAddress, boolean success, Throwable exception) {
            boolean runSucess = false;
            boolean runError = false;
            DigHoleEntry digHoleEntry = this;
            synchronized (digHoleEntry) {
                --this.taskCount;
                if (this.finishRun) {
                    return;
                }
                if (this.connectHander.isDone()) {
                    return;
                }
                if (success) {
                    this.finishRun = true;
                    runSucess = true;
                } else {
                    String mesg = "\u521b\u5efap2p\u8fde\u63a5\u5f02\u5e38\uff01\u5c1d\u8bd5\u5bf9 " + this.peerName + ":" + this.peerId + ", remoteAddress: " + destSocektAddress + "\u8fdb\u884cP2P\u7a7f\u900f\u5931\u8d25: " + (exception == null ? "" : exception.getMessage());
                    if (this.taskCount <= 0) {
                        this.finishRun = true;
                        runError = true;
                    } else {
                        if (this.errMessageList == null) {
                            this.errMessageList = new LinkedList<String>();
                        }
                        this.errMessageList.add(mesg);
                    }
                }
            }
            if (runSucess) {
                P2pPeerConnector.doHandshake(this.peerId, this.peerName, this.sessionId, destSocektAddress, this.publicKey, this.connectHander);
            } else if (runError) {
                this.connectHander.setException((Throwable)new IOException("P2P\u65e0\u6cd5\u8fde\u63a5, \u5bf9\u65b9\u65e0\u54cd\u5e94"));
            }
        }
    }
}

