/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p;

import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.ProxyP2pConnection;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.p2p.DefaultP2pConnSession;
import com.wovoe.framework.p2p.IoSessionP2pConnSession;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pConnSessionCloseListener;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pTransferTool;
import com.wovoe.framework.p2p.action.P2pConnectionAction;
import com.wovoe.framework.p2p.action.SyncRunAction;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class P2pReverseConnection
implements SyncRunAction {
    public static final String PROXY_HOST_TYPE_PARKING_HOST = "0";
    public static final String PROXY_HOST_TYPE_CAMERA = "1";
    protected static ConcurrentHashMap<String, P2pReverseConnection> p2pConnSessionMap = new ConcurrentHashMap();
    private static Map<Class<?>, Map<String, Method>> classMethodsMap = new ConcurrentHashMap();
    private static P2pConnSessionCloseListener p2pConnSessionCloseListener = new P2pConnSessionCloseListener(){

        public void onClose(P2pConnSession session, int reason) {
            P2pReverseConnection act = p2pConnSessionMap.get(session.getSessionId());
            if (act != null && act.getP2pConnSession() == session && (act = p2pConnSessionMap.remove(session.getSessionId())) != null && act.getP2pConnSession() != session && !act.isClosed()) {
                act.close();
            }
        }
    };
    private P2pConnSession session;
    private long activeTimeMills;
    private static final long timeoutMills = 30000L;
    private Map<String, Method> methodsMap;

    public static ServiceActionManager getServiceActionManager() {
        return P2pConnectionAction.getServiceActionManager();
    }

    private static void addP2pReverseConnection(P2pReverseConnection connection) {
        P2pReverseConnection connection0 = p2pConnSessionMap.put(connection.getP2pConnSession().getSessionId(), connection);
        connection.getP2pConnSession().addP2pConnSessionCloseListener(p2pConnSessionCloseListener);
        if (connection0 != null && connection0 != connection) {
            connection0.close();
        }
    }

    public static JobTask newCheckTimeoutJob() {
        return new JobTask(){

            protected void doRun() throws Exception {
                Iterator<Map.Entry<String, P2pReverseConnection>> iterator = p2pConnSessionMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, P2pReverseConnection> entry = iterator.next();
                    if (entry.getValue().isClosed()) {
                        iterator.remove();
                        continue;
                    }
                    if (entry.getValue().isActive()) continue;
                    P2pReverseConnection cl = entry.getValue();
                    iterator.remove();
                    cl.close();
                }
            }
        };
    }

    public static void closeAll() {
        if (!p2pConnSessionMap.isEmpty()) {
            LinkedList<P2pReverseConnection> list = new LinkedList<P2pReverseConnection>();
            list.addAll(p2pConnSessionMap.values());
            p2pConnSessionMap.clear();
            for (P2pReverseConnection connection : list) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public P2pReverseConnection(P2pConnSession session) {
        this.session = session;
        this.activeTimeMills = P2pContextUtil.getContext().currentTimeMillis();
        session.setAttribute("DISPATCH_SERVICE_ACTION", (Object)this);
        P2pReverseConnection.addP2pReverseConnection(this);
        this.methodsMap = classMethodsMap.get(this.getClass());
        if (this.methodsMap == null) {
            HashMap<String, Method> methodsMap0 = new HashMap<String, Method>();
            Method[] methods = this.getClass().getMethods();
            if (methods != null && methods.length > 0) {
                String nameX = "service";
                Method[] methodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> type;
                    Method method = methodArray[n2];
                    Class<?>[] pts = method.getParameterTypes();
                    String methodName = method.getName();
                    if (pts != null && pts.length == 1 && Receiver.class.equals(pts[0]) && !nameX.equals(methodName) && ((type = method.getReturnType()).equals(Void.class) || type.equals(Void.TYPE))) {
                        methodsMap0.put(methodName, method);
                    }
                    ++n2;
                }
            }
            classMethodsMap.put(this.getClass(), methodsMap0);
            this.methodsMap = methodsMap0;
        }
    }

    public boolean isActive() {
        long mills;
        if (this.session instanceof DefaultP2pConnSession && this.session.getTransportType() == 0 && (mills = this.session.getActiveMills()) > this.activeTimeMills) {
            this.activeTimeMills = mills;
        }
        return P2pContextUtil.getContext().currentTimeMillis() - this.activeTimeMills < 30000L;
    }

    public P2pConnSession getP2pConnSession() {
        return this.session;
    }

    public void close() {
        if (!this.session.isClosed()) {
            this.session.close();
        }
        this.removeFromMapWhenClosed();
    }

    private void removeFromMapWhenClosed() {
        P2pReverseConnection act = p2pConnSessionMap.get(this.session.getSessionId());
        if (act != null && act == this && (act = p2pConnSessionMap.remove(this.session.getSessionId())) != null && act != this && !act.isClosed()) {
            act.close();
        }
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public RequestSender newRequestSender() throws IOException {
        if (this.session instanceof IoSessionP2pConnSession) {
            return ((IoSessionP2pConnSession)this.session).newRequestSender();
        }
        return P2pContextUtil.getContext().getP2PUDPConnectionFactory().createUdpRequestSender(this.session);
    }

    public void service(Receiver request) throws Exception {
        this.activeTimeMills = P2pContextUtil.getContext().currentTimeMillis();
        try {
            if (!P2pTransferTool.checkSign((Receiver)request, (String)this.session.getRemoteSignKey())) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"SIGN_ERROR", (String)"\u7b7e\u540d\u9519\u8bef", (String)this.session.getLocalSignKey());
                return;
            }
            String op = request.getHeaderValue("op");
            if (op == null) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"\u7f3a\u5c11\u53c2\u6570OP", (String)this.session.getLocalSignKey());
                return;
            }
            Method method = this.methodsMap.get(op);
            if (method == null) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_METHOD_NOTFOUND", (String)("\u6682\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\uff1a" + op), (String)this.session.getLocalSignKey());
                return;
            }
            method.invoke((Object)this, request);
        }
        catch (Throwable ex) {
            LogUtil.getLog().error((Object)"\u5185\u90e8\u9519\u8bef", ex);
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"SYS_ERROR", (String)"\u7cfb\u7edf\u5185\u90e8\u9519\u8bef", (String)this.session.getLocalSignKey());
        }
    }

    public void heartbeat(Receiver request) {
        String msg = request.getHeaderValue("e");
        if (msg == null) {
            msg = "";
        }
        P2pTransferTool.doSimpleResponse((Receiver)request, (String)"SUCCESS", (String)msg, (String)this.session.getLocalSignKey());
    }

    public void proxyConnect(final Receiver request) {
        String proxyIp;
        int transportType;
        int proxyPort;
        String proxyType = request.getHeaderValue("pt");
        String proxyNo = request.getHeaderValue("pn");
        String _proxyPort = request.getHeaderValue("pp");
        String _transportType = request.getHeaderValue("tp");
        String _sk = request.getHeaderValue("sk");
        String peerId = request.getHeaderValue("ad");
        String peerName = request.getHeaderValue("an");
        String connId = request.getHeaderValue("gd");
        if (proxyType == null || proxyType.length() == 0) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Missing pt", (String)this.session.getLocalSignKey());
            return;
        }
        if (proxyNo == null || proxyNo.length() == 0) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Missing pn", (String)this.session.getLocalSignKey());
            return;
        }
        if (_proxyPort == null || _proxyPort.length() == 0) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Missing pp", (String)this.session.getLocalSignKey());
            return;
        }
        try {
            proxyPort = Integer.parseInt(_proxyPort);
        }
        catch (Exception ex) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param pp:" + _proxyPort), (String)this.session.getLocalSignKey());
            return;
        }
        if (proxyPort <= 0 || proxyPort >= 65535) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param pp:" + _proxyPort), (String)this.session.getLocalSignKey());
            return;
        }
        if (String.valueOf(0).equals(_transportType)) {
            transportType = 0;
        } else if (String.valueOf(1).equals(_transportType)) {
            transportType = 1;
        } else {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Unknown tp", (String)this.session.getLocalSignKey());
            return;
        }
        String connectIp = null;
        int tcpPort = 0;
        if (transportType == 1) {
            String _tcpPort = request.getHeaderValue("tpt");
            if (_tcpPort == null || _tcpPort.length() == 0) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Missing tpt", (String)this.session.getLocalSignKey());
                return;
            }
            try {
                tcpPort = Integer.parseInt(_tcpPort);
            }
            catch (Exception ex) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param tpt:" + _tcpPort), (String)this.session.getLocalSignKey());
                return;
            }
            if (tcpPort <= 0 || tcpPort >= 65535) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param tpt:" + _tcpPort), (String)this.session.getLocalSignKey());
                return;
            }
            connectIp = request.getHeaderValue("tit");
            if (connectIp == null || connectIp.length() == 0) {
                connectIp = ((InetSocketAddress)request.getRemoteAddress()).getAddress().getHostAddress();
            }
        }
        if (PROXY_HOST_TYPE_PARKING_HOST.equals(proxyType)) {
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                if (localHost == null || localHost.getHost_no() == null || !localHost.getHost_no().equals(proxyNo)) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Invalid param proxyNo: not local host", (String)this.session.getLocalSignKey());
                    return;
                }
                proxyIp = "127.0.0.1";
            } else {
                CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(proxyNo);
                if (host == null) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param proxyNo: unknown host no:" + proxyNo), (String)this.session.getLocalSignKey());
                    return;
                }
                if (host.getHost_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
                    proxyIp = "127.0.0.1";
                } else {
                    proxyIp = host.getHost_ip();
                    if (proxyIp == null || proxyIp.length() == 0) {
                        P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param proxyNo: Host(" + proxyNo + ") IP not defined:"), (String)this.session.getLocalSignKey());
                        return;
                    }
                }
            }
        } else if (PROXY_HOST_TYPE_CAMERA.equals(proxyType)) {
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                Equipment equipment = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(proxyNo);
                if (equipment == null || equipment.getIp() == null || equipment.getIp().length() == 0) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"Invalid param proxyNo: not local manage device or not a net device", (String)this.session.getLocalSignKey());
                    return;
                }
                proxyIp = equipment.getIp();
            } else {
                ChannelEquipmentVo cv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVo(proxyNo);
                if (cv == null) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param proxyNo: unknown device no:" + proxyNo), (String)this.session.getLocalSignKey());
                    return;
                }
                proxyIp = cv.getEquipment_ip();
                if (proxyIp == null || proxyIp.length() == 0) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param proxyNo: Device(" + proxyNo + ") IP not defined:"), (String)this.session.getLocalSignKey());
                    return;
                }
            }
        } else {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)("Invalid param proxyType:" + proxyType), (String)this.session.getLocalSignKey());
            return;
        }
        final ProxyP2pConnection conn = new ProxyP2pConnection(proxyIp, proxyPort, peerId, peerName, transportType, connectIp, tcpPort, connId, _sk);
        conn.connect().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Boolean>(){

            public void operationComplete(OperationFuture<Boolean> future) {
                if (future.isCancelled()) {
                    this.onConnectResult("REQUEST_ERROR", "connect timeout");
                } else if (future.getException() != null) {
                    String msg = future.getException().getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = "connect error";
                    }
                    this.onConnectResult("REQUEST_ERROR", msg);
                } else if (future.getResult() == null || !((Boolean)future.getResult()).booleanValue()) {
                    this.onConnectResult("REQUEST_ERROR", "connect failed");
                } else {
                    this.onConnectResult("SUCCESS", "SUCCESS");
                }
            }

            public void waitCompleteTimeout() {
                this.onConnectResult("REQUEST_ERROR", "connect timeout");
            }

            private void onConnectResult(String code, String value) {
                try {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)code, (String)value, (String)P2pReverseConnection.this.session.getLocalSignKey());
                }
                finally {
                    if (!"SUCCESS".equals(code)) {
                        conn.close();
                    }
                }
            }
        });
    }
}

