/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p;

import com.wovoe.carpark.DiskCacheBuffer;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.P2pPeerConnector;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.Sender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionGetter;
import com.wovoe.framework.p2p.IoSessionP2pConnSession;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pConnSessionCloseListener;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pTransferTool;
import com.wovoe.framework.p2p.action.P2pConnectionAction;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class ProxyP2pConnection
extends IoHandlerAdapter
implements P2pConnSessionCloseListener,
ServiceAction {
    private P2pConnSession p2pConnSession;
    private IoSession proxySession;
    private DiskCacheBuffer diskCacheBuffer;
    private String proxyIp;
    private int proxyPort;
    private String p2pPeerId;
    private String p2pPeerName;
    private int p2pTransportType;
    private String p2pIp;
    private int p2pPort;
    private String p2pIpConnId;
    private String p2pSigKey;
    private volatile boolean closed;
    private OperationFutureHandler<Boolean> connectFutureHandler;
    private ConnectFuture proxyConnectFuture;
    private ConnectFuture p2pTcpConnectFuture;
    private OperationFuture<P2pConnSession> p2pUdpConnectFuture;
    private volatile boolean p2pHandShake;
    private static final String op_dispatch_data = "d";
    protected byte[] sendBytes;
    protected volatile boolean sending = false;
    private volatile boolean connectSuccess = false;
    private static final String P2pReverseProxyAction = "/P2pReverseProxyAction";
    private static final String OP_proxyConnect = "proxyConnect";
    private static final String OP_dispatchProxyData = "dispatchProxyData";

    public ProxyP2pConnection(String proxyIp, int proxyPort, String p2pPeerId, String p2pPeerName, int p2pTransportType, String p2pIp, int p2pPort, String p2pIpConnId, String p2pSigKey) {
        this.proxyIp = proxyIp;
        this.proxyPort = proxyPort;
        this.p2pPeerId = p2pPeerId;
        this.p2pPeerName = p2pPeerName;
        this.p2pTransportType = p2pTransportType;
        this.p2pIp = p2pIp;
        this.p2pPort = p2pPort;
        this.p2pIpConnId = p2pIpConnId;
        this.p2pSigKey = p2pSigKey;
    }

    public synchronized OperationFuture<Boolean> connect() {
        InetSocketAddress proxySocketAddress;
        if (this.connectFutureHandler != null) {
            return this.connectFutureHandler;
        }
        if (this.closed) {
            this.connectFutureHandler = ServiceUtil.getServiceContext().createOperationFuture();
            this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
            return this.connectFutureHandler;
        }
        this.connectFutureHandler = ServiceUtil.getServiceContext().createOperationFuture();
        if (this.proxyIp == null || this.proxyIp.length() == 0) {
            this.connectFutureHandler.setException((Throwable)new NullPointerException("Parameter proxyIp is null or empty"));
            this.closed = true;
            return this.connectFutureHandler;
        }
        if (this.proxyPort <= 0 || this.proxyPort >= 65535) {
            this.connectFutureHandler.setException((Throwable)new IllegalArgumentException("Parameter proxyPort value is invalid"));
            this.closed = true;
            return this.connectFutureHandler;
        }
        if (this.p2pPeerId == null || this.p2pPeerId.length() == 0) {
            this.connectFutureHandler.setException((Throwable)new NullPointerException("Parameter p2pPeerId is null or empty"));
            this.closed = true;
            return this.connectFutureHandler;
        }
        if (this.p2pPeerName == null || this.p2pPeerName.length() == 0) {
            this.connectFutureHandler.setException((Throwable)new NullPointerException("Parameter p2pPeerName is null or empty"));
            this.closed = true;
            return this.connectFutureHandler;
        }
        if (this.p2pIpConnId == null || this.p2pIpConnId.length() == 0) {
            this.connectFutureHandler.setException((Throwable)new NullPointerException("Parameter p2pIpConnId is null or empty"));
            this.closed = true;
            return this.connectFutureHandler;
        }
        try {
            proxySocketAddress = new InetSocketAddress(this.proxyIp, this.proxyPort);
        }
        catch (Exception ex) {
            this.connectFutureHandler.setException((Throwable)new IllegalArgumentException("Parameter proxyIp, proxyPort error! " + this.proxyIp + ":" + this.proxyPort));
            this.closed = true;
            return this.connectFutureHandler;
        }
        InetSocketAddress tcpDestAddress = null;
        if (this.p2pTransportType == 1) {
            if (this.p2pIp == null || this.p2pIp.length() == 0) {
                this.connectFutureHandler.setException((Throwable)new NullPointerException("Parameter p2pIp is null or empty"));
                this.closed = true;
                return this.connectFutureHandler;
            }
            if (this.p2pPort <= 0 || this.p2pPort >= 65535) {
                this.connectFutureHandler.setException((Throwable)new IllegalArgumentException("Parameter p2pPort value is invalid"));
                this.closed = true;
                return this.connectFutureHandler;
            }
            try {
                tcpDestAddress = new InetSocketAddress(this.p2pIp, this.p2pPort);
            }
            catch (Exception ex) {
                this.connectFutureHandler.setException((Throwable)new IllegalArgumentException("Parameter p2pIp, p2pPort error! " + this.p2pIp + ":" + this.p2pPort));
                this.closed = true;
                return this.connectFutureHandler;
            }
            this.p2pTcpConnectFuture = P2pContextUtil.getContext().getNioSocketConnector().connect((SocketAddress)tcpDestAddress);
        } else if (this.p2pTransportType == 0) {
            this.p2pUdpConnectFuture = P2pPeerConnector.connect(this.p2pPeerId, this.p2pPeerName);
        } else {
            this.connectFutureHandler.setException((Throwable)new IllegalArgumentException("Unsupported transport type: " + this.p2pTransportType));
            this.closed = true;
            return this.connectFutureHandler;
        }
        this.proxyConnectFuture = P2pContextUtil.getContext().getNioSocketConnector().connect((SocketAddress)proxySocketAddress);
        if (this.p2pTcpConnectFuture != null) {
            this.p2pTcpConnectFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void operationComplete(ConnectFuture ioFuture) {
                    ProxyP2pConnection proxyP2pConnection = ProxyP2pConnection.this;
                    synchronized (proxyP2pConnection) {
                        if (ioFuture.getException() != null) {
                            ProxyP2pConnection.this.closed = true;
                            try {
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException(ioFuture.getException());
                            }
                            finally {
                                if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                }
                                if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                    ProxyP2pConnection.this.proxySession.close(true);
                                }
                            }
                        } else if (ioFuture.isCanceled()) {
                            ProxyP2pConnection.this.closed = true;
                            try {
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connect cancelled"));
                            }
                            finally {
                                if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                }
                                if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                    ProxyP2pConnection.this.proxySession.close(true);
                                }
                            }
                        } else {
                            IoSession ioSession = ioFuture.getSession();
                            if (ioSession == null || !ioSession.isConnected()) {
                                ProxyP2pConnection.this.closed = true;
                                try {
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                }
                                finally {
                                    if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                        ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                    }
                                    if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                        ProxyP2pConnection.this.proxySession.close(true);
                                    }
                                }
                            } else if (ProxyP2pConnection.this.closed) {
                                ioSession.close(true);
                                try {
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                }
                                finally {
                                    if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                        ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                    }
                                    if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                        ProxyP2pConnection.this.proxySession.close(true);
                                    }
                                }
                            } else {
                                IoSessionP2pConnSession p2pSession = new IoSessionP2pConnSession(0, ioSession, (ServiceActionGetter)P2pConnectionAction.getServiceActionManager(), ProxyP2pConnection.this.p2pSigKey);
                                p2pSession.setRemotePeerId(ProxyP2pConnection.this.p2pPeerId);
                                p2pSession.setRemotePeerName(ProxyP2pConnection.this.p2pPeerName);
                                p2pSession.setAttribute("WOVOE_TCPCONNECTIOHANLER", (Object)p2pSession);
                                ProxyP2pConnection.this.p2pConnSession = (P2pConnSession)p2pSession;
                                ProxyP2pConnection.this.p2pConnSession.addP2pConnSessionCloseListener((P2pConnSessionCloseListener)ProxyP2pConnection.this);
                                ProxyP2pConnection.this.p2pConnSession.setAttribute("DISPATCH_SERVICE_ACTION", (Object)ProxyP2pConnection.this);
                                if (ProxyP2pConnection.this.proxySession == null) return;
                                if (!ProxyP2pConnection.this.proxySession.isConnected()) {
                                    ProxyP2pConnection.this.closed = true;
                                    ProxyP2pConnection.this.p2pConnSession.close();
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                } else {
                                    if (ProxyP2pConnection.this.p2pHandShake) return;
                                    ProxyP2pConnection.this.doP2pHandShake();
                                }
                            }
                        }
                        return;
                    }
                }
            });
        } else if (this.p2pUdpConnectFuture != null) {
            this.p2pUdpConnectFuture.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<P2pConnSession>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void operationComplete(OperationFuture<P2pConnSession> future) {
                    ProxyP2pConnection proxyP2pConnection = ProxyP2pConnection.this;
                    synchronized (proxyP2pConnection) {
                        if (future.isCancelled()) {
                            ProxyP2pConnection.this.closed = true;
                            try {
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connect cancelled"));
                            }
                            finally {
                                if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                }
                                if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                    ProxyP2pConnection.this.proxySession.close(true);
                                }
                            }
                        } else if (future.getException() != null) {
                            this.onException(future.getException());
                        } else {
                            P2pConnSession session = (P2pConnSession)future.getResult();
                            if (session == null || session.isClosed()) {
                                ProxyP2pConnection.this.closed = true;
                                try {
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                }
                                finally {
                                    if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                        ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                    }
                                    if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                        ProxyP2pConnection.this.proxySession.close(true);
                                    }
                                }
                            } else if (ProxyP2pConnection.this.closed) {
                                session.close();
                                try {
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                }
                                finally {
                                    if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                                        ProxyP2pConnection.this.proxyConnectFuture.cancel();
                                    }
                                    if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                                        ProxyP2pConnection.this.proxySession.close(true);
                                    }
                                }
                            } else {
                                ProxyP2pConnection.this.p2pConnSession = session;
                                ProxyP2pConnection.this.p2pConnSession.addP2pConnSessionCloseListener((P2pConnSessionCloseListener)ProxyP2pConnection.this);
                                ProxyP2pConnection.this.p2pConnSession.setAttribute("DISPATCH_SERVICE_ACTION", (Object)ProxyP2pConnection.this);
                                if (ProxyP2pConnection.this.proxySession == null) return;
                                if (!ProxyP2pConnection.this.proxySession.isConnected()) {
                                    ProxyP2pConnection.this.closed = true;
                                    ProxyP2pConnection.this.p2pConnSession.close();
                                    if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                    ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                                } else {
                                    if (ProxyP2pConnection.this.p2pHandShake) return;
                                    ProxyP2pConnection.this.doP2pHandShake();
                                }
                            }
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void waitCompleteTimeout() {
                    ProxyP2pConnection proxyP2pConnection = ProxyP2pConnection.this;
                    synchronized (proxyP2pConnection) {
                        this.onException(new IOException("Connect timeout"));
                    }
                }

                private void onException(Throwable ex) {
                    ProxyP2pConnection.this.closed = true;
                    try {
                        if (!ProxyP2pConnection.this.connectFutureHandler.isDone()) {
                            ProxyP2pConnection.this.connectFutureHandler.setException(ex);
                        }
                    }
                    finally {
                        if (!ProxyP2pConnection.this.proxyConnectFuture.isDone()) {
                            ProxyP2pConnection.this.proxyConnectFuture.cancel();
                        }
                        if (ProxyP2pConnection.this.proxySession != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                            ProxyP2pConnection.this.proxySession.close(true);
                        }
                    }
                }
            });
        }
        this.proxyConnectFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void operationComplete(ConnectFuture ioFuture) {
                ProxyP2pConnection proxyP2pConnection = ProxyP2pConnection.this;
                synchronized (proxyP2pConnection) {
                    if (ioFuture.getException() != null) {
                        ProxyP2pConnection.this.closed = true;
                        try {
                            if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                            ProxyP2pConnection.this.connectFutureHandler.setException(ioFuture.getException());
                        }
                        finally {
                            if (ProxyP2pConnection.this.p2pUdpConnectFuture != null && !ProxyP2pConnection.this.p2pUdpConnectFuture.isDone()) {
                                ProxyP2pConnection.this.p2pUdpConnectFuture.cancel(true);
                            }
                            if (ProxyP2pConnection.this.p2pTcpConnectFuture != null && !ProxyP2pConnection.this.p2pTcpConnectFuture.isDone()) {
                                ProxyP2pConnection.this.p2pTcpConnectFuture.cancel();
                            }
                            if (ProxyP2pConnection.this.p2pConnSession != null && ProxyP2pConnection.this.p2pConnSession.isConnected()) {
                                ProxyP2pConnection.this.p2pConnSession.close();
                            }
                        }
                    } else if (ioFuture.isCanceled()) {
                        ProxyP2pConnection.this.closed = true;
                        try {
                            if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                            ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connect cancelled"));
                        }
                        finally {
                            if (ProxyP2pConnection.this.p2pUdpConnectFuture != null && !ProxyP2pConnection.this.p2pUdpConnectFuture.isDone()) {
                                ProxyP2pConnection.this.p2pUdpConnectFuture.cancel(true);
                            }
                            if (ProxyP2pConnection.this.p2pTcpConnectFuture != null && !ProxyP2pConnection.this.p2pTcpConnectFuture.isDone()) {
                                ProxyP2pConnection.this.p2pTcpConnectFuture.cancel();
                            }
                            if (ProxyP2pConnection.this.p2pConnSession != null && ProxyP2pConnection.this.p2pConnSession.isConnected()) {
                                ProxyP2pConnection.this.p2pConnSession.close();
                            }
                        }
                    } else {
                        IoSession ioSession = ioFuture.getSession();
                        if (ioSession == null || !ioSession.isConnected()) {
                            ProxyP2pConnection.this.closed = true;
                            try {
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                            }
                            finally {
                                if (ProxyP2pConnection.this.p2pUdpConnectFuture != null && !ProxyP2pConnection.this.p2pUdpConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.p2pUdpConnectFuture.cancel(true);
                                }
                                if (ProxyP2pConnection.this.p2pTcpConnectFuture != null && !ProxyP2pConnection.this.p2pTcpConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.p2pTcpConnectFuture.cancel();
                                }
                                if (ProxyP2pConnection.this.p2pConnSession != null && ProxyP2pConnection.this.p2pConnSession.isConnected()) {
                                    ProxyP2pConnection.this.p2pConnSession.close();
                                }
                            }
                        } else if (ProxyP2pConnection.this.closed) {
                            ioSession.close(true);
                            try {
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                            }
                            finally {
                                if (ProxyP2pConnection.this.p2pUdpConnectFuture != null && !ProxyP2pConnection.this.p2pUdpConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.p2pUdpConnectFuture.cancel(true);
                                }
                                if (ProxyP2pConnection.this.p2pTcpConnectFuture != null && !ProxyP2pConnection.this.p2pTcpConnectFuture.isDone()) {
                                    ProxyP2pConnection.this.p2pTcpConnectFuture.cancel();
                                }
                                if (ProxyP2pConnection.this.p2pConnSession != null && ProxyP2pConnection.this.p2pConnSession.isConnected()) {
                                    ProxyP2pConnection.this.p2pConnSession.close();
                                }
                            }
                        } else {
                            ProxyP2pConnection.this.diskCacheBuffer = new DiskCacheBuffer();
                            ProxyP2pConnection.this.proxySession = ioSession;
                            ProxyP2pConnection.this.proxySession.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)ProxyP2pConnection.this);
                            if (ProxyP2pConnection.this.p2pConnSession == null) return;
                            if (ProxyP2pConnection.this.p2pConnSession.isClosed()) {
                                ProxyP2pConnection.this.closed = true;
                                ProxyP2pConnection.this.proxySession.close(true);
                                if (ProxyP2pConnection.this.connectFutureHandler.isDone()) return;
                                ProxyP2pConnection.this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                            } else {
                                if (ProxyP2pConnection.this.p2pHandShake) return;
                                ProxyP2pConnection.this.doP2pHandShake();
                            }
                        }
                    }
                    return;
                }
            }
        });
        return this.connectFutureHandler;
    }

    private synchronized void doP2pHandShake() {
        if (this.p2pHandShake) {
            return;
        }
        this.p2pHandShake = true;
        try {
            RequestSender sender = this.newRequestSender();
            sender.setRequestActionName(P2pReverseProxyAction);
            sender.setHeader("op", OP_proxyConnect);
            sender.setHeader("connectId", this.p2pIpConnId);
            sender.setHeader("e", String.valueOf(System.currentTimeMillis()));
            P2pTransferTool.setSign((Sender)sender, (String)this.p2pConnSession.getLocalSignKey());
            sender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    ProxyP2pConnection.this.close(0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    if ("SUCCESS".equals(receiver.getHeaderValue("c"))) {
                        ProxyP2pConnection.this.connectSuccess = true;
                        if (ProxyP2pConnection.this.closed) {
                            ProxyP2pConnection.this.close(0);
                        } else if (!ProxyP2pConnection.this.connectFutureHandler.isDone()) {
                            ProxyP2pConnection.this.connectFutureHandler.setResult((Object)Boolean.TRUE);
                        }
                    } else {
                        ProxyP2pConnection.this.close(0);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    ProxyP2pConnection.this.close(0);
                }

                public long getWaitTimeoutMills() {
                    return 10000L;
                }
            });
        }
        catch (Throwable ex) {
            this.close(0);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        if (buf.hasRemaining()) {
            if (this.diskCacheBuffer == null || this.diskCacheBuffer.isClosed()) {
                session.close(true);
                return;
            }
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            if (!this.diskCacheBuffer.write(data)) {
                session.close(true);
                return;
            }
            this.trySend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySend() {
        int sendLength = 0;
        ProxyP2pConnection proxyP2pConnection = this;
        synchronized (proxyP2pConnection) {
            if (this.p2pConnSession == null || this.p2pConnSession.isClosed() || !this.connectSuccess) {
                return;
            }
            if (!this.sending) {
                if (this.sendBytes == null) {
                    this.sendBytes = new byte[8192];
                }
                if ((sendLength = this.diskCacheBuffer.read(this.sendBytes, 0, this.sendBytes.length)) > 0) {
                    this.sending = true;
                } else if (this.closed) {
                    this.close(2);
                }
            }
        }
        if (sendLength > 0 && this.sendBytes != null) {
            this.directSend(this.sendBytes, 0, sendLength);
        }
    }

    private RequestSender newRequestSender() throws IOException {
        if (this.p2pConnSession instanceof IoSessionP2pConnSession) {
            return ((IoSessionP2pConnSession)this.p2pConnSession).newRequestSender();
        }
        return P2pContextUtil.getContext().getP2PUDPConnectionFactory().createUdpRequestSender(this.p2pConnSession);
    }

    protected void directSend(byte[] data, int offset, int length) {
        try {
            RequestSender sender = this.newRequestSender();
            sender.setRequestActionName(P2pReverseProxyAction);
            sender.setHeader("op", OP_dispatchProxyData);
            sender.setHeader("connectId", this.p2pIpConnId);
            sender.setSendData(data, offset, length);
            P2pTransferTool.setSign((Sender)sender, (String)this.p2pConnSession.getLocalSignKey());
            sender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    ProxyP2pConnection.this.close(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCompleted() {
                    ProxyP2pConnection proxyP2pConnection = ProxyP2pConnection.this;
                    synchronized (proxyP2pConnection) {
                        ProxyP2pConnection.this.sending = false;
                    }
                    ProxyP2pConnection.this.trySend();
                }
            }, null);
        }
        catch (Exception ex) {
            this.close(2);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.close(1);
    }

    public void onClose(P2pConnSession session, int reason) {
        this.close(2);
    }

    public void close() {
        this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int cause) {
        ProxyP2pConnection proxyP2pConnection = this;
        synchronized (proxyP2pConnection) {
            if (this.closed) {
                if (cause != 1) {
                    if (this.p2pConnSession != null && !this.p2pConnSession.isClosed()) {
                        this.p2pConnSession.close();
                    }
                    if (this.proxySession != null && this.proxySession.isConnected()) {
                        this.proxySession.close(true);
                    }
                    if (this.diskCacheBuffer != null && !this.diskCacheBuffer.isClosed()) {
                        this.diskCacheBuffer.close();
                    }
                }
                return;
            }
            this.closed = true;
            if (this.proxyConnectFuture != null && !this.proxyConnectFuture.isDone()) {
                this.proxyConnectFuture.cancel();
            }
            if (this.p2pTcpConnectFuture != null && !this.p2pTcpConnectFuture.isDone()) {
                this.p2pTcpConnectFuture.cancel();
            }
            if (this.p2pUdpConnectFuture != null && !this.p2pUdpConnectFuture.isDone()) {
                this.p2pUdpConnectFuture.cancel(true);
            }
            try {
                if (this.connectFutureHandler != null && !this.connectFutureHandler.isDone()) {
                    this.connectFutureHandler.setException((Throwable)new ConnectException("Connection closed"));
                }
            }
            finally {
                if (this.p2pConnSession != null && this.proxySession != null) {
                    if (this.proxySession.isConnected() && !this.proxySession.isClosing()) {
                        this.proxySession.close(true);
                    }
                    if (cause == 1 && this.diskCacheBuffer != null && !this.diskCacheBuffer.isClosed() && this.diskCacheBuffer.availableSize() > 0L && !this.p2pConnSession.isClosed()) {
                        this.trySend();
                    } else {
                        if (!this.p2pConnSession.isClosed()) {
                            this.p2pConnSession.close();
                        }
                        if (this.diskCacheBuffer != null && !this.diskCacheBuffer.isClosed()) {
                            this.diskCacheBuffer.close();
                        }
                    }
                } else {
                    if (this.p2pConnSession != null && !this.p2pConnSession.isClosed()) {
                        this.p2pConnSession.close();
                    }
                    if (this.proxySession != null && this.proxySession.isConnected()) {
                        this.proxySession.close(true);
                    }
                    if (this.diskCacheBuffer != null && !this.diskCacheBuffer.isClosed()) {
                        this.diskCacheBuffer.close();
                    }
                }
            }
        }
    }

    public void service(Receiver request) throws Exception {
        if (this.p2pConnSession == null) {
            return;
        }
        String op = request.getHeaderValue("op");
        if (op_dispatch_data.equals(op)) {
            if (this.proxySession == null || !this.proxySession.isConnected()) {
                this.close();
                return;
            }
            if (!P2pTransferTool.checkSign((Receiver)request, (String)this.p2pConnSession.getRemoteSignKey())) {
                this.close();
                return;
            }
            if (request.getData() != null && request.getData().length > 0 && request.getDataLength() > 0) {
                IoBuffer ioBuffer = IoBuffer.wrap((byte[])request.getData(), (int)request.getDataOffset(), (int)request.getDataLength());
                this.proxySession.write((Object)ioBuffer).addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                    public void operationComplete(IoFuture ioFuture) {
                        WriteFuture s = (WriteFuture)ioFuture;
                        if (s.getException() != null && ProxyP2pConnection.this.proxySession.isConnected()) {
                            ProxyP2pConnection.this.proxySession.close(true);
                        }
                    }
                });
            }
        }
    }
}

