/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.CameraConnServiceActionGetter;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.LiveDataFrame;
import com.wovoe.carpark.p2p.media.MediaPushConnection;
import com.wovoe.carpark.p2p.media.rtsp.H264Frame;
import com.wovoe.carpark.p2p.media.rtsp.H264FrameHelper;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.SendCallback;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class BasicMediaPushConnection
extends CameraConnServiceActionGetter
implements MediaPushConnection {
    protected volatile OperationFutureHandler<Boolean> connectHandler;
    protected volatile OperationFutureHandler<String> pushSessionIdFutureHandler;
    protected volatile boolean closed;
    protected LinkedList<LiveDataFrame> sendQueue;
    protected volatile boolean streamSending = false;
    protected int maxSendFrameSize;
    protected ConcurrentLinkedQueue<MediaPushConnection.CloseListener> closeListeners;
    protected String sdp;
    private boolean sendSdp;
    protected List<H264Frame> h264FrameList = new LinkedList<H264Frame>();
    protected CameraLivePushEntry cameraLivePushEntry;
    private volatile int frameIndex = 0;
    SendCallback sendFrameCallback = new SendCallback(){

        public void onException(Throwable exception) {
            LogUtil.getLog().warn((Object)("\u53d1\u9001\u89c6\u9891\u6d41\u5f02\u5e38\uff01" + exception.getMessage()));
            BasicMediaPushConnection.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted() {
            LiveDataFrame frame;
            LinkedList<LiveDataFrame> linkedList = BasicMediaPushConnection.this.sendQueue;
            synchronized (linkedList) {
                frame = BasicMediaPushConnection.this.sendQueue.poll();
                if (frame == null) {
                    BasicMediaPushConnection.this.streamSending = false;
                }
            }
            if (frame != null) {
                BasicMediaPushConnection.this.doSend(frame);
            }
        }
    };

    protected abstract void doSend(LiveDataFrame var1, SendCallback var2);

    protected abstract void doConnect();

    protected abstract void doClose();

    protected abstract void disconnect();

    protected abstract void doRequestPushSessionId();

    protected BasicMediaPushConnection(CameraLivePushEntry entry) {
        this.cameraLivePushEntry = entry;
        this.closed = false;
        this.sendQueue = new LinkedList();
        this.maxSendFrameSize = 500;
        this.closeListeners = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLiveDataFrame(LiveDataFrame frame) {
        if (!this.isConnected()) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (this.connectHandler.getResult() == null || !((Boolean)this.connectHandler.getResult()).booleanValue()) {
            return;
        }
        if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
            return;
        }
        LiveDataFrame sendFrame = null;
        LinkedList<LiveDataFrame> linkedList = this.sendQueue;
        synchronized (linkedList) {
            ++this.frameIndex;
            if (this.frameIndex < 0) {
                this.frameIndex = 0;
                ++this.frameIndex;
            }
            frame.setFrameIndex(this.frameIndex);
            if (this.sendQueue.size() < this.maxSendFrameSize) {
                this.sendQueue.offer(frame);
            }
            if (!this.streamSending && (sendFrame = this.sendQueue.poll()) != null) {
                this.streamSending = true;
            }
        }
        if (sendFrame != null) {
            this.doSend(sendFrame);
        }
    }

    protected void doSend(LiveDataFrame sendFrame) {
        this.doSend(sendFrame, this.sendFrameCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<Boolean> connect() {
        boolean closed;
        if (this.connectHandler != null) {
            return this.connectHandler;
        }
        BasicMediaPushConnection basicMediaPushConnection = this;
        synchronized (basicMediaPushConnection) {
            if (this.connectHandler != null) {
                return this.connectHandler;
            }
            this.connectHandler = ServiceUtil.getServiceContext().createOperationFuture();
            closed = this.closed;
        }
        if (closed) {
            this.connectHandler.cancel(true);
        } else {
            this.doConnect();
        }
        return this.connectHandler;
    }

    @Override
    public OperationFuture<Boolean> getConnectFuture() {
        return this.connectHandler;
    }

    @Override
    public boolean isClosed() {
        if (this.closed && this.isConnected()) {
            this.disconnect();
        }
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            object = this.sendQueue;
            synchronized (object) {
                this.sendQueue.clear();
                this.streamSending = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.doClose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.connectHandler == null) {
                object = this;
                synchronized (object) {
                    if (this.connectHandler == null) {
                        this.connectHandler = ServiceUtil.getServiceContext().createOperationFuture();
                    }
                }
            }
            if (!this.connectHandler.isDone()) {
                this.connectHandler.cancel(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            OperationFutureHandler<String> handler = this.pushSessionIdFutureHandler;
            if (handler != null && !handler.isDone()) {
                handler.setException((Throwable)new IOException("connection has been closed!"));
            }
        }
        catch (Throwable handler) {
            // empty catch block
        }
        if (this.closeListeners != null) {
            MediaPushConnection.CloseListener l;
            while ((l = this.closeListeners.poll()) != null) {
                try {
                    l.onClose(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addCloseListener(MediaPushConnection.CloseListener l) {
        if (this.isClosed()) {
            if (l != null) {
                l.onClose(this);
            }
        } else if (l != null) {
            this.closeListeners.offer(l);
            if (this.isClosed() && this.closeListeners.remove(l)) {
                l.onClose(this);
            }
        }
    }

    @Override
    public void removeCloseListener(MediaPushConnection.CloseListener l) {
        if (l != null) {
            this.closeListeners.remove(l);
        }
    }

    @Override
    public String getPushHostName() {
        return this.cameraLivePushEntry.getPushHostName();
    }

    @Override
    public String getPushHostAppName() {
        return this.cameraLivePushEntry.getPushHostAppName();
    }

    @Override
    public String getPushHostGroupName() {
        return this.cameraLivePushEntry.getPushHostGroupName();
    }

    @Override
    public String getPushHSeq() {
        return this.cameraLivePushEntry.getPushHSeq();
    }

    @Override
    public void onException(int opType, Throwable ex) {
        LogUtil.getLog().info((Object)("\u4e0e\u6444\u50cf\u673a\u901a\u4fe1\u9519\u8bef\uff01\u64cd\u4f5c\u7c7b\u578b\uff1a" + opType + ", \u539f\u56e0\uff1a" + ex.getMessage() + "."));
    }

    @Override
    public void onDisconnect() {
        try {
            LogUtil.getLog().info((Object)"\u4e0e\u8bbe\u5907\u65ad\u5f00\u8fde\u63a5! \u8fd9\u5c06\u5173\u95ed\u4e0e\u89c6\u9891\u670d\u52a1\u5668\u8fde\u63a5");
        }
        finally {
            this.close();
        }
    }

    @Override
    public void onReadyPlay() {
    }

    @Override
    public void onHandleRtpData(int channelType, int dataType, byte[] data, int offset, int length) {
        LiveDataFrame frame;
        if (length == 0) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
            return;
        }
        if (!this.sendSdp && this.sdp != null && this.sdp.length() > 0) {
            byte[] sdpBytes;
            frame = new LiveDataFrame();
            try {
                sdpBytes = this.sdp.getBytes("UTF-8");
            }
            catch (Exception ex) {
                sdpBytes = this.sdp.getBytes();
            }
            frame.setData(sdpBytes);
            frame.setDataOffset(0);
            frame.setDataLength(sdpBytes.length);
            frame.setFrameType(2);
            frame.setDataType(0);
            this.addLiveDataFrame(frame);
            this.sendSdp = true;
        }
        if (channelType == 0) {
            if (dataType == 0) {
                byte[] h264Data;
                if (offset == 0) {
                    h264Data = data;
                } else {
                    h264Data = new byte[length];
                    System.arraycopy(data, offset, h264Data, 0, length);
                }
                this.onHandleH264Data(h264Data);
            }
        } else if (channelType == 1 && dataType == 1) {
            frame = new LiveDataFrame();
            frame.setData(data);
            frame.setDataOffset(offset);
            frame.setDataLength(length);
            frame.setFrameType(1);
            frame.setDataType(64);
            this.addLiveDataFrame(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHandleH264Data(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
            return;
        }
        List<H264Frame> list = this.h264FrameList;
        synchronized (list) {
            H264FrameHelper.findFrame(data, this.h264FrameList);
            Iterator<H264Frame> it = this.h264FrameList.iterator();
            while (it.hasNext()) {
                H264Frame frame = it.next();
                it.remove();
                this.addH264DataFrame(frame);
            }
        }
    }

    protected void addH264DataFrame(H264Frame h264frame) {
        if (!this.isConnected()) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
            return;
        }
        LiveDataFrame frame = new LiveDataFrame();
        frame.setData(h264frame.getData());
        frame.setDataOffset(h264frame.getDataOffset());
        frame.setDataLength(h264frame.getDataLength());
        frame.setFrameType(0);
        frame.setDataType(32);
        this.addLiveDataFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<String> requestPushSessionId() {
        if (this.pushSessionIdFutureHandler != null) {
            return this.pushSessionIdFutureHandler;
        }
        if (this.isClosed()) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new IOException("\u8fde\u63a5\u5df2\u5173\u95ed"));
            return f;
        }
        if (!this.isConnected()) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new IOException("\u8fd8\u672a\u80fd\u8fde\u63a5\u6210\u529f!"));
            return f;
        }
        BasicMediaPushConnection basicMediaPushConnection = this;
        synchronized (basicMediaPushConnection) {
            if (this.pushSessionIdFutureHandler != null) {
                return this.pushSessionIdFutureHandler;
            }
            this.pushSessionIdFutureHandler = ServiceUtil.getServiceContext().createOperationFuture();
        }
        this.doRequestPushSessionId();
        return this.pushSessionIdFutureHandler;
    }

    @Override
    public OperationFuture<String> getPushSessionIdFuture() {
        return this.pushSessionIdFutureHandler;
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onSdp(String sdp) {
        this.sdp = sdp;
    }

    @Override
    public String getRemoteSignKey() {
        return this.cameraLivePushEntry.getSignKey();
    }
}

