/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.CameraLivePusher;
import com.wovoe.carpark.p2p.media.DefaultCameraLivePusher;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.transfer.ResultResponseMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class CameraLivePushManager
extends JobTask {
    private final ConcurrentHashMap<String, CameraLivePusher> pusherMap;
    private NioSocketConnector connector;
    protected volatile boolean destroyed;

    public CameraLivePushManager(NioSocketConnector connector) {
        this.connector = connector;
        this.pusherMap = new ConcurrentHashMap();
    }

    public CameraLivePusher getCameraLivePusher(String cameraNo) {
        if (cameraNo == null || cameraNo.length() == 0) {
            return null;
        }
        return this.pusherMap.get(cameraNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPush(CameraLivePushEntry entry, OperationFutureHandler<ResultResponseMap> operationFutureHandler) {
        if (operationFutureHandler == null || operationFutureHandler.isDone()) {
            return;
        }
        if (entry == null) {
            operationFutureHandler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570CameraLivePushEntry"));
            return;
        }
        if (this.destroyed) {
            operationFutureHandler.setResult((Object)new ResultResponseMap("501", "\u7cfb\u7edf\u5df2\u5173\u95ed"));
            return;
        }
        if (this.connector == null || this.connector.isDisposing() || this.connector.isDisposed()) {
            operationFutureHandler.setResult((Object)new ResultResponseMap("501", "\u7cfb\u7edf\u5df2\u5173\u95ed"));
            return;
        }
        CameraLivePusher pusher = this.pusherMap.get(entry.getCameraNo());
        if (pusher == null || pusher.isClosed()) {
            CameraLivePushManager cameraLivePushManager = this;
            synchronized (cameraLivePushManager) {
                if (this.destroyed) {
                    operationFutureHandler.setResult((Object)new ResultResponseMap("403", "\u7cfb\u7edf\u5df2\u5173\u95ed"));
                    return;
                }
                pusher = this.pusherMap.get(entry.getCameraNo());
                if (pusher == null || pusher.isClosed()) {
                    pusher = new DefaultCameraLivePusher(entry.getCameraNo(), this.getNioSocketConnector());
                    this.pusherMap.put(entry.getCameraNo(), pusher);
                }
            }
        }
        pusher.doPush(entry, operationFutureHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        CameraLivePushManager cameraLivePushManager = this;
        synchronized (cameraLivePushManager) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        Iterator<Map.Entry<String, CameraLivePusher>> entryIterator = this.pusherMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, CameraLivePusher> entry = entryIterator.next();
            entry.getValue().close();
            entryIterator.remove();
        }
    }

    public NioSocketConnector getNioSocketConnector() {
        return this.connector;
    }

    protected void doRun() throws Exception {
        Iterator<Map.Entry<String, CameraLivePusher>> iterator = this.pusherMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CameraLivePusher> entry = iterator.next();
            if (ServiceUtil.getServiceContext() == null || ServiceUtil.getServiceContext().getDBConfigCache() == null || ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVo(entry.getKey()) == null) {
                if (!entry.getValue().isClosed()) {
                    entry.getValue().close();
                }
                iterator.remove();
                continue;
            }
            if (entry.getValue().isClosed()) {
                iterator.remove();
                continue;
            }
            entry.getValue().check();
        }
    }
}

