/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.equipment.action.MediaProfile;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.CameraLivePusher;
import com.wovoe.carpark.p2p.media.MediaPushConnection;
import com.wovoe.carpark.p2p.media.P2pUdpMediaPushConnection;
import com.wovoe.carpark.p2p.media.TcpMediaPushConnection;
import com.wovoe.carpark.p2p.media.rtsp.MediaStreamCallback;
import com.wovoe.carpark.p2p.media.rtsp.RtspConnection;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.transfer.ResultResponseMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class DefaultCameraLivePusher
implements CameraLivePusher,
MediaStreamCallback,
MediaPushConnection.CloseListener {
    private String cameraNo;
    private CopyOnWriteArrayList<MediaPushConnection> mediaPushConnectionList = new CopyOnWriteArrayList();
    private volatile RtspConnection rtspConnection;
    private long allowCloseRtspMills;
    private NioSocketConnector nioSocketConnector;
    private boolean closed;
    String latestSdp;
    private static final String p2pDirConnGroupName = "p2pDirConn";

    public DefaultCameraLivePusher(String cameraNo, NioSocketConnector nioSocketConnector) {
        this.cameraNo = cameraNo;
        this.nioSocketConnector = nioSocketConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check() {
        RtspConnection rtspConnection0 = this.rtspConnection;
        if (rtspConnection0 == null || !rtspConnection0.isStarted()) {
            return;
        }
        if (ServiceUtil.getServiceContext().currentTimeMillis() - rtspConnection0.getLastRevVideoMills() >= 10000L) {
            rtspConnection0.stop();
        }
        if (!this.mediaPushConnectionList.isEmpty()) {
            return;
        }
        DefaultCameraLivePusher defaultCameraLivePusher = this;
        synchronized (defaultCameraLivePusher) {
            if (this.mediaPushConnectionList.isEmpty() && ServiceUtil.getServiceContext().currentTimeMillis() >= this.allowCloseRtspMills) {
                this.rtspConnection.stop();
                this.rtspConnection = null;
            }
        }
    }

    @Override
    public String getCameraNo() {
        return this.cameraNo;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPush(CameraLivePushEntry entry, OperationFutureHandler<ResultResponseMap> resultSetFuture) {
        if (resultSetFuture == null || resultSetFuture.isDone()) {
            return;
        }
        if (entry == null) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u5185\u90e8\u8c03\u7528\u53c2\u6570\u9519\u8befCameraLivePushEntry\u4e3aNULL"));
            return;
        }
        if (entry.getPushHostName() == null || entry.getPushHostName().length() == 0) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570pushHostName"));
            return;
        }
        if (entry.getPushHostAppName() == null || entry.getPushHostAppName().length() == 0) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570pushHostGroup"));
            return;
        }
        if (entry.getPushHostGroupName() == null || entry.getPushHostGroupName().length() == 0) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570pushHostGroupName"));
            return;
        }
        if (entry.getPushHSeq() == null || entry.getPushHSeq().length() == 0) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570pushHSeq"));
            return;
        }
        if (entry.getConnectId() == null || entry.getConnectId().length() == 0) {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11\u53c2\u6570connectId"));
            return;
        }
        LinkedList<MediaPushConnection> connectingList = null;
        DefaultCameraLivePusher defaultCameraLivePusher = this;
        synchronized (defaultCameraLivePusher) {
            MediaPushConnection connection;
            if (this.isClosed()) {
                resultSetFuture.setResult((Object)new ResultResponseMap("501", "connect is closed"));
                return;
            }
            if (!this.cameraNo.equals(entry.getCameraNo())) {
                resultSetFuture.setResult((Object)new ResultResponseMap("403", "cameraNo error"));
                return;
            }
            if (this.rtspConnection != null && this.rtspConnection.isStarted()) {
                this.allowCloseRtspMills = ServiceUtil.getServiceContext().currentTimeMillis() + 20000L;
                if (p2pDirConnGroupName.equals(entry.getPushHostGroupName())) {
                    int p2pDirCount = 0;
                    for (MediaPushConnection mediaPushConnection : this.mediaPushConnectionList) {
                        if (mediaPushConnection.isClosed()) {
                            this.mediaPushConnectionList.remove(mediaPushConnection);
                            continue;
                        }
                        if (mediaPushConnection.getConnectFuture() == null) {
                            mediaPushConnection.close();
                            continue;
                        }
                        if (!p2pDirConnGroupName.equals(entry.getPushHostGroupName())) continue;
                        ++p2pDirCount;
                    }
                    if (p2pDirCount >= 50) {
                        resultSetFuture.setResult((Object)new ResultResponseMap("MAX_P2P_CONN_LIMIT", "P2P\u8fde\u63a5\u89c6\u9891\u6570\u4e0a\u9650,\u8bf7\u4ece\u89c6\u9891\u670d\u52a1\u5668\u4e2d\u52a0\u8f7d\u89c6\u9891"));
                        return;
                    }
                } else {
                    for (MediaPushConnection connection3 : this.mediaPushConnectionList) {
                        if (connection3.isClosed()) {
                            this.mediaPushConnectionList.remove(connection3);
                            continue;
                        }
                        if (connection3.getConnectFuture() == null) {
                            connection3.close();
                            continue;
                        }
                        if (!entry.getPushHostAppName().equals(connection3.getPushHostAppName()) || !entry.getPushHostName().equals(connection3.getPushHostName())) continue;
                        if (!entry.getPushHSeq().equals(connection3.getPushHSeq()) || !entry.getPushHostGroupName().equals(connection3.getPushHostGroupName())) {
                            LogUtil.getLog().info((Object)("\u8fde\u63a5\u53d1\u751f\u66f4\u6539\uff1a\u8fd9\u5c06\u5173\u95ed\u8fde\u63a5: " + connection3.getPushHSeq()));
                            connection3.close();
                            continue;
                        }
                        if (connection3.isConnected()) {
                            if (connection3.getPushSessionId() != null && connection3.getPushSessionId().length() > 0) {
                                SocketAddress address;
                                ResultResponseMap responseMap = new ResultResponseMap("0", "SUCCESS");
                                responseMap.put((Object)"pushSessionId", (Object)connection3.getPushSessionId());
                                responseMap.put((Object)"pushHostGroup", (Object)connection3.getPushHostAppName());
                                responseMap.put((Object)"pushHostName", (Object)connection3.getPushHostName());
                                responseMap.put((Object)"pushHostAppName", (Object)connection3.getPushHostAppName());
                                responseMap.put((Object)"pushHostGroupName", (Object)connection3.getPushHostGroupName());
                                responseMap.put((Object)"tanTransportType", (Object)String.valueOf(connection3.getTanTransportType()));
                                String remoteSignKey = connection3.getRemoteSignKey();
                                if (remoteSignKey != null && remoteSignKey.length() > 0) {
                                    responseMap.put((Object)"pushHostKey", (Object)remoteSignKey);
                                }
                                if ((address = connection3.getRemoteAddress()) instanceof InetSocketAddress) {
                                    InetSocketAddress netAddress = (InetSocketAddress)address;
                                    responseMap.put((Object)"pushHostAddress", (Object)netAddress.getAddress().getHostAddress());
                                    responseMap.put((Object)"pushHostPort", (Object)String.valueOf(netAddress.getPort()));
                                }
                                resultSetFuture.setResult((Object)responseMap);
                                return;
                            }
                            if (connection3.getPushSessionIdFuture() != null) {
                                this.addRequestPushSessionIdResult(connection3, resultSetFuture);
                                return;
                            }
                        }
                        if (connectingList == null) {
                            connectingList = new LinkedList();
                        }
                        connectingList.add(connection3);
                    }
                    for (MediaPushConnection connection2 : this.mediaPushConnectionList) {
                        if (connection2.isClosed()) {
                            this.mediaPushConnectionList.remove(connection2);
                            continue;
                        }
                        if (connection2.getConnectFuture() == null) {
                            connection2.close();
                            continue;
                        }
                        if (entry.getPushHostAppName().equals(connection2.getPushHostAppName()) && entry.getPushHostName().equals(connection2.getPushHostName()) || !entry.getPushHostGroupName().equals(connection2.getPushHostGroupName())) continue;
                        if (connection2.isConnected()) {
                            if (connection2.getPushSessionId() != null && connection2.getPushSessionId().length() > 0) {
                                SocketAddress address;
                                ResultResponseMap responseMap = new ResultResponseMap("0", "SUCCESS");
                                responseMap.put((Object)"pushSessionId", (Object)connection2.getPushSessionId());
                                responseMap.put((Object)"pushHostGroup", (Object)connection2.getPushHostAppName());
                                responseMap.put((Object)"pushHostName", (Object)connection2.getPushHostName());
                                responseMap.put((Object)"pushHostAppName", (Object)connection2.getPushHostAppName());
                                responseMap.put((Object)"pushHostGroupName", (Object)connection2.getPushHostGroupName());
                                responseMap.put((Object)"tanTransportType", (Object)String.valueOf(connection2.getTanTransportType()));
                                String remoteSignKey = connection2.getRemoteSignKey();
                                if (remoteSignKey != null && remoteSignKey.length() > 0) {
                                    responseMap.put((Object)"pushHostKey", (Object)remoteSignKey);
                                }
                                if ((address = connection2.getRemoteAddress()) instanceof InetSocketAddress) {
                                    InetSocketAddress netAddress = (InetSocketAddress)address;
                                    responseMap.put((Object)"pushHostAddress", (Object)netAddress.getAddress().getHostAddress());
                                    responseMap.put((Object)"pushHostPort", (Object)String.valueOf(netAddress.getPort()));
                                }
                                resultSetFuture.setResult((Object)responseMap);
                                return;
                            }
                            if (connection2.getPushSessionIdFuture() != null) {
                                this.addRequestPushSessionIdResult(connection2, resultSetFuture);
                                return;
                            }
                        }
                        if (connectingList == null) {
                            connectingList = new LinkedList();
                        }
                        connectingList.add(connection2);
                    }
                }
            } else {
                for (MediaPushConnection connection4 : this.mediaPushConnectionList) {
                    connection4.close();
                }
                this.mediaPushConnectionList.clear();
                MediaProfile mediaProfile = entry.getCameraMediaProfile();
                if (mediaProfile == null || mediaProfile.getUri() == null || !mediaProfile.getUri().startsWith("rtsp://")) {
                    resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u83b7\u53d6rtsp\u64ad\u653e\u5217\u8868\u5931\u8d25\u6216\u4e0d\u652f\u6301\u7684\u5a92\u4f53\u64ad\u653e\u8def\u5f84"));
                    return;
                }
                LogUtil.getLog().info((Object)("\u51c6\u5907\u8fde\u63a5\u8bbe\u5907\u89c6\u9891: " + mediaProfile));
                this.allowCloseRtspMills = ServiceUtil.getServiceContext().currentTimeMillis() + 20000L;
                RtspConnection rtspConnection = new RtspConnection(this.nioSocketConnector, mediaProfile.getUri(), this, ServiceUtil.getServiceContext().getTimeoutObjectPool(), this.cameraNo, entry.getCameraUserName(), entry.getCameraUserPwd(), mediaProfile);
                rtspConnection.start();
                this.rtspConnection = rtspConnection;
            }
            if ((connection = this.newVideoPushConnection(entry)) == null) {
                resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u521b\u5efa\u4e0e\u89c6\u9891\u670d\u52a1\u8fde\u63a5\u5931\u8d25! \u8fde\u63a5\u7c7b\u578b: " + entry.getPushTransportType()));
                return;
            }
            connection.addCloseListener(this);
            this.mediaPushConnectionList.add(connection);
            OperationFuture<Boolean> operationFuture = connection.connect();
            if (connection.getConnectFuture() != operationFuture) {
                connection.close();
                resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u521b\u5efa\u4e0e\u89c6\u9891\u670d\u52a1\u8fde\u63a5\u5931\u8d25! \u8fde\u63a5\u7c7b\u578b: " + entry.getPushTransportType()));
                return;
            }
            if (connectingList == null) {
                connectingList = new LinkedList<MediaPushConnection>();
            }
            connectingList.add(connection);
        }
        if (connectingList != null && !connectingList.isEmpty()) {
            new WaitResultEntry(resultSetFuture, connectingList, this.rtspConnection, entry.getPushHostGroupName(), this).waitConnectSuccess();
        } else {
            resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u65e0\u6cd5\u8fde\u63a5\u6307\u5b9a\u89c6\u9891\u670d\u52a1\u5668"));
        }
    }

    protected void addRequestPushSessionIdResult(final MediaPushConnection connection, final OperationFutureHandler<ResultResponseMap> resultSetFuture) {
        connection.getPushSessionIdFuture().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<String>(){

            public void operationComplete(OperationFuture<String> future) {
                if (future.isCancelled()) {
                    if (!connection.isClosed()) {
                        connection.close();
                    }
                    resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u83b7\u53d6\u8fdc\u7a0b\u89c6\u9891\u670d\u52a1\u5668\u5730\u5740\u4efb\u52a1\u88ab\u53d6\u6d88"));
                } else if (future.getException() != null) {
                    if (!connection.isClosed()) {
                        connection.close();
                    }
                    resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u83b7\u53d6\u8fdc\u7a0b\u89c6\u9891\u670d\u52a1\u5668\u5730\u5740\u5f02\u5e38\uff01\u65e0\u6cd5\u83b7\u53d6pushSessionId\uff0c \u539f\u56e0: " + future.getException().getMessage()));
                } else if (future.getResult() == null || ((String)future.getResult()).length() == 0 || !((String)future.getResult()).equals(connection.getPushSessionId())) {
                    resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u83b7\u53d6\u8fdc\u7a0b\u89c6\u9891\u670d\u52a1\u5668\u5730\u5740\u5f02\u5e38\uff01pushSessionId is null"));
                } else {
                    SocketAddress address;
                    ResultResponseMap responseMap = new ResultResponseMap("0", "SUCCESS");
                    responseMap.put((Object)"pushSessionId", (Object)connection.getPushSessionId());
                    responseMap.put((Object)"pushHostGroup", (Object)connection.getPushHostAppName());
                    responseMap.put((Object)"pushHostName", (Object)connection.getPushHostName());
                    responseMap.put((Object)"pushHostAppName", (Object)connection.getPushHostAppName());
                    responseMap.put((Object)"pushHostGroupName", (Object)connection.getPushHostGroupName());
                    responseMap.put((Object)"tanTransportType", (Object)String.valueOf(connection.getTanTransportType()));
                    String remoteSignKey = connection.getRemoteSignKey();
                    if (remoteSignKey != null && remoteSignKey.length() > 0) {
                        responseMap.put((Object)"pushHostKey", (Object)remoteSignKey);
                    }
                    if ((address = connection.getRemoteAddress()) instanceof InetSocketAddress) {
                        InetSocketAddress netAddress = (InetSocketAddress)address;
                        responseMap.put((Object)"pushHostAddress", (Object)netAddress.getAddress().getHostAddress());
                        responseMap.put((Object)"pushHostPort", (Object)String.valueOf(netAddress.getPort()));
                    }
                    resultSetFuture.setResult((Object)responseMap);
                }
            }

            public void waitCompleteTimeout() {
                if (!connection.isClosed()) {
                    connection.close();
                }
                resultSetFuture.setResult((Object)new ResultResponseMap("501", "\u83b7\u53d6\u8fdc\u7a0b\u89c6\u9891\u670d\u52a1\u5668\u5730\u5740\u8d85\u65f6"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaPushConnection doRequestPushSessionId(String groupName) {
        if (groupName == null || groupName.length() == 0) {
            return null;
        }
        DefaultCameraLivePusher defaultCameraLivePusher = this;
        synchronized (defaultCameraLivePusher) {
            MediaPushConnection connected = null;
            for (MediaPushConnection conn : this.mediaPushConnectionList) {
                if (!groupName.equals(conn.getPushHostGroupName()) || conn.isClosed() || !conn.isConnected()) continue;
                if (conn.getPushSessionIdFuture() != null) {
                    for (MediaPushConnection c1 : this.mediaPushConnectionList) {
                        if (c1 == conn || !groupName.equals(c1.getPushHostGroupName()) || !c1.isConnected() || c1.getPushSessionIdFuture() == null) continue;
                        c1.close();
                    }
                    return conn;
                }
                if (connected != null) continue;
                connected = conn;
            }
            if (connected != null) {
                OperationFuture<String> op = connected.requestPushSessionId();
                if (op != connected.getPushSessionIdFuture()) {
                    connected.close();
                } else {
                    return connected;
                }
            }
        }
        return null;
    }

    @Override
    public void onHandleRtpData(int channelType, int dataType, byte[] data, int offset, int length) {
        boolean hasConnectedConn = false;
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onHandleRtpData(channelType, dataType, data, offset, length);
                if (hasConnectedConn || !connection.isConnected()) continue;
                hasConnectedConn = true;
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex1);
            }
        }
        if (hasConnectedConn) {
            this.allowCloseRtspMills = ServiceUtil.getServiceContext().currentTimeMillis() + 20000L;
        }
    }

    protected MediaPushConnection newVideoPushConnection(CameraLivePushEntry entry) {
        if (entry.getPushTransportType() == 1) {
            return new TcpMediaPushConnection(entry, this.nioSocketConnector);
        }
        return new P2pUdpMediaPushConnection(entry);
    }

    @Override
    public void onException(int opType, Throwable ex) {
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onException(opType, ex);
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex);
            }
        }
    }

    @Override
    public void onConnect() {
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onConnect();
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex1);
            }
        }
    }

    @Override
    public void onDisconnect() {
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onDisconnect();
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex1);
            }
        }
    }

    @Override
    public void onSdp(String sdp) {
        this.latestSdp = sdp;
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onSdp(sdp);
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex1);
            }
        }
    }

    @Override
    public void onReadyPlay() {
        for (MediaPushConnection connection : this.mediaPushConnectionList) {
            try {
                connection.onReadyPlay();
            }
            catch (Throwable ex1) {
                LogUtil.getLog().warn((Object)ex1.getMessage(), ex1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        var1_1 = this;
        synchronized (var1_1) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.rtspConnection != null) {
                    try {
                        this.rtspConnection.stop();
                    }
                    catch (Exception var2_2) {
                        // empty catch block
                    }
                    this.rtspConnection = null;
                }
            }
            finally {
                var5_5 = this.mediaPushConnectionList.iterator();
                if (true) ** GOTO lbl32
            }
            {
            }
            do {
                connection = var5_5.next();
                try {
                    if (connection.isClosed()) continue;
                    connection.close();
                }
                catch (Exception var6_9) {
                    // empty catch block
                }
lbl32:
                // 4 sources

            } while (var5_5.hasNext());
            this.mediaPushConnectionList.clear();
        }
    }

    @Override
    public void onClose(MediaPushConnection connection) {
        this.mediaPushConnectionList.remove(connection);
    }

    @Override
    public RtspConnection getRtspConnection() {
        return this.rtspConnection;
    }

    private static class WaitResultEntry
    implements OperationFuture.CompleteListener<Boolean> {
        private OperationFutureHandler<ResultResponseMap> resultSetFuture;
        private List<MediaPushConnection> connectingList;
        private RtspConnection rtspConnection;
        private volatile int count;
        private String groupName;
        private DefaultCameraLivePusher defaultCameraLivePusher;
        private volatile boolean finish = false;

        private WaitResultEntry(OperationFutureHandler<ResultResponseMap> resultSetFuture, List<MediaPushConnection> connectingList, RtspConnection rtspConnection, String groupName, DefaultCameraLivePusher defaultCameraLivePusher) {
            this.resultSetFuture = resultSetFuture;
            this.connectingList = connectingList;
            this.rtspConnection = rtspConnection;
            this.groupName = groupName;
            this.count = connectingList.size();
            this.defaultCameraLivePusher = defaultCameraLivePusher;
        }

        /*
         * Unable to fully structure code
         */
        private void finishCameraConnError(List<MediaPushConnection> list) {
            try {
                if (!this.resultSetFuture.isDone()) {
                    this.resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u8fde\u63a5\u76f8\u673a\u5931\u8d25"));
                }
            }
            finally {
                var4_4 = list.iterator();
                if (true) ** GOTO lbl15
            }
            {
            }
            do {
                if ((c = var4_4.next()).isClosed()) continue;
                c.close();
lbl15:
                // 3 sources

            } while (var4_4.hasNext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFishConnect() {
            WaitResultEntry waitResultEntry;
            if (this.rtspConnection == null || !this.rtspConnection.isStarted()) {
                LinkedList<MediaPushConnection> list;
                waitResultEntry = this;
                synchronized (waitResultEntry) {
                    if (this.connectingList.isEmpty()) {
                        return;
                    }
                    this.finish = true;
                    list = new LinkedList<MediaPushConnection>();
                    list.addAll(this.connectingList);
                    this.connectingList.clear();
                }
                this.finishCameraConnError(list);
            }
            if (this.finish) {
                return;
            }
            MediaPushConnection connection = null;
            if (DefaultCameraLivePusher.p2pDirConnGroupName.equals(this.groupName)) {
                MediaPushConnection connected = null;
                for (MediaPushConnection conn : this.connectingList) {
                    if (conn.isClosed() || !conn.isConnected()) continue;
                    if (conn.getPushSessionIdFuture() != null) {
                        connection = conn;
                        break;
                    }
                    if (connected != null) continue;
                    connected = conn;
                }
                if (connected != null) {
                    OperationFuture<String> op = connected.requestPushSessionId();
                    if (op != connected.getPushSessionIdFuture()) {
                        connected.close();
                    } else {
                        connection = connected;
                    }
                }
            } else {
                connection = this.defaultCameraLivePusher.doRequestPushSessionId(this.groupName);
            }
            waitResultEntry = this;
            synchronized (waitResultEntry) {
                --this.count;
                if (this.finish) {
                    return;
                }
                if (connection != null || this.count <= 0) {
                    this.finish = true;
                }
            }
            if (this.finish) {
                if (connection != null) {
                    this.defaultCameraLivePusher.addRequestPushSessionIdResult(connection, this.resultSetFuture);
                } else {
                    this.resultSetFuture.setResult((Object)new ResultResponseMap("403", "\u65e0\u6cd5\u8fde\u63a5\u6307\u5b9a\u89c6\u9891\u670d\u52a1\u5668"));
                }
            }
        }

        private void waitConnectSuccess() {
            LinkedList<MediaPushConnection> list = new LinkedList<MediaPushConnection>();
            list.addAll(this.connectingList);
            for (MediaPushConnection connection : list) {
                connection.getConnectFuture().addCompleteListener((OperationFuture.CompleteListener)this);
            }
        }

        public void operationComplete(OperationFuture<Boolean> future) {
            this.doFishConnect();
        }

        public void waitCompleteTimeout() {
        }
    }
}

