/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.MediaProfile;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfile;
import com.wovoe.carpark.equipment.onvif.RtspUriTool;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.CameraLivePusher;
import com.wovoe.carpark.p2p.media.rtsp.RtspConnection;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.ActionMapping;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pTransferTool;
import com.wovoe.framework.p2p.action.SyncRunAction;
import com.wovoe.framework.transfer.ResultResponseMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;

@ActionMapping(value={"/p2pCameraLiveDataAction"})
public class P2pCameraLiveDataAction
implements SyncRunAction {
    private static final String OP_connectCamera = "connectCamera";

    public void service(Receiver request) throws Exception {
        P2pConnSession session = P2pTransferTool.getP2pConnSession((Receiver)request);
        if (session == null) {
            return;
        }
        if (!P2pTransferTool.checkSign((Receiver)request, (String)session.getRemoteSignKey())) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"SIGN_ERROR", (String)"\u7b7e\u540d\u9519\u8bef", (String)session.getLocalSignKey());
            return;
        }
        String op = request.getHeaderValue("op");
        if (op == null) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"\u7f3a\u5c11\u53c2\u6570OP", (String)session.getLocalSignKey());
            return;
        }
        if (!OP_connectCamera.equals(op)) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_METHOD_NOTFOUND", (String)"\u64cd\u4f5c\u4e0d\u652f\u6301", (String)session.getLocalSignKey());
            return;
        }
        this.connectCamera(request, session);
    }

    private void connectCamera(final Receiver request, final P2pConnSession session) throws Exception {
        MediaProfile mediaProfie;
        RtspConnection connection;
        ChannelEquipmentVo camera;
        final String cameraNo = request.getHeaderValue("cameraNo");
        final String connectId = request.getHeaderValue("connectId");
        String hseq = request.getHeaderValue("hseq");
        if (hseq == null || hseq.length() == 0) {
            hseq = "0";
        }
        final String hseq0 = hseq;
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(cameraNo);
        if (eq != null) {
            if (eq.getType() != 33) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"\u76f8\u673a\u7f16\u53f7\u9519\u8bef\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u662f\u76f8\u673a", (String)session.getLocalSignKey());
                return;
            }
            if (!eq.getEquipmentAction().isWorkingProperly()) {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"\u65e0\u6cd5\u8fde\u63a5\u76f8\u673a\uff0c\u76f8\u673a\u5de5\u4f5c\u4e0d\u6b63\u5e38", (String)session.getLocalSignKey());
                return;
            }
        }
        if ((camera = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVo(cameraNo)) == null) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"\u76f8\u673a\u7f16\u53f7\u9519\u8bef", (String)session.getLocalSignKey());
            return;
        }
        if (camera.getEquipment_type() == null || camera.getEquipment_type() != 33) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"PARAM_ERROR", (String)"\u76f8\u673a\u7f16\u53f7\u9519\u8bef\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u662f\u76f8\u673a", (String)session.getLocalSignKey());
            return;
        }
        if (camera.getOnvifPort() == null) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"\u76f8\u673a\u672a\u914d\u7f6e Onvif \u7aef\u53e3", (String)session.getLocalSignKey());
            return;
        }
        if (camera.getEquipment_ip() == null || camera.getEquipment_ip().length() == 0) {
            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"\u76f8\u673a\u672a\u914d\u7f6eIP", (String)session.getLocalSignKey());
            return;
        }
        boolean streamType = false;
        boolean pushType = false;
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        handler.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<ResultResponseMap>(){

            public void operationComplete(OperationFuture<ResultResponseMap> future) {
                if (future.isCancelled()) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"cancelled", (String)session.getLocalSignKey());
                } else if (future.getException() != null) {
                    P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)future.getException().getMessage(), (String)session.getLocalSignKey());
                } else {
                    ResultResponseMap responseMap = (ResultResponseMap)future.getResult();
                    if (responseMap != null) {
                        if (responseMap.isSuccess()) {
                            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"SUCCESS", (String)"SUCCESS", (String)session.getLocalSignKey());
                        } else {
                            P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)responseMap.getResponseMsg(), (String)session.getLocalSignKey());
                        }
                    } else {
                        P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"null response", (String)session.getLocalSignKey());
                    }
                }
            }

            public void waitCompleteTimeout() {
                P2pTransferTool.doSimpleResponse((Receiver)request, (String)"RESP_CODE_SERVICE_ERROR", (String)"timeout", (String)session.getLocalSignKey());
            }
        });
        CameraLivePusher livePusher = ServiceUtil.getServiceContext().getCameraLivePushManager().getCameraLivePusher(cameraNo);
        if (livePusher != null && (connection = livePusher.getRtspConnection()) != null && (connection.isConnected() || connection.isStarted()) && (mediaProfie = connection.getMediaProfile()) != null && mediaProfie.getUri() != null && mediaProfie.getUri().length() > 0) {
            CameraLivePushEntry pushEntry = new CameraLivePushEntry(session.getRemotePeerId(), session.getRemotePeerName(), null, session.getLocalSignKey(), connectId, 0, 0, "p2pDirConn", hseq0, cameraNo, camera.getOnvifUserName(), camera.getOnvifUserPwd(), mediaProfie);
            pushEntry.setP2pConnSession(session);
            ServiceUtil.getServiceContext().getCameraLivePushManager().doPush(pushEntry, (OperationFutureHandler<ResultResponseMap>)handler);
            return;
        }
        OperationFuture<List<OnvifMediaProfile>> operationFuture = RtspUriTool.getOnvifMediaProfileListUseShortCache(camera.getEquipment_ip(), camera.getOnvifPort(), camera.getOnvifUserName(), camera.getOnvifUserPwd());
        operationFuture.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<List<OnvifMediaProfile>>(){

            public void operationComplete(OperationFuture<List<OnvifMediaProfile>> future) {
                if (future.getException() != null) {
                    ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u83b7\u53d6\u76f8\u673a\uff1a" + camera.getEquipment_ip() + " rtsp \u64ad\u653e\u8def\u5f84\uff01" + future.getException()));
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25,\u7f51\u7edc\u5f02\u5e38"));
                } else if (future.isCancelled()) {
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u64cd\u4f5c\u88ab\u53d6\u6d88"));
                } else if (future.getResult() == null) {
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                } else {
                    ArrayList<MediaProfile> mediaProfileList = null;
                    List list = (List)future.getResult();
                    if (list != null && !list.isEmpty()) {
                        ArrayList<MediaProfile> profiles = new ArrayList<MediaProfile>(list.size());
                        for (OnvifMediaProfile ov : list) {
                            if (ov.getUri() == null || ov.getUri().length() <= 0) continue;
                            MediaProfile profile = new MediaProfile();
                            JavaBeanTool.copyTo((Object)ov, (Object)profile);
                            if (ov.getVideo_Encoding() != null && ov.getVideo_Encoding().length() > 0) {
                                profile.setVideo_Encoding(ov.getVideo_Encoding().toUpperCase(Locale.US));
                            } else {
                                profile.setVideo_Encoding("");
                            }
                            if (ov.getVideo_Width() != null && ov.getVideo_Width().length() > 0) {
                                try {
                                    profile.setWidth((int)Double.parseDouble(ov.getVideo_Width()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (ov.getVideo_Height() != null && ov.getVideo_Height().length() > 0) {
                                try {
                                    profile.setHeight((int)Double.parseDouble(ov.getVideo_Height()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (profile.getWidth() <= 0) {
                                profile.setWidth(1);
                            }
                            if (profile.getHeight() <= 0) {
                                profile.setHeight(1);
                            }
                            profiles.add(profile);
                        }
                        if (!profiles.isEmpty()) {
                            mediaProfileList = profiles;
                        }
                    }
                    if (mediaProfileList == null || mediaProfileList.isEmpty()) {
                        handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                    } else {
                        MediaProfile mediaProfile = this.getInternetMediaProfile((List<MediaProfile>)mediaProfileList);
                        if (mediaProfile == null) {
                            handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                        } else {
                            CameraLivePushEntry pushEntry = new CameraLivePushEntry(session.getRemotePeerId(), session.getRemotePeerName(), null, session.getLocalSignKey(), connectId, 0, 0, "p2pDirConn", hseq0, cameraNo, camera.getOnvifUserName(), camera.getOnvifUserPwd(), mediaProfile);
                            pushEntry.setP2pConnSession(session);
                            ServiceUtil.getServiceContext().getCameraLivePushManager().doPush(pushEntry, (OperationFutureHandler<ResultResponseMap>)handler);
                            return;
                        }
                    }
                }
            }

            public void waitCompleteTimeout() {
                handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u8d85\u65f6"));
            }

            public MediaProfile getInternetMediaProfile(List<MediaProfile> mediaProfiles) {
                if (mediaProfiles == null || mediaProfiles.isEmpty()) {
                    return null;
                }
                if (mediaProfiles.size() == 1) {
                    return mediaProfiles.get(0);
                }
                final boolean isMainStream = !"sub_stream".equals(camera.getInternetMediaStreamType());
                PriorityQueue<MediaProfile> profiles = new PriorityQueue<MediaProfile>(mediaProfiles.size(), new Comparator<MediaProfile>(){
                    private String rtsp = "rtsp://";
                    private String H264 = "H264";
                    private String H265 = "H265";

                    private int getEncodingOrder(String encoding) {
                        if (encoding == null || encoding.length() == 0) {
                            return 100;
                        }
                        if (this.H264.equalsIgnoreCase(encoding)) {
                            return 1;
                        }
                        if (this.H265.equalsIgnoreCase(encoding)) {
                            return 2;
                        }
                        return 99;
                    }

                    @Override
                    public int compare(MediaProfile o1, MediaProfile o2) {
                        int f2;
                        if (o1.getUri().startsWith(this.rtsp) && !o2.getUri().startsWith(this.rtsp)) {
                            return -1;
                        }
                        if (!o1.getUri().startsWith(this.rtsp) && o2.getUri().startsWith(this.rtsp)) {
                            return 1;
                        }
                        int a1 = Integer.compare(this.getEncodingOrder(o1.getVideo_Encoding()), this.getEncodingOrder(o2.getVideo_Encoding()));
                        if (a1 != 0) {
                            return a1;
                        }
                        int f1 = o1.getWidth() * o1.getHeight();
                        a1 = Integer.compare(f1, f2 = o2.getWidth() * o2.getHeight());
                        if (a1 != 0) {
                            if (isMainStream) {
                                return 0 - a1;
                            }
                            return a1;
                        }
                        int sub1 = o1.getUri().toLowerCase(Locale.US).indexOf("sub");
                        int sub2 = o2.getUri().toLowerCase(Locale.US).indexOf("sub");
                        if (sub1 != -1 && sub2 == -1) {
                            if (isMainStream) {
                                return 1;
                            }
                            return -1;
                        }
                        if (sub1 == -1 && sub2 != -1) {
                            if (isMainStream) {
                                return -1;
                            }
                            return 1;
                        }
                        return 0;
                    }
                });
                for (MediaProfile f : mediaProfiles) {
                    profiles.offer(f);
                }
                return profiles.poll();
            }
        }, 7L, TimeUnit.SECONDS);
    }
}

