/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.P2pPeerConnector;
import com.wovoe.carpark.p2p.media.BasicMediaPushConnection;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.LiveDataFrame;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.Sender;
import com.wovoe.framework.p2p.P2pAcceptUseKey;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pConnSessionCloseListener;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pSessionId;
import com.wovoe.framework.p2p.P2pTransferTool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class P2pUdpMediaPushConnection
extends BasicMediaPushConnection {
    private volatile P2pConnSession p2pConnSession;
    private volatile String pushSessionId;
    private Object requestPushSessionIdObj;
    private volatile long lastRevMills;
    private static final long timeoutMills = 10000L;

    protected P2pUdpMediaPushConnection(CameraLivePushEntry entry) {
        super(entry);
    }

    @Override
    protected void doConnect() {
        if (this.cameraLivePushEntry == null || this.cameraLivePushEntry.getPushHostAppName() == null || this.cameraLivePushEntry.getPushHostAppName().length() == 0 || this.cameraLivePushEntry.getPushHostName() == null || this.cameraLivePushEntry.getPushHostName().length() == 0) {
            try {
                this.connectHandler.setException((Throwable)new NullPointerException("\u7f3a\u5c11\u8fde\u63a5\u53c2\u6570"));
            }
            finally {
                this.close();
            }
            return;
        }
        if (this.cameraLivePushEntry.getP2pConnSession() != null) {
            if (this.cameraLivePushEntry.getP2pConnSession().isClosed()) {
                this.close();
            } else {
                this.setP2pConnSession(this.cameraLivePushEntry.getP2pConnSession());
                this.connectHandler.setResult((Object)(this.p2pConnSession != null ? 1 : 0));
            }
            return;
        }
        try {
            OperationFuture<P2pConnSession> operationFuture = P2pPeerConnector.connect(this.cameraLivePushEntry.getPushHostName(), this.cameraLivePushEntry.getPushHostAppName());
            operationFuture.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<P2pConnSession>(){

                private void doOperationComplete0(OperationFuture<P2pConnSession> future) {
                    if (future.isCancelled()) {
                        try {
                            P2pUdpMediaPushConnection.this.connectHandler.cancel(true);
                        }
                        finally {
                            P2pUdpMediaPushConnection.this.close();
                        }
                    } else if (future.getException() != null) {
                        try {
                            P2pUdpMediaPushConnection.this.connectHandler.setException(future.getException());
                        }
                        finally {
                            P2pUdpMediaPushConnection.this.close();
                        }
                    } else if (future.getResult() == null) {
                        try {
                            P2pUdpMediaPushConnection.this.connectHandler.setException((Throwable)new IOException("connect error!"));
                        }
                        finally {
                            P2pUdpMediaPushConnection.this.close();
                        }
                    } else {
                        P2pUdpMediaPushConnection.this.setP2pConnSession((P2pConnSession)future.getResult());
                        P2pUdpMediaPushConnection.this.connectHandler.setResult((Object)(P2pUdpMediaPushConnection.this.p2pConnSession != null ? 1 : 0));
                    }
                }

                public void operationComplete(final OperationFuture<P2pConnSession> future) {
                    if (ServiceUtil.getServiceContext().currentRunThreadIsWorkThread()) {
                        this.doOperationComplete0(future);
                    } else {
                        try {
                            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                                @Override
                                public void run() {
                                    this.doOperationComplete0((OperationFuture<P2pConnSession>)future);
                                }
                            });
                        }
                        catch (Exception ex) {
                            this.doOperationComplete0(future);
                        }
                    }
                }

                public void waitCompleteTimeout() {
                }
            }, 12000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            this.close();
        }
    }

    private void setP2pSessionId(String pushSessionId) {
        P2pConnSession session;
        this.pushSessionId = pushSessionId;
        Object obj = this.requestPushSessionIdObj;
        if (obj != null) {
            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject(obj);
        }
        if ((session = this.p2pConnSession) != null && session.getClientType() == 1) {
            P2pSessionId sessionKey = new P2pSessionId((InetSocketAddress)session.getRemoteAddress(), session.getSessionId(), ((InetSocketAddress)session.getLocalAddress()).getPort());
            P2pAcceptUseKey userKey = new P2pAcceptUseKey(sessionKey);
            Object obj1 = P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)userKey);
            if (obj1 == null) {
                LogUtil.getLog().warn((Object)"\u4e0d\u61c9\u8a72\u51fa\u73fe\u7684\u60c5\u6cc1\uff01\u8acb\u6aa2\u67e5\uff0c");
            }
        }
        this.pushSessionIdFutureHandler.setResult((Object)pushSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setP2pConnSession(P2pConnSession session) {
        if (session == null) {
            return;
        }
        P2pUdpMediaPushConnection p2pUdpMediaPushConnection = this;
        synchronized (p2pUdpMediaPushConnection) {
            if (this.isClosed()) {
                session.close();
                return;
            }
            this.p2pConnSession = session;
            if (this.requestPushSessionIdObj == null) {
                this.requestPushSessionIdObj = new Object();
            }
        }
        this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
        P2pContextUtil.getContext().getTimeoutObjectPool().addObject(this.requestPushSessionIdObj, this.requestPushSessionIdObj, new TimeoutObjectPool.TimeoutCallback(){

            public void onTimeout(Object key, Object value) throws Exception {
                if (!P2pUdpMediaPushConnection.this.isClosed()) {
                    P2pUdpMediaPushConnection.this.close();
                }
            }
        }, 15000L, TimeUnit.MILLISECONDS);
        this.p2pConnSession.addP2pConnSessionCloseListener(new P2pConnSessionCloseListener(){

            public void onClose(P2pConnSession session, int reason) {
                if (P2pUdpMediaPushConnection.this.isClosed()) {
                    return;
                }
                if (ServiceUtil.getServiceContext().currentRunThreadIsWorkThread()) {
                    P2pUdpMediaPushConnection.this.close();
                } else {
                    try {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                if (!P2pUdpMediaPushConnection.this.isClosed()) {
                                    P2pUdpMediaPushConnection.this.close();
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        P2pUdpMediaPushConnection.this.close();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        Object obj = null;
        if (this.p2pConnSession == null) {
            P2pUdpMediaPushConnection p2pUdpMediaPushConnection = this;
            synchronized (p2pUdpMediaPushConnection) {
                if (this.p2pConnSession == null) {
                    return;
                }
                if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
                    obj = this.requestPushSessionIdObj;
                }
            }
        }
        this.disconnect();
        if (obj != null) {
            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject(obj);
        }
    }

    @Override
    protected void disconnect() {
        if (this.p2pConnSession != null && !this.p2pConnSession.isClosed()) {
            this.p2pConnSession.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.p2pConnSession == null ? false : this.p2pConnSession.isConnected();
    }

    @Override
    public String getPushSessionId() {
        return this.pushSessionId;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.p2pConnSession == null ? null : this.p2pConnSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.p2pConnSession == null ? null : this.p2pConnSession.getLocalAddress();
    }

    @Override
    protected void doRequestPushSessionId() {
        try {
            RequestSender sender = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createUdpRequestSender(this.p2pConnSession);
            sender.setRequestActionName("/p2pLivePusher");
            sender.setHeader("op", "obtainPushSessionId");
            sender.setHeader("pushHostName", this.cameraLivePushEntry.getPushHostName());
            sender.setHeader("pushHostGroup", this.cameraLivePushEntry.getPushHostAppName());
            sender.setHeader("connectId", this.cameraLivePushEntry.getConnectId());
            sender.setHeader("pushHostAppName", this.cameraLivePushEntry.getPushHostAppName());
            sender.setHeader("pushHostGroupName", this.cameraLivePushEntry.getPushHostGroupName());
            sender.setHeader("e", String.valueOf(System.currentTimeMillis()));
            P2pTransferTool.setSign((Sender)sender, (String)this.p2pConnSession.getLocalSignKey());
            sender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    try {
                        P2pUdpMediaPushConnection.this.pushSessionIdFutureHandler.setException(exception);
                    }
                    finally {
                        P2pUdpMediaPushConnection.this.close();
                    }
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    if (!"SUCCESS".equals(receiver.getHeaderValue("c"))) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01" + receiver.getHeaderValue("c") + ": " + receiver.getHeaderValue("m")));
                        return;
                    }
                    if (!P2pTransferTool.checkSign((Receiver)receiver, (P2pConnSession)P2pUdpMediaPushConnection.this.p2pConnSession)) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff01"));
                        return;
                    }
                    String pushSessionId = receiver.getHeaderValue("pushSessionId");
                    if (pushSessionId == null || pushSessionId.length() == 0) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01\u8fd4\u56de\u7a7a\u6570\u636e"));
                        return;
                    }
                    P2pUdpMediaPushConnection.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    P2pUdpMediaPushConnection.this.setP2pSessionId(pushSessionId);
                }

                private void onError(Throwable ex) {
                    try {
                        try {
                            LogUtil.getLog().warn((Object)(String.valueOf(P2pUdpMediaPushConnection.this.p2pConnSession.getRemotePeerName()) + ":" + P2pUdpMediaPushConnection.this.p2pConnSession.getRemotePeerId() + ", " + P2pUdpMediaPushConnection.this.p2pConnSession.getRemoteAddress() + "\uff0c\u83b7\u53d6PushSessionId\u5931\u8d25\uff01 \u539f\u56e0:" + ex.getMessage()));
                        }
                        finally {
                            P2pUdpMediaPushConnection.this.pushSessionIdFutureHandler.setException(ex);
                        }
                    }
                    finally {
                        P2pUdpMediaPushConnection.this.close();
                    }
                }

                public void onWaitTimeout() throws Exception {
                    this.onError(new IOException("\u83b7\u53d6pushSessionId\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return 8000L;
                }
            });
        }
        catch (Throwable ex) {
            try {
                try {
                    LogUtil.getLog().warn((Object)("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01" + this.p2pConnSession.getRemotePeerName() + ":" + this.p2pConnSession.getRemotePeerId() + ", " + ex.getMessage()));
                }
                catch (Throwable throwable) {
                    this.pushSessionIdFutureHandler.setException(ex);
                    throw throwable;
                }
                this.pushSessionIdFutureHandler.setException(ex);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    protected void doSend(LiveDataFrame frame, final SendCallback sendCallback) {
        block10: {
            if (this.p2pConnSession == null) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("not connected yet!"));
                }
                return;
            }
            if (this.p2pConnSession.isClosed()) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("Connection has been closed!"));
                }
                return;
            }
            if (this.pushSessionId == null || this.pushSessionId.length() == 0) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("not request pushSessionId yet!"));
                }
                return;
            }
            if (ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills > 10000L) {
                LogUtil.getLog().error((Object)("\u4e0e\u8fde\u63a5" + this.getRemoteAddress() + "\u53ef\u80fd\u65ad\u5f00, " + 10000L + "\u6beb\u79d2\u6ca1\u6709\u6536\u5230\u4efb\u4f55\u54cd\u5e94\u6570\u636e"));
                this.close();
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("Connection has been closed!"));
                }
                return;
            }
            try {
                RequestSender sender = P2pContextUtil.getContext().getP2PUDPConnectionFactory().createUdpRequestSender(this.p2pConnSession);
                sender.setRequestActionName("/p2pLivePusher");
                sender.setHeader("op", "dv");
                sender.setHeader("ps", this.pushSessionId);
                sender.setHeader("ft", String.valueOf(frame.getFrameType()));
                sender.setHeader("dt", String.valueOf(frame.getDataType()));
                sender.setHeader("fi", String.valueOf(frame.getFrameIndex()));
                sender.setSendData(frame.getData(), frame.getDataOffset(), frame.getDataLength());
                sender.setAttribute("send.wait.ack.timeout", (Object)1000L);
                sender.setAttribute("send.attempt.times", (Object)2);
                sender.setAttribute("IGNORE_LAST_SEND_WAIT_ACK_TIMEOUT_FLG", (Object)Boolean.TRUE);
                sender.doRequest(new SendCallback(){

                    public void onException(Throwable exception) {
                        this.onCompleted();
                    }

                    public void onCompleted() {
                        sendCallback.onCompleted();
                    }
                }, new ReceiveCallback(){

                    public void doReceiver(Receiver receiver, int sendId) throws Exception {
                        if ("SUCCESS".equals(receiver.getHeaderValue("c"))) {
                            P2pUdpMediaPushConnection.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        } else {
                            LogUtil.getLog().error((Object)("\u53d1\u9001\u89c6\u9891\u6d41\u6570\u636e\u7ed9 " + P2pUdpMediaPushConnection.this.getRemoteAddress() + "\u5931\u8d25\uff01\u8fd4\u56de\u5931\u8d25\uff1a" + receiver.getHeaderValue("c") + ": " + receiver.getHeaderValue("m")));
                            P2pUdpMediaPushConnection.this.close();
                        }
                    }

                    public void onWaitTimeout() throws Exception {
                    }

                    public long getWaitTimeoutMills() {
                        return 10000L;
                    }
                });
            }
            catch (Exception ex) {
                if (sendCallback == null) break block10;
                sendCallback.onException((Throwable)new IOException("\u53d1\u9001\u5b9e\u65f6\u5a92\u4f53\u6d41\u5931\u8d25\uff01" + ex.getMessage()));
            }
        }
    }

    @Override
    public String getSessionId() {
        P2pConnSession p2pConnSession0 = this.p2pConnSession;
        if (p2pConnSession0 != null) {
            return p2pConnSession0.getSessionId();
        }
        return null;
    }

    @Override
    public int getTanTransportType() {
        return 0;
    }
}

