/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.BasicMediaPushConnection;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.LiveDataFrame;
import com.wovoe.carpark.p2p.media.MediaPusherCryptoFactory;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.PlainCryptoFactory;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.Sender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.ServiceActionGetter;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import com.wovoe.framework.communication.tcp.ParseDataResult;
import com.wovoe.framework.communication.tcp.TcpFrameProtocolHandler;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pMinaSender;
import com.wovoe.framework.p2p.P2pTcpActionProtocolHandler;
import com.wovoe.framework.p2p.P2pTransferTool;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class TcpMediaPushConnection
extends BasicMediaPushConnection
implements IoHandler,
ServiceActionGetter,
HMPResponseSenderFactory {
    private static final String P2pTcpSessionCloseAction = "/P2pTcpSessionCloseAction";
    private static final String OP_sessionClose = "sessionClose";
    private IoSession ioSession;
    private volatile String pushSessionId;
    private Object requestPushSessionIdObj;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private String sessionId;
    private P2pTcpActionProtocolHandler actionProtocolHandler;
    private TcpFrameProtocolHandler frameProtocolHandler;
    NioSocketConnector connector;
    private volatile long lastRevMills;
    private static final long timeoutMills = 10000L;

    protected TcpMediaPushConnection(CameraLivePushEntry entry, NioSocketConnector connector) {
        super(entry);
        this.connector = connector;
    }

    @Override
    protected void doSend(LiveDataFrame frame, final SendCallback sendCallback) {
        block10: {
            if (this.ioSession == null) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("not connected yet!"));
                }
                return;
            }
            if (!this.ioSession.isConnected()) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("Connection has been closed!"));
                }
                return;
            }
            if (this.pushSessionId == null || this.pushSessionId.length() == 0) {
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("not request pushSessionId yet!"));
                }
                return;
            }
            if (ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills > 10000L) {
                LogUtil.getLog().error((Object)("\u4e0e\u8fde\u63a5" + this.getRemoteAddress() + "\u53ef\u80fd\u65ad\u5f00, " + 10000L + "\u6beb\u79d2\u6ca1\u6709\u6536\u5230\u4efb\u4f55\u54cd\u5e94\u6570\u636e"));
                this.close();
                if (sendCallback != null) {
                    sendCallback.onException((Throwable)new IOException("Connection has been closed!"));
                }
                return;
            }
            try {
                RequestSender sender = this.newRequestSender();
                sender.setRequestActionName("/p2pLivePusher");
                sender.setHeader("op", "dv");
                sender.setHeader("ps", this.pushSessionId);
                sender.setHeader("ft", String.valueOf(frame.getFrameType()));
                sender.setHeader("dt", String.valueOf(frame.getDataType()));
                sender.setHeader("fi", String.valueOf(frame.getFrameIndex()));
                sender.setSendData(frame.getData(), frame.getDataOffset(), frame.getDataLength());
                sender.doRequest(new SendCallback(){

                    public void onException(Throwable exception) {
                        LogUtil.getLog().error((Object)("\u53d1\u9001\u89c6\u9891\u6d41\u6570\u636e\u7ed9 " + TcpMediaPushConnection.this.getRemoteAddress() + "\u5931\u8d25\uff01" + exception));
                        TcpMediaPushConnection.this.close();
                        if (sendCallback != null) {
                            sendCallback.onException(exception);
                        }
                    }

                    public void onCompleted() {
                        if (sendCallback != null) {
                            sendCallback.onCompleted();
                        }
                    }
                }, new ReceiveCallback(){

                    public void doReceiver(Receiver receiver, int sendId) throws Exception {
                        if ("SUCCESS".equals(receiver.getHeaderValue("c"))) {
                            TcpMediaPushConnection.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        } else {
                            LogUtil.getLog().error((Object)("\u53d1\u9001\u89c6\u9891\u6d41\u6570\u636e\u7ed9 " + TcpMediaPushConnection.this.getRemoteAddress() + "\u5931\u8d25\uff01\u8fd4\u56de\u5931\u8d25\uff1a" + receiver.getHeaderValue("c") + ": " + receiver.getHeaderValue("m")));
                            TcpMediaPushConnection.this.close();
                        }
                    }

                    public void onWaitTimeout() throws Exception {
                    }

                    public long getWaitTimeoutMills() {
                        return 10000L;
                    }
                });
            }
            catch (Exception ex) {
                if (sendCallback == null) break block10;
                sendCallback.onException((Throwable)new IOException("\u53d1\u9001\u5b9e\u65f6\u5a92\u4f53\u6d41\u5931\u8d25\uff01" + ex.getMessage()));
            }
        }
    }

    @Override
    protected void doRequestPushSessionId() {
        try {
            RequestSender sender = this.newRequestSender();
            sender.setRequestActionName("/p2pLivePusher");
            sender.setHeader("op", "obtainPushSessionId");
            sender.setHeader("pushHostName", this.cameraLivePushEntry.getPushHostName());
            sender.setHeader("pushHostGroup", this.cameraLivePushEntry.getPushHostAppName());
            sender.setHeader("connectId", this.cameraLivePushEntry.getConnectId());
            sender.setHeader("pushHostAppName", this.cameraLivePushEntry.getPushHostAppName());
            sender.setHeader("pushHostGroupName", this.cameraLivePushEntry.getPushHostGroupName());
            sender.setHeader("e", String.valueOf(System.currentTimeMillis()));
            P2pTransferTool.setSign((Sender)sender, (String)this.cameraLivePushEntry.getSignKey());
            sender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    try {
                        if (ServiceUtil.getServiceContext().isDevEnvironment()) {
                            LogUtil.getLog().info((Object)("------> doRequestPushSessionIdr send error: " + TcpMediaPushConnection.this.cameraLivePushEntry.getAddress() + ": " + exception));
                        }
                        TcpMediaPushConnection.this.pushSessionIdFutureHandler.setException(exception);
                    }
                    finally {
                        TcpMediaPushConnection.this.close();
                    }
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    if (ServiceUtil.getServiceContext().isDevEnvironment()) {
                        LogUtil.getLog().info((Object)("------> doRequestPushSessionIdr: " + TcpMediaPushConnection.this.cameraLivePushEntry.getAddress() + ": " + receiver.getHeaderValue("c") + ": " + receiver.getHeaderValue("m")));
                    }
                    if (!"SUCCESS".equals(receiver.getHeaderValue("c"))) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01" + receiver.getHeaderValue("c") + ": " + receiver.getHeaderValue("m")));
                        return;
                    }
                    if (!P2pTransferTool.checkSign((Receiver)receiver, (String)TcpMediaPushConnection.this.cameraLivePushEntry.getSignKey())) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff01"));
                        return;
                    }
                    String pushSessionId = receiver.getHeaderValue("pushSessionId");
                    if (pushSessionId == null || pushSessionId.length() == 0) {
                        this.onError(new IOException("\u83b7\u53d6PushSessionId\u5931\u8d25\uff01\u8fd4\u56de\u7a7a\u6570\u636e"));
                        return;
                    }
                    TcpMediaPushConnection.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    TcpMediaPushConnection.this.setP2pSessionId(pushSessionId);
                }

                private void onError(Throwable ex) {
                    try {
                        TcpMediaPushConnection.this.pushSessionIdFutureHandler.setException(ex);
                    }
                    finally {
                        TcpMediaPushConnection.this.close();
                    }
                }

                public void onWaitTimeout() throws Exception {
                    this.onError(new IOException("\u83b7\u53d6pushSessionId\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return 8000L;
                }
            });
        }
        catch (Throwable ex) {
            try {
                this.pushSessionIdFutureHandler.setException(ex);
            }
            finally {
                this.close();
            }
        }
    }

    private void setP2pSessionId(String pushSessionId) {
        this.pushSessionId = pushSessionId;
        Object obj = this.requestPushSessionIdObj;
        if (obj != null) {
            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject(obj);
        }
        this.pushSessionIdFutureHandler.setResult((Object)pushSessionId);
    }

    protected synchronized void setSession(IoSession session) {
        this.ioSession = session;
        this.ioSession.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        this.remoteAddress = this.ioSession.getRemoteAddress();
        this.localAddress = this.ioSession.getLocalAddress();
        this.sessionId = String.valueOf(this.ioSession.getId());
        Object crypto = this.cameraLivePushEntry.getSignKey() == null || this.cameraLivePushEntry.getSignKey().length() == 0 ? PlainCryptoFactory.getInstance() : new MediaPusherCryptoFactory(this.cameraLivePushEntry.getSignKey().getBytes());
        this.actionProtocolHandler = new P2pTcpActionProtocolHandler((HMPResponseSenderFactory)this, (ServiceActionGetter)this, (CryptoFactory)crypto);
        this.frameProtocolHandler = new TcpFrameProtocolHandler();
        this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.requestPushSessionIdObj = new Object();
        P2pContextUtil.getContext().getTimeoutObjectPool().addObject(this.requestPushSessionIdObj, this.requestPushSessionIdObj, new TimeoutObjectPool.TimeoutCallback(){

            public void onTimeout(Object key, Object value) throws Exception {
                if (!TcpMediaPushConnection.this.isClosed()) {
                    TcpMediaPushConnection.this.close();
                }
            }
        }, 15000L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doConnect() {
        if (this.cameraLivePushEntry == null || this.cameraLivePushEntry.getPushHostAppName() == null || this.cameraLivePushEntry.getPushHostAppName().length() == 0 || this.cameraLivePushEntry.getPushHostName() == null || this.cameraLivePushEntry.getPushHostName().length() == 0 || this.cameraLivePushEntry.getAddress() == null) {
            try {
                this.connectHandler.setException((Throwable)new NullPointerException("\u7f3a\u5c11\u8fde\u63a5\u53c2\u6570"));
            }
            finally {
                this.close();
            }
            return;
        }
        try {
            if (this.connector == null) {
                this.connector = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector();
            }
            ConnectFuture future = this.connector.connect((SocketAddress)this.cameraLivePushEntry.getAddress());
            future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void operationComplete(ConnectFuture ioFuture) {
                    if (ioFuture.getException() != null) {
                        try {
                            TcpMediaPushConnection.this.connectHandler.setException(ioFuture.getException());
                            if (!ServiceUtil.getServiceContext().isDevEnvironment()) return;
                            LogUtil.getLog().info((Object)("------> fail to connect push server: " + TcpMediaPushConnection.this.cameraLivePushEntry.getAddress()));
                            return;
                        }
                        finally {
                            TcpMediaPushConnection.this.close();
                        }
                    } else {
                        IoSession session = ioFuture.getSession();
                        if (session == null || !session.isConnected()) {
                            try {
                                TcpMediaPushConnection.this.connectHandler.setException((Throwable)new IOException("Connect failed"));
                                return;
                            }
                            finally {
                                TcpMediaPushConnection.this.close();
                            }
                        } else {
                            if (ServiceUtil.getServiceContext().isDevEnvironment()) {
                                LogUtil.getLog().info((Object)("------> connected push server: " + session.getRemoteAddress()));
                            }
                            TcpMediaPushConnection.this.setSession(session);
                            TcpMediaPushConnection.this.connectHandler.setResult((Object)Boolean.TRUE);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            this.close();
            this.connectHandler.setException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        IoSession obj = null;
        if (this.ioSession == null) {
            TcpMediaPushConnection tcpMediaPushConnection = this;
            synchronized (tcpMediaPushConnection) {
                if (this.ioSession == null) {
                    return;
                }
                if (this.getPushSessionId() == null || this.getPushSessionId().length() == 0) {
                    obj = this.ioSession;
                }
            }
        }
        this.disconnect();
        if (obj != null) {
            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject(obj);
        }
    }

    @Override
    protected void disconnect() {
        if (this.ioSession != null && this.ioSession.isConnected() && !this.ioSession.isClosing()) {
            this.ioSession.close(true);
        }
    }

    @Override
    public boolean isConnected() {
        return this.ioSession != null && this.ioSession.isConnected();
    }

    @Override
    public String getPushSessionId() {
        return this.pushSessionId;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        this.close();
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        this.handleRead(buf);
    }

    public void handleRead(IoBuffer buffer) {
        while (buffer.hasRemaining()) {
            ParseDataResult result = this.frameProtocolHandler.parse(buffer);
            if (result.getResult() == 0) break;
            if (result.getResult() == 1) {
                try {
                    byte[] data = (byte[])result.getMessage();
                    this.actionProtocolHandler.handleRead(data, this.getRemoteAddress(), this.getLocalAddress(), null);
                    continue;
                }
                catch (Exception ex) {
                    try {
                        LogUtil.getLog().warn((Object)("\u63a5\u6536\u8fdc\u7aef(" + this.getRemoteAddress() + ")\u6570\u636e\uff0c\u89e3\u6790\u9519\u8bef! " + ex.getMessage()));
                        break;
                    }
                    finally {
                        this.close();
                    }
                }
            }
            try {
                LogUtil.getLog().warn((Object)("\u63a5\u6536\u8fdc\u7aef(" + this.getRemoteAddress() + ")\u6570\u636e\uff0c\u89e3\u6790\u9519\u8bef! "));
                break;
            }
            finally {
                this.close();
            }
        }
    }

    public void messageSent(IoSession ioSession, Object o) throws Exception {
    }

    public RequestSender newRequestSender() {
        return new P2pMinaSender(this.ioSession, this.frameProtocolHandler, this.actionProtocolHandler);
    }

    public ResponseSender createResponseSender(HMPAppPacket receiverPacket) throws IOException {
        P2pMinaSender sender = new P2pMinaSender(this.ioSession, (Receiver)receiverPacket, this.frameProtocolHandler, this.actionProtocolHandler);
        sender.setRemoteSendId(receiverPacket.getRemoteSendId());
        return sender;
    }

    @Override
    public int getTanTransportType() {
        return 1;
    }

    @Override
    public ServiceAction getAction(String actionName) {
        if (P2pTcpSessionCloseAction.equals(actionName)) {
            return this;
        }
        return null;
    }

    @Override
    public void service(Receiver request) throws Exception {
        if (OP_sessionClose.equals(request.getHeaderValue("op"))) {
            this.close();
        }
    }
}

