/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.framework.BytesTool;

public class H264Frame {
    public static final int NonIDR = 1;
    public static final int IDR = 5;
    public static final int SEI = 6;
    public static final int SPS = 7;
    public static final int PPS = 8;
    public static final int AccessUnitDelimiter = 9;
    private byte[] data;
    private int frameOffset;
    private int headLength;
    private int frameLength;
    private int time = -1;

    public H264Frame(byte[] data, int frameOffset, int headLength, int frameLength) {
        this.data = data;
        this.frameOffset = frameOffset;
        this.headLength = headLength;
        this.frameLength = frameLength;
    }

    public int getHeadOffset() {
        return this.frameOffset;
    }

    public int getDataOffset() {
        return this.frameOffset + this.headLength;
    }

    public int getDataLength() {
        return this.frameLength - this.headLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getFrameOffset() {
        return this.frameOffset;
    }

    public int getHeadLength() {
        return this.headLength;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public String toString() {
        return BytesTool.byteArrayToHexString((byte[])this.data, (int)this.frameOffset, (int)this.frameLength);
    }

    public int getNaluType() {
        if (this.frameLength == this.headLength) {
            return -1;
        }
        return this.data[this.getDataOffset()] & 0x1F;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }
}

