/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.p2p.media.rtsp.H264Frame;
import com.wovoe.carpark.p2p.media.rtsp.H264NaluListener;
import java.util.Collection;

public class H264FrameHelper {
    private static final byte N = 0;
    private static final byte N1 = 1;
    private H264NaluListener h264NaluListener;
    private static final byte[] target;

    static {
        byte[] byArray = new byte[3];
        byArray[2] = 1;
        target = byArray;
    }

    public H264FrameHelper() {
    }

    public H264FrameHelper(H264NaluListener h264NaluListener) {
        this.setH264NaluListener(h264NaluListener);
    }

    public H264NaluListener getH264NaluListener() {
        return this.h264NaluListener;
    }

    public void setH264NaluListener(H264NaluListener h264NaluListener) {
        this.h264NaluListener = h264NaluListener;
    }

    private static void findFrameBeginIndex(byte[] data, int beginIndex, int[] flag) {
        int index = 0;
        flag[0] = -1;
        flag[1] = 0;
        int i = beginIndex;
        while (i < data.length) {
            if (index == 0 || index == 1) {
                if (data[i] == 0) {
                    ++index;
                } else if (index != 0) {
                    index = 0;
                }
            } else if (index == 2) {
                if (data[i] == 0) {
                    ++index;
                } else {
                    if (data[i] == 1) {
                        flag[0] = i - 2;
                        flag[1] = 3;
                        break;
                    }
                    index = 0;
                }
            } else if (index == 3) {
                if (data[i] == 1) {
                    flag[0] = i - 3;
                    flag[1] = 4;
                    break;
                }
                index = 0;
            }
            ++i;
        }
    }

    public void analyseVideoData(byte[] videoData) {
        if (videoData.length < 5) {
            return;
        }
        int nextIndex = 0;
        int[] nArray = new int[2];
        nArray[0] = -1;
        int[] flag = nArray;
        H264FrameHelper.findFrameBeginIndex(videoData, nextIndex, flag);
        if (flag[0] == -1 || flag[1] == 0) {
            return;
        }
        nextIndex = flag[0];
        while (nextIndex != -1) {
            int begin = flag[0];
            int headLen = flag[1];
            H264FrameHelper.findFrameBeginIndex(videoData, nextIndex + flag[1], flag);
            int end = flag[0] == -1 || flag[1] == 0 ? videoData.length : flag[0];
            nextIndex = flag[0];
            if (end - begin - headLen < 1) {
                return;
            }
            int naluType = videoData[begin + headLen] & 0x1F;
            if (this.h264NaluListener == null) continue;
            this.h264NaluListener.onFrame(naluType, videoData, begin, end - begin, headLen);
        }
    }

    public static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static void findFrame(byte[] data, Collection<H264Frame> Collection2) {
        int findIndex = 0;
        int position = -1;
        int headLength = target.length;
        while (true) {
            if ((findIndex = H264FrameHelper.indexOf(data, 0, data.length, target, 0, target.length, findIndex)) == -1) {
                if (position == -1) break;
                Collection2.add(new H264Frame(data, position, headLength, data.length - position));
                break;
            }
            if (position != -1) {
                int length = data[findIndex - 1] == 0 ? findIndex - position - 1 : findIndex - position;
                Collection2.add(new H264Frame(data, position, headLength, length));
                if (data[findIndex - 1] == 0) {
                    position = findIndex - 1;
                    headLength = target.length + 1;
                } else {
                    position = findIndex;
                    headLength = target.length;
                }
            } else if (findIndex == 0) {
                position = findIndex;
                headLength = target.length;
            } else if (data[findIndex - 1] == 0) {
                headLength = target.length + 1;
                position = findIndex - 1;
            } else {
                position = findIndex;
                headLength = target.length;
            }
            findIndex += target.length;
        }
    }
}

