/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.p2p.media.rtsp.RtpDataHandler;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocol;
import com.wovoe.carpark.p2p.media.rtsp.SDPMedia;
import com.wovoe.framework.LogUtil;

public class H264RtpProtocol
implements RtpProtocol {
    private static final int FF = 255;
    private static final byte[] H264SPLIT;
    private byte[] videoRTPBuf = new byte[0x100000];
    private volatile int videoRTPBufIndex = 0;
    private byte[] temp;
    private byte[] videoNalTemp = new byte[1];
    private SDPMedia sdpMedia;

    static {
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        H264SPLIT = byArray;
    }

    @Override
    public synchronized void parseRtpData(byte[] data, int offset, int length, int channelFlag, RtpDataHandler handler) {
        if (channelFlag == 0) {
            this.handleRtpVideo(data, offset, length, handler);
        } else if (channelFlag == 2 || channelFlag != 1) {
            // empty if block
        }
    }

    @Override
    public int getRtpType() {
        return 0;
    }

    @Override
    public SDPMedia getSdpMedia() {
        return this.sdpMedia;
    }

    @Override
    public void setSdpMedia(SDPMedia sdpMedia) {
        this.sdpMedia = sdpMedia;
    }

    private void pushAndHandleFrame(RtpDataHandler handler, byte[] data, int pushDataOffset, int pushDataLength, boolean forcePush) {
        if (pushDataLength == 0) {
            if (pushDataLength < 4) {
                return;
            }
            if (data[pushDataOffset] == H264SPLIT[0] && data[pushDataOffset + 1] == H264SPLIT[1] && data[pushDataOffset + 2] == H264SPLIT[2] && data[pushDataOffset + 3] == H264SPLIT[3]) {
                this.videoRTPBuf[this.videoRTPBufIndex++] = H264SPLIT[0];
                this.videoRTPBuf[this.videoRTPBufIndex++] = H264SPLIT[1];
                this.videoRTPBuf[this.videoRTPBufIndex++] = H264SPLIT[2];
                this.videoRTPBuf[this.videoRTPBufIndex++] = H264SPLIT[3];
                pushDataOffset += 4;
                pushDataLength -= 4;
            } else {
                return;
            }
        }
        if (pushDataLength > 0) {
            if (data[pushDataOffset] == H264SPLIT[0] && data[pushDataOffset + 1] == H264SPLIT[1] && data[pushDataOffset + 2] == H264SPLIT[2] && data[pushDataOffset + 3] == H264SPLIT[3]) {
                if (this.videoRTPBufIndex < 6) {
                    this.videoRTPBufIndex = 0;
                } else {
                    this.temp = new byte[this.videoRTPBufIndex];
                    this.videoRTPBufIndex = 0;
                    System.arraycopy(this.videoRTPBuf, 0, this.temp, 0, this.temp.length);
                    try {
                        handler.onHandleRtpData(0, 0, this.temp, 0, this.temp.length);
                    }
                    catch (Exception ex) {
                        LogUtil.getLog().warn((Object)("\u5904\u7406H264\u5e27\u5f02\u5e38" + ex));
                    }
                }
                if (pushDataLength > this.videoRTPBuf.length - this.videoRTPBufIndex) {
                    return;
                }
                System.arraycopy(data, pushDataOffset, this.videoRTPBuf, this.videoRTPBufIndex, pushDataLength);
                this.videoRTPBufIndex += pushDataLength;
            } else if (this.videoRTPBuf.length - this.videoRTPBufIndex >= pushDataLength) {
                System.arraycopy(data, pushDataOffset, this.videoRTPBuf, this.videoRTPBufIndex, pushDataLength);
                this.videoRTPBufIndex += pushDataLength;
            } else {
                this.videoRTPBufIndex = 0;
            }
        }
        if (forcePush && this.videoRTPBufIndex > 0) {
            this.temp = new byte[this.videoRTPBufIndex];
            this.videoRTPBufIndex = 0;
            System.arraycopy(this.videoRTPBuf, 0, this.temp, 0, this.temp.length);
            try {
                handler.onHandleRtpData(0, 0, this.temp, 0, this.temp.length);
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)("\u5904\u7406H264\u5e27\u5f02\u5e38" + ex));
            }
        }
    }

    private void handleRtpVideo(byte[] data, int offset, int length, RtpDataHandler handler) {
        if (length < 13) {
            return;
        }
        int V_P_X_CC = data[offset] & 0xFF;
        int CSRC_COUNT = V_P_X_CC & 0xF;
        int headSize = 12;
        if (CSRC_COUNT > 0) {
            headSize += CSRC_COUNT * 4;
        }
        if (length <= headSize) {
            return;
        }
        length -= headSize;
        byte F_NRI_TYPE = data[offset += headSize];
        int TYPE1 = F_NRI_TYPE & 0x1F;
        if (TYPE1 == 0) {
            if (length < 6) {
                return;
            }
            if (data[offset] == H264SPLIT[0] && data[offset + 1] == H264SPLIT[1] && data[offset + 2] == H264SPLIT[2] && data[offset + 3] == H264SPLIT[3]) {
                this.pushAndHandleFrame(handler, data, offset, length, true);
            }
            return;
        }
        if (TYPE1 <= 23) {
            if (length < 2) {
                return;
            }
            if (TYPE1 == 1 || TYPE1 == 5 || TYPE1 == 6 || TYPE1 == 7 || TYPE1 == 8) {
                this.pushAndHandleFrame(handler, H264SPLIT, 0, H264SPLIT.length, false);
                this.pushAndHandleFrame(handler, data, offset, length, true);
            } else if (TYPE1 == 9 && length >= 7 && data[offset + 1] == H264SPLIT[0] && data[offset + 2] == H264SPLIT[1] && data[offset + 2] == H264SPLIT[3] && data[offset + 4] == H264SPLIT[3]) {
                this.pushAndHandleFrame(handler, data, offset + 1, length - 1, true);
            }
            return;
        }
        if (TYPE1 != 28) {
            return;
        }
        if (length < 3) {
            return;
        }
        int S_E_R_TYPE = data[offset + 1] & 0xFF;
        int S = S_E_R_TYPE >> 7;
        int E = (S_E_R_TYPE & 0x40) >> 6;
        int R = (S_E_R_TYPE & 0x20) >> 5;
        if (R != 0) {
            return;
        }
        int NALU = F_NRI_TYPE & 0xE0 | S_E_R_TYPE & 0x1F;
        TYPE1 = NALU & 0x1F;
        if (TYPE1 == 9) {
            if (S == 1) {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            } else if (E == 1) {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, true);
            } else {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            }
        } else if (TYPE1 == 1 || TYPE1 == 5 || TYPE1 == 6 || TYPE1 == 7 || TYPE1 == 8) {
            if (S == 1) {
                this.pushAndHandleFrame(handler, H264SPLIT, 0, H264SPLIT.length, false);
                this.videoNalTemp[0] = (byte)NALU;
                this.pushAndHandleFrame(handler, this.videoNalTemp, 0, 1, false);
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            } else if (E == 1) {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, true);
            } else {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            }
        } else if (TYPE1 == 0) {
            if (S == 1) {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            } else if (E == 1) {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, true);
            } else {
                this.pushAndHandleFrame(handler, data, offset + 2, length - 2, false);
            }
        }
    }
}

