/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.rtsp.H264RtpProtocol;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocol;
import com.wovoe.carpark.p2p.media.rtsp.SDPMedia;
import com.wovoe.framework.RandomStringGenerator;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RtpProtocolFactory {
    public static final String H264 = "H264";
    private static final Map<String, Class<?>> rtpProtocolVideoMap = new HashMap();
    private static final Map<String, Class<?>> rtpProtocolAudioMap = new HashMap();
    private static AtomicInteger LOCALSSRC;
    public static final byte[] CNAME;

    static {
        rtpProtocolVideoMap.put(H264, H264RtpProtocol.class);
        LOCALSSRC = new AtomicInteger((int)System.currentTimeMillis());
        CNAME = RandomStringGenerator.getDefaultInstance().getNewString(8).getBytes();
    }

    public static RtpProtocol createRtpProtocol(SDPMedia sdpMedia) {
        Class<?> cl;
        if (sdpMedia == null || sdpMedia.getEncoding() == null || sdpMedia.getEncoding().length() == 0) {
            return null;
        }
        if (sdpMedia.isVideo()) {
            cl = rtpProtocolVideoMap.get(sdpMedia.getEncoding());
        } else if (sdpMedia.isAudio()) {
            cl = rtpProtocolAudioMap.get(sdpMedia.getEncoding());
        } else {
            return null;
        }
        if (cl != null) {
            try {
                RtpProtocol protocol = (RtpProtocol)cl.newInstance();
                protocol.setSdpMedia(sdpMedia);
                return protocol;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static int createLocalSsrc() {
        int x = LOCALSSRC.incrementAndGet();
        if (x == 0) {
            x = LOCALSSRC.incrementAndGet();
        }
        return x;
    }

    public static ByteBuffer createRtcpBuf(int localSsrc, int rtpFrameSSRC, int latestRtpFrameSeq, int resetRtpFrameSeqCount, int lastLSR, long lastRevRtcpMills) {
        ByteBuffer buffer = ByteBuffer.allocate(52);
        buffer.put((byte)-127);
        buffer.put((byte)-55);
        buffer.put((byte)0);
        buffer.put((byte)7);
        buffer.putInt(localSsrc);
        buffer.putInt(rtpFrameSSRC);
        buffer.put((byte)0);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        int extended_seq_num = latestRtpFrameSeq + 65536 * resetRtpFrameSeqCount;
        buffer.putInt(extended_seq_num);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        long z = 7L;
        long z1 = System.currentTimeMillis() % z;
        buffer.put((byte)(241 + (int)z1));
        buffer.putInt(lastLSR);
        long dur = ServiceUtil.getServiceContext().currentTimeMillis() - lastRevRtcpMills;
        long t = dur * 65536L / 1000L;
        buffer.putInt((int)t);
        buffer.put((byte)-127);
        buffer.put((byte)-54);
        buffer.put((byte)0);
        buffer.put((byte)4);
        buffer.putInt(rtpFrameSSRC);
        buffer.put((byte)1);
        buffer.put((byte)8);
        buffer.put(CNAME);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.flip();
        return buffer;
    }
}

