/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.equipment.action.MediaProfile;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.rtsp.MediaStreamCallback;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocol;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocolFactory;
import com.wovoe.carpark.p2p.media.rtsp.RtspProtocol;
import com.wovoe.carpark.p2p.media.rtsp.RtspRequestModel;
import com.wovoe.carpark.p2p.media.rtsp.RtspResponseModel;
import com.wovoe.carpark.p2p.media.rtsp.RtspResponseModelHandler;
import com.wovoe.carpark.p2p.media.rtsp.SDPMedia;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.TimeoutObjectPool;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class RtspConnection
implements IoHandler,
IoSessionInitializer<ConnectFuture>,
RtspResponseModelHandler {
    private NioSocketConnector connector;
    private String rtspUrl;
    private String host;
    private int port;
    private MediaStreamCallback mediaStreamCallback;
    private boolean localCreate;
    private static final String PROTOCOL = "rtsp://";
    private IoSession ioSession;
    private AtomicLong sendSeq = new AtomicLong(0L);
    private volatile ConnectFuture connectFuture;
    private AtomicBoolean started = new AtomicBoolean();
    private TimeoutObjectPool timeoutObjectPool;
    private volatile ResponseHandler currentHandler;
    private static final String SUCCESS_CODE = "200";
    private static final String AUTH_CODE = "401";
    private static final String ATTR_AUTH_PARAM = "AUTH_PARAM_401";
    private String cameraNo;
    private String userName;
    private String pwd;
    private MediaProfile mediaProfile;
    private volatile long lastRevVideoMills;

    public RtspConnection(String rtspUrl, MediaStreamCallback mediaStreamCallback, TimeoutObjectPool pool, String userName, String pwd) {
        this(null, rtspUrl, mediaStreamCallback, pool, null, userName, pwd, null);
    }

    public RtspConnection(NioSocketConnector connector, String rtspUrl, MediaStreamCallback mediaStreamCallback, TimeoutObjectPool pool, String cameraNo, String userName, String pwd, MediaProfile mediaProfile) {
        this.connector = connector;
        this.rtspUrl = rtspUrl;
        this.mediaStreamCallback = mediaStreamCallback;
        this.timeoutObjectPool = pool;
        this.userName = userName;
        this.pwd = pwd;
        this.cameraNo = cameraNo;
        this.lastRevVideoMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.mediaProfile = mediaProfile;
    }

    public MediaProfile getMediaProfile() {
        return this.mediaProfile;
    }

    public String getCameraNo() {
        return this.cameraNo;
    }

    private void parseUrl() throws IOException {
        if (this.rtspUrl == null || this.rtspUrl.length() == 0) {
            throw new IOException("invalid rtsp url!");
        }
        if (!this.rtspUrl.startsWith(PROTOCOL)) {
            throw new IOException("invalid rtsp url!");
        }
        String ax = this.rtspUrl.substring(PROTOCOL.length());
        int sx = ax.indexOf(47);
        if (sx == -1) {
            throw new IOException("invalid rtsp url! ");
        }
        int x = (ax = ax.substring(0, sx)).indexOf(58);
        if (x == -1) {
            this.port = 554;
            this.host = ax;
        } else {
            this.host = ax.substring(0, x);
            try {
                this.port = Integer.parseInt(ax.substring(x + 1));
            }
            catch (Exception ex) {
                throw new IOException("invalid rtsp url! ");
            }
        }
        if (this.host == null || this.host.length() == 0) {
            throw new IOException("invalid rtsp url! ");
        }
        if (this.port > 65535 || this.port <= 0) {
            throw new IOException("invalid rtsp url! ");
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            block16: {
                this.currentHandler = null;
                ConnectFuture connectFuture = this.connectFuture;
                this.connectFuture = null;
                try {
                    if (!connectFuture.isDone()) {
                        connectFuture.cancel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connectFuture.getException() == null && connectFuture.getSession() != null) {
                        connectFuture.getSession().close(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    block18: {
                        if (this.ioSession == null) break block16;
                        if (!this.ioSession.isClosing() || this.ioSession.isConnected()) {
                            try {
                                try {
                                    if (this.ioSession.getAttribute((Object)"Session") != null && this.ioSession.getAttribute((Object)"PLAYING") != null) {
                                        IoBuffer buf = RtspProtocol.toSendBufer(this.createOptionsTEARDOWNequest(this.sendSeq.incrementAndGet(), (String)this.ioSession.getAttribute((Object)"Session")));
                                        this.ioSession.write((Object)buf).await(1L, TimeUnit.SECONDS);
                                    }
                                }
                                catch (Exception exception) {
                                    this.ioSession.close(true);
                                    break block18;
                                }
                            }
                            catch (Throwable throwable) {
                                this.ioSession.close(true);
                                throw throwable;
                            }
                            this.ioSession.close(true);
                        }
                    }
                    this.ioSession = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connector != null && this.localCreate) {
                this.connector.dispose();
                this.connector = null;
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isConnected() {
        IoSession session = this.ioSession;
        return session != null && session.isConnected();
    }

    private void doStart() {
        try {
            this.parseUrl();
            if (this.connector == null) {
                this.connector = new NioSocketConnector();
                this.connector.setConnectTimeoutMillis(5000L);
                this.connector.getSessionConfig().setReadBufferSize(8192);
                this.connector.getSessionConfig().setMaxReadBufferSize(65536);
                this.connector.getSessionConfig().setReceiveBufferSize(65536);
                this.connector.getSessionConfig().setSendBufferSize(65536);
                this.connector.setHandler((IoHandler)this);
                this.localCreate = true;
            }
            this.connectFuture = this.connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port), (IoSessionInitializer)this);
            this.connectFuture.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                public void operationComplete(IoFuture ioFuture) {
                    ConnectFuture future = (ConnectFuture)ioFuture;
                    if (future.getException() != null) {
                        try {
                            if (RtspConnection.this.mediaStreamCallback != null) {
                                RtspConnection.this.mediaStreamCallback.onException(0, future.getException());
                            }
                        }
                        finally {
                            RtspConnection.this.stop();
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            try {
                if (this.mediaStreamCallback != null) {
                    this.mediaStreamCallback.onException(0, ex);
                }
            }
            finally {
                this.stop();
            }
            {
            }
        }
    }

    public void start() {
        boolean s = this.started.compareAndSet(false, true);
        if (s) {
            if (this.rtspUrl != null && this.rtspUrl.length() > 0) {
                this.doStart();
            } else {
                this.stop();
            }
        }
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        if (this.mediaStreamCallback != null) {
            this.mediaStreamCallback.onConnect();
        }
    }

    public void sessionOpened(IoSession ioSession) throws Exception {
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        try {
            if (this.started.get()) {
                this.stop();
            }
        }
        finally {
            if (this.mediaStreamCallback != null) {
                this.mediaStreamCallback.onDisconnect();
            } else {
                LogUtil.getLog().warn((Object)"\u8fde\u63a5\u5df2\u88ab\u65ad\u5f00: ");
            }
        }
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) throws Exception {
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        if (this.mediaStreamCallback != null) {
            this.mediaStreamCallback.onException(7, throwable);
        }
    }

    public void messageReceived(IoSession ioSession, Object o) throws Exception {
        try {
            IoBuffer ioBuffer = (IoBuffer)o;
            RtspProtocol rtspProtocol = (RtspProtocol)ioSession.getAttribute((Object)RtspProtocol.class.getName());
            rtspProtocol.parse(ioSession, ioBuffer, this);
        }
        catch (Exception ex) {
            try {
                if (this.mediaStreamCallback != null) {
                    this.mediaStreamCallback.onException(7, ex);
                }
                LogUtil.getLog().warn((Object)"\u89e3\u6790\u9519\u8bef! ", (Throwable)ex);
            }
            finally {
                this.stop();
            }
        }
    }

    public void messageSent(IoSession ioSession, Object o) throws Exception {
    }

    public void initializeSession(IoSession ioSession, ConnectFuture connectFuture) {
        if (!this.isStarted()) {
            ioSession.close(true);
            return;
        }
        this.ioSession = ioSession;
        ioSession.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        ioSession.setAttribute((Object)RtspProtocol.class.getName(), (Object)new RtspProtocol());
        ResponseHandler handler = new ResponseHandler(this.sendSeq.incrementAndGet(), ioSession.getId(), 1);
        this.send(ioSession, RtspProtocol.toSendBufer(this.createOptionsRequest(handler.seq)), handler, 6000L);
    }

    private RtspRequestModel createOptionsRequest(long seq) {
        RtspRequestModel request = new RtspRequestModel();
        request.setMethod("OPTIONS");
        request.setUri(this.rtspUrl);
        request.setVersion("RTSP/1.0");
        request.getHeaders().put("CSeq", String.valueOf(seq));
        request.getHeaders().put("User-Agent", "RTSPClientEx (LIVE555 Streaming Media v2018.12.14)");
        return request;
    }

    private RtspRequestModel createOptionsDESCRIBERequest(long seq, String Authorization) {
        RtspRequestModel request = new RtspRequestModel();
        request.setMethod("DESCRIBE");
        request.setUri(this.rtspUrl);
        request.setVersion("RTSP/1.0");
        request.getHeaders().put("CSeq", String.valueOf(seq));
        request.getHeaders().put("User-Agent", "RTSPClientEx (LIVE555 Streaming Media v2018.12.14)");
        request.getHeaders().put("Accept", "application/sdp");
        if (Authorization != null && Authorization.length() > 0) {
            request.getHeaders().put("Authorization", Authorization);
        }
        return request;
    }

    private RtspRequestModel createOptionsTEARDOWNequest(long seq, String sessionId) {
        RtspRequestModel request = new RtspRequestModel();
        request.setMethod("TEARDOWN");
        request.setUri(this.rtspUrl);
        request.setVersion("RTSP/1.0");
        request.getHeaders().put("CSeq", String.valueOf(seq));
        request.getHeaders().put("User-Agent", "RTSPClientEx (LIVE555 Streaming Media v2018.12.14)");
        request.getHeaders().put("Session", sessionId);
        return request;
    }

    @Override
    public void onReceiveStatusFinish(IoSession session, RtspResponseModel responseModel) {
        if (ServiceUtil.getServiceContext().isDevEnvironment()) {
            LogUtil.getLog().info((Object)("\u54cd\u5e94\u72b6\u6001\u63a5\u6536\u5b8c\u6bd5\uff1a" + responseModel.getVersion() + " " + responseModel.getCode() + " " + responseModel.getStatus()));
        }
    }

    @Override
    public void onReceiveHeaderFinish(IoSession session, RtspResponseModel responseModel) {
        if (ServiceUtil.getServiceContext().isDevEnvironment()) {
            LogUtil.getLog().info((Object)("header \u63a5\u6536\u5b8c\u6bd5\uff1a" + responseModel.getHeaders()));
        }
    }

    @Override
    public void onReceiveBodyFinish(IoSession session, RtspResponseModel responseModel) {
        if (ServiceUtil.getServiceContext().isDevEnvironment()) {
            LogUtil.getLog().info((Object)("body \u63a5\u6536\u5b8c\u6bd5: \u957f\u5ea6:" + (responseModel.getBody() == null ? 0 : responseModel.getBody().length)));
        }
    }

    @Override
    public void onReceiveFinish(IoSession session, RtspResponseModel responseModel) {
        ResponseHandler currentHandler0;
        String seq;
        if (ServiceUtil.getServiceContext().isDevEnvironment()) {
            LogUtil.getLog().info((Object)"\u54cd\u5e94\u5168\u90e8\u63a5\u6536\u5b8c\u6bd5");
        }
        if ((seq = responseModel.getHeaders().get("CSeq")) != null && seq.length() > 0 && (currentHandler0 = this.currentHandler) != null && currentHandler0.sessionId == session.getId() && String.valueOf(currentHandler0.seq).equals(seq)) {
            currentHandler0.onReceiveFinish(session, responseModel);
        }
    }

    public long getLastRevVideoMills() {
        return this.lastRevVideoMills;
    }

    @Override
    public void onHandleRtpData(int channelType, int dataType, byte[] data, int offset, int length) {
        if (!this.isStarted()) {
            return;
        }
        if (channelType == 0) {
            this.lastRevVideoMills = ServiceUtil.getServiceContext().currentTimeMillis();
        }
        if (this.mediaStreamCallback != null && this.mediaStreamCallback != this) {
            this.mediaStreamCallback.onHandleRtpData(channelType, dataType, data, offset, length);
        }
    }

    private void send(IoSession session, IoBuffer buf, ResponseHandler handler, long waitMills) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        if (session == null || !session.isConnected() || session.isClosing()) {
            handler.handleException(new IOException("session is invalid! unconnected!"));
            return;
        }
        try {
            RtspProtocol protocol = (RtspProtocol)session.getAttribute((Object)RtspProtocol.class.getName());
            protocol.reset();
            this.timeoutObjectPool.addObject((Object)handler, (Object)handler, (TimeoutObjectPool.TimeoutCallback)handler, waitMills, TimeUnit.MILLISECONDS);
            this.currentHandler = handler;
            session.write((Object)buf).addListener((IoFutureListener)handler);
        }
        catch (Throwable ex) {
            handler.handleException(ex);
        }
    }

    private class ResponseHandler
    implements RtspResponseModelHandler,
    TimeoutObjectPool.TimeoutCallback,
    IoFutureListener<IoFuture> {
        private long seq;
        private long sessionId;
        private int opType;

        public ResponseHandler(long seq, long sessionId, int opType) {
            this.seq = seq;
            this.sessionId = sessionId;
            this.opType = opType;
        }

        @Override
        public void onReceiveStatusFinish(IoSession session, RtspResponseModel responseModel) {
        }

        @Override
        public void onReceiveHeaderFinish(IoSession session, RtspResponseModel responseModel) {
        }

        @Override
        public void onReceiveBodyFinish(IoSession session, RtspResponseModel responseModel) {
        }

        @Override
        public void onReceiveFinish(IoSession session, RtspResponseModel responseModel) {
            RtspConnection.this.timeoutObjectPool.removeObject((Object)this);
            RtspConnection.this.currentHandler = null;
            if (this.opType == 1) {
                this.handleOPTIONS(session, responseModel);
            } else if (this.opType == 2) {
                this.handleDESCRIBE(session, responseModel);
            } else if (this.opType == 3) {
                this.handleSETUP(session, responseModel);
            } else if (this.opType == 4) {
                this.handlePLAY(session, responseModel);
            } else if (this.opType != 5 && this.opType == 6) {
                this.handleTEARDOWN(session, responseModel);
            }
        }

        @Override
        public void onHandleRtpData(int channelType, int dataType, byte[] data, int offset, int length) {
        }

        private void handleOPTIONS(IoSession session, RtspResponseModel responseModel) {
            if (!RtspConnection.SUCCESS_CODE.equals(responseModel.getCode())) {
                this.handleException(new IOException("OPTIONS response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion()));
            } else {
                String supportOptions = responseModel.getHeaders().get("Public");
                if (supportOptions == null || supportOptions.length() == 0) {
                    this.handleException(new IOException("RSTP response OPTIONS Public header not found! "));
                } else if (!supportOptions.contains("PLAY")) {
                    this.handleException(new IOException("PLAY operation not supported by the RSTP server, Public: " + supportOptions));
                } else if (!supportOptions.contains("DESCRIBE")) {
                    this.handleException(new IOException("DESCRIBE operation not supported by the RSTP server, Public: " + supportOptions));
                } else if (!supportOptions.contains("SETUP")) {
                    this.handleException(new IOException("SETUP operation not supported by the RSTP server, Public: " + supportOptions));
                } else {
                    ResponseHandler handler = new ResponseHandler(RtspConnection.this.sendSeq.incrementAndGet(), session.getId(), 2);
                    RtspConnection.this.send(session, RtspProtocol.toSendBufer(RtspConnection.this.createOptionsDESCRIBERequest(handler.seq, null)), handler, 6000L);
                }
            }
        }

        private MessageDigest createMessageDigest(String digAlg) {
            try {
                return MessageDigest.getInstance(digAlg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported algorithm in HTTP Digest authentication: " + digAlg, e);
            }
        }

        private String digestMd5Authenticate(String uri, String nonce, String realm, String method, String charset, String userName, String userPwd) {
            if (charset == null || charset.length() == 0) {
                charset = "ISO-8859-1";
            }
            MessageDigest digester = this.createMessageDigest("MD5");
            String a2 = String.valueOf(method) + ":" + uri;
            String hasha2 = BytesTool.byteArrayToHexString((byte[])digester.digest(this.getBytes(a2, charset)));
            String a1 = String.valueOf(userName) + ":" + realm + ":" + userPwd;
            String checksum = BytesTool.byteArrayToHexString((byte[])digester.digest(this.getBytes(a1, charset)));
            String fx = String.valueOf(checksum) + ":" + nonce + ":" + hasha2;
            String hex = BytesTool.byteArrayToHexString((byte[])digester.digest(this.getBytes(fx, charset)));
            return hex;
        }

        private String basicAuthenticate(String charset, String userName, String userPwd) {
            if (charset == null || charset.length() == 0) {
                charset = "ISO-8859-1";
            }
            String a1 = String.valueOf(userName) + ":" + userPwd;
            return Base64.getEncoder().encodeToString(this.getBytes(a1, charset));
        }

        private byte[] getBytes(String s, String charset) {
            try {
                return s.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                return s.getBytes();
            }
        }

        private Map<String, String> getAuthParam(IoSession session) {
            Map authParam = (Map)session.getAttribute((Object)RtspConnection.ATTR_AUTH_PARAM);
            return authParam;
        }

        private String buildAuthParam(RtspResponseModel responseModel, Map<String, String> authParam) {
            String header = responseModel.getHeaders().get("WWW-Authenticate");
            if (header == null || header.length() == 0) {
                return "Missing WWW-Authenticate in authentication header! " + responseModel.getHeaders();
            }
            if ((header = header.trim()).startsWith("Digest ")) {
                String[] z;
                authParam.put("authType", "Digest");
                String v = header.substring(7).trim();
                String[] stringArray = z = v.split(",");
                int n = z.length;
                int n2 = 0;
                while (n2 < n) {
                    String z1 = stringArray[n2];
                    int h = z1.indexOf(61);
                    if (h != -1) {
                        String name = z1.substring(0, h).trim();
                        String value = z1.substring(h + 1).trim();
                        if (value.indexOf(34) == 0 && value.lastIndexOf(34) == value.length() - 1) {
                            value = value.substring(1, value.length() - 1);
                        }
                        authParam.put(name, value);
                    }
                    ++n2;
                }
                String nonce = authParam.get("nonce");
                String realm = authParam.get("realm");
                if (nonce == null || nonce.length() == 0) {
                    return "Missing nonce in authentication header! " + responseModel.getHeaders();
                }
                if (realm == null || realm.length() == 0) {
                    return "Missing realm in authentication header! " + responseModel.getHeaders();
                }
                String algorithm = authParam.get("algorithm");
                if (algorithm == null || algorithm.length() == 0) {
                    authParam.put("algorithm", "MD5");
                } else if (!"MD5".equalsIgnoreCase(algorithm)) {
                    return "Unsupported data signature algorithm (" + algorithm + ") currently! " + responseModel.getHeaders();
                }
                String charset = authParam.get("charset");
                if (charset == null || charset.length() == 0) {
                    authParam.put("charset", "ISO-8859-1");
                }
            } else if (header.startsWith("Basic ")) {
                authParam.put("authType", "Basic");
            } else {
                return "Unknown WWW-Authenticate: " + header;
            }
            return null;
        }

        private String getAuthorization(String uri, String method, Map<String, String> authParam, String userName, String userPwd) {
            String header = authParam.get("authType");
            String charset = authParam.get("charset");
            String returnValue = null;
            if ("Digest".equals(header)) {
                String nonce = authParam.get("nonce");
                String realm = authParam.get("realm");
                String algorithm = authParam.get("algorithm");
                String resp = null;
                if (algorithm == null || algorithm.length() == 0 || "MD5".equalsIgnoreCase(algorithm)) {
                    resp = this.digestMd5Authenticate(uri, nonce, realm, method, charset, userName, userPwd);
                }
                if (resp != null) {
                    StringBuilder sbr = new StringBuilder();
                    sbr.append("Digest username=\"").append(userName).append("\", realm=\"").append(realm).append("\", nonce=\"").append(nonce).append("\", uri=\"").append(uri).append("\", response=\"").append(resp).append("\"");
                    returnValue = sbr.toString();
                }
            } else if ("Basic".equals(header)) {
                String ax = this.basicAuthenticate(charset, userName, userPwd);
                returnValue = "Basic " + ax;
            }
            return returnValue;
        }

        private void handleDESCRIBE(IoSession session, RtspResponseModel responseModel) {
            if (!RtspConnection.SUCCESS_CODE.equals(responseModel.getCode())) {
                if (RtspConnection.AUTH_CODE.equals(responseModel.getCode())) {
                    Map<String, String> authParam = this.getAuthParam(session);
                    if (authParam != null) {
                        this.handleException(new IOException("DESCRIBE response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", auth failed! " + responseModel.getVersion()));
                    } else {
                        authParam = new HashMap<String, String>();
                        String errorMessage = this.buildAuthParam(responseModel, authParam);
                        if (errorMessage != null) {
                            this.handleException(new IOException("DESCRIBE response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion() + ", " + errorMessage));
                        } else {
                            String Authorization = this.getAuthorization(RtspConnection.this.rtspUrl, "DESCRIBE", authParam, RtspConnection.this.userName, RtspConnection.this.pwd);
                            if (Authorization == null) {
                                this.handleException(new IOException("DESCRIBE response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion() + ", getAuthorization return null!"));
                            } else {
                                session.setAttribute((Object)RtspConnection.ATTR_AUTH_PARAM, authParam);
                                ResponseHandler handler = new ResponseHandler(RtspConnection.this.sendSeq.incrementAndGet(), session.getId(), 2);
                                RtspConnection.this.send(session, RtspProtocol.toSendBufer(RtspConnection.this.createOptionsDESCRIBERequest(handler.seq, Authorization)), handler, 6000L);
                            }
                        }
                    }
                } else {
                    this.handleException(new IOException("DESCRIBE response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion()));
                }
            } else if (!"application/sdp".equals(responseModel.getHeaders().get("Content-Type"))) {
                this.handleException(new IOException("DESCRIBE response error!, Content-Type error, expect:application/sdp, current:" + responseModel.getHeaders().get("Content-Type")));
            } else if (responseModel.getBody() == null || responseModel.getBody().length == 0) {
                this.handleException(new IOException("DESCRIBE response error!, content is empty "));
            } else {
                String bodyLine = new String(responseModel.getBody());
                if (ServiceUtil.getServiceContext().isDevEnvironment()) {
                    LogUtil.getLog().info((Object)("sdp: " + bodyLine));
                }
                StringTokenizer st = new StringTokenizer(bodyLine, "\r\n");
                LinkedList<SDPMedia> mediaList = new LinkedList<SDPMedia>();
                SDPMedia media = null;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken().trim();
                    if (line.length() <= 0) continue;
                    if (line.startsWith("m=")) {
                        media = new SDPMedia();
                        mediaList.add(media);
                    }
                    if (media == null) continue;
                    media.setKeyValue(line);
                }
                SDPMedia videoMedia = null;
                SDPMedia audioMedia = null;
                for (SDPMedia media1 : mediaList) {
                    if (media1.isVideo()) {
                        if (videoMedia == null) {
                            videoMedia = media1;
                        }
                        if (media1.getControl() == null || media1.getControl().length() <= 0) continue;
                        break;
                    }
                    if (!media1.isAudio()) continue;
                    audioMedia = media1;
                }
                String control = null;
                if (videoMedia == null) {
                    this.handleException(new IOException("DESCRIBE response sdp error!, m=video not found!"));
                    return;
                }
                control = videoMedia.getControl();
                if (videoMedia.getEncoding() == null || videoMedia.getEncoding().length() == 0) {
                    if (RtspConnection.this.mediaProfile != null && RtspConnection.this.mediaProfile.getVideo_Encoding() != null && RtspConnection.this.mediaProfile.getVideo_Encoding().length() > 0) {
                        videoMedia.setEncoding(RtspConnection.this.mediaProfile.getVideo_Encoding());
                    }
                } else {
                    videoMedia.setEncoding(videoMedia.getEncoding().toUpperCase(Locale.US));
                    if (RtspConnection.this.mediaProfile != null && (RtspConnection.this.mediaProfile.getVideo_Encoding() == null || RtspConnection.this.mediaProfile.getVideo_Encoding().length() == 0)) {
                        RtspConnection.this.mediaProfile.setVideo_Encoding(videoMedia.getEncoding());
                    }
                }
                if (videoMedia.getEncoding() == null || videoMedia.getEncoding().length() == 0) {
                    this.handleException(new IOException("Unknown video encoding name! " + videoMedia));
                    return;
                }
                if (control == null || control.length() == 0) {
                    this.handleException(new IOException("DESCRIBE response error!, a=control: not found!"));
                } else {
                    String Authorization;
                    RtpProtocol audioRtpProtocol;
                    RtspProtocol rtspProtocol = (RtspProtocol)session.getAttribute((Object)RtspProtocol.class.getName());
                    RtpProtocol videoRtpProtocol = RtpProtocolFactory.createRtpProtocol(videoMedia);
                    if (videoRtpProtocol == null) {
                        this.handleException(new IOException("Video encoding " + videoMedia.getEncoding() + " not currently supported " + videoMedia));
                        return;
                    }
                    rtspProtocol.setRtpVideoProtocol(videoRtpProtocol);
                    if (audioMedia != null && (audioRtpProtocol = RtpProtocolFactory.createRtpProtocol(videoMedia)) != null) {
                        rtspProtocol.setRtpAudioProtocol(audioRtpProtocol);
                    }
                    session.setAttribute((Object)"Control", (Object)control);
                    String range = videoMedia.getRange();
                    if (range != null && range.length() > 0) {
                        session.setAttribute((Object)"Range", (Object)range);
                    }
                    String channelUrl = control;
                    if (!control.startsWith(RtspConnection.PROTOCOL)) {
                        if (!RtspConnection.this.rtspUrl.endsWith("/")) {
                            channelUrl = String.valueOf(RtspConnection.this.rtspUrl) + "/" + control;
                            session.setAttribute((Object)"Control", (Object)channelUrl);
                        } else {
                            channelUrl = String.valueOf(RtspConnection.this.rtspUrl) + control;
                            session.setAttribute((Object)"Control", (Object)channelUrl);
                        }
                    }
                    ResponseHandler handler = new ResponseHandler(RtspConnection.this.sendSeq.incrementAndGet(), session.getId(), 3);
                    RtspRequestModel request = new RtspRequestModel();
                    request.setMethod("SETUP");
                    request.setUri(channelUrl);
                    request.setVersion("RTSP/1.0");
                    request.getHeaders().put("CSeq", String.valueOf(handler.seq));
                    request.getHeaders().put("Transport", "RTP/AVP/TCP;unicast;interleaved=0-1");
                    Map<String, String> authParam = this.getAuthParam(session);
                    if (authParam != null && (Authorization = this.getAuthorization(channelUrl, "SETUP", authParam, RtspConnection.this.userName, RtspConnection.this.pwd)) != null && Authorization.length() > 0) {
                        request.getHeaders().put("Authorization", Authorization);
                    }
                    RtspConnection.this.send(session, RtspProtocol.toSendBufer(request), handler, 6000L);
                    try {
                        if (RtspConnection.this.mediaStreamCallback != null) {
                            RtspConnection.this.mediaStreamCallback.onSdp(bodyLine);
                        }
                    }
                    catch (Exception ex1) {
                        LogUtil.getLog().error((Object)"mediaStreamCallback.onSdp", (Throwable)ex1);
                    }
                }
            }
        }

        private void handleSETUP(IoSession session, RtspResponseModel responseModel) {
            if (!RtspConnection.SUCCESS_CODE.equals(responseModel.getCode())) {
                this.handleException(new IOException("SETUP response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion()));
            } else {
                String sessionId = responseModel.getHeaders().get("Session");
                long sessionTimeoutSec = 0L;
                if (sessionId == null || (sessionId = sessionId.trim()).length() == 0) {
                    this.handleException(new IOException("RTSP SETUP OPTIONS error! Session header not found! "));
                } else {
                    String Authorization;
                    if (sessionId.indexOf(59) != -1) {
                        String[] ax = sessionId.split(";");
                        sessionId = ax[0];
                        String timeoutName = "timeout";
                        int i = 1;
                        while (i < ax.length) {
                            try {
                                int h;
                                String rm = ax[i].trim();
                                if (rm.startsWith(timeoutName) && (h = rm.indexOf(61)) != -1) {
                                    String z1 = rm.substring(0, h).trim();
                                    String z2 = rm.substring(h + 1).trim();
                                    if (timeoutName.equals(z1) && z2.length() > 0) {
                                        try {
                                            sessionTimeoutSec = Long.parseLong(z2);
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                            catch (Exception ex) {
                                LogUtil.getLog().warn((Object)("handle error: " + ax[i]));
                            }
                            ++i;
                        }
                    }
                    session.setAttribute((Object)"Session", (Object)sessionId);
                    if (sessionTimeoutSec > 0L) {
                        session.setAttribute((Object)"SessionTimeoutSecs", (Object)sessionTimeoutSec);
                    }
                    ResponseHandler handler = new ResponseHandler(RtspConnection.this.sendSeq.incrementAndGet(), session.getId(), 4);
                    RtspRequestModel request = new RtspRequestModel();
                    request.setMethod("PLAY");
                    String uri = (String)session.getAttribute((Object)"Control");
                    request.setUri(uri);
                    request.setVersion("RTSP/1.0");
                    request.getHeaders().put("CSeq", String.valueOf(handler.seq));
                    request.getHeaders().put("User-Agent", "RTSPClientEx (LIVE555 Streaming Media v2018.12.14)");
                    request.getHeaders().put("Session", sessionId);
                    request.getHeaders().put("Range", session.getAttribute((Object)"Range") == null ? "npt=0.00-" : (String)session.getAttribute((Object)"Range"));
                    Map<String, String> authParam = this.getAuthParam(session);
                    if (authParam != null && (Authorization = this.getAuthorization(uri, "PLAY", authParam, RtspConnection.this.userName, RtspConnection.this.pwd)) != null && Authorization.length() > 0) {
                        request.getHeaders().put("Authorization", Authorization);
                    }
                    session.setAttribute((Object)"WAIT_PLAY_RESPONSE", (Object)String.valueOf(handler.seq));
                    RtspConnection.this.send(session, RtspProtocol.toSendBufer(request), handler, 6000L);
                }
            }
        }

        private void handlePLAY(IoSession session, RtspResponseModel responseModel) {
            if (!RtspConnection.SUCCESS_CODE.equals(responseModel.getCode())) {
                this.handleException(new IOException("PLAY response error code: " + responseModel.getCode() + ", " + responseModel.getStatus() + ", " + responseModel.getVersion()));
            } else {
                session.removeAttribute((Object)"WAIT_PLAY_RESPONSE");
                session.setAttribute((Object)"PLAYING", (Object)Boolean.TRUE);
                try {
                    if (RtspConnection.this.mediaStreamCallback != null) {
                        RtspConnection.this.mediaStreamCallback.onReadyPlay();
                    }
                }
                catch (Exception ex) {
                    LogUtil.getLog().error((Object)"mediaStreamCallback.onReadyPlay", (Throwable)ex);
                }
            }
        }

        private void handleTEARDOWN(IoSession session, RtspResponseModel responseModel) {
            RtspConnection.this.stop();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResponseHandler handler = (ResponseHandler)o;
            if (this.seq != handler.seq) {
                return false;
            }
            if (this.sessionId != handler.sessionId) {
                return false;
            }
            return this.opType == handler.opType;
        }

        public int hashCode() {
            int result = (int)(this.seq ^ this.seq >>> 32);
            result = 31 * result + (int)(this.sessionId ^ this.sessionId >>> 32);
            result = 31 * result + this.opType;
            return result;
        }

        public void operationComplete(IoFuture ioFuture) {
            WriteFuture s;
            if (ioFuture instanceof WriteFuture && (s = (WriteFuture)ioFuture).getException() != null) {
                try {
                    ResponseHandler handler = (ResponseHandler)RtspConnection.this.timeoutObjectPool.removeObject((Object)this);
                    if (handler != null) {
                        handler.handleException(s.getException());
                    } else {
                        RtspConnection.this.currentHandler = null;
                    }
                }
                finally {
                    RtspConnection.this.stop();
                }
            }
        }

        protected void handleException(Throwable ex) {
            try {
                RtspConnection.this.currentHandler = null;
                LogUtil.getLog().warn((Object)("request rstp server error! operation: " + this.opType + " host:" + RtspConnection.this.host + ":" + RtspConnection.this.port + " --> cause:" + ex.getMessage()));
            }
            finally {
                try {
                    RtspConnection.this.stop();
                }
                finally {
                    try {
                        if (RtspConnection.this.mediaStreamCallback != null) {
                            RtspConnection.this.mediaStreamCallback.onException(this.opType, ex);
                        }
                    }
                    catch (Exception ex1) {
                        LogUtil.getLog().error((Object)"mediaStreamCallback.onReadyPlay", (Throwable)ex1);
                    }
                }
            }
        }

        public void onTimeout(Object key, Object value) throws Exception {
            this.handleException(new TimeoutException("wait response timeout!"));
        }
    }
}

