/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocol;
import com.wovoe.carpark.p2p.media.rtsp.RtpProtocolFactory;
import com.wovoe.carpark.p2p.media.rtsp.RtspRequestModel;
import com.wovoe.carpark.p2p.media.rtsp.RtspResponseModel;
import com.wovoe.carpark.p2p.media.rtsp.RtspResponseModelHandler;
import com.wovoe.framework.BytesTool;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;

public class RtspProtocol {
    private static final int WAIT_STATUS = 0;
    private static final int WAIT_HEADER = 1;
    private static final int WAIT_BODY = 2;
    private static final char BLANK_SPACE = ' ';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char COLON = ':';
    private byte[] cacheBuffer = new byte[65550];
    private static final byte F_$ = 36;
    private static final int WAIT_$ = 0;
    private static final int WAIT_CH_TYP1 = 1;
    private static final int WAIT_FARMAE_LEN0 = 2;
    private static final int WAIT_FARMAE_LEN1 = 3;
    private static final int WAIT_FARMAE_DATA = 4;
    private byte[] rtpFrameBufer = new byte[65550];
    private int rtpFrameLengthIndex = 0;
    private int rtpFrameLength = 0;
    private int rtpFrameParseType = 0;
    private volatile int index = 0;
    private volatile int parseType = 0;
    private static final int WAIT_CR = 0;
    private static final int WAIT_LF = 1;
    private volatile int wait_line_end = 0;
    private static final String CHARSET = "UTF-8";
    private volatile RtspResponseModel response;
    private RtpProtocol rtpVideoProtocol;
    private RtpProtocol rtpAudioProtocol;
    private volatile long lastRevRtpFrameMills;
    private volatile int rtpFrameSSRC;
    private volatile int latestRtpFrameSeq = -1;
    private volatile int resetRtpFrameSeqCount;
    private volatile int latestRtpFrameTimestamp;
    volatile int lastRtpFrameTimestamp;
    volatile int lastRtpFrameSeq;
    private volatile long lastSendRtcpFramemills;
    private volatile int localSsrc;
    private volatile long lastRevRtcpC8Mills;
    private volatile int lastLSR;
    public static final String PLAYING_FLAG = "PLAYING";
    public static final String WAIT_PLAY_RESPONSE = "WAIT_PLAY_RESPONSE";
    public static final String SessionTimeoutSecs_LAG = "SessionTimeoutSecs";

    public RtpProtocol getRtpVideoProtocol() {
        return this.rtpVideoProtocol;
    }

    public void setRtpVideoProtocol(RtpProtocol rtpVideoProtocol) {
        this.rtpVideoProtocol = rtpVideoProtocol;
    }

    public RtpProtocol getRtpAudioProtocol() {
        return this.rtpAudioProtocol;
    }

    public void setRtpAudioProtocol(RtpProtocol rtpAudioProtocol) {
        this.rtpAudioProtocol = rtpAudioProtocol;
    }

    public synchronized void reset() {
        this.response = null;
        this.wait_line_end = 0;
        this.parseType = 0;
        this.index = 0;
    }

    private synchronized void handleRtspData(IoSession session, IoBuffer buffer, RtspResponseModelHandler responseModelHandler) {
        while (buffer.hasRemaining()) {
            String line;
            if (this.parseType == 0) {
                if (this.response == null) {
                    this.response = new RtspResponseModel();
                }
                if ((line = this.readLine(buffer)) == null) {
                    return;
                }
                if (!RtspProtocol.parseStatusLine(this.response, line)) continue;
                this.parseType = 1;
                this.index = 0;
                if (responseModelHandler == null) continue;
                responseModelHandler.onReceiveStatusFinish(session, this.response);
                continue;
            }
            if (this.parseType == 1) {
                String len;
                line = this.readLine(buffer);
                if (line == null) {
                    return;
                }
                if ((line = line.trim()).length() > 0) {
                    int x = line.indexOf(58);
                    if (x == -1) continue;
                    String key = line.substring(0, x).trim();
                    String value = line.substring(x + 1).trim();
                    this.response.getHeaders().put(key, value);
                    continue;
                }
                if (responseModelHandler != null) {
                    responseModelHandler.onReceiveHeaderFinish(session, this.response);
                }
                if ((len = this.response.getHeaders().get("Content-Length")) != null && len.length() > 0) {
                    int contentLength = Integer.parseInt(len);
                    if (contentLength == 0 || contentLength > this.cacheBuffer.length) {
                        try {
                            if (responseModelHandler == null) continue;
                            responseModelHandler.onReceiveFinish(session, this.response);
                            continue;
                        }
                        finally {
                            this.reset();
                        }
                    }
                    this.response.setBody(new byte[contentLength]);
                    this.index = 0;
                    this.parseType = 2;
                    continue;
                }
                try {
                    if (responseModelHandler == null) continue;
                    responseModelHandler.onReceiveFinish(session, this.response);
                    continue;
                }
                finally {
                    this.reset();
                }
            }
            if (this.parseType == 2) {
                this.response.getBody()[this.index++] = buffer.get();
                if (this.index != this.response.getBody().length) continue;
                try {
                    if (responseModelHandler == null) continue;
                    responseModelHandler.onReceiveBodyFinish(session, this.response);
                    continue;
                }
                finally {
                    try {
                        if (responseModelHandler != null) {
                            responseModelHandler.onReceiveFinish(session, this.response);
                        }
                    }
                    finally {
                        this.reset();
                    }
                }
            }
            this.reset();
        }
    }

    public synchronized void parse(IoSession session, IoBuffer buffer, RtspResponseModelHandler responseModelHandler) {
        Boolean PLAYING = (Boolean)session.getAttribute((Object)PLAYING_FLAG);
        if (!(PLAYING != null && PLAYING.booleanValue() || session.getAttribute((Object)WAIT_PLAY_RESPONSE) == null)) {
            int pos = buffer.position();
            byte b = buffer.get();
            buffer.position(pos);
            if (this.rtpFrameParseType == 0 && b == 36) {
                Object cseQ = session.getAttribute((Object)WAIT_PLAY_RESPONSE);
                if (responseModelHandler != null && cseQ != null) {
                    if (this.response == null) {
                        this.response = new RtspResponseModel();
                    }
                    this.response.setVersion("RTSP/1.0");
                    this.response.setCode("200");
                    this.response.setStatus("OK");
                    responseModelHandler.onReceiveStatusFinish(session, this.response);
                    this.response.getHeaders().put("CSeq", cseQ.toString());
                    this.response.getHeaders().put("Date", new Date().toString());
                    responseModelHandler.onReceiveHeaderFinish(session, this.response);
                    responseModelHandler.onReceiveFinish(session, this.response);
                    this.reset();
                    PLAYING = (Boolean)session.getAttribute((Object)PLAYING_FLAG);
                }
            }
        }
        if (PLAYING != null && PLAYING.booleanValue()) {
            while (buffer.hasRemaining()) {
                if (this.rtpFrameLengthIndex >= this.rtpFrameBufer.length) {
                    this.rtpFrameLengthIndex = 0;
                    this.rtpFrameLength = 0;
                    this.rtpFrameParseType = 0;
                }
                byte b = buffer.get();
                if (this.rtpFrameParseType == 0) {
                    if (b == 36) {
                        this.rtpFrameBufer[this.rtpFrameLengthIndex++] = b;
                        this.rtpFrameParseType = 1;
                        continue;
                    }
                    this.rtpFrameLengthIndex = 0;
                    this.rtpFrameLength = 0;
                    continue;
                }
                if (this.rtpFrameParseType == 1) {
                    this.rtpFrameBufer[this.rtpFrameLengthIndex++] = b;
                    this.rtpFrameParseType = 2;
                    continue;
                }
                if (this.rtpFrameParseType == 2) {
                    this.rtpFrameBufer[this.rtpFrameLengthIndex++] = b;
                    this.rtpFrameParseType = 3;
                    continue;
                }
                if (this.rtpFrameParseType == 3) {
                    this.rtpFrameBufer[this.rtpFrameLengthIndex++] = b;
                    int len = (this.rtpFrameBufer[2] & 0xFF) << 8 | this.rtpFrameBufer[3] & 0xFF;
                    if (len <= 0 || len > this.rtpFrameBufer.length - 4) {
                        this.rtpFrameLengthIndex = 0;
                        this.rtpFrameLength = 0;
                        this.rtpFrameParseType = 0;
                        continue;
                    }
                    this.rtpFrameLength = len;
                    this.rtpFrameParseType = 4;
                    continue;
                }
                if (this.rtpFrameParseType != 4) continue;
                this.rtpFrameBufer[this.rtpFrameLengthIndex++] = b;
                if (this.rtpFrameLengthIndex != this.rtpFrameLength + 4) continue;
                try {
                    int channelFlag = this.rtpFrameBufer[1] & 0xFF;
                    this.preHandleRtpData(session, this.rtpFrameBufer, 4, this.rtpFrameLengthIndex - 4, channelFlag);
                    RtpProtocol rtpProtocol = null;
                    if (channelFlag == 0) {
                        rtpProtocol = this.getRtpVideoProtocol();
                    } else if (channelFlag == 2) {
                        rtpProtocol = this.getRtpAudioProtocol();
                    }
                    if (rtpProtocol == null) continue;
                    rtpProtocol.parseRtpData(this.rtpFrameBufer, 4, this.rtpFrameLengthIndex - 4, this.rtpFrameBufer[1] & 0xFF, responseModelHandler);
                }
                finally {
                    this.rtpFrameLengthIndex = 0;
                    this.rtpFrameLength = 0;
                    this.rtpFrameParseType = 0;
                }
            }
        } else {
            this.handleRtspData(session, buffer, responseModelHandler);
        }
    }

    private void preHandleRtpData(IoSession session, byte[] data, int offset, int length, int channelFlag) {
        if (channelFlag == 0) {
            this.parseVideoRtpHeadData(session, data, offset, length);
        } else if (channelFlag != 2 && channelFlag == 1) {
            this.parseRtcpVideoData(data, offset, length);
        }
    }

    private void parseRtcpVideoData(byte[] data, int offset, int length) {
        if (length < 4) {
            return;
        }
        int type = data[offset + 1] & 0xFF;
        if (type == 200 && length >= 20) {
            this.lastLSR = BytesTool.bytesToInt((byte[])data, (int)(offset + 10));
            this.lastRevRtcpC8Mills = ServiceUtil.getServiceContext().currentTimeMillis();
        }
    }

    public void parseVideoRtpHeadData(IoSession session, byte[] data, int offset, int length) {
        if (length < 12) {
            return;
        }
        this.lastRevRtpFrameMills = ServiceUtil.getServiceContext().currentTimeMillis();
        int seq = data[offset] & 0xFFFF;
        int timestamp = BytesTool.bytesToInt((byte[])data, (int)(offset + 4));
        this.rtpFrameSSRC = BytesTool.bytesToInt((byte[])data, (int)(offset + 8));
        if (this.latestRtpFrameSeq >= 0) {
            if (seq < this.latestRtpFrameSeq && this.latestRtpFrameSeq - seq >= 255) {
                ++this.resetRtpFrameSeqCount;
            }
            this.lastRtpFrameTimestamp = this.latestRtpFrameTimestamp;
            this.lastRtpFrameSeq = this.latestRtpFrameSeq;
        }
        this.latestRtpFrameSeq = seq;
        this.latestRtpFrameTimestamp = timestamp;
        if (this.lastSendRtcpFramemills == 0L) {
            this.lastSendRtcpFramemills = this.lastRevRtpFrameMills;
        } else {
            long currentTimeMillis = this.lastRevRtpFrameMills;
            long gz = currentTimeMillis - this.lastSendRtcpFramemills;
            if (gz >= 5000L) {
                this.lastSendRtcpFramemills = currentTimeMillis;
                if (this.lastRevRtcpC8Mills > 0L) {
                    if (this.localSsrc == 0) {
                        this.localSsrc = RtpProtocolFactory.createLocalSsrc();
                    }
                    ByteBuffer buffer = RtpProtocolFactory.createRtcpBuf(this.localSsrc, this.rtpFrameSSRC, this.latestRtpFrameSeq, this.resetRtpFrameSeqCount, this.lastLSR, this.lastRevRtcpC8Mills);
                    int sendDataLen = buffer.remaining();
                    IoBuffer sendBuf = IoBuffer.allocate((int)(4 + sendDataLen));
                    sendBuf.put((byte)36);
                    sendBuf.put((byte)1);
                    sendBuf.put((byte)(sendDataLen >> 8));
                    sendBuf.put((byte)sendDataLen);
                    while (buffer.hasRemaining()) {
                        sendBuf.put(buffer.get());
                    }
                    sendBuf.flip();
                    session.write((Object)sendBuf);
                }
            }
        }
    }

    private String readLine(IoBuffer buffer) {
        while (buffer.hasRemaining()) {
            if (this.index >= this.cacheBuffer.length) {
                this.reset();
            }
            byte b = buffer.get();
            if (this.wait_line_end == 0) {
                if (b == 13) {
                    this.wait_line_end = 1;
                }
                this.cacheBuffer[this.index++] = b;
                continue;
            }
            if (this.wait_line_end != 1) continue;
            if (b == 10) {
                String line;
                try {
                    line = new String(this.cacheBuffer, 0, this.index - 1, CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    line = new String(this.cacheBuffer, 0, this.index - 1);
                }
                this.index = 0;
                this.wait_line_end = 0;
                return line;
            }
            this.cacheBuffer[this.index++] = b;
            this.wait_line_end = 0;
        }
        return null;
    }

    public static IoBuffer toSendBufer(RtspRequestModel request) {
        IoBuffer buf;
        byte[] v;
        StringBuilder sb = new StringBuilder(128);
        sb.append(request.getMethod()).append(' ').append(request.getUri()).append(' ').append(request.getVersion()).append('\r').append('\n');
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> en : headers.entrySet()) {
                sb.append(en.getKey()).append(':').append(' ').append(en.getValue()).append('\r').append('\n');
            }
        }
        sb.append('\r').append('\n');
        try {
            v = sb.toString().getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            v = sb.toString().getBytes();
        }
        if (request.getBody() != null && request.getBody().length > 0) {
            buf = IoBuffer.allocate((int)(v.length + request.getBody().length));
            buf.put(v);
            buf.put(request.getBody());
            buf.flip();
        } else {
            buf = IoBuffer.wrap((byte[])v);
        }
        return buf;
    }

    private static boolean parseStatusLine(RtspResponseModel response, String line) {
        if (line == null || line.length() == 0) {
            return false;
        }
        int x = (line = line.trim()).indexOf(32);
        if (x == -1) {
            return false;
        }
        String version = line.substring(0, x);
        if (!version.toUpperCase().startsWith("RTSP/")) {
            return false;
        }
        if ((x = (line = line.substring(x + 1)).indexOf(32)) == -1) {
            return false;
        }
        String code = line.substring(0, x);
        try {
            Integer.parseInt(code);
        }
        catch (Exception ex) {
            return false;
        }
        String status = line.substring(x + 1);
        response.setVersion(version);
        response.setCode(code);
        response.setStatus(status);
        return true;
    }
}

