/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import java.util.StringTokenizer;

public class SDPMedia {
    public static final String KEY_M = "m=";
    public static final String KEY_C = "c=";
    public static final String KEY_B = "b=";
    public static final String KEY_B_AS = "b=AS:";
    public static final String KEY_a = "a=";
    public static final String KEY_a_rtpmap = "a=rtpmap:";
    public static final String KEY_a_fmtp = "a=fmtp:";
    public static final String KEY_a_control = "a=control:";
    public static final String KEY_a_range = "a=range:";
    public static final String v_recvonly = "recvonly";
    public static final String v_sendrecv = "sendrecv";
    public static final String v_sendonly = "sendonly";
    private String media;
    private String mediaType;
    private String transport;
    private String address;
    private String bandwidth;
    private String rtpmap;
    private String playLoadType;
    private String encoding;
    private String clockRate;
    private String fmtp;
    private String control;
    private String range;
    private String recvSendMode;

    public void setKeyValue(String kv) {
        if (kv == null || (kv = kv.trim()).length() == 0) {
            return;
        }
        if (kv.startsWith(KEY_M)) {
            this.setMedia(SDPMedia.getValue(kv, KEY_M));
        } else if (kv.startsWith(KEY_C)) {
            this.setAddress(SDPMedia.getValue(kv, KEY_C));
        } else if (kv.startsWith(KEY_B_AS)) {
            this.setBandwidth(SDPMedia.getValue(kv, KEY_B_AS));
        } else if (kv.startsWith(KEY_a)) {
            if (kv.startsWith(KEY_a_rtpmap)) {
                this.setRtpmap(SDPMedia.getValue(kv, KEY_a_rtpmap));
            } else if (kv.startsWith(KEY_a_fmtp)) {
                this.setFmtp(SDPMedia.getValue(kv, KEY_a_fmtp));
            } else if (kv.startsWith(KEY_a_control)) {
                this.setControl(SDPMedia.getValue(kv, KEY_a_control));
            } else if (kv.startsWith(KEY_a_range)) {
                this.setRange(SDPMedia.getValue(kv, KEY_a_range));
            } else if (kv.equals("a=recvonly")) {
                this.setRecvSendMode(v_recvonly);
            } else if (kv.equals("a=sendrecv")) {
                this.setRecvSendMode(v_sendrecv);
            } else if (kv.equals("a=sendonly")) {
                this.setRecvSendMode(v_sendonly);
            }
        }
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        String mediaType = null;
        String transport = null;
        if (media != null && media.length() > 0) {
            StringTokenizer st = new StringTokenizer(media, " ");
            int index = 0;
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                if (v.length() <= 0) continue;
                if (index == 0) {
                    mediaType = v;
                } else if (index != 1 && index == 2) {
                    transport = v;
                }
                ++index;
            }
        }
        this.media = media;
        this.setMediaType(mediaType);
        this.setTransport(transport);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(String bandwidth) {
        this.bandwidth = bandwidth;
    }

    public String getRtpmap() {
        return this.rtpmap;
    }

    public void setRtpmap(String rtpmap) {
        String playLoadType = null;
        String encoding = null;
        String clockRate = null;
        String tz = null;
        if (rtpmap != null && rtpmap.length() > 0) {
            StringTokenizer st = new StringTokenizer(rtpmap, " ");
            int index = 0;
            while (st.hasMoreTokens()) {
                String v = st.nextToken();
                if (v.length() <= 0) continue;
                if (index == 0) {
                    playLoadType = v;
                } else if (index == 1) {
                    tz = v.trim();
                }
                ++index;
            }
        }
        if (tz != null && tz.length() > 0) {
            int h1 = tz.indexOf(47);
            if (h1 != -1) {
                encoding = tz.substring(0, h1).trim();
                if ((tz = tz.substring(h1 + 1).trim()).length() > 0) {
                    h1 = tz.indexOf(47);
                    clockRate = h1 != -1 ? tz.substring(0, h1).trim() : tz;
                }
            } else {
                encoding = tz;
            }
        }
        this.rtpmap = rtpmap;
        this.setPlayLoadType(playLoadType);
        this.setEncoding(encoding);
        this.setClockRate(clockRate);
    }

    public String getPlayLoadType() {
        return this.playLoadType;
    }

    public void setPlayLoadType(String playLoadType) {
        this.playLoadType = playLoadType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getClockRate() {
        return this.clockRate;
    }

    public void setClockRate(String clockRate) {
        this.clockRate = clockRate;
    }

    public String getFmtp() {
        return this.fmtp;
    }

    public void setFmtp(String fmtp) {
        this.fmtp = fmtp;
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getRecvSendMode() {
        return this.recvSendMode;
    }

    public void setRecvSendMode(String recvSendMode) {
        this.recvSendMode = recvSendMode;
    }

    public boolean isVideo() {
        return "video".equals(this.getMediaType());
    }

    public boolean isAudio() {
        return "audio".equals(this.getMediaType());
    }

    private static String getValue(String v, String prefix) {
        if (v != null && v.length() > 0 && prefix != null && prefix.length() > 0 && v.startsWith(prefix)) {
            return v.substring(prefix.length());
        }
        return v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SDPMedia{");
        sb.append("mediaType='").append(this.mediaType).append('\'');
        sb.append(", transport='").append(this.transport).append('\'');
        sb.append(", address='").append(this.address).append('\'');
        sb.append(", bandwidth='").append(this.bandwidth).append('\'');
        sb.append(", playLoadType='").append(this.playLoadType).append('\'');
        sb.append(", encoding='").append(this.encoding).append('\'');
        sb.append(", clockRate='").append(this.clockRate).append('\'');
        sb.append(", fmtp='").append(this.fmtp).append('\'');
        sb.append(", control='").append(this.control).append('\'');
        sb.append(", range='").append(this.range).append('\'');
        sb.append(", recvSendMode='").append(this.recvSendMode).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

