/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.p2p.media.rtsp;

import com.wovoe.carpark.p2p.media.rtsp.H264SPSPaser;
import java.util.Arrays;

public class SpsFrame {
    private int forbidden_zero_bit;
    private int nal_ref_idc;
    private int nal_unit_type;
    private int profile_idc;
    private int constraint_set0_flag;
    private int constraint_set1_flag;
    private int constraint_set2_flag;
    private int constraint_set3_flag;
    private int reserved_zero_4bits;
    private int level_idc;
    private int seq_parameter_set_id;
    private int chroma_format_idc;
    private int residual_colour_transform_flag;
    private int bit_depth_luma_minus8;
    private int bit_depth_chroma_minus8;
    private int qpprime_y_zero_transform_bypass_flag;
    private int seq_scaling_matrix_present_flag;
    private int[] seq_scaling_list_present_flag = new int[8];
    private int log2_max_frame_num_minus4;
    private int pic_order_cnt_type;
    private int log2_max_pic_order_cnt_lsb_minus4;
    private int delta_pic_order_always_zero_flag;
    private int offset_for_non_ref_pic;
    private int offset_for_top_to_bottom_field;
    private int getNum_ref_frames_in_pic_prder_cnt_cycle;
    private int[] offset_for_ref_frame;
    private int num_ref_frames;
    private int gaps_in_frame_num_value_allowed_flag;
    private int pic_width_in_mbs_minus_1;
    private int pic_height_in_map_units_minus_1;
    private int frame_mbs_only_flag;
    private int mb_adaptive_frame_field_flag;
    private int direct_8x8_inference_flag;
    private int frame_cropping_flag;
    private int frame_crop_left_offset;
    private int frame_crop_right_offset;
    private int frame_crop_top_offset;
    private int frame_crop_bottom_offset;
    private int vui_prameters_present_flag;
    private int vui_parameters;
    private int rbsp_stop_one_bit;
    private int fps;

    public SpsFrame getSpsFrame(byte[] sps) {
        int i;
        H264SPSPaser h264SPSPaser = new H264SPSPaser();
        this.forbidden_zero_bit = h264SPSPaser.u(sps, 1, 0);
        this.nal_ref_idc = h264SPSPaser.u(sps, 2, h264SPSPaser.getStartBit());
        this.nal_unit_type = h264SPSPaser.u(sps, 5, h264SPSPaser.getStartBit());
        this.profile_idc = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit());
        this.constraint_set0_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.constraint_set1_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.constraint_set2_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.constraint_set3_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.reserved_zero_4bits = h264SPSPaser.u(sps, 4, h264SPSPaser.getStartBit());
        this.level_idc = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit());
        this.seq_parameter_set_id = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        if (this.profile_idc == 100 || this.profile_idc == 110 || this.profile_idc == 122 || this.profile_idc == 144) {
            this.chroma_format_idc = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            if (this.chroma_format_idc == 3) {
                this.residual_colour_transform_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            }
            this.bit_depth_luma_minus8 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.bit_depth_chroma_minus8 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.qpprime_y_zero_transform_bypass_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            this.seq_scaling_matrix_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            if (this.seq_scaling_matrix_present_flag == 1) {
                this.seq_scaling_list_present_flag = new int[8];
                i = 0;
                while (i < 8) {
                    this.seq_scaling_list_present_flag[i] = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
                    ++i;
                }
            }
        }
        this.log2_max_frame_num_minus4 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        this.pic_order_cnt_type = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        if (this.pic_order_cnt_type == 0) {
            this.log2_max_pic_order_cnt_lsb_minus4 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        } else if (this.pic_order_cnt_type == 1) {
            this.delta_pic_order_always_zero_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            this.offset_for_non_ref_pic = h264SPSPaser.se(sps, h264SPSPaser.getStartBit());
            this.offset_for_top_to_bottom_field = h264SPSPaser.se(sps, h264SPSPaser.getStartBit());
            this.getNum_ref_frames_in_pic_prder_cnt_cycle = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.offset_for_ref_frame = new int[this.getNum_ref_frames_in_pic_prder_cnt_cycle];
            i = 0;
            while (i < this.getNum_ref_frames_in_pic_prder_cnt_cycle) {
                this.offset_for_ref_frame[i] = h264SPSPaser.se(sps, h264SPSPaser.getStartBit());
                ++i;
            }
        }
        this.num_ref_frames = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        this.gaps_in_frame_num_value_allowed_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.pic_width_in_mbs_minus_1 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        this.pic_height_in_map_units_minus_1 = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        this.frame_mbs_only_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        if (this.frame_mbs_only_flag == 0) {
            this.mb_adaptive_frame_field_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        }
        this.direct_8x8_inference_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        this.frame_cropping_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        if (this.frame_cropping_flag == 1) {
            this.frame_crop_left_offset = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.frame_crop_right_offset = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.frame_crop_top_offset = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            this.frame_crop_bottom_offset = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
        }
        this.vui_prameters_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
        if (this.vui_prameters_present_flag == 1) {
            short timing_info_present_flag;
            short chroma_loc_info_present_flag;
            short colour_description_present_flag;
            short video_signal_type_present_flag;
            short overscan_info_present_flag;
            short sar_width;
            short aspect_ratio_idc;
            short aspect_ratio_info_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            if (aspect_ratio_info_present_flag == 1 && (aspect_ratio_idc = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit())) == 255) {
                sar_width = h264SPSPaser.u(sps, 16, h264SPSPaser.getStartBit());
                short s = h264SPSPaser.u(sps, 16, h264SPSPaser.getStartBit());
            }
            if ((overscan_info_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit())) == 1) {
                sar_width = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
            }
            if ((video_signal_type_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit())) == 1) {
                short video_format = h264SPSPaser.u(sps, 3, h264SPSPaser.getStartBit());
                short video_full_range_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
                colour_description_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit());
                if (colour_description_present_flag == 1) {
                    short colour_primaries = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit());
                    short transfer_characteristics = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit());
                    short s = h264SPSPaser.u(sps, 8, h264SPSPaser.getStartBit());
                }
            }
            if ((chroma_loc_info_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit())) == 1) {
                short chroma_sample_loc_type_top_field = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
                colour_description_present_flag = h264SPSPaser.ue(sps, h264SPSPaser.getStartBit());
            }
            if ((timing_info_present_flag = h264SPSPaser.u(sps, 1, h264SPSPaser.getStartBit())) == 1) {
                short num_units_in_tick = h264SPSPaser.u(sps, 32, h264SPSPaser.getStartBit());
                short time_scale = h264SPSPaser.u(sps, 32, h264SPSPaser.getStartBit());
                this.fps = time_scale / (2 * num_units_in_tick);
            }
        }
        return this;
    }

    public int getForbidden_zero_bit() {
        return this.forbidden_zero_bit;
    }

    public void setForbidden_zero_bit(int forbidden_zero_bit) {
        this.forbidden_zero_bit = forbidden_zero_bit;
    }

    public int getNal_ref_idc() {
        return this.nal_ref_idc;
    }

    public void setNal_ref_idc(int nal_ref_idc) {
        this.nal_ref_idc = nal_ref_idc;
    }

    public int getNal_unit_type() {
        return this.nal_unit_type;
    }

    public void setNal_unit_type(int nal_unit_type) {
        this.nal_unit_type = nal_unit_type;
    }

    public int getProfile_idc() {
        return this.profile_idc;
    }

    public void setProfile_idc(int profile_idc) {
        this.profile_idc = profile_idc;
    }

    public int getConstraint_set0_flag() {
        return this.constraint_set0_flag;
    }

    public void setConstraint_set0_flag(int constraint_set0_flag) {
        this.constraint_set0_flag = constraint_set0_flag;
    }

    public int getConstraint_set1_flag() {
        return this.constraint_set1_flag;
    }

    public void setConstraint_set1_flag(int constraint_set1_flag) {
        this.constraint_set1_flag = constraint_set1_flag;
    }

    public int getConstraint_set2_flag() {
        return this.constraint_set2_flag;
    }

    public void setConstraint_set2_flag(int constraint_set2_flag) {
        this.constraint_set2_flag = constraint_set2_flag;
    }

    public int getConstraint_set3_flag() {
        return this.constraint_set3_flag;
    }

    public void setConstraint_set3_flag(int constraint_set3_flag) {
        this.constraint_set3_flag = constraint_set3_flag;
    }

    public int getReserved_zero_4bits() {
        return this.reserved_zero_4bits;
    }

    public void setReserved_zero_4bits(int reserved_zero_4bits) {
        this.reserved_zero_4bits = reserved_zero_4bits;
    }

    public int getLevel_idc() {
        return this.level_idc;
    }

    public void setLevel_idc(int level_idc) {
        this.level_idc = level_idc;
    }

    public int getSeq_parameter_set_id() {
        return this.seq_parameter_set_id;
    }

    public void setSeq_parameter_set_id(int seq_parameter_set_id) {
        this.seq_parameter_set_id = seq_parameter_set_id;
    }

    public int getChroma_format_idc() {
        return this.chroma_format_idc;
    }

    public void setChroma_format_idc(int chroma_format_idc) {
        this.chroma_format_idc = chroma_format_idc;
    }

    public int getResidual_colour_transform_flag() {
        return this.residual_colour_transform_flag;
    }

    public void setResidual_colour_transform_flag(int residual_colour_transform_flag) {
        this.residual_colour_transform_flag = residual_colour_transform_flag;
    }

    public int getBit_depth_luma_minus8() {
        return this.bit_depth_luma_minus8;
    }

    public void setBit_depth_luma_minus8(int bit_depth_luma_minus8) {
        this.bit_depth_luma_minus8 = bit_depth_luma_minus8;
    }

    public int getBit_depth_chroma_minus8() {
        return this.bit_depth_chroma_minus8;
    }

    public void setBit_depth_chroma_minus8(int bit_depth_chroma_minus8) {
        this.bit_depth_chroma_minus8 = bit_depth_chroma_minus8;
    }

    public int getQpprime_y_zero_transform_bypass_flag() {
        return this.qpprime_y_zero_transform_bypass_flag;
    }

    public void setQpprime_y_zero_transform_bypass_flag(int qpprime_y_zero_transform_bypass_flag) {
        this.qpprime_y_zero_transform_bypass_flag = qpprime_y_zero_transform_bypass_flag;
    }

    public int getSeq_scaling_matrix_present_flag() {
        return this.seq_scaling_matrix_present_flag;
    }

    public void setSeq_scaling_matrix_present_flag(int seq_scaling_matrix_present_flag) {
        this.seq_scaling_matrix_present_flag = seq_scaling_matrix_present_flag;
    }

    public int[] getSeq_scaling_list_present_flag() {
        return this.seq_scaling_list_present_flag;
    }

    public void setSeq_scaling_list_present_flag(int[] seq_scaling_list_present_flag) {
        this.seq_scaling_list_present_flag = seq_scaling_list_present_flag;
    }

    public int getLog2_max_frame_num_minus4() {
        return this.log2_max_frame_num_minus4;
    }

    public void setLog2_max_frame_num_minus4(int log2_max_frame_num_minus4) {
        this.log2_max_frame_num_minus4 = log2_max_frame_num_minus4;
    }

    public int getPic_order_cnt_type() {
        return this.pic_order_cnt_type;
    }

    public void setPic_order_cnt_type(int pic_order_cnt_type) {
        this.pic_order_cnt_type = pic_order_cnt_type;
    }

    public int getLog2_max_pic_order_cnt_lsb_minus4() {
        return this.log2_max_pic_order_cnt_lsb_minus4;
    }

    public void setLog2_max_pic_order_cnt_lsb_minus4(int log2_max_pic_order_cnt_lsb_minus4) {
        this.log2_max_pic_order_cnt_lsb_minus4 = log2_max_pic_order_cnt_lsb_minus4;
    }

    public int getDelta_pic_order_always_zero_flag() {
        return this.delta_pic_order_always_zero_flag;
    }

    public void setDelta_pic_order_always_zero_flag(int delta_pic_order_always_zero_flag) {
        this.delta_pic_order_always_zero_flag = delta_pic_order_always_zero_flag;
    }

    public int getOffset_for_non_ref_pic() {
        return this.offset_for_non_ref_pic;
    }

    public void setOffset_for_non_ref_pic(int offset_for_non_ref_pic) {
        this.offset_for_non_ref_pic = offset_for_non_ref_pic;
    }

    public int getOffset_for_top_to_bottom_field() {
        return this.offset_for_top_to_bottom_field;
    }

    public void setOffset_for_top_to_bottom_field(int offset_for_top_to_bottom_field) {
        this.offset_for_top_to_bottom_field = offset_for_top_to_bottom_field;
    }

    public int getGetNum_ref_frames_in_pic_prder_cnt_cycle() {
        return this.getNum_ref_frames_in_pic_prder_cnt_cycle;
    }

    public void setGetNum_ref_frames_in_pic_prder_cnt_cycle(int getNum_ref_frames_in_pic_prder_cnt_cycle) {
        this.getNum_ref_frames_in_pic_prder_cnt_cycle = getNum_ref_frames_in_pic_prder_cnt_cycle;
    }

    public int[] getOffset_for_ref_frame() {
        return this.offset_for_ref_frame;
    }

    public void setOffset_for_ref_frame(int[] offset_for_ref_frame) {
        this.offset_for_ref_frame = offset_for_ref_frame;
    }

    public int getNum_ref_frames() {
        return this.num_ref_frames;
    }

    public void setNum_ref_frames(int num_ref_frames) {
        this.num_ref_frames = num_ref_frames;
    }

    public int getGaps_in_frame_num_value_allowed_flag() {
        return this.gaps_in_frame_num_value_allowed_flag;
    }

    public void setGaps_in_frame_num_value_allowed_flag(int gaps_in_frame_num_value_allowed_flag) {
        this.gaps_in_frame_num_value_allowed_flag = gaps_in_frame_num_value_allowed_flag;
    }

    public int getPic_width_in_mbs_minus_1() {
        return this.pic_width_in_mbs_minus_1;
    }

    public void setPic_width_in_mbs_minus_1(int pic_width_in_mbs_minus_1) {
        this.pic_width_in_mbs_minus_1 = pic_width_in_mbs_minus_1;
    }

    public int getPic_height_in_map_units_minus_1() {
        return this.pic_height_in_map_units_minus_1;
    }

    public void setPic_height_in_map_units_minus_1(int pic_height_in_map_units_minus_1) {
        this.pic_height_in_map_units_minus_1 = pic_height_in_map_units_minus_1;
    }

    public int getFrame_mbs_only_flag() {
        return this.frame_mbs_only_flag;
    }

    public void setFrame_mbs_only_flag(int frame_mbs_only_flag) {
        this.frame_mbs_only_flag = frame_mbs_only_flag;
    }

    public int getMb_adaptive_frame_field_flag() {
        return this.mb_adaptive_frame_field_flag;
    }

    public void setMb_adaptive_frame_field_flag(int mb_adaptive_frame_field_flag) {
        this.mb_adaptive_frame_field_flag = mb_adaptive_frame_field_flag;
    }

    public int getDirect_8x8_inference_flag() {
        return this.direct_8x8_inference_flag;
    }

    public void setDirect_8x8_inference_flag(int direct_8x8_inference_flag) {
        this.direct_8x8_inference_flag = direct_8x8_inference_flag;
    }

    public int getFrame_cropping_flag() {
        return this.frame_cropping_flag;
    }

    public void setFrame_cropping_flag(int frame_cropping_flag) {
        this.frame_cropping_flag = frame_cropping_flag;
    }

    public int getFrame_crop_left_offset() {
        return this.frame_crop_left_offset;
    }

    public void setFrame_crop_left_offset(int frame_crop_left_offset) {
        this.frame_crop_left_offset = frame_crop_left_offset;
    }

    public int getFrame_crop_right_offset() {
        return this.frame_crop_right_offset;
    }

    public void setFrame_crop_right_offset(int frame_crop_right_offset) {
        this.frame_crop_right_offset = frame_crop_right_offset;
    }

    public int getFrame_crop_top_offset() {
        return this.frame_crop_top_offset;
    }

    public void setFrame_crop_top_offset(int frame_crop_top_offset) {
        this.frame_crop_top_offset = frame_crop_top_offset;
    }

    public int getFrame_crop_bottom_offset() {
        return this.frame_crop_bottom_offset;
    }

    public void setFrame_crop_bottom_offset(int frame_crop_bottom_offset) {
        this.frame_crop_bottom_offset = frame_crop_bottom_offset;
    }

    public int getVui_prameters_present_flag() {
        return this.vui_prameters_present_flag;
    }

    public void setVui_prameters_present_flag(int vui_prameters_present_flag) {
        this.vui_prameters_present_flag = vui_prameters_present_flag;
    }

    public int getVui_parameters() {
        return this.vui_parameters;
    }

    public void setVui_parameters(int vui_parameters) {
        this.vui_parameters = vui_parameters;
    }

    public int getRbsp_stop_one_bit() {
        return this.rbsp_stop_one_bit;
    }

    public void setRbsp_stop_one_bit(int rbsp_stop_one_bit) {
        this.rbsp_stop_one_bit = rbsp_stop_one_bit;
    }

    public int getWidth() {
        return H264SPSPaser.getWidth(this);
    }

    public int getHeight() {
        return H264SPSPaser.getHeight(this);
    }

    public int getFps() {
        return this.fps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SpsFrame{");
        sb.append("forbidden_zero_bit=").append(this.forbidden_zero_bit);
        sb.append(", nal_ref_idc=").append(this.nal_ref_idc);
        sb.append(", nal_unit_type=").append(this.nal_unit_type);
        sb.append(", profile_idc=").append(this.profile_idc);
        sb.append(", constraint_set0_flag=").append(this.constraint_set0_flag);
        sb.append(", constraint_set1_flag=").append(this.constraint_set1_flag);
        sb.append(", constraint_set2_flag=").append(this.constraint_set2_flag);
        sb.append(", constraint_set3_flag=").append(this.constraint_set3_flag);
        sb.append(", reserved_zero_4bits=").append(this.reserved_zero_4bits);
        sb.append(", level_idc=").append(this.level_idc);
        sb.append(", seq_parameter_set_id=").append(this.seq_parameter_set_id);
        sb.append(", chroma_format_idc=").append(this.chroma_format_idc);
        sb.append(", residual_colour_transform_flag=").append(this.residual_colour_transform_flag);
        sb.append(", bit_depth_luma_minus8=").append(this.bit_depth_luma_minus8);
        sb.append(", bit_depth_chroma_minus8=").append(this.bit_depth_chroma_minus8);
        sb.append(", qpprime_y_zero_transform_bypass_flag=").append(this.qpprime_y_zero_transform_bypass_flag);
        sb.append(", seq_scaling_matrix_present_flag=").append(this.seq_scaling_matrix_present_flag);
        sb.append(", seq_scaling_list_present_flag=").append(Arrays.toString(this.seq_scaling_list_present_flag));
        sb.append(", log2_max_frame_num_minus4=").append(this.log2_max_frame_num_minus4);
        sb.append(", pic_order_cnt_type=").append(this.pic_order_cnt_type);
        sb.append(", log2_max_pic_order_cnt_lsb_minus4=").append(this.log2_max_pic_order_cnt_lsb_minus4);
        sb.append(", delta_pic_order_always_zero_flag=").append(this.delta_pic_order_always_zero_flag);
        sb.append(", offset_for_non_ref_pic=").append(this.offset_for_non_ref_pic);
        sb.append(", offset_for_top_to_bottom_field=").append(this.offset_for_top_to_bottom_field);
        sb.append(", getNum_ref_frames_in_pic_prder_cnt_cycle=").append(this.getNum_ref_frames_in_pic_prder_cnt_cycle);
        sb.append(", offset_for_ref_frame=").append(Arrays.toString(this.offset_for_ref_frame));
        sb.append(", num_ref_frames=").append(this.num_ref_frames);
        sb.append(", gaps_in_frame_num_value_allowed_flag=").append(this.gaps_in_frame_num_value_allowed_flag);
        sb.append(", pic_width_in_mbs_minus_1=").append(this.pic_width_in_mbs_minus_1);
        sb.append(", pic_height_in_map_units_minus_1=").append(this.pic_height_in_map_units_minus_1);
        sb.append(", frame_mbs_only_flag=").append(this.frame_mbs_only_flag);
        sb.append(", mb_adaptive_frame_field_flag=").append(this.mb_adaptive_frame_field_flag);
        sb.append(", direct_8x8_inference_flag=").append(this.direct_8x8_inference_flag);
        sb.append(", frame_cropping_flag=").append(this.frame_cropping_flag);
        sb.append(", frame_crop_left_offset=").append(this.frame_crop_left_offset);
        sb.append(", frame_crop_right_offset=").append(this.frame_crop_right_offset);
        sb.append(", frame_crop_top_offset=").append(this.frame_crop_top_offset);
        sb.append(", frame_crop_bottom_offset=").append(this.frame_crop_bottom_offset);
        sb.append(", vui_prameters_present_flag=").append(this.vui_prameters_present_flag);
        sb.append(", vui_parameters=").append(this.vui_parameters);
        sb.append(", rbsp_stop_one_bit=").append(this.rbsp_stop_one_bit);
        sb.append('}');
        return sb.toString();
    }
}

