/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.pass.filter.MainHostPassFilter;
import com.wovoe.carpark.pass.filter.PassChargeFilter;
import com.wovoe.carpark.pass.filter.PassEnterRecordNotFoundFilter;
import com.wovoe.carpark.pass.filter.PassExpiredFilter;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.PassFilterChain;
import com.wovoe.carpark.pass.filter.PassJudgeFilter;
import com.wovoe.carpark.pass.filter.PassNosensePayFilter;
import com.wovoe.carpark.pass.filter.PassParkingFullFilter;
import com.wovoe.carpark.pass.filter.PassPermissionFilter;
import com.wovoe.carpark.pass.filter.PassRepeatEnterFilter;
import com.wovoe.carpark.pass.filter.PassSessionCheckOldDialogFilter;
import com.wovoe.carpark.pass.filter.PassSuccessFilter;
import com.wovoe.carpark.pass.filter.PassVisitPassTypeFilter;
import com.wovoe.carpark.pass.filter.SavePassDataFilter;
import com.wovoe.carpark.pass.filter.WuhanPlateCheckFilter;
import com.wovoe.carpark.pass.filter.YiChangPlateCheckFilter;
import com.wovoe.carpark.pass.filter.YongchengPlateCheckFilter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultPassFilterChain
implements PassFilterChain {
    private CopyOnWriteArrayList<PassFilter> filterChain = new CopyOnWriteArrayList();

    public DefaultPassFilterChain() {
        this.filterChain.add(new MainHostPassFilter());
        this.filterChain.add(new PassSessionCheckOldDialogFilter());
        this.filterChain.add(new YongchengPlateCheckFilter());
        this.filterChain.add(new WuhanPlateCheckFilter());
        this.filterChain.add(new YiChangPlateCheckFilter());
        this.filterChain.add(new PassVisitPassTypeFilter());
        this.filterChain.add(new PassPermissionFilter());
        this.filterChain.add(new PassEnterRecordNotFoundFilter());
        this.filterChain.add(new PassRepeatEnterFilter());
        this.filterChain.add(new PassExpiredFilter());
        this.filterChain.add(new PassParkingFullFilter());
        this.filterChain.add(new PassChargeFilter());
        this.filterChain.add(new PassNosensePayFilter());
        this.filterChain.add(new PassJudgeFilter());
        this.filterChain.add(new SavePassDataFilter());
        this.filterChain.add(new PassSuccessFilter());
    }

    @Override
    public void execute(PassSession session) throws Exception {
        for (PassFilter filter : this.filterChain) {
            if (filter.doFilter(session)) continue;
            if (session.getSessionState() != PassSession.SessionState.PROCESSING) break;
            session.setSessionState(PassSession.SessionState.CANCELED);
            break;
        }
    }

    @Override
    public Enumeration<PassFilter> getPassFilters() {
        return Collections.enumeration(this.filterChain);
    }

    @Override
    public boolean removePassFilter(PassFilter filter) {
        return this.filterChain.remove(filter);
    }

    @Override
    public void addPassFilter(PassFilter filter) {
        this.filterChain.add(filter);
    }

    @Override
    public void excecutePassFilterAndBehind(PassSession session, PassFilter filter) throws Exception {
        boolean execute = false;
        for (PassFilter f : this.filterChain) {
            if (!execute && f.equals(filter)) {
                execute = true;
            }
            if (!execute || f.doFilter(session)) continue;
            if (session.getSessionState() != PassSession.SessionState.PROCESSING) break;
            session.setSessionState(PassSession.SessionState.CANCELED);
            break;
        }
    }

    @Override
    public void excecuteBehindPassFilters(PassSession session, PassFilter filter) throws Exception {
        boolean execute = false;
        for (PassFilter f : this.filterChain) {
            if (execute) {
                if (f.doFilter(session)) continue;
                if (session.getSessionState() != PassSession.SessionState.PROCESSING) break;
                session.setSessionState(PassSession.SessionState.CANCELED);
                break;
            }
            if (!f.equals(filter)) continue;
            execute = true;
        }
    }

    @Override
    public PassFilter getChargePassFilter() {
        for (PassFilter f : this.filterChain) {
            if (!(f instanceof PassChargeFilter)) continue;
            return f;
        }
        return null;
    }

    @Override
    public PassFilter getSuccessPassFilter() {
        for (PassFilter f : this.filterChain) {
            if (!(f instanceof PassSuccessFilter)) continue;
            return f;
        }
        return null;
    }

    @Override
    public PassFilter getSavePassDataFilter() {
        for (PassFilter f : this.filterChain) {
            if (!(f instanceof SavePassDataFilter)) continue;
            return f;
        }
        return null;
    }
}

