/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.net.LanPassChannelHandleAction;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.event.app.ConfirmPassEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.PassFilterChain;
import com.wovoe.carpark.pass.filter.PassJudgeFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.UpgradeService;
import com.wovoe.carpark.vo.PassSessionData;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;

public class MainHostPassFilter
implements PassFilter {
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        CarparkHost host;
        String slaveHostNo;
        if (session.isTempSession()) {
            return true;
        }
        if (session.getReadPassportNumberEvent() == null) {
            return true;
        }
        if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
            return true;
        }
        if (session.getAttribute("GUI_CONFIRM") != null) {
            return this.doFilterGuiConfirm(session);
        }
        PassSessionData passSessionData0 = session.getReadPassportNumberEvent().getPassSessionData();
        if (passSessionData0 != null) {
            OperationFutureHandler<PassSession> of = session.getReadPassportNumberEvent().getSetPassSessionDataHandler();
            if (MainHostPassFilter.setPassSessionData(session, passSessionData0, true, true, passSessionData0.getRegPlate())) {
                if (of != null) {
                    of.setResult((Object)session);
                }
            } else {
                session.setSessionState(PassSession.SessionState.CANCELED);
                of.setResult(null);
            }
            return false;
        }
        if (session.getReadPassportNumberEvent().isManualTrigger()) {
            if (session.getAttribute("StartNewManualSession") == null) {
                session.setAttribute("StartNewManualSession", Boolean.TRUE);
                return this.doStartNewManualSession(session);
            }
            return true;
        }
        if (session.getReadPassportNumberEvent().isUserScan()) {
            return true;
        }
        boolean isSwipCard = session.getPassChannel().isSwipeCard(session);
        if (isSwipCard) {
            return true;
        }
        PlateRecognizedEvent plateRecognizedEvent0 = session.getPlateRecognizedEvent();
        if (plateRecognizedEvent0 == null) {
            plateRecognizedEvent0 = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
        }
        if (plateRecognizedEvent0 == null) {
            return true;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            if (isSwipCard) {
                return true;
            }
            String regPlate = plateRecognizedEvent0.getPlateNumber();
            String tvMsg = "\u8f66\u724c: " + regPlate;
            HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
            if (state == null || state.getLanSocketAddress() == null) {
                String msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ":\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u672a\u8fde\u63a5\uff0c\u672c\u673a\u5c06\u5904\u7406" + tvMsg;
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                return true;
            }
            int i = 0;
            while (i < 2) {
                block33: {
                    PassSessionData passSessionData;
                    String msg;
                    block34: {
                        block32: {
                            block31: {
                                block30: {
                                    KeyValueEntry entry;
                                    block29: {
                                        block28: {
                                            OperationFuture<KeyValueEntry<String, PassSessionData>> fl = LanPassChannelHandleAction.queryPassSessionData(host.getHost_no(), state.getLanSocketAddress(), session.getPassChannel().getChannelNo(), regPlate, session.getSessionId(), plateRecognizedEvent0.getCarmeraRegTimeMills());
                                            try {
                                                long x6 = ServiceUtil.getServiceContext().currentTimeMillis();
                                                entry = (KeyValueEntry)fl.get(7000L, TimeUnit.MILLISECONDS);
                                                ServiceLog.getLog().info((Object)("\u67e5\u8be2\u76d2\u5b50\u5904\u7406" + tvMsg + " \u8017\u65f6" + (ServiceUtil.getServiceContext().currentTimeMillis() - x6) + "\u6beb\u79d2"));
                                                if (entry != null) break block28;
                                                msg = "\u67e5\u8be2" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u5904\u7406\u72b6\u6001\u8d85\u65f6! \u672c\u673a\u5c06\u5904\u7406" + tvMsg;
                                                ServiceLog.getLog().warn((Object)msg);
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                                                return true;
                                            }
                                            catch (Throwable ex) {
                                                if (fl.getException() != null) {
                                                    ex = fl.getException();
                                                }
                                                String msg2 = "\u67e5\u8be2" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u5904\u7406\u72b6\u6001\u5f02\u5e38! \u539f\u56e0: " + ex.getMessage() + "\uff0c\u672c\u673a\u5c06\u5904\u7406 " + tvMsg;
                                                ServiceLog.getLog().warn((Object)msg2);
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg2, 3));
                                                return true;
                                            }
                                        }
                                        if (entry.getKey() == null || !((String)entry.getKey()).startsWith("discard:")) break block29;
                                        session.setSessionState(PassSession.SessionState.CANCELED);
                                        session.getPassChannel().invalidateSession(session);
                                        ServiceLog.getLog().info((Object)("\u505c\u8f66\u76d2\u5b50\u8981\u6c42\u4e22\u5f03\u6b64\u8f66\u724c: " + regPlate + ", " + (String)entry.getKey()));
                                        return false;
                                    }
                                    passSessionData = (PassSessionData)entry.getValue();
                                    if (passSessionData != null) break block30;
                                    String errMsg = (String)entry.getKey();
                                    errMsg = errMsg == null || errMsg.length() == 0 ? "" : "\u539f\u56e0\uff1a" + errMsg;
                                    String msg3 = "\u67e5\u8be2" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u5904\u7406\u72b6\u6001\u5931\u8d25! " + errMsg + " \u672c\u673a\u5c06\u5904\u7406" + tvMsg;
                                    ServiceLog.getLog().warn((Object)msg3);
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg3, 3));
                                    return true;
                                }
                                if (passSessionData.getSessionStateName() != null && passSessionData.getSessionStateName().length() != 0) break block31;
                                msg = "\u67e5\u8be2" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u5904\u7406\u72b6\u6001\u5931\u8d25!  \u54cd\u5e94\u7f3a\u5c11\u72b6\u6001\u4fe1\u606f! \u672c\u673a\u5c06\u5904\u7406: " + tvMsg;
                                ServiceLog.getLog().warn((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                                return true;
                            }
                            if (!PassSession.SessionState.PROCESSING.name().equals(passSessionData.getSessionStateName()) && !PassSession.SessionState.PENDING.name().equals(passSessionData.getSessionStateName())) break block32;
                            if (i == 0) {
                                msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u6b63\u5728\u5904\u7406" + tvMsg;
                                ServiceLog.getLog().warn((Object)(String.valueOf(msg) + ", \u5904\u7406\u5df2\u8d85\u8fc74S\uff0c\u8bf7\u68c0\u67e5"));
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 1));
                                break block33;
                            }
                            if (i != 1) break block32;
                            msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u5904\u7406\u65f6\u95f4\u8d85\u65f6\uff01\u672c\u673a\u5c06\u5904\u7406" + tvMsg;
                            ServiceLog.getLog().warn((Object)msg);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                            return true;
                        }
                        if (!MainHostPassFilter.setPassSessionData(session, passSessionData, true, true, regPlate)) break block34;
                        session.setAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no(), String.valueOf(passSessionData.getSessionId()));
                        ServiceLog.getLog().info((Object)("\u76d2\u5b50\u5df2\u5904\u7406\uff1a" + tvMsg + ", \u8f66\u724c\u8bc6\u522b\u65f6\u95f4(\u76f8\u673a)\uff1a" + (plateRecognizedEvent0.getCarmeraRegTimeMills() == null ? "" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(plateRecognizedEvent0.getCarmeraRegTimeMills())))));
                        return false;
                    }
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u8fd4\u56de\u672a\u77e5\u7684\u5904\u7406\u72b6\u6001" + passSessionData.getSessionStateName() + "\uff01\u672c\u673a\u5c06\u5904\u7406" + tvMsg;
                    ServiceLog.getLog().warn((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean doStartNewManualSession(PassSession session) throws Exception {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            PassSessionData passSessionData;
            OperationFuture<KeyValueEntry<String, PassSessionData>> fl;
            block16: {
                block15: {
                    KeyValueEntry entry;
                    block14: {
                        HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
                        if (state == null || state.getLanSocketAddress() == null) {
                            return true;
                        }
                        if (state.getVer() == null || state.getVer().length() == 0) {
                            return true;
                        }
                        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                        if (upgradeService.compareVersion(state.getVer(), "6.2.6.38") < 0) {
                            return true;
                        }
                        ApplicationService appSerivce = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        UserSession userSession = appSerivce.getUserSession();
                        if (userSession == null) {
                            return true;
                        }
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("channelNo", session.getPassChannel().getChannelNo());
                        paramMap.put("refSessionId", String.valueOf(session.getSessionId()));
                        paramMap.put("opUserCode", userSession.getUser().getUser_code());
                        paramMap.put("opUserName", userSession.getUser().getUser_name());
                        if (userSession.getDutyNumber() != null) {
                            paramMap.put("dutyNumber", userSession.getDutyNumber().getDuty_no());
                        }
                        if (!"\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
                            paramMap.put("inputPlate", session.getReadPassportNumberEvent().getPassportNumber());
                        }
                        fl = LanPassChannelHandleAction.doLanStartManualConfirmSession(state.getHostNo(), state.getLanSocketAddress(), paramMap);
                        entry = (KeyValueEntry)fl.get(6000L, TimeUnit.MILLISECONDS);
                        if (entry != null) break block14;
                        String msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u542f\u52a8\u4eba\u5de5\u653e\u884c\u7a97\u53e3\u64cd\u4f5c\u8d85\u65f6! \u672c\u673a\u5c06\u542f\u52a8\u65b0\u7a97\u53e3\u3002";
                        ServiceLog.getLog().warn((Object)msg);
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                        return true;
                    }
                    passSessionData = (PassSessionData)entry.getValue();
                    if (passSessionData != null) break block15;
                    String errMsg = (String)entry.getKey();
                    errMsg = errMsg == null || errMsg.length() == 0 ? "" : "\u539f\u56e0\uff1a" + errMsg;
                    String msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u542f\u52a8\u4eba\u5de5\u653e\u884c\u7a97\u53e3\u5931\u8d25! \u672c\u673a\u5c06\u542f\u52a8\u65b0\u7a97\u53e3\u3002";
                    ServiceLog.getLog().warn((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                    return true;
                }
                if (PassSession.SessionState.OPEN_DIALOG.name().equals(passSessionData.getSessionStateName())) break block16;
                String msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u542f\u52a8\u4eba\u5de5\u653e\u884c\u7a97\u53e3\u8fd4\u56de\u9519\u8bef\u7a97\u53e3\u72b6\u6001! \u672c\u673a\u5c06\u542f\u52a8\u65b0\u7a97\u53e3\u3002";
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                return true;
            }
            try {
                boolean success = MainHostPassFilter.setPassSessionData(session, passSessionData, false, true, null);
                if (success) {
                    session.setAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no(), String.valueOf(passSessionData.getSessionId()));
                    return false;
                }
            }
            catch (Throwable ex) {
                if (fl.getException() != null) {
                    ex = fl.getException();
                }
                String msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u542f\u52a8\u4eba\u5de5\u653e\u884c\u7a97\u53e3\u5931\u8d25! \u539f\u56e0: " + ex.getMessage() + "\uff0c\u672c\u673a\u5c06\u542f\u52a8\u65b0\u7a97\u53e3\u3002 ";
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
            }
        }
        return true;
    }

    private boolean doFilterGuiConfirm(PassSession session) throws Exception {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
            if (state == null || state.getLanSocketAddress() == null) {
                return true;
            }
            String remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no());
            if (remoteSessionId == null || remoteSessionId.length() == 0) {
                return true;
            }
            String plateNumber = session.getReadPassportNumberEvent().getPlateNumber();
            if (plateNumber != null && (plateNumber.length() == 7 || plateNumber.length() == 8)) {
                PassSessionData passSessionData;
                OperationFuture<KeyValueEntry<String, PassSessionData>> fl;
                String tPlate;
                String tMsg;
                block17: {
                    KeyValueEntry entry;
                    block16: {
                        int passportMediumType = session.getReadPassportNumberEvent().getPassportMediumType();
                        String passportNumber = session.getReadPassportNumberEvent().getPassportNumber();
                        String qprPassportNumber = session.getReadPassportNumberEvent().getQueryPreseceRecordPassportNumber();
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("channelNo", session.getPassChannel().getChannelNo());
                        paramMap.put("passSessionId", remoteSessionId);
                        paramMap.put("passportMediumType", String.valueOf(passportMediumType));
                        paramMap.put("passportNumber", passportNumber);
                        if (qprPassportNumber != null && qprPassportNumber.length() > 0) {
                            paramMap.put("qprPassportNumber", qprPassportNumber);
                        }
                        if (plateNumber != null && plateNumber.length() > 0) {
                            paramMap.put("plateNumber", plateNumber);
                        }
                        paramMap.put("modifyItem", "passPlate");
                        paramMap.put("modifyValue", plateNumber == null || plateNumber.length() == 0 ? passportNumber : plateNumber);
                        tMsg = null;
                        if (qprPassportNumber != null && qprPassportNumber.length() > 0) {
                            tPlate = qprPassportNumber;
                            tMsg = "\u5339\u914d";
                        } else if (plateNumber != null && plateNumber.length() > 0) {
                            tPlate = plateNumber;
                            tMsg = "\u4fee\u6539";
                        } else {
                            tPlate = passportNumber;
                            tMsg = "\u4fee\u6539";
                        }
                        fl = LanPassChannelHandleAction.doLanUpdateConfirmPassInfo(state.getHostNo(), state.getLanSocketAddress(), paramMap);
                        entry = (KeyValueEntry)fl.get(6000L, TimeUnit.MILLISECONDS);
                        if (entry != null) break block16;
                        String msg = String.valueOf(tMsg) + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u8f66\u724c\u64cd\u4f5c\u8d85\u65f6! \u672c\u673a\u5c06\u5904\u7406\u8f66\u724c: " + tPlate;
                        ServiceLog.getLog().warn((Object)msg);
                        return true;
                    }
                    passSessionData = (PassSessionData)entry.getValue();
                    if (passSessionData != null) break block17;
                    String errMsg = (String)entry.getKey();
                    errMsg = errMsg == null || errMsg.length() == 0 ? "" : "\u539f\u56e0\uff1a" + errMsg;
                    String msg = String.valueOf(tMsg) + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u8f66\u724c\u64cd\u4f5c\u5931\u8d25! " + errMsg + " \u672c\u673a\u5c06\u5904\u7406\u8f66\u724c: " + tPlate;
                    ServiceLog.getLog().warn((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                    return true;
                }
                try {
                    boolean success = MainHostPassFilter.setPassSessionData(session, passSessionData, false, false, plateNumber);
                    if (success) {
                        return false;
                    }
                }
                catch (Throwable ex) {
                    if (fl.getException() != null) {
                        ex = fl.getException();
                    }
                    String msg = String.valueOf(tMsg) + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u8f66\u724c\u64cd\u4f5c\u5931\u8d25! \u539f\u56e0: " + ex.getMessage() + "\uff0c\u672c\u673a\u5c06\u5904\u7406\u8f66\u724c: " + tPlate;
                    ServiceLog.getLog().warn((Object)msg);
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setPassSessionData(PassSession session, PassSessionData passSessionData, boolean throwMsg, boolean throwConfirm, String plateNumber) {
        if (session == null) return false;
        if (passSessionData == null) {
            return false;
        }
        isSwipeCard = session.getPassChannel().isSwipeCard(session);
        isManual = session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() != false;
        keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
        lockKey = ServiceUtil.getConfirmDialogHandelrLock(keyLockManager, session.getPassChannel().getChannelNo(), session.getSessionId());
        var9_9 = lockKey;
        synchronized (var9_9) {
            block73: {
                block77: {
                    block74: {
                        block76: {
                            block75: {
                                if (!throwConfirm || passSessionData.getRegPlate() == null || passSessionData.getRegPlate().length() <= 0 || isSwipeCard || isManual) break block74;
                                plateRecognizedEvent = session.getPlateRecognizedEvent();
                                if (plateRecognizedEvent == null) {
                                    plateRecognizedEvent = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
                                }
                                if (plateRecognizedEvent == null || passSessionData.getRegPlate().equals(plateRecognizedEvent.getPlateNumber())) break block74;
                                ev1 = null;
                                if (plateRecognizedEvent.getMutiCameraRecognizedEventList() != null && !plateRecognizedEvent.getMutiCameraRecognizedEventList().isEmpty()) {
                                    for (PlateRecognizedEvent e : plateRecognizedEvent.getMutiCameraRecognizedEventList()) {
                                        if (!plateRecognizedEvent.getPlateNumber().equals(e.getPlateNumber())) continue;
                                        ev1 = e;
                                        break;
                                    }
                                }
                                if (ev1 == null) break block75;
                                ServiceLog.getLog().info((Object)("\u901a\u9053\uff1a" + session.getPassChannel().getChannel().getChannel_name() + "\u51fa\u73b0\u591a\u4e2a\u76f8\u673a\u8bc6\u522b\u5230\u4e86\u4e0d\u540c\u8f66\u724c\uff0c\u7535\u8111\u5904\u7406\u4e3a: " + plateRecognizedEvent.getPlateNumber() + ", \u505c\u8f66\u76d2\u5b50\u5904\u7406\u4e3a: " + passSessionData.getRegPlate() + ", \u8fd9\u5c06\u4ee5\u505c\u8f66\u76d2\u5b50\u5904\u7406\u4e3a\u51c6"));
                                plateNumber = ev1.getPlateNumber();
                                plateE = new HashMap<String, PlateRecognizedEvent>();
                                plateE.put(plateRecognizedEvent.getPlateNumber(), plateRecognizedEvent);
                                if (plateRecognizedEvent.getMutiCameraRecognizedEventList() == null || plateRecognizedEvent.getMutiCameraRecognizedEventList().isEmpty()) break block76;
                                var14_14 = plateRecognizedEvent.getMutiCameraRecognizedEventList().iterator();
                                if (true) ** GOTO lbl46
                            }
                            msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ": \u76d2\u5b50\u653e\u884c\u5904\u7406\u8f66\u724c: " + passSessionData.getRegPlate() + ", \u4f46\u7535\u8111\u672a\u63a5\u6536\u5230\u6b64\u8f66\u724c\uff01\u672c\u673a\u63a5\u6536\u5230\u7684\u8f66\u724c\uff1a" + plateRecognizedEvent.getPlateNumber() + ", \u8f66\u724c\u4e0d\u4e00\u81f4\uff01";
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                            ServiceLog.getLog().warn((Object)msg);
                            if (session.getPlateRecognizedEvent() != null) {
                                session.getPlateRecognizedEvent().setPlateNumber(passSessionData.getRegPlate());
                            }
                            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getPlateRecognizedEvent() != null) {
                                session.getReadPassportNumberEvent().getPlateRecognizedEvent().setPlateNumber(passSessionData.getRegPlate());
                            }
                            plateNumber = passSessionData.getRegPlate();
                            break block74;
                            do {
                                e = var14_14.next();
                                plateE.put(e.getPlateNumber(), e);
lbl46:
                                // 2 sources

                            } while (var14_14.hasNext());
                        }
                        plateRecognizedEvent = ev1;
                        plateE.remove(plateRecognizedEvent.getPlateNumber());
                        if (!plateE.isEmpty()) {
                            plateRecognizedEvent.setMutiCameraRecognizedEventList(plateE.values());
                        } else {
                            plateRecognizedEvent.setMutiCameraRecognizedEventList(null);
                        }
                        if (session.getPlateRecognizedEvent() != null) {
                            session.setPlateRecognizedEvent(plateRecognizedEvent);
                        }
                        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getPlateRecognizedEvent() != null) {
                            session.getReadPassportNumberEvent().setPlateRecognizedEvent(plateRecognizedEvent);
                        }
                    }
                    if (isSwipeCard) {
                        cardNo = session.getReadPassportNumberEvent().getPassportNumber();
                        tvMsg = "\u5361\u53f7: " + cardNo;
                    } else {
                        cardNo = null;
                        tvMsg = "\u8f66\u724c: " + plateNumber;
                    }
                    if (passSessionData.getConfirmPassExceptions() != null && session.getConfirmPassExceptions() != null) {
                        session.getConfirmPassExceptions().clear();
                        session.getConfirmPassExceptions().addAll(passSessionData.getConfirmPassExceptions());
                    }
                    if (passSessionData.getForbidPassExceptions() != null && session.getForbidPassExceptions() != null) {
                        session.getForbidPassExceptions().clear();
                        session.getForbidPassExceptions().addAll(passSessionData.getForbidPassExceptions());
                    }
                    if (passSessionData.getAllowPassExceptions() != null && session.getAllowPassExcetpions() != null) {
                        session.getAllowPassExcetpions().clear();
                        session.getAllowPassExcetpions().addAll(passSessionData.getAllowPassExceptions());
                    }
                    if (passSessionData.getPassTime() != null) {
                        session.setAttribute("passTime", passSessionData.getPassTime());
                    }
                    if (passSessionData.getLastMatchPassRecord() == null) {
                        session.removeAttribute("NO_ENTRY_MARCH_RECORD");
                    } else {
                        session.setAttribute("NO_ENTRY_MARCH_RECORD", passSessionData.getLastMatchPassRecord());
                    }
                    if (!PassSession.SessionState.CANCELED.name().equals(passSessionData.getSessionStateName())) break block77;
                    var13_12 = session.getForbidPassExceptions().iterator();
                    if (true) ** GOTO lbl225
                }
                if (PassSession.SessionState.WAIT_PAY.name().equals(passSessionData.getSessionStateName()) || PassSession.SessionState.OPEN_DIALOG.name().equals(passSessionData.getSessionStateName())) {
                    session.setChargeFilter(ServiceUtil.getServiceContext().getPassFilterChain().getChargePassFilter());
                    if (passSessionData.getAreaPresenceRecordMap() != null) {
                        session.setAttribute("areaPresenceRecordMap", passSessionData.getAreaPresenceRecordMap());
                    } else {
                        session.setAttribute("areaPresenceRecordMap", new LinkedHashMap<K, V>());
                    }
                    if (passSessionData.getTakeChargeRecord() != null) {
                        session.setAttribute("takeChargeRecord", passSessionData.getTakeChargeRecord());
                    } else {
                        session.removeAttribute("takeChargeRecord");
                    }
                    if (passSessionData.getOccupyChargeRecord() != null) {
                        session.setAttribute("occupyChargeRecord", passSessionData.getOccupyChargeRecord());
                    } else {
                        session.removeAttribute("occupyChargeRecord");
                    }
                    if (passSessionData.getChangePassTypeRecord() != null) {
                        session.setAttribute("changePassTypeRecord", passSessionData.getChangePassTypeRecord());
                    } else {
                        session.removeAttribute("changePassTypeRecord");
                    }
                    if (passSessionData.getExistMutiCarCount() != null) {
                        session.setAttribute("EXIST_MUTI_CAR_COUNT", passSessionData.getExistMutiCarCount());
                    } else {
                        session.removeAttribute("EXIST_MUTI_CAR_COUNT");
                    }
                    if (passSessionData.getExistMutiCarEnterRecords() != null) {
                        session.setAttribute("existMutiCarEnterRecords", passSessionData.getExistMutiCarEnterRecords());
                    } else {
                        session.removeAttribute("existMutiCarEnterRecords");
                    }
                    if (passSessionData.getDefaultCarTypeNo() != null && passSessionData.getDefaultCarTypeNo().length() > 0) {
                        session.setAttribute("DEFAULT_CARTYPE_NO", passSessionData.getDefaultCarTypeNo());
                    }
                    if (passSessionData.getCost() != null) {
                        session.setAttribute("pass_cost", passSessionData.getCost());
                    } else {
                        zeroCost = new Cost();
                        zeroCost.setShouldCharged(Cost.ZERO);
                        zeroCost.setCash(Cost.ZERO);
                        zeroCost.setDeduct_money(Cost.ZERO);
                        session.setAttribute("pass_cost", zeroCost);
                    }
                    if (passSessionData.getPassport() != null) {
                        session.setPassport(passSessionData.getPassport());
                    }
                    if (passSessionData.getPassportType() != null) {
                        session.setPassportType(passSessionData.getPassportType());
                    }
                    if (passSessionData.getCarType() != null) {
                        session.setCarType(passSessionData.getCarType());
                    }
                    if (passSessionData.getCarOwner() != null) {
                        session.setCarOwner(passSessionData.getCarOwner());
                    }
                    if (passSessionData.getVisitCar() != null) {
                        session.setVisitCar(passSessionData.getVisitCar());
                    }
                    if (passSessionData.getDatabasePassport() != null) {
                        session.setDatabasePassport(passSessionData.getDatabasePassport());
                    } else {
                        session.setDatabasePassport(null);
                    }
                    if (passSessionData.getDatabasePassportType() != null) {
                        session.setDatabasePassportType(session.getDatabasePassportType());
                    } else {
                        session.setDatabasePassportType(null);
                    }
                    if (passSessionData.getPassportMediumType() != null) {
                        session.getReadPassportNumberEvent().setPassportMediumType(passSessionData.getPassportMediumType());
                    }
                    if (passSessionData.getPassportNumber() != null && passSessionData.getPassportNumber().length() > 0) {
                        session.getReadPassportNumberEvent().setPassportNumber(passSessionData.getPassportNumber());
                    }
                    if (passSessionData.getQprPassportNumber() != null && passSessionData.getQprPassportNumber().length() > 0) {
                        session.getReadPassportNumberEvent().setQueryPreseceRecordPassportNumber(passSessionData.getQprPassportNumber());
                    } else {
                        session.getReadPassportNumberEvent().setQueryPreseceRecordPassportNumber(null);
                    }
                    if (passSessionData.getPlateNumber() != null && passSessionData.getPlateNumber().length() > 0) {
                        session.getReadPassportNumberEvent().setPlateNumber(passSessionData.getPlateNumber());
                    }
                    if (passSessionData.getEscapeOrder() != null) {
                        session.setAttribute("ESCAPE_ORDER", passSessionData.getEscapeOrder());
                    } else {
                        session.removeAttribute("ESCAPE_ORDER");
                    }
                    session.setAttribute("CONFIRM_SESSION_DATA_FROM_BOX", Boolean.TRUE);
                    if (PassSession.SessionState.WAIT_PAY.name().equals(passSessionData.getSessionStateName())) {
                        session.setAttribute("PLAY_HANDLE_SESSION_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
                        session.setSessionState(PassSession.SessionState.WAIT_PAY);
                    } else {
                        session.setAttribute("PLAY_HANDLE_SESSION_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
                        session.setConfirmPassFilter(MainHostPassFilter.getPassJudgeFilter(ServiceUtil.getServiceContext().getPassFilterChain()));
                        session.setSessionState(PassSession.SessionState.OPEN_DIALOG);
                        if (throwConfirm) {
                            session.resetSessionTimeoutMills((int)TimeUnit.MINUTES.toMillis(15L));
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new ConfirmPassEvent(session.getPassChannel(), session));
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 55] lbl172 : MonitorExitStatement: MONITOREXIT : var9_9
                    keyLockManager.releaseLock(lockKey);
                    return true;
                }
                if (!PassSession.SessionState.WAIT_CAR_LEAVE.name().equals(passSessionData.getSessionStateName()) && !PassSession.SessionState.CAR_LEAVING.name().equals(passSessionData.getSessionStateName()) && !PassSession.SessionState.CAR_LEFT.name().equals(passSessionData.getSessionStateName())) break block73;
                session.setChargeFilter(ServiceUtil.getServiceContext().getPassFilterChain().getChargePassFilter());
                session.setConfirmPassFilter(MainHostPassFilter.getPassJudgeFilter(ServiceUtil.getServiceContext().getPassFilterChain()));
                if (passSessionData.getPassRecordList() != null && !passSessionData.getPassRecordList().isEmpty()) {
                    session.setAttribute("SAVED_PASSRECORD_LIST", passSessionData.getPassRecordList());
                }
                if (passSessionData.getSavedPassRecordMills() != null) {
                    session.setAttribute("SAVED_PASSRECORD_MILLS", session.getCreatedTimeMills() + passSessionData.getSavedPassRecordMills());
                }
                if (passSessionData.getCost() != null) {
                    session.setAttribute("pass_cost", passSessionData.getCost());
                }
                session.setSessionState(PassSession.SessionState.CAR_LEAVING);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 6] lbl186 : MonitorExitStatement: MONITOREXIT : var9_9
                keyLockManager.releaseLock(lockKey);
                return true;
            }
            return false;
            do {
                if ((a = (Integer)var13_12.next()) == 1) {
                    if (!throwMsg) break;
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u65e0\u6743\u9650\uff0c\u7981\u6b62\u901a\u884c";
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                    break;
                }
                if (a == 2) {
                    if (!throwMsg) break;
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u91cd\u590d\u5165\u573a";
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                    break;
                }
                if (a == 3) {
                    if (!throwMsg) break;
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u672a\u5165\u573a";
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                    break;
                }
                if (a == 4) {
                    if (!throwMsg) break;
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u6708\u5361\u5df2\u8fc7\u671f";
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                    break;
                }
                if (a == 5) {
                    if (!throwMsg) break;
                    msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u505c\u8f66\u4f4d\u5df2\u6ee1\uff0c\u7981\u6b62\u5165\u573a";
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                    break;
                }
                if (a != 6) continue;
                if (!throwMsg) break;
                msg = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + ", " + tvMsg + ", \u9ed1\u540d\u5355\u8f66\uff0c\u7981\u6b62\u901a\u884c";
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 4));
                break;
lbl225:
                // 2 sources

            } while (var13_12.hasNext());
            session.setSessionState(PassSession.SessionState.CANCELED);
            // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl225 : MonitorExitStatement: MONITOREXIT : var9_9
            keyLockManager.releaseLock(lockKey);
            return true;
        }
    }

    private static PassJudgeFilter getPassJudgeFilter(PassFilterChain chain) {
        Enumeration<PassFilter> enus = chain.getPassFilters();
        while (enus.hasMoreElements()) {
            PassFilter f = enus.nextElement();
            if (!(f instanceof PassJudgeFilter)) continue;
            return (PassJudgeFilter)f;
        }
        return null;
    }

    public static boolean doLanRemoteModify(PassSession session, String modifyItem, String modifyValue) {
        CarparkHost host;
        String slaveHostNo;
        if (session == null || modifyItem == null || modifyItem.length() == 0 || modifyValue == null || modifyValue.length() == 0) {
            return false;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            PassSessionData passSessionData;
            OperationFuture<KeyValueEntry<String, PassSessionData>> fl;
            block11: {
                KeyValueEntry entry;
                block10: {
                    HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
                    if (state == null || state.getLanSocketAddress() == null) {
                        return false;
                    }
                    String remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no());
                    if (remoteSessionId == null || remoteSessionId.length() == 0) {
                        return false;
                    }
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("channelNo", session.getPassChannel().getChannelNo());
                    paramMap.put("passSessionId", remoteSessionId);
                    paramMap.put("modifyItem", modifyItem);
                    paramMap.put("modifyValue", modifyValue);
                    fl = LanPassChannelHandleAction.doLanUpdateConfirmPassInfo(state.getHostNo(), state.getLanSocketAddress(), paramMap);
                    entry = (KeyValueEntry)fl.get(6000L, TimeUnit.MILLISECONDS);
                    if (entry != null) break block10;
                    String msg = "\u4fee\u6539" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u653e\u884c\u4fe1\u606f\u8d85\u65f6! ";
                    ServiceLog.getLog().warn((Object)msg);
                    return false;
                }
                passSessionData = (PassSessionData)entry.getValue();
                if (passSessionData != null) break block11;
                String errMsg = (String)entry.getKey();
                errMsg = errMsg == null || errMsg.length() == 0 ? "" : "\u539f\u56e0\uff1a" + errMsg;
                String msg = "\u4fee\u6539" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u653e\u884c\u4fe1\u606f\u5931\u8d25! " + errMsg;
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
                return false;
            }
            try {
                boolean success = MainHostPassFilter.setPassSessionData(session, passSessionData, false, false, session.getPassPlate());
                if (success) {
                    return true;
                }
            }
            catch (Throwable ex) {
                if (fl.getException() != null) {
                    ex = fl.getException();
                }
                String msg = "\u4fee\u6539" + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u63a7\u5236\u8bbe\u5907[" + host.getHost_name() + "] \u653e\u884c\u4fe1\u606f\u5931\u8d25! \u539f\u56e0: " + ex.getMessage();
                ServiceLog.getLog().warn((Object)msg);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session.getPassChannel(), msg, 3));
            }
        }
        return false;
    }
}

