/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PassChargeFilter
implements PassFilter {
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        CarparkArea enterArea;
        session.setChargeFilter(this);
        Cost zeroCost = new Cost();
        zeroCost.setShouldCharged(Cost.ZERO);
        zeroCost.setCash(Cost.ZERO);
        zeroCost.setDeduct_money(Cost.ZERO);
        session.setAttribute("pass_cost", zeroCost);
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
            return true;
        }
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        List exitAreaList = (List)session.getAttribute("PASS_EXIT_AREA_LIST");
        if (exitAreaList != null && !exitAreaList.isEmpty()) {
            CarparkArea outArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
            if (outArea != null && outArea.getArea_level() == 1) {
                Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
                CarparkPresenceRecord takeRecord = (CarparkPresenceRecord)session.getAttribute("takeChargeRecord");
                Date passTime = (Date)session.getAttribute("passTime");
                CarparkPassRecord passRreaRecord = null;
                CarparkPresenceRecord enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(outArea.getArea_no());
                if (takeRecord != null && outArea.getArea_no().equals(takeRecord.getArea_no()) && takeRecord.getEnter_time() != null && takeRecord.getExit_time() == null && takeRecord.getPassport_number() != null && takeRecord.getMedium_type() != null && takeRecord.getEnter_time().before(passTime)) {
                    passRreaRecord = takeRecord;
                } else if (enterRecord != null && !(passRreaRecord = enterRecord).getPassport_number().equals(session.getPassport().getPassport_number())) {
                    passRreaRecord = (CarparkPassRecord)enterRecord.clone();
                    passRreaRecord.setPassport_number(session.getPassport().getPassport_number());
                    passRreaRecord.setMedium_type(session.getPassport().getMedium_type());
                }
                if (passRreaRecord != null && enterRecord != null) {
                    CarparkPassDiscount passDiscount;
                    ApplicationService appService;
                    String carTypeNo;
                    CarparkPassportType passportType = session.getPassportType();
                    CarparkPassport passport = session.getPassport();
                    Date expirDate = null;
                    if (session.getPassportType().getPass_type() == 2) {
                        expirDate = passport.getDeadline();
                    }
                    if ((carTypeNo = (String)session.getAttribute("GUI_SELECT_CARTYPE_NO")) == null || carTypeNo.length() == 0) {
                        carTypeNo = session.getCarType().getCar_type_no();
                    }
                    String plateNo = session.getPassPlate();
                    CarparkDiscountProject selectDiscount = (CarparkDiscountProject)session.getAttribute("GUI_SELECT_DISCOUNT");
                    if (selectDiscount != null) {
                        appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        UserSession userSession = appService.getUserSession();
                        passDiscount = new CarparkPassDiscount();
                        passDiscount.setCarpark_id(selectDiscount.getCarpark_id());
                        passDiscount.setCoupon_no(null);
                        passDiscount.setCoupon_order_no(null);
                        passDiscount.setCreated_time(passTime);
                        passDiscount.setDiscount_time(passTime);
                        passDiscount.setDiscount_merchant_name("\u8f66\u573a\u7ba1\u7406");
                        passDiscount.setDiscount_merchant_no("0");
                        passDiscount.setDiscount_merchant_type(0);
                        passDiscount.setDiscount_method(selectDiscount.getDiscount_method());
                        passDiscount.setDiscount_no("0");
                        passDiscount.setDiscount_project_name(selectDiscount.getDiscount_project_name());
                        passDiscount.setDiscount_project_no(selectDiscount.getDiscount_project_no());
                        passDiscount.setDiscount_source(0);
                        passDiscount.setDiscount_value(selectDiscount.getDiscount_value());
                        passDiscount.setDiscount_value_des(ServiceUtil.getString(appService.getDiscountValueDes(selectDiscount.getDiscount_method(), selectDiscount.getDiscount_value()), 100));
                        passDiscount.setEnter_record_no(enterRecord.getEnter_record_no());
                        passDiscount.setEnter_time(enterRecord.getEnter_time());
                        passDiscount.setId(null);
                        passDiscount.setMedium_type(passport.getMedium_type());
                        if (userSession != null && userSession.getUser() != null) {
                            passDiscount.setOperation_user_code(userSession.getUser().getUser_code());
                            passDiscount.setOperation_user_name(userSession.getUser().getUser_name());
                        } else {
                            passDiscount.setOperation_user_code("admin");
                            passDiscount.setOperation_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                        }
                        passDiscount.setPalte_number(plateNo);
                        passDiscount.setPassport_number(passport.getPassport_number());
                        passDiscount.setProject_id(selectDiscount.getProject_id());
                    } else {
                        passDiscount = null;
                    }
                    appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    CarparkPassRecord lastEntryRecord = (CarparkPassRecord)session.getAttribute("NO_ENTRY_MARCH_RECORD");
                    LinkedList<CarparkPresenceRecord> subRecordsList = null;
                    if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && outArea != null) {
                        subRecordsList = new LinkedList<CarparkPresenceRecord>();
                        for (Map.Entry entry : areaPresenceRecordMap.entrySet()) {
                            if (entry.getValue() == null || ((CarparkPresenceRecord)entry.getValue()).getArea_no() == null || ((CarparkPresenceRecord)entry.getValue()).getArea_level() == null || outArea.getArea_level() <= outArea.getArea_level()) continue;
                            subRecordsList.add((CarparkPresenceRecord)entry.getValue());
                        }
                    }
                    Cost cost = appService.charge(passRreaRecord, passTime, passportType.getPassport_type_no(), carTypeNo, expirDate, plateNo, passport.getPassport_number(), passport.getMedium_type(), enterRecord.getEnter_time(), passDiscount, lastEntryRecord, subRecordsList);
                    BigDecimal ac = cost.getActualCharge();
                    if (passportType.getPass_type() == 1) {
                        if (passport.getBalance() != null && passport.getBalance().doubleValue() >= ac.doubleValue()) {
                            cost.setDeduct_money(ac);
                            cost.setCash(Cost.ZERO);
                        } else {
                            CarparkPassportType updatePassportType = this.getInsufficientChargePassportType(passportType.getPassport_type_no());
                            if (updatePassportType != null) {
                                cost = appService.charge(passRreaRecord, passTime, updatePassportType.getPassport_type_no(), carTypeNo, expirDate, plateNo, passport.getPassport_number(), passport.getMedium_type(), enterRecord.getEnter_time(), passDiscount, lastEntryRecord, subRecordsList);
                                ac = cost.getActualCharge();
                                cost.setCash(ac);
                                cost.setDeduct_money(Cost.ZERO);
                            } else {
                                cost.setCash(ac);
                                cost.setDeduct_money(Cost.ZERO);
                            }
                        }
                    } else {
                        cost.setCash(ac);
                        cost.setDeduct_money(Cost.ZERO);
                    }
                    session.setAttribute("pass_cost", cost);
                }
            }
        } else if (channelArea != null && channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty() && (enterArea = channelArea.getEnterAreas().get(0)) != null && enterArea.getArea_level() == 1) {
            session.removeAttribute("ESCAPE_ORDER");
            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CARPARK_ENTER_COLLECTION_FEE"))) {
                Date passTime = (Date)session.getAttribute("passTime");
                if (passTime == null) {
                    passTime = ServiceUtil.getNow();
                }
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                String escapeOrderTable = commonDaoService.getTableName(CarparkEscapeOrder.class);
                SearchParam sp = new SearchParam(escapeOrderTable);
                sp.addEQ("passport_number", (Object)session.getReadPassportNumberEvent().getPassportNumber());
                sp.addLT("exit_time", (Object)passTime);
                sp.addEQ("medium_type", (Object)session.getReadPassportNumberEvent().getPassportMediumType());
                sp.addEQ("area_no", (Object)enterArea.getArea_no());
                sp.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                sp.addEQ("order_state", (Object)0);
                sp.setOrder_by("exit_time DESC");
                Pagination p = new Pagination();
                p.setRecordsCount(1L);
                p.setNeedQueryCount(false);
                p.setGotoPage(1);
                CarparkEscapeOrder escapeOrder = (CarparkEscapeOrder)commonDaoService.selectOne(sp, CarparkEscapeOrder.class, p);
                if (escapeOrder != null && escapeOrder.getExit_should_charge() != null && escapeOrder.getExit_should_charge().doubleValue() > 0.0 && escapeOrder.getCash_pay() != null && escapeOrder.getCash_pay().doubleValue() > 0.0 && escapeOrder.getEnter_time() != null && escapeOrder.getExit_time() != null && escapeOrder.getOrder_state() != null && escapeOrder.getOrder_state() == 0) {
                    Number n;
                    if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(escapeOrder.getPassport_type_no(), "PASSPORTTYPE_ARREARAGE_FEE"))) {
                        return true;
                    }
                    SearchParam param1 = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class)).addEQ("carpark_id", (Object)escapeOrder.getCarpark_id()).addEQ("passport_number", (Object)escapeOrder.getPassport_number()).addEQ("medium_type", (Object)escapeOrder.getMedium_type()).addEQ("enter_time", (Object)escapeOrder.getEnter_time()).addEQ("tran_type", (Object)0).addEQ("enter_record_no", (Object)escapeOrder.getEnter_record_no());
                    param1.setQueryFields(new String[]{"SUM(tran_money) AS tran_money"});
                    Map alPayMap = commonDaoService.selectOne(param1);
                    BigDecimal aMoney = null;
                    if (alPayMap != null && (n = (Number)alPayMap.get("tran_money")) != null) {
                        aMoney = n instanceof BigDecimal ? (BigDecimal)n : new BigDecimal(n.doubleValue()).setScale(2, 4);
                    }
                    Cost cost = new Cost();
                    cost.setShouldCharged(escapeOrder.getExit_should_charge());
                    cost.setPeriod_multi_free(escapeOrder.getPeriod_multi_free());
                    cost.setPeriod_multi_received(escapeOrder.getPeriod_multi_received());
                    cost.setPeriod_multi_start(escapeOrder.getPeriod_multi_start());
                    cost.setNext_period_multi_cur(escapeOrder.getNext_period_multi_cur());
                    cost.setNext_period_multi_start(escapeOrder.getNext_period_multi_start());
                    cost.setDeduct_money(escapeOrder.getDeduct_money());
                    cost.setDiscountMoney(escapeOrder.getDiscount_money());
                    if (escapeOrder.getExit_fee_time_length() == null || escapeOrder.getExit_fee_time_length() <= 0) {
                        cost.setCharge_start_time(escapeOrder.getEnter_time());
                        cost.setChargeTimeMinutes(ServiceUtil.getMins(escapeOrder.getEnter_time(), escapeOrder.getExit_time()));
                    } else {
                        cost.setCharge_start_time(new Date(escapeOrder.getExit_time().getTime() - (long)(escapeOrder.getExit_fee_time_length() * 60 * 1000)));
                        if (cost.getCharge_start_time().before(escapeOrder.getEnter_time())) {
                            cost.setCharge_start_time(escapeOrder.getEnter_time());
                        }
                        cost.setChargeTimeMinutes(escapeOrder.getExit_fee_time_length());
                    }
                    cost.setAlready_paid_time(escapeOrder.getAlready_paid_time());
                    cost.setAlready_paid_method(escapeOrder.getAlready_paid_method());
                    cost.setAlready_paid_scene(escapeOrder.getAlready_paid_scene());
                    cost.setAlready_paid_charge_org(escapeOrder.getAlready_paid_charge_org());
                    cost.setAlready_paid(escapeOrder.getAlready_paid());
                    cost.setCash(escapeOrder.getCash_pay());
                    if (aMoney != null && aMoney.doubleValue() > cost.getAlready_paid().doubleValue()) {
                        cost.setAlready_paid(aMoney);
                        BigDecimal money = cost.getActualCharge();
                        cost.setCash(money);
                        cost.setDeduct_money(Cost.ZERO);
                    }
                    if (cost.getCash().doubleValue() > 0.0) {
                        session.setAttribute("ESCAPE_ORDER", escapeOrder);
                        session.setAttribute("pass_cost", cost);
                    }
                }
            }
        }
        return true;
    }

    public CarparkPassportType getInsufficientChargePassportType(String passportTypeNo) {
        return PassChargeFilter.getInsufficientChargePassportTypeX(passportTypeNo);
    }

    public static CarparkPassportType getInsufficientChargePassportTypeX(String passportTypeNo) {
        Map<String, CarparkPassportType> m;
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSTYPE_INSUFFICIENT_CHARGE_PASSTYPENO");
        if (v != null && v.length() > 0 && !Constants.NO_STR.equals(v) && (m = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()) != null && !m.isEmpty()) {
            CarparkPassportType t = null;
            t = m.get(v);
            if (t != null && !passportTypeNo.equals(t.getPassport_type_no())) {
                return t;
            }
        }
        return null;
    }
}

