/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.service.DisplayVoiceService;
import java.util.Date;

public class PassExpiredFilter
implements PassFilter {
    public static String getExpireValue(PassSession session, String passportTypeNo) {
        CarparkChannel channel = session.getPassChannel().getChannel();
        boolean unManned = channel.getChannel_mode() == 1 || session.getPassChannel().isOtherHostChannel();
        String keyName = unManned ? "CHANNEL_PASSTYPE_PASS_DATE_EXPIRE_1" : "CHANNEL_PASSTYPE_PASS_DATE_EXPIRE_0";
        String value = session.getAttribute("GUI_CONFIRM") != null || session.getReadPassportNumberEvent().isManualTrigger() || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null ? "2" : ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), passportTypeNo, keyName);
        if (value == null || value.length() == 0) {
            value = "1";
        }
        return value;
    }

    @Override
    public boolean doFilter(PassSession session) throws Exception {
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
            return true;
        }
        CarparkPassportType passportType = session.getPassportType();
        CarparkPassport passport = session.getPassport();
        Date passTime = (Date)session.getAttribute("passTime");
        if (passportType.getPass_type() == 2 && passport.getDeadline() != null && passport.getDeadline().before(passTime)) {
            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                session.getAllowPassExcetpions().add(4);
                return true;
            }
            CarparkChannel channel = session.getPassChannel().getChannel();
            boolean unManned = channel.getChannel_mode() == 1 || session.getPassChannel().isOtherHostChannel();
            String value = PassExpiredFilter.getExpireValue(session, passportType.getPassport_type_no());
            if ("3".equals(value)) {
                session.getForbidPassExceptions().add(4);
                session.setSessionState(PassSession.SessionState.CANCELED);
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                try {
                    displayVoiceService.dateExpired(session);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                }
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c\u5df2\u8fc7\u671f\uff0c\u7981\u6b62\u901a\u884c\uff01" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 4));
                return false;
            }
            if (unManned) {
                session.getAllowPassExcetpions().add(4);
            } else if ("2".equals(value)) {
                session.getConfirmPassExceptions().add(4);
            } else {
                session.getAllowPassExcetpions().add(4);
            }
        }
        return true;
    }
}

