/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkSenselessPay;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.RsuAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.ibatis.session.SqlSession;

public class PassNosensePayFilter
implements PassFilter {
    private boolean doEtcDeduct(PassSession session) {
        CarparkArea outArea;
        List exitAreaList;
        PlateRecognizedEvent plateRecognizedEvent = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
        if (plateRecognizedEvent == null) {
            plateRecognizedEvent = session.getPlateRecognizedEvent();
        }
        if (plateRecognizedEvent != null && (exitAreaList = (List)session.getAttribute("PASS_EXIT_AREA_LIST")) != null && !exitAreaList.isEmpty() && (outArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA")) != null && outArea.getArea_level() == 1) {
            List<Equipment> rsus;
            Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
            Date passTime = (Date)session.getAttribute("passTime");
            CarparkPresenceRecord enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(outArea.getArea_no());
            if (enterRecord != null && (rsus = session.getPassChannel().getEquipmentList(34)) != null && !rsus.isEmpty()) {
                Cost cost0 = (Cost)session.getAttribute("pass_cost");
                for (Equipment eq : rsus) {
                    RsuAction action;
                    if (eq.getUse() != 1 || (action = (RsuAction)eq.getEquipmentAction()) == null || !action.isWorkingProperly() || !action.isSupportDeduct()) continue;
                    HashMap<String, Object> deductContext = new HashMap<String, Object>();
                    deductContext.put("passSession", session);
                    deductContext.put("enterRecord", enterRecord);
                    session.setAttribute("PASS_NOSENSE_PLAYING", Boolean.TRUE);
                    try {
                        long deductMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        KeyValueEntry<String, Object> kv = action.deduct(plateRecognizedEvent.getPlateNumber(), plateRecognizedEvent.getPlateColor(), cost0.getCash(), enterRecord.getEnter_time(), passTime, enterRecord.getEnter_record_no(), deductContext);
                        long deductCostMills = ServiceUtil.getServiceContext().currentTimeMillis() - deductMills;
                        if (!"SUCCESS".equals(kv.getKey())) continue;
                        Map deductMap = (Map)kv.getValue();
                        String orderNo = deductMap.get("orderNo").toString();
                        String plateNumber = deductMap.get("plateNumber").toString();
                        BigDecimal tranMoney = (BigDecimal)deductMap.get("tranMoney");
                        Date tranTime = (Date)deductMap.get("tranTime");
                        String remark = "";
                        if (deductMap.get("obuId") != null) {
                            remark = "OBUID:" + deductMap.get("obuId");
                        }
                        if (deductMap.get("cardTypeDes") != null) {
                            if (remark.length() > 0) {
                                remark = String.valueOf(remark) + ",";
                            }
                            remark = String.valueOf(remark) + deductMap.get("cardTypeDes");
                        }
                        if (deductMap.get("payTypeDes") != null) {
                            if (remark.length() > 0) {
                                remark = String.valueOf(remark) + ",";
                            }
                            remark = String.valueOf(remark) + deductMap.get("payTypeDes");
                        }
                        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        long selfPayId = applicationService.createLocalRecordSeq("ck_carpark_query_fee_seq");
                        CarparkPassSelfPay sefPay = new CarparkPassSelfPay();
                        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                            int x = (int)selfPayId;
                            selfPayId = x;
                        }
                        String dutyNo = "0";
                        String dutyUserCode = "USER_SELF";
                        String dutyUserName = "\u81ea\u52a9\u7f34\u8d39";
                        sefPay.setId(selfPayId);
                        sefPay.setPaid_amount(tranMoney);
                        sefPay.setPaid_method(6);
                        sefPay.setPay_scene(5);
                        sefPay.setCharge_org(0);
                        sefPay.setPay_entry(0);
                        sefPay.setPaid_time(tranTime);
                        Calendar cl = Calendar.getInstance();
                        cl.setTime(tranTime);
                        cl.add(12, 15);
                        sefPay.setPlan_leave_time(cl.getTime());
                        sefPay.setPassport_number(session.getReadPassportNumberEvent().getPassportNumber());
                        sefPay.setMedium_type(session.getReadPassportNumberEvent().getPassportMediumType());
                        sefPay.setEnter_time(enterRecord.getEnter_time());
                        sefPay.setCharge_start_time(cost0.getCharge_start_time() == null ? enterRecord.getEnter_time() : cost0.getCharge_start_time());
                        sefPay.setPlate_number(plateNumber);
                        sefPay.setEnter_record_no(enterRecord.getEnter_record_no());
                        sefPay.setShould_charge(cost0.getShouldCharged());
                        sefPay.setDiscount_money(cost0.getDiscountMoney());
                        sefPay.setAlready_paid(cost0.getAlready_paid());
                        sefPay.setPeriod_multi_free(cost0.getPeriod_multi_free());
                        sefPay.setPeriod_multi_received(cost0.getPeriod_multi_received());
                        sefPay.setPeriod_multi_start(cost0.getPeriod_multi_start());
                        sefPay.setNext_period_multi_cur(cost0.getNext_period_multi_cur());
                        sefPay.setNext_period_multi_start(cost0.getNext_period_multi_start());
                        sefPay.setCharge_time_length(cost0.getChargeTimeMinutes());
                        sefPay.setCloud_order_no(orderNo);
                        sefPay.setCreated_time(ServiceUtil.getNow());
                        sefPay.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                        sefPay.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                        sefPay.setDuty_no(dutyNo);
                        CarparkTransaction t = new CarparkTransaction();
                        long tranId = applicationService.createLocalRecordSeq("ck_carpark_transaction_seq");
                        t.setId(tranId);
                        t.setTansaction_no("C" + t.getId().toString());
                        t.setTran_type(0);
                        t.setService_type(0);
                        t.setPlate_number(sefPay.getPlate_number());
                        t.setPassport_number(sefPay.getPassport_number());
                        t.setMedium_type(sefPay.getMedium_type());
                        t.setPassport_no(session.getPassport().getPassport_no());
                        t.setPass_type(session.getPassportType().getPass_type());
                        t.setPassport_type_no(session.getPassportType().getPassport_type_no());
                        t.setPassport_type_name(session.getPassportType().getPassport_type_name());
                        t.setCar_type_no(session.getCarType().getCar_type_no());
                        t.setCar_type_name(session.getCarType().getCar_type_name());
                        t.setOrder_no(sefPay.getCloud_order_no());
                        t.setTran_money(sefPay.getPaid_amount());
                        t.setTran_time(sefPay.getPaid_time());
                        t.setPay_method(sefPay.getPaid_method());
                        t.setPay_scene(sefPay.getPay_scene());
                        t.setCharge_org(sefPay.getCharge_org());
                        t.setPay_entry(sefPay.getPay_entry());
                        t.setTran_area_no(outArea.getArea_no());
                        t.setTran_area_name(outArea.getArea_name());
                        t.setTran_channel_no(session.getPassChannel().getChannelNo());
                        t.setTran_channel_name(session.getPassChannel().getChannel().getChannel_name());
                        if (session.getCarOwner() != null) {
                            t.setTran_user_no(session.getCarOwner().getCar_owner_no());
                            t.setTran_user_name(session.getCarOwner().getCar_owner_name());
                        }
                        t.setDuty_no(sefPay.getDuty_no());
                        t.setEnter_record_no(sefPay.getEnter_record_no());
                        t.setEnter_time(sefPay.getEnter_time());
                        t.setOperate_user_code(dutyUserCode);
                        t.setOperate_user_name(dutyUserName);
                        if (remark == null || remark.length() == 0) {
                            t.setTran_des("ETC\u6263\u8d39");
                        } else {
                            t.setTran_des(ServiceUtil.getString(remark, 200));
                        }
                        t.setShould_charge(sefPay.getShould_charge());
                        t.setDiscount_money(sefPay.getDiscount_money());
                        t.setAlready_paid(sefPay.getAlready_paid());
                        t.setPeriod_multi_free(sefPay.getPeriod_multi_free());
                        t.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
                        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                        if (localHost != null) {
                            t.setHost_name(localHost.getHost_name());
                        }
                        t.setCreated_time(sefPay.getCreated_time());
                        t.setCarpark_id(sefPay.getCarpark_id());
                        t.setProject_id(sefPay.getProject_id());
                        t.setExit_time(passTime);
                        sefPay.setCharge_record_no(t.getTansaction_no());
                        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
                        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkTransaction.class), t.getId().toString(), "ALL_HOSTS"));
                        try (SqlSession daoSession = daoService.openSqlSession();){
                            try {
                                daoService.insert(daoSession, (Object)sefPay);
                                daoService.insert(daoSession, (Object)t);
                                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                                    for (CarparkDispatchTask task : dispatchTaskList) {
                                        daoService.insert(daoSession, (Object)task);
                                    }
                                }
                                daoSession.commit();
                            }
                            catch (Exception ex) {
                                daoSession.rollback();
                                throw ex;
                            }
                        }
                        ArrayList<CarparkPassSelfPay> selfPayList = new ArrayList<CarparkPassSelfPay>();
                        List<CarparkPassSelfPay> selfPayList0 = cost0.getAlreadyPaidList();
                        if (selfPayList0 != null && !selfPayList0.isEmpty()) {
                            selfPayList.addAll(selfPayList0);
                        }
                        selfPayList.add(sefPay);
                        int lastIndex = selfPayList.size() - 1;
                        CarparkPassSelfPay selfPay = ((CarparkPassSelfPay)selfPayList.get(lastIndex)).clone();
                        BigDecimal d1 = Constants.MONEY_ZERO;
                        int i = 0;
                        while (i < lastIndex) {
                            CarparkPassSelfPay p = (CarparkPassSelfPay)selfPayList.get(i);
                            if (p.getPaid_amount() != null) {
                                d1 = d1.add(p.getPaid_amount());
                            }
                            ++i;
                        }
                        if (selfPay.getAlready_paid() == null || selfPay.getAlready_paid().doubleValue() < d1.doubleValue()) {
                            selfPay.setAlready_paid(d1);
                        }
                        Cost cost = new Cost();
                        cost.setShouldCharged(selfPay.getShould_charge());
                        cost.setPeriod_multi_start(selfPay.getPeriod_multi_start());
                        cost.setPeriod_multi_received(selfPay.getPeriod_multi_received());
                        cost.setPeriod_multi_free(selfPay.getPeriod_multi_free());
                        cost.setNext_period_multi_start(selfPay.getNext_period_multi_start());
                        cost.setNext_period_multi_cur(selfPay.getNext_period_multi_cur());
                        cost.setDiscountMoney(selfPay.getDiscount_money());
                        cost.setCharge_start_time(selfPay.getCharge_start_time());
                        cost.setChargeTimeMinutes(selfPay.getCharge_time_length());
                        cost.setChargeDetail(new HashMap<String, String>());
                        BigDecimal money = selfPay.getPaid_amount();
                        if (selfPay.getAlready_paid() != null && selfPay.getAlready_paid().doubleValue() > 0.0) {
                            money = money.add(selfPay.getAlready_paid());
                        }
                        cost.setAlready_paid(money);
                        cost.setAlready_paid_method(selfPay.getPaid_method());
                        cost.setAlready_paid_scene(selfPay.getPay_scene());
                        cost.setAlready_paid_time(selfPay.getPaid_time());
                        cost.setAlready_paid_charge_org(selfPay.getCharge_org());
                        cost.setAlreadyPaidList(selfPayList);
                        cost.setCash(cost.getActualCharge());
                        cost.setDiscountList(cost0.getDiscountList());
                        BigDecimal ac = cost.getActualCharge();
                        if (session.getPassportType().getPass_type() == 1) {
                            if (session.getPassport().getBalance() != null && session.getPassport().getBalance().doubleValue() >= ac.doubleValue()) {
                                cost.setDeduct_money(ac);
                                cost.setCash(Cost.ZERO);
                            } else {
                                cost.setCash(ac);
                                cost.setDeduct_money(Cost.ZERO);
                            }
                        } else {
                            cost.setCash(ac);
                            cost.setDeduct_money(Cost.ZERO);
                        }
                        session.setAttribute("pass_cost", cost);
                        StringBuilder sbr = new StringBuilder();
                        sbr.append("ETC\u652f\u4ed8\u6210\u529f");
                        if (sefPay.getPaid_amount() != null) {
                            sbr.append("\uff0c\u652f\u4ed8\u91d1\u989d\uff1a").append(sefPay.getPaid_amount()).append("\u5143");
                        }
                        if (sefPay.getPaid_time() != null) {
                            sbr.append("\uff0c\u652f\u4ed8\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(sefPay.getPaid_time()));
                        }
                        if (sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 4) {
                            sbr.append("\uff0c\u652f\u4ed8\u8f66\u724c\uff1a").append(sefPay.getPlate_number());
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 1, 10000));
                        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                            applicationService.asynTryRunDispatchTask(dispatchTaskList);
                        }
                        try {
                            ServiceLog.getLog().info((Object)("ETC\u652f\u4ed8\u6210\u529f\uff0c\u8ba2\u5355\u53f7:" + sefPay.getCloud_order_no() + ", \u8f66\u724c: " + (sefPay.getPlate_number() == null ? "" : sefPay.getPlate_number()) + ", \u6263\u8d39\u8017\u65f6: " + deductCostMills + "\u6beb\u79d2"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PassNosensePayFilter.checkIsConfirmSession(session, cost, sefPay);
                        return true;
                    }
                    finally {
                        session.removeAttribute("PASS_NOSENSE_PLAYING");
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIsConfirmSession(PassSession session, Cost cost, CarparkPassSelfPay sefPay) {
        if (cost.getCash().doubleValue() <= 0.0) {
            session.setAttribute("SELF_PAY_SUCCESS_PASS", Boolean.TRUE);
            session.setAttribute("SELF_SLEF_PAY_RESULT", sefPay);
            if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG || session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                Object lock;
                session.removeAttribute("PASS_NOSENSE_PLAYING");
                KeyLockManager keyLockManager = null;
                if (session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                    lock = session.getExeFilterLock();
                } else {
                    keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
                    lock = ServiceUtil.getConfirmDialogHandelrLock(keyLockManager, session.getPassChannel().getChannelNo(), session.getSessionId());
                }
                try {
                    Object object = lock;
                    synchronized (object) {
                        block24: {
                            if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG || session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                                String v1 = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREESECT_PAYMENT_CONFIRM");
                                if (v1 != null && v1.equals("1") && session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                    try {
                                        session.setAttribute("PASS_CONFIRM_MESSAGE", "ETC\u6263\u8d39" + sefPay.getPaid_amount() + "\u6210\u529f\uff0c\u6b63\u5728\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4\u653e\u884c");
                                        displayVoiceService.playConfirmPass(session);
                                        session.removeAttribute("PASS_CONFIRM_MESSAGE");
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    try {
                                        try {
                                            ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                        }
                                        catch (Exception ex) {
                                            ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u653e\u884c\u6570\u636e\u5f02\u5e38\uff01", (Throwable)ex);
                                            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                            session.setAttribute("SYS_EXCEPTION_CANCEL", Boolean.TRUE);
                                            session.setSessionState(PassSession.SessionState.CANCELED);
                                            String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01";
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                                            ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                            if (callback != null) {
                                                callback.doClosePassDialog(session);
                                            }
                                            break block24;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                        if (callback != null) {
                                            callback.doClosePassDialog(session);
                                        }
                                        throw throwable;
                                    }
                                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                    if (callback != null) {
                                        callback.doClosePassDialog(session);
                                    }
                                }
                            }
                        }
                    }
                }
                finally {
                    if (keyLockManager != null) {
                        keyLockManager.releaseLock(lock);
                    }
                }
            }
        }
    }

    @Override
    public boolean doFilter(PassSession session) throws Exception {
        block91: {
            Map config1;
            String string;
            Object list;
            Map.Entry<Integer, Map<String, String>> entry1;
            String v;
            CarparkHost host;
            String slaveHostNo;
            if (session.isTempSession()) {
                return true;
            }
            if (session.getAttribute("GUI_CONFIRM") != null || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                return true;
            }
            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
                return true;
            }
            if (session.getAttribute("PASS_NOSENSE_PLAYING") != null) {
                return true;
            }
            if (session.getAttribute("AFTER_CONFIRM_DO_NOSENSE_PAY_FILTER") != null) {
                if (session.getSessionState() != PassSession.SessionState.OPEN_DIALOG) {
                    return true;
                }
                session.removeAttribute("AFTER_CONFIRM_DO_NOSENSE_PAY_FILTER");
            } else if (session.getSessionState() != PassSession.SessionState.PROCESSING) {
                return true;
            }
            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
            if (channelArea.getExitAreas() == null || channelArea.getExitAreas().isEmpty()) {
                return true;
            }
            CarparkArea exitArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
            if (exitArea == null) {
                return true;
            }
            if (exitArea.getArea_level() != 1) {
                return true;
            }
            Cost cost = (Cost)session.getAttribute("pass_cost");
            if (cost == null || cost.getCash() == null || cost.getCash().doubleValue() <= 0.0) {
                return true;
            }
            String plate = session.getPassPlate();
            if (plate == null || plate.length() != 7 && plate.length() != 8) {
                return true;
            }
            if (session.getPlateRecognizedEvent() == null) {
                return true;
            }
            if (!plate.equals(session.getPlateRecognizedEvent().getPlateNumber())) {
                return true;
            }
            if (cost.getArrears() != null && cost.getArrears().doubleValue() > 0.0) {
                return true;
            }
            CarparkEscapeOrder escapeOrder = (CarparkEscapeOrder)session.getAttribute("ESCAPE_ORDER");
            if (escapeOrder != null) {
                return true;
            }
            CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            if (config != null && config.getCarpark_deploy_type() == 1 && config.getNet_mode() == 2 && config.getHost_use() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
                return true;
            }
            if (session.getSessionState() == PassSession.SessionState.PROCESSING && (v = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("FREESECT_PAYMENT_ACTION")) != null && "1".equals(v)) {
                session.setAttribute("AFTER_CONFIRM_DO_NOSENSE_PAY_FILTER", this);
                return true;
            }
            try {
                if (this.doEtcDeduct(session)) {
                    return true;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u5c1d\u8bd5ETC\u6263\u8d39\u5f02\u5e38", (Throwable)ex);
            }
            if (!ServiceUtil.getServiceContext().isConnectedCloud()) {
                return true;
            }
            Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
            if (areaPresenceRecordMap == null) {
                return true;
            }
            CarparkPresenceRecord record = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
            if (record == null) {
                return true;
            }
            if (!plate.equals(record.getEnter_plate())) {
                return true;
            }
            if (session.getForbidPassExceptions() != null && session.getForbidPassExceptions().contains(1)) {
                return true;
            }
            boolean unManned = session.getPassChannel().getChannel().getChannel_mode() == 1 || session.getPassChannel().isOtherHostChannel();
            CarparkPassportType passportType = session.getPassportType();
            String keyName = unManned ? "CHANNEL_PASSTYPE_PASS_1" : "CHANNEL_PASSTYPE_PASS_0";
            String value = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(session.getPassChannel().getChannelNo(), passportType.getPassport_type_no(), keyName);
            if (value == null || value.length() == 0) {
                CarparkArea outArea;
                value = unManned ? "1" : (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() ? ((outArea = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1)).getArea_level() > 1 ? "1" : (passportType.getPass_type() == 0 ? (passportType.getUse_muti_car() == 1 ? "1" : "2") : "1")) : "1");
            }
            if ("3".equals(value)) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isSupportSenselessPay()) {
                return true;
            }
            Map<Integer, Map<String, String>> noSenceConfigMap0 = ServiceUtil.getServiceContext().getAllSenselessConfig();
            if (noSenceConfigMap0 == null || noSenceConfigMap0.isEmpty()) {
                return true;
            }
            PriorityQueue<Map.Entry<Integer, Map<String, String>>> queue = new PriorityQueue<Map.Entry<Integer, Map<String, String>>>(10, new Comparator<Map.Entry<Integer, Map<String, String>>>(){

                @Override
                public int compare(Map.Entry<Integer, Map<String, String>> o1, Map.Entry<Integer, Map<String, String>> o2) {
                    int x1;
                    String a = o1.getValue().get("WL_PRI");
                    String b = o2.getValue().get("WL_PRI");
                    int x = 0;
                    int y = 0;
                    try {
                        if (a != null && a.length() > 0) {
                            x = Integer.parseInt(a);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (b != null && b.length() > 0) {
                            y = Integer.parseInt(b);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((x1 = Integer.compare(x, y)) == 0) {
                        return Integer.compare(o1.getKey(), o2.getKey());
                    }
                    return 0 - x1;
                }
            });
            for (Map.Entry<Integer, Map<String, String>> entry : noSenceConfigMap0.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                queue.offer(entry);
            }
            LinkedHashSet<Integer> supportContractTypes = new LinkedHashSet<Integer>();
            LinkedHashSet<Integer> notSupportContractTypes = new LinkedHashSet<Integer>();
            LinkedHashMap<Integer, Map<String, String>> allMap = new LinkedHashMap<Integer, Map<String, String>>();
            while ((entry1 = queue.poll()) != null) {
                allMap.put(entry1.getKey(), entry1.getValue());
                String a2 = entry1.getValue().get("WL_SCA");
                if (a2 != null && Constants.YES_STR.equals(a2)) {
                    supportContractTypes.add(entry1.getKey());
                    continue;
                }
                a2 = entry1.getValue().get("WL_CCA");
                if (a2 != null && Constants.YES_STR.equals(a2)) {
                    supportContractTypes.add(entry1.getKey());
                    continue;
                }
                notSupportContractTypes.add(entry1.getKey());
            }
            if (allMap.isEmpty()) {
                return true;
            }
            boolean hasSupportContractTypes = false;
            if (supportContractTypes != null && !supportContractTypes.isEmpty()) {
                String keyx = "contract_type";
                CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                list = daoService.selectList(new SearchParam(daoService.getTableName(CarparkSenselessPay.class)).setQueryFields(new String[]{"DISTINCT " + keyx}).addEQ("plate_number", (Object)plate), null);
                if (list != null && !list.isEmpty()) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Map map = (Map)iterator.next();
                        Integer ax = (Integer)map.get(keyx);
                        if (ax == null || !supportContractTypes.contains(ax)) continue;
                        hasSupportContractTypes = true;
                        supportContractTypes.remove(ax);
                    }
                }
                if (!supportContractTypes.isEmpty()) {
                    for (Integer n : supportContractTypes) {
                        allMap.remove(n);
                    }
                }
            }
            if (allMap.isEmpty()) {
                return true;
            }
            String payName = "";
            if (allMap.size() == 1 && (list = allMap.values().iterator()).hasNext() && (string = (String)(config1 = (Map)list.next()).get("WL_NAM")) != null && string.length() > 0) {
                payName = string;
            }
            StringBuilder contractTypes = new StringBuilder(64);
            for (Integer v2 : allMap.keySet()) {
                if (contractTypes.length() > 0) {
                    contractTypes.append(',');
                }
                contractTypes.append(v2.toString());
            }
            if (contractTypes.length() == 0) {
                return true;
            }
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            try {
                try {
                    if (session.getSessionState() == PassSession.SessionState.PROCESSING) {
                        try {
                            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                            String txt = payName.length() > 0 && payName.indexOf("\u652f\u4ed8") != -1 ? payName : String.valueOf(payName) + "\u65e0\u611f\u652f\u4ed8";
                            displayVoiceService.displaySenselessPaying(session.getPassChannel(), plate, hasSupportContractTypes ? String.valueOf(txt) + "\u4e2d..." : String.valueOf(txt) + "\u68c0\u6d4b\u4e2d...");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    session.setAttribute("PASS_NOSENSE_PLAYING", Boolean.TRUE);
                    long l = ServiceUtil.getServiceContext().currentTimeMillis();
                    Map<String, Object> resultMap = applicationService.doSenselessPay(plate, contractTypes.toString(), session);
                    long deductCostMills = ServiceUtil.getServiceContext().currentTimeMillis() - l;
                    String RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    String RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                    if ("SUCCESS".equals(RETURN_CODE)) {
                        CarparkPassSelfPay sefPay = (CarparkPassSelfPay)GsonBuilder.create().fromJson(RETURN_VALUE, CarparkPassSelfPay.class);
                        ArrayList<CarparkPassSelfPay> selfPayList = new ArrayList<CarparkPassSelfPay>();
                        List<CarparkPassSelfPay> selfPayList0 = cost.getAlreadyPaidList();
                        if (selfPayList0 != null && !selfPayList0.isEmpty()) {
                            selfPayList.addAll(selfPayList0);
                        }
                        selfPayList.add(sefPay);
                        int lastIndex = selfPayList.size() - 1;
                        CarparkPassSelfPay selfPay = ((CarparkPassSelfPay)selfPayList.get(lastIndex)).clone();
                        BigDecimal d1 = Constants.MONEY_ZERO;
                        int i = 0;
                        while (i < lastIndex) {
                            CarparkPassSelfPay p = (CarparkPassSelfPay)selfPayList.get(i);
                            if (p.getPaid_amount() != null) {
                                d1 = d1.add(p.getPaid_amount());
                            }
                            ++i;
                        }
                        if (selfPay.getAlready_paid() == null || selfPay.getAlready_paid().doubleValue() < d1.doubleValue()) {
                            selfPay.setAlready_paid(d1);
                        }
                        cost = new Cost();
                        cost.setShouldCharged(selfPay.getShould_charge());
                        cost.setPeriod_multi_start(selfPay.getPeriod_multi_start());
                        cost.setPeriod_multi_received(selfPay.getPeriod_multi_received());
                        cost.setPeriod_multi_free(selfPay.getPeriod_multi_free());
                        cost.setNext_period_multi_start(selfPay.getNext_period_multi_start());
                        cost.setNext_period_multi_cur(selfPay.getNext_period_multi_cur());
                        cost.setDiscountMoney(selfPay.getDiscount_money());
                        cost.setCharge_start_time(selfPay.getCharge_start_time());
                        cost.setChargeTimeMinutes(selfPay.getCharge_time_length());
                        cost.setChargeDetail(new HashMap<String, String>());
                        BigDecimal money = selfPay.getPaid_amount();
                        if (selfPay.getAlready_paid() != null && selfPay.getAlready_paid().doubleValue() > 0.0) {
                            money = money.add(selfPay.getAlready_paid());
                        }
                        cost.setAlready_paid(money);
                        cost.setAlready_paid_method(selfPay.getPaid_method());
                        cost.setAlready_paid_scene(selfPay.getPay_scene());
                        cost.setAlready_paid_time(selfPay.getPaid_time());
                        cost.setAlready_paid_charge_org(selfPay.getCharge_org());
                        cost.setAlreadyPaidList(selfPayList);
                        cost.setCash(cost.getActualCharge());
                        LinkedList<CarparkPassDiscount> discountList = new LinkedList<CarparkPassDiscount>();
                        try {
                            if (selfPay.getDiscounts_json() != null && selfPay.getDiscounts_json().length() > 0 && cost.getDiscountMoney() != null && cost.getDiscountMoney().doubleValue() > 0.0) {
                                JsonListType<CarparkPassDiscount> jsonListType = new JsonListType<CarparkPassDiscount>(CarparkPassDiscount.class);
                                List discountListOrder = (List)GsonBuilder.create().fromJson(selfPay.getDiscounts_json(), jsonListType);
                                if (discountListOrder != null && !discountListOrder.isEmpty()) {
                                    HashMap<String, BigDecimal> disNosMap = null;
                                    for (CarparkPassDiscount d : discountListOrder) {
                                        if (d.getId() == null) continue;
                                        if (disNosMap == null) {
                                            disNosMap = new HashMap<String, BigDecimal>();
                                        }
                                        disNosMap.put(d.getDiscount_no(), d.getDiscount_amount() == null ? Cost.ZERO : d.getDiscount_amount());
                                    }
                                    if (disNosMap != null && !disNosMap.isEmpty()) {
                                        List discountRecordList = null;
                                        SearchParam sp = new SearchParam();
                                        if (disNosMap.size() == 1) {
                                            sp.addEQ("discount_no", ServiceUtil.getFirstElement(disNosMap.keySet()));
                                        } else {
                                            sp.addINList("discount_no", disNosMap.keySet());
                                        }
                                        sp.addEQ("enter_time", (Object)sefPay.getEnter_time()).addEQ("passport_number", (Object)sefPay.getPassport_number()).addEQ("medium_type", (Object)sefPay.getMedium_type());
                                        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                        discountRecordList = commonDaoService.selectList(sp, CarparkDiscountRecord.class, null);
                                        if (discountRecordList != null && !discountRecordList.isEmpty()) {
                                            for (CarparkDiscountRecord d : discountRecordList) {
                                                d.setDiscount_amount(Cost.ZERO);
                                                BigDecimal d2 = (BigDecimal)disNosMap.get(d.getDiscount_no());
                                                if (d2 != null) {
                                                    d.setDiscount_amount(d2);
                                                }
                                                discountList.add(d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                        }
                        cost.setDiscountList(discountList);
                        BigDecimal ac = cost.getActualCharge();
                        if (passportType.getPass_type() == 1) {
                            if (session.getPassport().getBalance() != null && session.getPassport().getBalance().doubleValue() >= ac.doubleValue()) {
                                cost.setDeduct_money(ac);
                                cost.setCash(Cost.ZERO);
                            } else {
                                cost.setCash(ac);
                                cost.setDeduct_money(Cost.ZERO);
                            }
                        } else {
                            cost.setCash(ac);
                            cost.setDeduct_money(Cost.ZERO);
                        }
                        session.setAttribute("pass_cost", cost);
                        StringBuilder sbr = new StringBuilder();
                        Map noSensePayConfig = null;
                        if (sefPay.getCharge_org() != null) {
                            if (sefPay.getCharge_org() == 9 || sefPay.getCharge_org() == 1) {
                                noSensePayConfig = (Map)allMap.get(9);
                                if (noSensePayConfig == null) {
                                    noSensePayConfig = (Map)allMap.get(1);
                                }
                            } else {
                                noSensePayConfig = (Map)allMap.get(sefPay.getCharge_org());
                            }
                        }
                        String payMethodName = null;
                        if (noSensePayConfig != null) {
                            payMethodName = (String)noSensePayConfig.get("WL_NAM");
                        }
                        if (payMethodName == null || payMethodName.length() == 0) {
                            payMethodName = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(sefPay.getCharge_org());
                        }
                        if (payMethodName == null || payMethodName.length() == 0) {
                            payMethodName = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(sefPay.getPaid_method());
                        }
                        if (payMethodName == null) {
                            payMethodName = "";
                        }
                        sbr.append(payMethodName);
                        if (payMethodName.indexOf("\u652f\u4ed8") == -1) {
                            sbr.append("\u65e0\u611f\u652f\u4ed8");
                        }
                        sbr.append("\u6210\u529f");
                        if (sefPay.getPaid_amount() != null) {
                            sbr.append("\uff0c\u652f\u4ed8\u91d1\u989d\uff1a").append(sefPay.getPaid_amount()).append("\u5143");
                        }
                        if (sefPay.getPaid_time() != null) {
                            sbr.append("\uff0c\u652f\u4ed8\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(sefPay.getPaid_time()));
                        }
                        if (sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 4) {
                            sbr.append("\uff0c\u652f\u4ed8\u8f66\u724c\uff1a").append(sefPay.getPlate_number());
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 1, 10000));
                        try {
                            ServiceLog.getLog().info((Object)("\u65e0\u611f\u652f\u4ed8\u6210\u529f\uff0c\u8ba2\u5355\u53f7:" + sefPay.getCloud_order_no() + ", \u8f66\u724c: " + (sefPay.getPlate_number() == null ? "" : sefPay.getPlate_number()) + ", \u6263\u8d39\u8017\u65f6: " + deductCostMills + "\u6beb\u79d2"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        PassNosensePayFilter.checkIsConfirmSession(session, cost, sefPay);
                        break block91;
                    }
                    if (hasSupportContractTypes) {
                        StringBuilder sbr = new StringBuilder();
                        sbr.append("\u8f66\u724c: " + plate + "\u65e0\u611f\u652f\u4ed8\u5931\u8d25\uff01\u539f\u56e0: " + RETURN_VALUE);
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 4, 10000));
                    }
                    ServiceLog.getLog().info((Object)("\u8f66\u724c: " + plate + "\u65e0\u611f\u652f\u4ed8\u5931\u8d25\uff01\u539f\u56e0: " + RETURN_VALUE));
                }
                catch (Exception exception) {
                    ServiceLog.getLog().warn((Object)("\u8f66\u724c: " + plate + " \u8fdb\u884c\u65e0\u611f\u652f\u4ed8\u5f02\u5e38!  " + exception.getMessage()));
                    session.removeAttribute("PASS_NOSENSE_PLAYING");
                }
            }
            finally {
                session.removeAttribute("PASS_NOSENSE_PLAYING");
            }
        }
        return true;
    }
}

