/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.PassPermissionFilter;
import com.wovoe.carpark.service.DisplayVoiceService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PassParkingFullFilter
implements PassFilter {
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
            return true;
        }
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
            CarparkArea enterArea = channelArea.getEnterAreas().get(0);
            CarparkPassportType passportType = session.getPassportType();
            CarparkChannel channel = session.getPassChannel().getChannel();
            CarparkCarType carType = session.getCarType();
            boolean unManned = channel.getChannel_mode() == 1 || session.getPassChannel().isOtherHostChannel();
            String keyName = unManned ? "CHANNEL_PASSTYPE_PARKING_FULL_1" : "CHANNEL_PASSTYPE_PARKING_FULL_0";
            String value = session.getAttribute("GUI_CONFIRM") != null || session.getReadPassportNumberEvent().isManualTrigger() || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null ? "2" : ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), passportType.getPassport_type_no(), keyName);
            if (value == null || value.length() == 0) {
                value = "1";
            }
            if ("1".equals(value)) {
                return true;
            }
            Integer count = PassParkingFullFilter.getRemainSpace(enterArea.getArea_no(), passportType.getPassport_type_no(), carType.getCar_type_no(), session.getReadPassportNumberEvent().getPassportNumber());
            if (count <= 0) {
                if ("4".equals(value) && (session.getReadPassportNumberEvent() == null || session.getReadPassportNumberEvent().isUserScan() || session.getReadPassportNumberEvent().isManualTrigger() || session.getPlateRecognizedEvent() == null || session.getReadPassportNumberEvent().getPassportMediumType() != 6)) {
                    value = "3";
                }
                if ("3".equals(value)) {
                    session.getForbidPassExceptions().add(5);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    try {
                        displayVoiceService.parkingFull(session);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                    }
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c\u65e0\u5269\u4f59\u8f66\u4f4d\uff01\u7981\u6b62\u5165\u573a" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 4));
                    return false;
                }
                if ("4".equals(value)) {
                    session.setAttribute("PARKING_FULL_QUEUE_FLAG", Boolean.TRUE);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    session.resetSessionTimeoutMills(3600000);
                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    try {
                        displayVoiceService.parkingFullQueue(session);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                    }
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c\u6682\u65e0\u8f66\u4f4d\uff01\u5df2\u52a0\u5165\u6392\u961f\u961f\u5217\uff0c\u7b49\u5f85\u5176\u5b83\u8f66\u79bb\u573a\u3002" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 2));
                    return false;
                }
                if ("2".equals(value) && !unManned) {
                    session.getConfirmPassExceptions().add(5);
                }
            }
        }
        return true;
    }

    public static int getRemainSpace(String areaNo, String passportTypeNo, String carTypeNo, String passportNumber) {
        if (areaNo == null || areaNo.length() == 0) {
            return 0;
        }
        Integer count = ParkingSpace.getInstance().getRemainSpace(areaNo, passportTypeNo, carTypeNo);
        if (count == null) {
            count = PassParkingFullFilter.getAreaRemainSpace(areaNo, passportTypeNo);
        }
        return count;
    }

    public static int getAreaRemainSpace(String areaNo, String passportTypeNo) {
        CarparkArea area;
        if (areaNo == null || areaNo.length() == 0) {
            return 0;
        }
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        CarparkArea carparkArea = area = areaMap == null ? null : areaMap.get(areaNo);
        if (area == null) {
            return 0;
        }
        if (area.getChildren() == null || area.getChildren().isEmpty()) {
            return ParkingSpace.getInstance().getRemainSpace(areaNo);
        }
        if (passportTypeNo == null || passportTypeNo.length() == 0) {
            return ParkingSpace.getInstance().getRemainSpace(areaNo);
        }
        HashSet<String> allowSet = new HashSet<String>();
        Map<String, List<String>> areaChannelMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreaChannelsMap();
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, ChannelArea> chanelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        if (areaChannelMap != null && channelMap != null && chanelAreaMap != null) {
            block0: for (CarparkArea subArea : area.getChildren()) {
                List<String> channelNos = areaChannelMap.get(subArea.getArea_no());
                if (channelNos == null || channelNos.isEmpty()) continue;
                for (String channelNo : channelNos) {
                    CarparkChannel passChannel;
                    ChannelArea ca = chanelAreaMap.get(channelNo);
                    if (ca == null) continue;
                    if (ca.getEnterAreas() != null && !ca.getEnterAreas().isEmpty()) {
                        boolean con = false;
                        for (CarparkArea t : ca.getEnterAreas()) {
                            if (!subArea.getArea_no().equals(t.getArea_no())) continue;
                            con = true;
                            break;
                        }
                        if (!con) continue;
                    }
                    if ((passChannel = channelMap.get(channelNo)) == null || PassPermissionFilter.isStrategyForbidPass(passChannel, passportTypeNo) || areaNo.equals(subArea.getArea_no())) continue;
                    allowSet.add(subArea.getArea_no());
                    continue block0;
                }
            }
        }
        if (allowSet.isEmpty()) {
            return ParkingSpace.getInstance().getRemainSpaceWithoutSub(areaNo);
        }
        int ax = ParkingSpace.getInstance().getRemainSpaceWithoutSub(areaNo);
        for (String sub : allowSet) {
            ax += PassParkingFullFilter.getAreaRemainSpace(sub, passportTypeNo);
        }
        return ax;
    }
}

