/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDateRange;
import com.wovoe.carpark.dto.CarparkPassPermission;
import com.wovoe.carpark.dto.CarparkPassPermissionChannel;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassExpiredFilter;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.vo.PassPermissionVo;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PassPermissionFilter
implements PassFilter {
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        CarparkPassportType restPassportType;
        CarparkPassport resetPassport;
        block29: {
            String keyName2;
            String keyName;
            boolean unManned;
            if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
                return true;
            }
            CarparkChannel channel = session.getPassChannel().getChannel();
            boolean bl = unManned = channel.getChannel_mode() == 1 || session.getPassChannel().isOtherHostChannel();
            if (unManned) {
                keyName = "CHANNEL_PASSTYPE_PASS_1";
                keyName2 = "CHANNEL_PASSTYPE_NO_PERMISSION_PASS_1";
            } else {
                keyName = "CHANNEL_PASSTYPE_PASS_0";
                keyName2 = "CHANNEL_PASSTYPE_NO_PERMISSION_PASS_0";
            }
            String value = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), session.getPassportType().getPassport_type_no(), keyName);
            resetPassport = null;
            restPassportType = null;
            if (session.getAllowPassExcetpions() != null && (session.getAllowPassExcetpions().contains(7) || session.getAllowPassExcetpions().contains(8)) && session.getDatabasePassport() != null && session.getDatabasePassportType() != null && session.getDatabasePassportType().getPass_type() == 2 && session.getPassportType().getPass_type() == 0) {
                String value1 = PassExpiredFilter.getExpireValue(session, session.getDatabasePassportType().getPassport_type_no());
                if ("3".equals(value1)) {
                    String text;
                    session.setPassport(session.getDatabasePassport());
                    session.setPassportType(session.getDatabasePassportType());
                    if (session.getAllowPassExcetpions().contains(7)) {
                        session.getAllowPassExcetpions().remove(7);
                        session.getForbidPassExceptions().add(7);
                        text = "\u672a\u542f\u7528";
                    } else {
                        session.getAllowPassExcetpions().remove(8);
                        session.getForbidPassExceptions().add(8);
                        text = "\u5df2\u505c\u7528";
                    }
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    try {
                        displayVoiceService.dateExpired(session);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                    }
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c" + text + "\uff0c\u7981\u6b62\u901a\u884c\uff01" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 4));
                    return false;
                }
                if ("2".equals(value1)) {
                    if (session.getAllowPassExcetpions().contains(7)) {
                        session.getAllowPassExcetpions().remove(7);
                        session.getConfirmPassExceptions().add(7);
                    } else {
                        session.getAllowPassExcetpions().remove(8);
                        session.getConfirmPassExceptions().add(8);
                    }
                    value = value1;
                    resetPassport = session.getDatabasePassport();
                    restPassportType = session.getPassportType();
                    session.setPassport(session.getDatabasePassport());
                    session.setPassportType(session.getDatabasePassportType());
                }
            }
            if (value != null && "3".equals(value)) {
                if (session.getAttribute("GUI_CONFIRM") != null || session.getReadPassportNumberEvent().isManualTrigger() || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                    session.getConfirmPassExceptions().add(1);
                } else {
                    session.getForbidPassExceptions().add(1);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    try {
                        displayVoiceService.forbidPass(session);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                    }
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c\u65e0\u6743\u9650\u901a\u884c\uff01" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 4));
                    return false;
                }
            }
            try {
                String va = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channel.getChannel_no(), "CHANNEL_AUTH");
                if (va == null || !"1".equals(va) || this.havePermission(session)) break block29;
                if (session.getAttribute("GUI_CONFIRM") != null || session.getReadPassportNumberEvent().isManualTrigger() || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                    session.getConfirmPassExceptions().add(1);
                    break block29;
                }
                String value2 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), session.getPassportType().getPassport_type_no(), keyName2);
                if ("2".equals(value2)) {
                    session.getConfirmPassExceptions().add(1);
                    break block29;
                }
                session.getForbidPassExceptions().add(1);
                session.setSessionState(PassSession.SessionState.CANCELED);
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                try {
                    displayVoiceService.noPermissionPass(session);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                }
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(channel.getChannel_name()) + "\uff1a" + (session.getPassPlate() == null ? session.getReadPassportNumberEvent().getPassportNumber() : session.getPassPlate()) + "\uff0c\u65e0\u6743\u9650\u901a\u884c\uff01" + session.getPassportType().getPassport_type_name() + "\u3001" + session.getCarType().getCar_type_name(), 4));
                if (resetPassport != null) {
                    session.setPassport(resetPassport);
                }
                if (restPassportType != null) {
                    session.setPassportType(restPassportType);
                }
                return false;
            }
            catch (Throwable throwable) {
                if (resetPassport != null) {
                    session.setPassport(resetPassport);
                }
                if (restPassportType != null) {
                    session.setPassportType(restPassportType);
                }
                throw throwable;
            }
        }
        if (resetPassport != null) {
            session.setPassport(resetPassport);
        }
        if (restPassportType != null) {
            session.setPassportType(restPassportType);
        }
        return true;
    }

    public static boolean isStrategyForbidPass(CarparkChannel channel, String passportTypeNo) {
        boolean unManned = channel.getChannel_mode() == 1;
        String keyName = unManned ? "CHANNEL_PASSTYPE_PASS_1" : "CHANNEL_PASSTYPE_PASS_0";
        String value = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), passportTypeNo, keyName);
        return value != null && "3".equals(value);
    }

    public static boolean isEnableChannelAuth(String channelNo) {
        String va = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_AUTH");
        return va != null && "1".equals(va);
    }

    public static boolean isNoPermissionForbidPass(CarparkChannel channel, String passportTypeNo) {
        boolean unManned = channel.getChannel_mode() == 1;
        String keyName = unManned ? "CHANNEL_PASSTYPE_NO_PERMISSION_PASS_1" : "CHANNEL_PASSTYPE_NO_PERMISSION_PASS_0";
        String value2 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channel.getChannel_no(), passportTypeNo, keyName);
        return !"2".equals(value2);
    }

    protected boolean havePermission(PassSession session) {
        String passportTypeNo = session.getPassportType().getPassport_type_no();
        String carTypeNo = session.getCarType().getCar_type_no();
        String passportNumber = session.getReadPassportNumberEvent().getPassportNumber();
        String channelNo = session.getPassChannel().getChannelNo();
        return PassPermissionFilter.havePermission(channelNo, passportTypeNo, carTypeNo, passportNumber);
    }

    public static boolean havePermission(String channelNo, String passportTypeNo, String carTypeNo, String passportNumber) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        HashSet<String> set = new HashSet<String>();
        if (passportTypeNo != null && passportTypeNo.length() > 0) {
            set.add(passportTypeNo);
        }
        if (carTypeNo != null && carTypeNo.length() > 0) {
            set.add(carTypeNo);
        }
        if (passportNumber != null && passportNumber.length() > 0) {
            set.add(passportNumber);
        }
        if (set.isEmpty()) {
            return false;
        }
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        String dateRangeTableName = commonDaoService.getTableName(CarparkDateRange.class);
        String joinTableName = String.valueOf(commonDaoService.getTableName(CarparkPassPermission.class)) + " a JOIN " + commonDaoService.getTableName(CarparkPassPermissionChannel.class) + " b ON a.pass_permission_no=b.pass_permission_no ";
        SearchParam sp = new SearchParam(joinTableName);
        sp.setQueryFields(new String[]{"a.pass_permission_no", "a.auth_type", "a.auth_type_no", "a.date_range_type", "a.date_range_value", "a.auth_value"});
        if (set.size() == 1) {
            sp.addEQ("a.auth_type_no", ServiceUtil.getFirstElement(set));
        } else {
            sp.addINList("a.auth_type_no", set);
        }
        sp.addEQ("b.channel_no", (Object)channelNo);
        List passPermissionVoList = commonDaoService.selectList(sp, PassPermissionVo.class, null);
        if (passPermissionVoList == null || passPermissionVoList.isEmpty()) {
            return false;
        }
        LinkedHashMap<String, PassPermissionVo> forbidPassRulesMap = null;
        LinkedHashMap<String, PassPermissionVo> allowPassRulesMap = null;
        for (PassPermissionVo rule : passPermissionVoList) {
            if (rule.getAuth_type() == null || rule.getAuth_type_no() == null || !(rule.getAuth_type() == 0 && rule.getAuth_type_no().equals(passportTypeNo) || rule.getAuth_type() == 1 && rule.getAuth_type_no().equals(carTypeNo)) && (rule.getAuth_type() != 2 || !rule.getAuth_type_no().equals(passportNumber)) || rule == null || rule.getAuth_value() == null) continue;
            if (rule.getAuth_value() == 1) {
                if (allowPassRulesMap == null) {
                    allowPassRulesMap = new LinkedHashMap<String, PassPermissionVo>();
                }
                allowPassRulesMap.put(rule.getPass_permission_no(), rule);
                continue;
            }
            if (rule.getAuth_value() != 0) continue;
            if (forbidPassRulesMap == null) {
                forbidPassRulesMap = new LinkedHashMap<String, PassPermissionVo>();
            }
            forbidPassRulesMap.put(rule.getPass_permission_no(), rule);
        }
        if (allowPassRulesMap == null || allowPassRulesMap.isEmpty()) {
            return false;
        }
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        Date now = cl.getTime();
        int week0 = cl.get(7) - 1;
        if (week0 == 0) {
            week0 = 7;
        }
        String week = String.valueOf(week0);
        if (forbidPassRulesMap != null && !forbidPassRulesMap.isEmpty()) {
            for (PassPermissionVo vo : forbidPassRulesMap.values()) {
                if (!PassPermissionFilter.isMatchPassRule(commonDaoService, cl, now, week, vo, dateRangeTableName, carpark_id)) continue;
                return false;
            }
        }
        if (allowPassRulesMap != null && !allowPassRulesMap.isEmpty()) {
            for (PassPermissionVo vo : allowPassRulesMap.values()) {
                if (!PassPermissionFilter.isMatchPassRule(commonDaoService, cl, now, week, vo, dateRangeTableName, carpark_id)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isMatchPassRule(CommonDaoService commonDaoService, Calendar cl, Date now, String nowWeek, PassPermissionVo vo, String dateRangeTableName, Integer carparkId) {
        LinkedList<String> byTimeRangeSet = null;
        LinkedList<String> byDateRangeSet = null;
        Integer date_range_type = vo.getDate_range_type();
        String pass_permission_no = vo.getPass_permission_no();
        if (date_range_type == null || pass_permission_no == null || pass_permission_no.length() == 0) {
            return false;
        }
        if (date_range_type == 1) {
            if (byTimeRangeSet == null) {
                byTimeRangeSet = new LinkedList<String>();
            }
            byTimeRangeSet.add(pass_permission_no);
        } else if (date_range_type == 2) {
            String date_range_value = vo.getDate_range_value();
            if (date_range_value != null && date_range_value.length() > 0 && date_range_value.indexOf(nowWeek) >= 0) {
                if (byTimeRangeSet == null) {
                    byTimeRangeSet = new LinkedList();
                }
                byTimeRangeSet.add(pass_permission_no);
            }
        } else if (date_range_type == 5) {
            if (byDateRangeSet == null) {
                byDateRangeSet = new LinkedList<String>();
            }
            byDateRangeSet.add(pass_permission_no);
        }
        if (byTimeRangeSet != null && !byTimeRangeSet.isEmpty()) {
            cl.set(1, 2000);
            cl.set(2, 0);
            cl.set(5, 1);
            Date qDAte = cl.getTime();
            if (PassPermissionFilter.findMatchRange(byTimeRangeSet, qDAte, commonDaoService, carparkId, dateRangeTableName)) {
                return true;
            }
        }
        return byDateRangeSet != null && !byDateRangeSet.isEmpty() && PassPermissionFilter.findMatchRange(byDateRangeSet, now, commonDaoService, carparkId, dateRangeTableName);
    }

    private static boolean findMatchRange(List<String> pList, Date date, CommonDaoService commonDaoService, Integer carparkId, String dateRangeTableName) {
        if (pList == null || pList.isEmpty() || date == null) {
            return false;
        }
        SearchParam sm = new SearchParam(dateRangeTableName);
        sm.addEQ("carpark_id", (Object)carparkId);
        sm.addLTE("range_begin", (Object)date);
        sm.addGTE("range_end", (Object)date);
        sm.addEQ("ref_type", (Object)0);
        if (pList.size() == 1) {
            sm.addEQ("ref_no", (Object)pList.get(0));
        } else {
            sm.addINList("ref_no", pList);
        }
        sm.setQueryFields(new String[]{"id"});
        sm.setOrder_by("id");
        Pagination p = new Pagination();
        p.setNeedQueryCount(false);
        p.setRecordsCount(1L);
        p.setGotoPage(1);
        p.setPageSize(1);
        List rangeList = commonDaoService.selectList(sm, p);
        Map r = null;
        if (rangeList != null && !rangeList.isEmpty()) {
            r = (Map)rangeList.get(0);
        }
        return r != null && r.get("id") != null;
    }
}

