/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.service.DisplayVoiceService;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PassSuccessFilter
implements PassFilter {
    public static final ThreadLocal<Collection<PassSuccessFilterInterceptor>> InterceptorsLocal = new ThreadLocal();

    @Override
    public boolean doFilter(PassSession session) throws Exception {
        if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
            if (session.getSessionState() == PassSession.SessionState.WAIT_CAR_LEAVE) {
                session.setSessionState(PassSession.SessionState.CAR_LEAVING);
                PassSuccessFilter.throwUpdateRecrodUI(session, this);
            }
            return true;
        }
        LinkedList list = new LinkedList();
        InterceptorsLocal.set(list);
        try {
            session.setDsiplay1MsgWhenMoney(null);
            ScheduledFuture<?> sss = session.getReDisplayPayMsg1Task();
            if (sss != null) {
                try {
                    sss.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                session.setReDisplayPayMsg1Task(null);
            }
            if (session.getSessionState() == PassSession.SessionState.WAIT_CAR_LEAVE) {
                List<Equipment> gateList;
                session.setSessionState(PassSession.SessionState.CAR_LEAVING);
                if (session.getAttribute("CONTROL_BOX_OPEN_POLE") == null) {
                    session.getPassChannel().openPole(session);
                }
                try {
                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    displayVoiceService.playPassSuccess(session);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u64ad\u653e\u653e\u884c\u6210\u529f\u663e\u793a\u4e0e\u8bed\u97f3\u5f02\u5e38", (Throwable)ex);
                }
                String passPlate = session.getPassPlate();
                if (passPlate != null && passPlate.length() > 0 && (gateList = session.getPassChannel().getEquipmentList(9)) != null && !gateList.isEmpty()) {
                    for (Equipment eq : gateList) {
                        List<String> channelNos = eq.getChannelNos();
                        if (channelNos == null || channelNos.isEmpty()) continue;
                        for (String channelNo : channelNos) {
                            if (session.getPassChannel().getChannelNo().equals(channelNo)) continue;
                            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)("PASS_CHANNEL_DISCARD_PLATE_" + channelNo + ":" + passPlate), (Object)(String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u5171\u95f8\u901a\u884c"), null, 60L, TimeUnit.SECONDS);
                        }
                    }
                }
            }
            PassSuccessFilter.throwUpdateRecrodUI(session, this);
        }
        finally {
            try {
                for (PassSuccessFilterInterceptor i : list) {
                    if (i == null) continue;
                    i.doFilterNext(session);
                }
            }
            finally {
                InterceptorsLocal.remove();
            }
        }
        return true;
    }

    public static void throwUpdateRecrodUI(PassSession session, Object source) {
        List passRecordList;
        if (source == null) {
            source = session;
        }
        if ((passRecordList = (List)session.getAttribute("SAVED_PASSRECORD_LIST")) != null && !passRecordList.isEmpty()) {
            ChannelArea channelArea;
            CarparkPassRecord r = (CarparkPassRecord)passRecordList.get(0);
            if (passRecordList.size() > 1 && (channelArea = (ChannelArea)session.getAttribute("channelArea")) != null) {
                CarparkArea rootArea;
                if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                    CarparkArea rootArea2 = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
                    if (rootArea2 != null) {
                        for (CarparkPassRecord r1 : passRecordList) {
                            if (!rootArea2.getArea_no().equals(r1.getArea_no())) continue;
                            r = r1;
                            break;
                        }
                    }
                } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty() && (rootArea = channelArea.getEnterAreas().get(0)) != null) {
                    for (CarparkPassRecord r1 : passRecordList) {
                        if (!rootArea.getArea_no().equals(r1.getArea_no())) continue;
                        r = r1;
                        break;
                    }
                }
            }
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new LocalPassRecordEvent(source, r));
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(source, r));
        }
    }

    public static interface PassSuccessFilterInterceptor {
        public void doFilterNext(PassSession var1);
    }
}

