/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkVisitAuth;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PassVisitPassTypeFilter
implements PassFilter {
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        session.setVisitCar(null);
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
            return true;
        }
        if (session.getDatabasePassport() != null) {
            return true;
        }
        if (session.getPassportType().getPass_type() != 0) {
            return true;
        }
        if (session.getCarOwner() != null) {
            return true;
        }
        String plateNo = session.getPassPlate();
        if (plateNo == null || plateNo.length() < 5 || plateNo.length() > 10) {
            return true;
        }
        Map<String, CarparkPassportType> tm = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (tm == null || tm.isEmpty()) {
            return true;
        }
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
            CarparkArea enterArea;
            List<CarparkArea> areaList = channelArea.getEnterAreas();
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(daoService.getTableName(CarparkVisitAuth.class));
            sp.addEQ("plate_number", (Object)plateNo);
            if (areaList.size() == 1) {
                sp.addEQ("visit_area_no", (Object)areaList.get(0).getArea_no());
            } else {
                for (CarparkArea area : areaList) {
                    sp.addIN("visit_area_no", (Object)area.getArea_no());
                }
            }
            Date passTime = (Date)session.getAttribute("passTime");
            sp.addLTE("visit_begin_time", (Object)passTime);
            sp.addGTE("visit_end_time", (Object)passTime);
            sp.addEQ("status", (Object)1);
            sp.setWhereString("AND pass_times<auth_times");
            sp.setOrder_by("visit_begin_time,id");
            Pagination p = new Pagination();
            int fetchSize = 20;
            p.setRecordsCount((long)fetchSize);
            p.setGotoPage(1);
            p.setNeedQueryCount(false);
            p.setPageSize(fetchSize);
            List authList = daoService.selectList(sp, CarparkVisitAuth.class, p);
            if (authList != null && !authList.isEmpty()) {
                for (CarparkVisitAuth auth : authList) {
                    CarparkPassportType t = tm.get(auth.getPassport_type_no());
                    if (t == null || t.getPass_type() != 5) continue;
                    session.setVisitCar(auth);
                    session.setPassportType(t);
                    session.getPassport().setPassport_type_no(t.getPassport_type_no());
                    return true;
                }
            }
            if ((enterArea = channelArea.getEnterAreas().get(0)).getArea_level() > 1 && enterArea.getParent_area_no() != null) {
                CarparkPassportType t;
                Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
                if (areaPresenceRecordMap == null || areaPresenceRecordMap.isEmpty()) {
                    return true;
                }
                CarparkPresenceRecord x1 = (CarparkPresenceRecord)areaPresenceRecordMap.get(enterArea.getParent_area_no());
                if (x1 == null) {
                    for (CarparkPresenceRecord r1 : areaPresenceRecordMap.values()) {
                        if (r1.getArea_level() == null || r1.getArea_level() != 1) continue;
                        x1 = r1;
                        break;
                    }
                }
                if (x1 != null && x1.getPassport_type_no() != null && (t = tm.get(x1.getPassport_type_no())) != null && t.getPass_type() == 5) {
                    session.setPassportType(t);
                    session.getPassport().setPassport_type_no(t.getPassport_type_no());
                    return true;
                }
            }
        } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            CarparkPassportType t;
            Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
            if (areaPresenceRecordMap == null || areaPresenceRecordMap.isEmpty()) {
                return true;
            }
            CarparkArea exitArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
            CarparkPresenceRecord x1 = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
            if (x1 == null) {
                if (exitArea.getArea_level() > 1 && exitArea.getParent_area_no() != null) {
                    x1 = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getParent_area_no());
                    if (x1 == null) {
                        for (CarparkPresenceRecord r1 : areaPresenceRecordMap.values()) {
                            if (r1.getArea_level() == null || r1.getArea_level() != 1) continue;
                            x1 = r1;
                            break;
                        }
                    }
                } else {
                    return true;
                }
            }
            if (x1 != null && x1.getPassport_type_no() != null && (t = tm.get(x1.getPassport_type_no())) != null && t.getPass_type() == 5) {
                session.setPassportType(t);
                session.getPassport().setPassport_type_no(t.getPassport_type_no());
                return true;
            }
        }
        return true;
    }
}

