/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalPassDataCache;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPlateCarType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.pass.filter.SavePassDataFilterInterceptor;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.SavePassData;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSession;

public class SavePassDataFilter
implements PassFilter {
    public static final String SAVEPASSDATASUCCESS = "SavePassDataFilter.SAVEPASSDATASUCCESS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doFilter(PassSession session) throws Exception {
        block5: {
            PassSession passSession = session;
            synchronized (passSession) {
                block4: {
                    if (session.getAttribute(SAVEPASSDATASUCCESS) != null) break block5;
                    SavePassDataFilterInterceptor iner = (SavePassDataFilterInterceptor)session.getAttribute(SavePassDataFilterInterceptor.class.getName());
                    if (iner == null || iner.onFilterBefore(session)) break block4;
                    return false;
                }
                this.doSaveSessionData(session);
                session.setAttribute(SAVEPASSDATASUCCESS, Boolean.TRUE);
            }
        }
        return true;
    }

    public SavePassData createSavePassData(PassSession session) {
        String tableName;
        boolean isReadCard = session.isReadCard();
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        Date passTime = (Date)session.getAttribute("passTime");
        LinkedList<CarparkPassRecord> passRecordList = new LinkedList<CarparkPassRecord>();
        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        LinkedList<CarparkDispatchTask> regPlateTaskList = null;
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        LinkedHashSet<String> dispatchPicPaths = new LinkedHashSet<String>();
        HashSet<String> picAlreadyDispathPaths = new HashSet<String>();
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        PlateRecognizedEvent plateRecognizedEvent = session.getPlateRecognizedEvent();
        Collection<Integer> cl1 = session.getConfirmPassExceptions();
        Collection<Integer> cl2 = session.getAllowPassExcetpions();
        Collection<Integer> cl3 = session.getForbidPassExceptions();
        HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
        if (cl1 != null) {
            exceptionValueSet.addAll(cl1);
        }
        if (cl2 != null) {
            exceptionValueSet.addAll(cl2);
        }
        if (cl3 != null) {
            exceptionValueSet.addAll(cl3);
        }
        int pass_state_value = 0;
        if (exceptionValueSet.contains(6)) {
            pass_state_value = 6;
        } else if (exceptionValueSet.contains(7)) {
            pass_state_value = 7;
        } else if (exceptionValueSet.contains(8)) {
            pass_state_value = 8;
        } else if (exceptionValueSet.contains(4)) {
            pass_state_value = 4;
        } else if (exceptionValueSet.contains(1)) {
            pass_state_value = 1;
        } else if (exceptionValueSet.contains(9)) {
            pass_state_value = 9;
        }
        if (plateRecognizedEvent == null && session.getReadPassportNumberEvent() != null) {
            plateRecognizedEvent = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
        }
        UserSession userSession = appService.getUserSession();
        if (plateRecognizedEvent != null && plateRecognizedEvent.isPicAlreadyDispath() && localHost.getHost_use() == 1) {
            picAlreadyDispathPaths.add(plateRecognizedEvent.getPicDBPath());
            picAlreadyDispathPaths.add(plateRecognizedEvent.getPicDBSmallPath());
            regPlateTaskList = plateRecognizedEvent.removeRegRecordAndPicTaskList();
            if (regPlateTaskList != null) {
                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(regPlateTaskList);
            }
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long dispathServerTimeMills = 0L;
        CarparkPassRecord rootExitRecord = null;
        CarparkPresenceRecord takeChargeRecord = (CarparkPresenceRecord)session.getAttribute("takeChargeRecord");
        Cost cost = (Cost)session.getAttribute("pass_cost");
        if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() && session.getAttribute("ONLY_SAVE_ENTER_AREA_RECORD") == null) {
            LinkedList<CarparkArea> existAreaList = (LinkedList<CarparkArea>)session.getAttribute("PASS_EXIT_AREA_LIST");
            if (existAreaList == null) {
                existAreaList = new LinkedList<CarparkArea>();
            }
            if (existAreaList.isEmpty()) {
                existAreaList.add(channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1));
            }
            CarparkArea rootArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
            Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
            for (CarparkArea area : existAreaList) {
                List<CaptureEvent> capList;
                CarparkPassRecord carparkPassRecord = new CarparkPassRecord();
                CarparkPresenceRecord enterRecord = null;
                if (areaPresenceRecordMap != null) {
                    enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(area.getArea_no());
                }
                if (enterRecord != null) {
                    JavaBeanMap map1 = new JavaBeanMap((Object)enterRecord);
                    JavaBeanMap map2 = new JavaBeanMap((Object)carparkPassRecord);
                    Set nemes = map1.keySet();
                    String enter_ = "enter_";
                    for (String nem : nemes) {
                        if (!nem.startsWith(enter_)) continue;
                        map2.put(nem, map1.get((Object)nem));
                    }
                    carparkPassRecord.setSecret_free_payment(enterRecord.getSecret_free_payment());
                    carparkPassRecord.setPlate_color(enterRecord.getPlate_color());
                    carparkPassRecord.setCar_logo(enterRecord.getCar_logo());
                    carparkPassRecord.setCar_color(enterRecord.getCar_color());
                    if (enterRecord.getVisit_auth_no() != null && enterRecord.getVisit_auth_no().length() > 0) {
                        carparkPassRecord.setVisit_auth_no(enterRecord.getVisit_auth_no());
                    }
                    carparkPassRecord.setOccupy_plate(enterRecord.getOccupy_plate());
                    carparkPassRecord.setOccupy_end_time(enterRecord.getOccupy_end_time());
                    carparkPassRecord.setOccupy_passport_type_no(enterRecord.getOccupy_passport_type_no());
                }
                long passRecordId = appService.createLocalRecordSeq("ck_carpark_pass_record_seq");
                carparkPassRecord.setId(passRecordId);
                carparkPassRecord.setExit_record_no("C" + carparkPassRecord.getId().toString());
                carparkPassRecord.setCreated_time(ServiceUtil.getNow());
                carparkPassRecord.setPassport_no(session.getPassport().getPassport_no());
                carparkPassRecord.setPassport_number(session.getPassport().getPassport_number());
                carparkPassRecord.setMedium_type(session.getPassport().getMedium_type());
                carparkPassRecord.setPass_type(session.getPassportType().getPass_type());
                carparkPassRecord.setPassport_type_no(session.getPassportType().getPassport_type_no());
                carparkPassRecord.setPassport_type_name(session.getPassportType().getPassport_type_name());
                if (session.getCarOwner() != null) {
                    carparkPassRecord.setCar_owner_no(session.getCarOwner().getCar_owner_no());
                    carparkPassRecord.setCar_owner_name(session.getCarOwner().getCar_owner_name());
                    carparkPassRecord.setCar_owner_addr(ServiceUtil.getString(session.getCarOwner().getAddress(), 100));
                    if (session.getPassport().getSpace_reg_no() == null || session.getPassport().getSpace_reg_no().length() == 0) {
                        carparkPassRecord.setOccupy_space_reg_no(session.getPassport().getRegister_plate());
                    } else {
                        carparkPassRecord.setOccupy_space_reg_no(session.getPassport().getSpace_reg_no());
                    }
                }
                carparkPassRecord.setArea_no(area.getArea_no());
                carparkPassRecord.setParent_area_no(area.getParent_area_no());
                carparkPassRecord.setArea_level(area.getArea_level());
                carparkPassRecord.setArea_name(area.getArea_name());
                carparkPassRecord.setPass_time(passTime);
                String sessionPassPlate = null;
                if (isReadCard) {
                    sessionPassPlate = (String)session.getAttribute("GUI_INPUT_PLATE");
                }
                if (sessionPassPlate == null || sessionPassPlate.length() == 0) {
                    sessionPassPlate = session.getPassPlate();
                }
                if (sessionPassPlate == null) {
                    sessionPassPlate = "";
                }
                carparkPassRecord.setPass_plate(sessionPassPlate);
                if (plateRecognizedEvent != null) {
                    if (plateRecognizedEvent.getPlateColor() != null && plateRecognizedEvent.getPlateColor().length() > 0) {
                        carparkPassRecord.setPlate_color(ServiceUtil.getString(plateRecognizedEvent.getPlateColor(), 15));
                    }
                    if (plateRecognizedEvent.getCarLogo() != null && plateRecognizedEvent.getCarLogo().length() > 0) {
                        carparkPassRecord.setCar_logo(ServiceUtil.getString(plateRecognizedEvent.getCarLogo(), 45));
                    }
                    if (plateRecognizedEvent.getVehicleColor() != null && plateRecognizedEvent.getVehicleColor().length() > 0) {
                        carparkPassRecord.setCar_color(ServiceUtil.getString(plateRecognizedEvent.getVehicleColor(), 15));
                    }
                }
                carparkPassRecord.setExit_time(passTime);
                carparkPassRecord.setExit_channel_no(session.getPassChannel().getChannelNo());
                carparkPassRecord.setExit_channel_name(session.getPassChannel().getChannel().getChannel_name());
                carparkPassRecord.setExit_car_type_no(session.getCarType().getCar_type_no());
                carparkPassRecord.setExit_car_type_name(session.getCarType().getCar_type_name());
                String defaultCarTypeNo = (String)session.getAttribute("DEFAULT_CARTYPE_NO");
                carparkPassRecord.setExit_default_car_type_no(defaultCarTypeNo);
                carparkPassRecord.setExit_plate(carparkPassRecord.getPass_plate());
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber().length() > 0 && session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU) {
                    carparkPassRecord.setExit_obu_plate(session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber());
                }
                if (plateRecognizedEvent != null) {
                    carparkPassRecord.setExit_reg_plate(plateRecognizedEvent.getPlateNumber());
                }
                if (carparkPassRecord.getExit_plate() != null && carparkPassRecord.getExit_plate().length() > 0) {
                    if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                        carparkPassRecord.setExit_plate_source(1);
                    } else if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan() && session.getReadPassportNumberEvent().getPlateNumber() != null) {
                        carparkPassRecord.setExit_plate_source(5);
                    } else if (session.isReadCard()) {
                        carparkPassRecord.setExit_plate_source(6);
                    } else if (carparkPassRecord.getExit_obu_plate() != null && carparkPassRecord.getExit_obu_plate().length() > 0) {
                        if (carparkPassRecord.getExit_plate().equals(carparkPassRecord.getExit_obu_plate())) {
                            carparkPassRecord.setExit_plate_source(3);
                        } else {
                            carparkPassRecord.setExit_plate_source(2);
                        }
                    } else if (carparkPassRecord.getExit_reg_plate() != null && carparkPassRecord.getExit_reg_plate().length() > 0) {
                        if (carparkPassRecord.getExit_plate().equals(carparkPassRecord.getExit_reg_plate())) {
                            carparkPassRecord.setExit_plate_source(0);
                        } else if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                            carparkPassRecord.setExit_plate_source(2);
                        } else {
                            carparkPassRecord.setExit_plate_source(4);
                        }
                    }
                }
                if (localHost != null) {
                    carparkPassRecord.setExit_host_no(localHost.getHost_no());
                    carparkPassRecord.setExit_host_name(localHost.getHost_name());
                }
                if (userSession != null) {
                    if (userSession.getDutyNumber() != null) {
                        carparkPassRecord.setExit_duty_no(userSession.getDutyNumber().getDuty_no());
                    } else {
                        carparkPassRecord.setExit_duty_no("0");
                    }
                    if (userSession.getUser() != null) {
                        carparkPassRecord.setExit_duty_user_code(userSession.getUser().getUser_code());
                        carparkPassRecord.setExit_duty_user_name(userSession.getUser().getUser_name());
                    } else {
                        carparkPassRecord.setExit_duty_user_code("admin");
                        carparkPassRecord.setExit_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                    }
                } else {
                    carparkPassRecord.setExit_duty_no("0");
                    carparkPassRecord.setExit_duty_user_code("admin");
                    carparkPassRecord.setExit_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                }
                carparkPassRecord.setExit_lan_state(this.getLanState(session));
                if (plateRecognizedEvent != null) {
                    carparkPassRecord.setExit_car_pic(plateRecognizedEvent.getPicDBPath());
                    carparkPassRecord.setExit_plate_pic(plateRecognizedEvent.getPicDBSmallPath());
                }
                if (session.getReadPassportNumberEvent() != null && (capList = session.getReadPassportNumberEvent().getCaptures()) != null && !capList.isEmpty()) {
                    RecordSaveService rService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    for (CaptureEvent cevent : capList) {
                        if (cevent.getPicture_use() == 1) {
                            if (carparkPassRecord.getExit_car_pic() != null && carparkPassRecord.getExit_car_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x2 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x2 == null || x2 != 0) continue;
                                    carparkPassRecord.setExit_car_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                carparkPassRecord.setExit_car_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x2) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 4) {
                            if (carparkPassRecord.getExit_face_pic() != null && carparkPassRecord.getExit_face_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x3 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x3 == null || x3 != 0) continue;
                                    carparkPassRecord.setExit_face_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                carparkPassRecord.setExit_face_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x3) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 8) {
                            if (carparkPassRecord.getCertificate_pic() != null && carparkPassRecord.getCertificate_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x4 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x4 == null || x4 != 0) continue;
                                    carparkPassRecord.setCertificate_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                carparkPassRecord.setCertificate_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x4) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 2) {
                            if (carparkPassRecord.getExit_car_trail_pic() != null && carparkPassRecord.getExit_car_trail_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x5 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x5 == null || x5 != 0) continue;
                                    carparkPassRecord.setExit_car_trail_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                carparkPassRecord.setExit_car_trail_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x5) {}
                            continue;
                        }
                        if (cevent.getPicture_use() != 16 || carparkPassRecord.getExit_car_body_pic() != null && carparkPassRecord.getExit_car_body_pic().length() != 0) continue;
                        try {
                            if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                            if (cevent.getCaptureHandle().isDone()) {
                                Integer x = (Integer)cevent.getCaptureHandle().getResult();
                                if (x == null || x != 0) continue;
                                carparkPassRecord.setExit_car_body_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                continue;
                            }
                            dispathServerTimeMills = 6000L;
                            carparkPassRecord.setExit_car_body_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (carparkPassRecord.getExit_car_pic() != null && carparkPassRecord.getExit_car_pic().length() > 0) {
                    dispatchPicPaths.add(carparkPassRecord.getExit_car_pic());
                }
                if (carparkPassRecord.getExit_plate_pic() != null && carparkPassRecord.getExit_plate_pic().length() > 0) {
                    dispatchPicPaths.add(carparkPassRecord.getExit_plate_pic());
                }
                if (carparkPassRecord.getExit_face_pic() != null && carparkPassRecord.getExit_face_pic().length() > 0) {
                    dispatchPicPaths.add(carparkPassRecord.getExit_face_pic());
                }
                if (carparkPassRecord.getCertificate_pic() != null && carparkPassRecord.getCertificate_pic().length() > 0) {
                    dispatchPicPaths.add(carparkPassRecord.getCertificate_pic());
                }
                carparkPassRecord.setExit_remark(null);
                if (carparkPassRecord.getPass_type() != null && carparkPassRecord.getPass_type() == 2) {
                    carparkPassRecord.setExit_valid_date(session.getPassport().getDeadline());
                }
                if (carparkPassRecord.getPass_type() != null && carparkPassRecord.getPass_type() == 1) {
                    carparkPassRecord.setExit_balance(session.getPassport().getBalance());
                }
                carparkPassRecord.setPass_state_value(pass_state_value);
                carparkPassRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                carparkPassRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                int state = 0;
                if (carparkPassRecord.getEnter_time() == null) {
                    state = 1;
                    if (carparkPassRecord.getExit_plate() != null && carparkPassRecord.getExit_plate().length() > 0 && carparkPassRecord.getExit_plate_source() != null) {
                        if (carparkPassRecord.getExit_plate_source() == 1) {
                            state = 3;
                        } else if (carparkPassRecord.getExit_plate_source() == 2) {
                            state = 4;
                        } else if (carparkPassRecord.getExit_plate_source() == 5) {
                            state = 7;
                        }
                    }
                } else if (carparkPassRecord.getExit_plate() != null && carparkPassRecord.getExit_plate().length() > 0) {
                    if (!carparkPassRecord.getExit_plate().equals(carparkPassRecord.getEnter_plate())) {
                        state = 2;
                    } else {
                        if (carparkPassRecord.getExit_plate_source() != null) {
                            if (carparkPassRecord.getExit_plate_source() == 1) {
                                state = 3;
                            } else if (carparkPassRecord.getExit_plate_source() == 2) {
                                state = 4;
                            } else if (carparkPassRecord.getExit_plate_source() == 5) {
                                state = 7;
                            }
                        }
                        if (state == 0 && carparkPassRecord.getEnter_plate() != null && carparkPassRecord.getEnter_plate().length() > 0 && carparkPassRecord.getEnter_plate_source() != null) {
                            if (carparkPassRecord.getEnter_plate_source() == 1) {
                                state = 3;
                            } else if (carparkPassRecord.getEnter_plate_source() == 2) {
                                String plate1 = carparkPassRecord.getEnter_reg_plate();
                                if (plate1 == null || plate1.length() == 0) {
                                    plate1 = carparkPassRecord.getEnter_obu_plate();
                                }
                                if (plate1 != null && plate1.length() > 0) {
                                    if (!carparkPassRecord.getEnter_plate().equals(plate1)) {
                                        state = 4;
                                    }
                                } else {
                                    state = 3;
                                }
                            } else if (carparkPassRecord.getEnter_plate_source() == 5) {
                                state = 7;
                            }
                        }
                    }
                }
                if (session.getAttribute("SAVE_PASS_STATE") != null) {
                    carparkPassRecord.setRecord_state((Integer)session.getAttribute("SAVE_PASS_STATE"));
                } else if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                    carparkPassRecord.setRecord_state(31);
                } else {
                    carparkPassRecord.setRecord_state(state);
                }
                carparkPassRecord.setPass_channel_no(carparkPassRecord.getExit_channel_no());
                carparkPassRecord.setPass_duty_user_code(carparkPassRecord.getExit_duty_user_code());
                carparkPassRecord.setPass_host_no(carparkPassRecord.getExit_host_no());
                carparkPassRecord.setPass_car_type_no(carparkPassRecord.getExit_car_type_no());
                if (enterRecord == null) {
                    Pagination xp = new Pagination();
                    xp.setNeedQueryCount(false);
                    xp.setRecordsCount(1L);
                    xp.setGotoPage(1);
                    xp.setPageSize(1);
                    SearchParam sp1x = new SearchParam();
                    sp1x.addEQ("area_no", (Object)carparkPassRecord.getArea_no());
                    sp1x.addEQ("passport_number", (Object)carparkPassRecord.getPassport_number());
                    sp1x.addEQ("medium_type", (Object)carparkPassRecord.getMedium_type());
                    sp1x.addLT("pass_time", (Object)carparkPassRecord.getPass_time());
                    sp1x.setOrder_by("pass_time DESC");
                    sp1x.setQueryFields(new String[]{"id", "enter_time", "exit_time", "remove_user_code", "remove_user_name", "remove_enter_time", "remove_op_time"});
                    CarparkPassRecord entp = (CarparkPassRecord)commonDaoService.selectOne(sp1x, CarparkPassRecord.class, xp);
                    if (entp != null && entp.getEnter_time() != null && entp.getExit_time() == null && entp.getRemove_op_time() != null && entp.getRemove_user_code() != null) {
                        carparkPassRecord.setRemove_enter_time(entp.getRemove_enter_time());
                        carparkPassRecord.setRemove_op_time(entp.getRemove_op_time());
                        carparkPassRecord.setRemove_user_code(entp.getRemove_user_code());
                        carparkPassRecord.setRemove_user_name(entp.getRemove_user_name());
                    }
                }
                if (rootArea != null && rootArea.getArea_no().equals(area.getArea_no())) {
                    rootExitRecord = carparkPassRecord;
                    if (takeChargeRecord != null) {
                        if (takeChargeRecord.getPassport_number() != null && takeChargeRecord.getPassport_number().length() > 0 && takeChargeRecord.getMedium_type() != null && takeChargeRecord.getMedium_type() == 6) {
                            carparkPassRecord.setTake_plate_number(takeChargeRecord.getPassport_number());
                        } else {
                            carparkPassRecord.setTake_plate_number(takeChargeRecord.getEnter_plate());
                        }
                        carparkPassRecord.setTake_enter_time(takeChargeRecord.getEnter_time());
                        if (takeChargeRecord.getEnter_passport_type_no() != null && takeChargeRecord.getEnter_passport_type_no().length() > 0) {
                            carparkPassRecord.setTake_passport_type_no(takeChargeRecord.getEnter_passport_type_no());
                        } else {
                            carparkPassRecord.setTake_passport_type_no(takeChargeRecord.getPassport_type_no());
                        }
                    } else {
                        CarparkPresenceRecord occupyChargeRecord = (CarparkPresenceRecord)session.getAttribute("occupyChargeRecord");
                        if (occupyChargeRecord != null && occupyChargeRecord.getEnter_plate() != null) {
                            carparkPassRecord.setChange_plate(occupyChargeRecord.getEnter_plate());
                            carparkPassRecord.setChange_enter_time(occupyChargeRecord.getEnter_time());
                            carparkPassRecord.setChange_pass_type_no(occupyChargeRecord.getPassport_type_no());
                        }
                    }
                    if (cost != null) {
                        carparkPassRecord.setExit_fee_time_length(cost.getChargeTimeMinutes());
                        carparkPassRecord.setExit_should_charge(cost.getShouldCharged());
                        carparkPassRecord.setPeriod_multi_start(cost.getPeriod_multi_start());
                        carparkPassRecord.setPeriod_multi_received(cost.getPeriod_multi_received());
                        carparkPassRecord.setPeriod_multi_free(cost.getPeriod_multi_free());
                        carparkPassRecord.setNext_period_multi_start(cost.getNext_period_multi_start());
                        carparkPassRecord.setNext_period_multi_cur(cost.getNext_period_multi_cur());
                        carparkPassRecord.setExit_fee_start_time(cost.getCharge_start_time());
                        carparkPassRecord.setDiscount_money(cost.getDiscountMoney());
                        carparkPassRecord.setAlready_paid(cost.getAlready_paid());
                        carparkPassRecord.setAlready_paid_method(cost.getAlready_paid_method());
                        carparkPassRecord.setAlready_paid_scene(cost.getAlready_paid_scene());
                        carparkPassRecord.setAlready_paid_charge_org(cost.getAlready_paid_charge_org());
                        carparkPassRecord.setAlready_paid_time(cost.getAlready_paid_time());
                        if (cost.getAlreadyPaidList() != null) {
                            carparkPassRecord.setAlready_paid_times(cost.getAlreadyPaidList().size());
                        } else {
                            carparkPassRecord.setAlready_paid_times(0);
                        }
                        carparkPassRecord.setDeduct_money(cost.getDeduct_money());
                        carparkPassRecord.setCash_pay(cost.getCash());
                        List<CarparkPassDiscount> discountList = cost.getDiscountList();
                        if (discountList == null || discountList.isEmpty()) {
                            carparkPassRecord.setDiscount_times(0);
                        } else {
                            carparkPassRecord.setDiscount_times(discountList.size());
                            CarparkPassDiscount c = discountList.get(0);
                            carparkPassRecord.setDiscount_project_no(c.getDiscount_project_no());
                            carparkPassRecord.setDiscount_project_name(c.getDiscount_project_name());
                            carparkPassRecord.setDiscount_merchant_type(c.getDiscount_merchant_type());
                            carparkPassRecord.setDiscount_merchant_no(c.getDiscount_merchant_no());
                            carparkPassRecord.setDiscount_merchant_name(c.getDiscount_merchant_name());
                            carparkPassRecord.setDiscount_method(c.getDiscount_method());
                            carparkPassRecord.setDiscount_source(c.getDiscount_source());
                            carparkPassRecord.setDiscount_value(c.getDiscount_value());
                            carparkPassRecord.setDiscount_time(c.getDiscount_time());
                        }
                    }
                }
                passRecordList.add(carparkPassRecord);
            }
        }
        if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
            Long preEntryRecordId = (Long)session.getAttribute("PRE_ENTRY_RECORD_ID");
            for (CarparkArea area : channelArea.getEnterAreas()) {
                List<CaptureEvent> capList;
                CarparkPresenceRecord changePassTypeRecord;
                long passRecordId;
                CarparkPassRecord passRecord = new CarparkPassRecord();
                if (preEntryRecordId != null) {
                    passRecordId = preEntryRecordId;
                    preEntryRecordId = null;
                } else {
                    passRecordId = appService.createLocalRecordSeq("ck_carpark_pass_record_seq");
                }
                passRecord.setId(passRecordId);
                passRecord.setEnter_record_no("C" + passRecord.getId().toString());
                passRecord.setCreated_time(ServiceUtil.getNow());
                passRecord.setPassport_no(session.getPassport().getPassport_no());
                passRecord.setPassport_number(session.getPassport().getPassport_number());
                passRecord.setMedium_type(session.getPassport().getMedium_type());
                passRecord.setPass_type(session.getPassportType().getPass_type());
                passRecord.setPassport_type_no(session.getPassportType().getPassport_type_no());
                passRecord.setPassport_type_name(session.getPassportType().getPassport_type_name());
                if (session.getCarOwner() != null) {
                    passRecord.setCar_owner_no(session.getCarOwner().getCar_owner_no());
                    passRecord.setCar_owner_name(session.getCarOwner().getCar_owner_name());
                    passRecord.setCar_owner_addr(ServiceUtil.getString(session.getCarOwner().getAddress(), 100));
                    if (session.getPassport().getSpace_reg_no() == null || session.getPassport().getSpace_reg_no().length() == 0) {
                        passRecord.setOccupy_space_reg_no(session.getPassport().getRegister_plate());
                    } else {
                        passRecord.setOccupy_space_reg_no(session.getPassport().getSpace_reg_no());
                    }
                }
                passRecord.setArea_no(area.getArea_no());
                passRecord.setParent_area_no(area.getParent_area_no());
                passRecord.setArea_level(area.getArea_level());
                passRecord.setArea_name(area.getArea_name());
                passRecord.setPass_time(passTime);
                Object sessionPassPlate = null;
                if (isReadCard) {
                    sessionPassPlate = (String)session.getAttribute("GUI_INPUT_PLATE");
                }
                if (sessionPassPlate == null || ((String)sessionPassPlate).length() == 0) {
                    sessionPassPlate = session.getPassPlate();
                }
                if (sessionPassPlate == null) {
                    sessionPassPlate = "";
                }
                passRecord.setPass_plate((String)sessionPassPlate);
                passRecord.setEnter_passport_type_no(session.getPassportType().getPassport_type_no());
                if (session.getVisitCar() != null && area.getArea_no().equals(session.getVisitCar().getVisit_area_no())) {
                    passRecord.setVisit_auth_no(session.getVisitCar().getVisit_auth_no());
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setPlate_color(ServiceUtil.getString(plateRecognizedEvent.getPlateColor(), 15));
                    passRecord.setCar_logo(ServiceUtil.getString(plateRecognizedEvent.getCarLogo(), 45));
                    passRecord.setCar_color(ServiceUtil.getString(plateRecognizedEvent.getVehicleColor(), 15));
                }
                passRecord.setEnter_time(passTime);
                passRecord.setEnter_channel_no(session.getPassChannel().getChannelNo());
                passRecord.setEnter_channel_name(session.getPassChannel().getChannel().getChannel_name());
                passRecord.setEnter_car_type_no(session.getCarType().getCar_type_no());
                passRecord.setEnter_car_type_name(session.getCarType().getCar_type_name());
                String defaultCarTypeNo = (String)session.getAttribute("DEFAULT_CARTYPE_NO");
                passRecord.setEnter_default_car_type_no(defaultCarTypeNo);
                passRecord.setEnter_plate(passRecord.getPass_plate());
                if (area.getArea_level() > 1 && (changePassTypeRecord = (CarparkPresenceRecord)session.getAttribute("changePassTypeRecord")) != null && changePassTypeRecord.getEnter_plate() != null) {
                    passRecord.setChange_plate(changePassTypeRecord.getEnter_plate());
                    passRecord.setChange_enter_time(changePassTypeRecord.getEnter_time());
                    passRecord.setChange_pass_type_no(changePassTypeRecord.getPassport_type_no());
                }
                if (userSession != null) {
                    if (userSession.getDutyNumber() != null) {
                        passRecord.setEnter_duty_no(userSession.getDutyNumber().getDuty_no());
                    } else {
                        passRecord.setEnter_duty_no("0");
                    }
                    if (userSession.getUser() != null) {
                        passRecord.setEnter_duty_user_code(userSession.getUser().getUser_code());
                        passRecord.setEnter_duty_user_name(userSession.getUser().getUser_name());
                    } else {
                        passRecord.setEnter_duty_user_code("admin");
                        passRecord.setEnter_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                    }
                } else {
                    passRecord.setEnter_duty_no("0");
                    passRecord.setEnter_duty_user_code("admin");
                    passRecord.setEnter_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                }
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber().length() > 0 && session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU) {
                    passRecord.setEnter_obu_plate(session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber());
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setEnter_reg_plate(plateRecognizedEvent.getPlateNumber());
                }
                if (passRecord.getEnter_plate() != null && passRecord.getEnter_plate().length() > 0) {
                    if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                        passRecord.setEnter_plate_source(1);
                    } else if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan() && session.getReadPassportNumberEvent().getPlateNumber() != null) {
                        passRecord.setEnter_plate_source(5);
                    } else if (session.isReadCard()) {
                        passRecord.setEnter_plate_source(6);
                    } else if (passRecord.getEnter_obu_plate() != null && passRecord.getEnter_obu_plate().length() > 0) {
                        if (passRecord.getEnter_plate().equals(passRecord.getEnter_obu_plate())) {
                            passRecord.setEnter_plate_source(3);
                        } else {
                            passRecord.setEnter_plate_source(2);
                            passRecord.setEnter_plate_modify_time(passTime);
                            passRecord.setEnter_plate_modify_user_name(passRecord.getEnter_duty_user_name());
                        }
                    } else if (passRecord.getEnter_reg_plate() != null && passRecord.getEnter_reg_plate().length() > 0) {
                        if (passRecord.getEnter_plate().equals(passRecord.getEnter_reg_plate())) {
                            passRecord.setEnter_plate_source(0);
                        } else if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                            passRecord.setEnter_plate_source(2);
                            passRecord.setEnter_plate_modify_time(passTime);
                            passRecord.setEnter_plate_modify_user_name(passRecord.getEnter_duty_user_name());
                        } else {
                            passRecord.setEnter_plate_source(4);
                        }
                    }
                }
                if (localHost != null) {
                    passRecord.setEnter_host_no(localHost.getHost_no());
                    passRecord.setEnter_host_name(localHost.getHost_name());
                }
                passRecord.setEnter_lan_state(this.getLanState(session));
                if (plateRecognizedEvent != null) {
                    passRecord.setEnter_car_pic(plateRecognizedEvent.getPicDBPath());
                    passRecord.setEnter_plate_pic(plateRecognizedEvent.getPicDBSmallPath());
                }
                if (session.getReadPassportNumberEvent() != null && (capList = session.getReadPassportNumberEvent().getCaptures()) != null && !capList.isEmpty()) {
                    RecordSaveService rService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    for (CaptureEvent cevent : capList) {
                        if (cevent.getPicture_use() == 1) {
                            if (passRecord.getEnter_car_pic() != null && passRecord.getEnter_car_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x6 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x6 == null || x6 != 0) continue;
                                    passRecord.setEnter_car_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                passRecord.setEnter_car_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x6) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 4) {
                            if (passRecord.getEnter_face_pic() != null && passRecord.getEnter_face_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x7 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x7 == null || x7 != 0) continue;
                                    passRecord.setEnter_face_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                passRecord.setEnter_face_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x7) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 2) {
                            if (passRecord.getEnter_car_trail_pic() != null && passRecord.getEnter_car_trail_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                                if (cevent.getCaptureHandle().isDone()) {
                                    Integer x8 = (Integer)cevent.getCaptureHandle().getResult();
                                    if (x8 == null || x8 != 0) continue;
                                    passRecord.setEnter_car_trail_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                    continue;
                                }
                                dispathServerTimeMills = 6000L;
                                passRecord.setEnter_car_trail_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                            }
                            catch (Exception x8) {}
                            continue;
                        }
                        if (cevent.getPicture_use() != 16 || passRecord.getEnter_car_body_pic() != null && passRecord.getEnter_car_body_pic().length() != 0) continue;
                        try {
                            if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled()) continue;
                            if (cevent.getCaptureHandle().isDone()) {
                                Integer x = (Integer)cevent.getCaptureHandle().getResult();
                                if (x == null || x != 0) continue;
                                passRecord.setEnter_car_body_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                                continue;
                            }
                            dispathServerTimeMills = 6000L;
                            passRecord.setEnter_car_body_pic(rService.getDbPicPath(cevent.getImgLocalPath()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 2) {
                    passRecord.setEnter_valid_date(session.getPassport().getDeadline());
                }
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 1) {
                    passRecord.setEnter_balance(session.getPassport().getBalance());
                }
                passRecord.setPass_state_value(pass_state_value);
                int state = 0;
                if (exceptionValueSet.contains(2)) {
                    state = 5;
                } else if (passRecord.getEnter_plate_source() != null) {
                    if (passRecord.getEnter_plate_source() == 1) {
                        state = 3;
                    } else if (passRecord.getEnter_plate_source() == 2) {
                        state = 4;
                    } else if (passRecord.getEnter_plate_source() == 5) {
                        state = 7;
                    }
                }
                if (session.getAttribute("SAVE_PASS_STATE") != null) {
                    passRecord.setRecord_state((Integer)session.getAttribute("SAVE_PASS_STATE"));
                } else if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                    passRecord.setRecord_state(31);
                } else {
                    passRecord.setRecord_state(state);
                }
                passRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                passRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                passRecord.setPass_channel_no(passRecord.getEnter_channel_no());
                passRecord.setPass_duty_user_code(passRecord.getEnter_duty_user_code());
                passRecord.setPass_host_no(passRecord.getEnter_host_no());
                passRecord.setPass_car_type_no(passRecord.getEnter_car_type_no());
                if (passRecord.getEnter_car_pic() != null && passRecord.getEnter_car_pic().length() > 0) {
                    dispatchPicPaths.add(passRecord.getEnter_car_pic());
                }
                if (passRecord.getEnter_plate_pic() != null && passRecord.getEnter_plate_pic().length() > 0) {
                    dispatchPicPaths.add(passRecord.getEnter_plate_pic());
                }
                if (passRecord.getEnter_face_pic() != null && passRecord.getEnter_face_pic().length() > 0) {
                    dispatchPicPaths.add(passRecord.getEnter_face_pic());
                }
                passRecordList.add(passRecord);
            }
        }
        LinkedList<CarparkTransaction> trasactionList = null;
        LinkedList<CarparkDiscountRecord> dicountRecordList = null;
        LinkedList<CommonParam> updateList = null;
        CarparkTransaction deductTansaction = null;
        if (cost != null) {
            if (rootExitRecord != null) {
                List<CarparkPassDiscount> pList;
                CarparkTransaction t;
                if (cost.getCash() != null && cost.getCash().doubleValue() > 0.0) {
                    if (trasactionList == null) {
                        trasactionList = new LinkedList<CarparkTransaction>();
                    }
                    t = SavePassDataFilter.createCarparkTransaction(rootExitRecord, cost, cost.getCash(), 0);
                    trasactionList.add(t);
                }
                if (cost.getDeduct_money() != null && cost.getDeduct_money().doubleValue() > 0.0) {
                    if (trasactionList == null) {
                        trasactionList = new LinkedList();
                    }
                    t = SavePassDataFilter.createCarparkTransaction(rootExitRecord, cost, cost.getDeduct_money(), 1);
                    trasactionList.add(t);
                    deductTansaction = t;
                }
                if ((pList = cost.getDiscountList()) != null && !pList.isEmpty()) {
                    for (CarparkPassDiscount carparkPassDiscount : pList) {
                        if (carparkPassDiscount.getId() == null) {
                            if (dicountRecordList == null) {
                                dicountRecordList = new LinkedList<CarparkDiscountRecord>();
                            }
                            CarparkDiscountRecord rd = (CarparkDiscountRecord)new JavaBeanMap((Object)new JavaBeanMap((Object)carparkPassDiscount).toMap()).toJavaBean(CarparkDiscountRecord.class);
                            rd.setPassport_type_no(rootExitRecord.getPassport_no());
                            rd.setPassport_type_name(rootExitRecord.getPassport_type_name());
                            rd.setCertificate_pic(rootExitRecord.getCertificate_pic());
                            rd.setExit_time(rootExitRecord.getExit_time());
                            rd.setExit_record_no(rootExitRecord.getExit_record_no());
                            rd.setDiscount_amount(carparkPassDiscount.getDiscount_amount());
                            rd.setCreated_time(ServiceUtil.getNow());
                            long rdId = appService.createLocalRecordSeq("ck_carpark_discount_record_seq");
                            rd.setId(rdId);
                            rd.setDiscount_no("C" + rdId);
                            dicountRecordList.add(rd);
                            continue;
                        }
                        if (carparkPassDiscount.getDiscount_method() != null && carparkPassDiscount.getDiscount_method() == 3) {
                            if (carparkPassDiscount.getDiscount_amount() == null || !(carparkPassDiscount.getDiscount_amount().doubleValue() > 0.0)) continue;
                            if (dicountRecordList == null) {
                                dicountRecordList = new LinkedList();
                            }
                            CarparkDiscountRecord rd = (CarparkDiscountRecord)new JavaBeanMap((Object)new JavaBeanMap((Object)carparkPassDiscount).toMap()).toJavaBean(CarparkDiscountRecord.class);
                            rd.setPassport_type_no(rootExitRecord.getPassport_no());
                            rd.setPassport_type_name(rootExitRecord.getPassport_type_name());
                            rd.setCertificate_pic(rootExitRecord.getCertificate_pic());
                            rd.setExit_time(rootExitRecord.getExit_time());
                            rd.setExit_record_no(rootExitRecord.getExit_record_no());
                            if (rootExitRecord.getEnter_time() != null) {
                                rd.setEnter_record_no(rootExitRecord.getEnter_record_no());
                                rd.setEnter_time(rootExitRecord.getEnter_time());
                            }
                            rd.setDiscount_amount(carparkPassDiscount.getDiscount_amount());
                            long rdId = appService.createLocalRecordSeq("ck_carpark_discount_record_seq");
                            rd.setId(rdId);
                            rd.setDiscount_no("C" + rdId);
                            rd.setDiscount_method(0);
                            rd.setDiscount_value((int)(carparkPassDiscount.getDiscount_amount().doubleValue() * 100.0));
                            String v = String.valueOf(rd.getDiscount_value_des()) + "(\u672c\u6b21\u4f18\u60e0:" + carparkPassDiscount.getDiscount_amount() + ")";
                            rd.setDiscount_value_des(ServiceUtil.getString(v, 100));
                            rd.setCreated_time(ServiceUtil.getNow());
                            rd.setDiscount_time(rootExitRecord.getExit_time() == null ? rd.getCreated_time() : rootExitRecord.getExit_time());
                            dicountRecordList.add(rd);
                            continue;
                        }
                        if (updateList == null) {
                            updateList = new LinkedList<CommonParam>();
                        }
                        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkDiscountRecord.class));
                        CarparkDiscountRecord dsr = (CarparkDiscountRecord)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"id", "discount_no"}).addEQ("discount_no", (Object)carparkPassDiscount.getDiscount_no()).addEQ("carpark_id", (Object)carparkPassDiscount.getCarpark_id()), CarparkDiscountRecord.class);
                        if (dsr != null && dsr.getId() != null && carparkPassDiscount.getId() != null && carparkPassDiscount.getId().longValue() != dsr.getId().longValue()) {
                            carparkPassDiscount.setId(dsr.getId());
                        }
                        updateP.addEQ("id", (Object)carparkPassDiscount.getId());
                        updateP.addUpdate("exit_time", (Object)rootExitRecord.getExit_time());
                        updateP.addUpdate("exit_record_no", (Object)rootExitRecord.getExit_record_no());
                        updateP.addUpdate("discount_amount", (Object)(carparkPassDiscount.getDiscount_amount() == null ? Constants.MONEY_ZERO : carparkPassDiscount.getDiscount_amount()));
                        updateP.addUpdate("passport_type_no", (Object)rootExitRecord.getPassport_no());
                        updateP.addUpdate("passport_type_name", (Object)rootExitRecord.getPassport_type_name());
                        updateList.add(updateP);
                        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDiscountRecord.class), carparkPassDiscount.getId().toString(), "ALL_HOSTS"));
                    }
                }
            } else {
                CarparkEscapeOrder escapOrder = (CarparkEscapeOrder)session.getAttribute("ESCAPE_ORDER");
                if (escapOrder != null && cost.getCash() != null && cost.getCash().doubleValue() > 0.0) {
                    if (trasactionList == null) {
                        trasactionList = new LinkedList();
                    }
                    CarparkTransaction carparkTransaction = this.createArrearageTransaction(escapOrder, cost, cost.getCash(), 0, session);
                    trasactionList.add(carparkTransaction);
                    CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkEscapeOrder.class));
                    updateP.addEQ("passport_number", (Object)escapOrder.getPassport_number());
                    updateP.addEQ("exit_time", (Object)escapOrder.getExit_time());
                    updateP.addEQ("medium_type", (Object)escapOrder.getMedium_type());
                    updateP.addEQ("area_no", (Object)escapOrder.getArea_no());
                    updateP.addEQ("carpark_id", (Object)escapOrder.getCarpark_id());
                    updateP.addEQ("exit_record_no", (Object)escapOrder.getExit_record_no());
                    updateP.addUpdate("order_pay_time", (Object)carparkTransaction.getTran_time());
                    updateP.addUpdate("order_pay_method", (Object)carparkTransaction.getPay_method());
                    updateP.addUpdate("order_pay_scene", (Object)carparkTransaction.getPay_scene());
                    updateP.addUpdate("order_charge_org", (Object)carparkTransaction.getCharge_org());
                    updateP.addUpdate("order_pay_entry", (Object)carparkTransaction.getPay_entry());
                    updateP.addUpdate("order_des", (Object)(String.valueOf(carparkTransaction.getOperate_user_name()) + "\u6536\u53d6\u73b0\u91d1\u653e\u884c"));
                    if (carparkTransaction.getOrder_no() != null) {
                        updateP.addUpdate("pay_order_no", (Object)carparkTransaction.getOrder_no());
                    }
                    updateP.addUpdate("tran_record_no", (Object)carparkTransaction.getTansaction_no());
                    updateP.addUpdate("order_pay_money", (Object)carparkTransaction.getTran_money());
                    updateP.addUpdate("order_state", (Object)1);
                    commonDaoService.update(updateP);
                }
            }
        }
        if (dispatchPicPaths != null && !dispatchPicPaths.isEmpty()) {
            for (String path : dispatchPicPaths) {
                if (picAlreadyDispathPaths != null && picAlreadyDispathPaths.contains(path)) continue;
                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(path, "ALL_HOSTS_PC"));
            }
        }
        if (passRecordList != null && !passRecordList.isEmpty()) {
            tableName = commonDaoService.getTableName(CarparkPassRecord.class);
            for (CarparkPassRecord carparkPassRecord : passRecordList) {
                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(tableName, carparkPassRecord.getId().toString(), "ALL_HOSTS"));
            }
        }
        if (trasactionList != null && !trasactionList.isEmpty()) {
            tableName = commonDaoService.getTableName(CarparkTransaction.class);
            for (CarparkTransaction carparkTransaction : trasactionList) {
                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(tableName, carparkTransaction.getId().toString(), "ALL_HOSTS"));
            }
        }
        if (dicountRecordList != null && !dicountRecordList.isEmpty()) {
            tableName = commonDaoService.getTableName(CarparkDiscountRecord.class);
            for (CarparkDiscountRecord carparkDiscountRecord : dicountRecordList) {
                dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(tableName, carparkDiscountRecord.getId().toString(), "ALL_HOSTS"));
            }
        }
        SavePassData saveData = new SavePassData(passRecordList, deductTansaction, trasactionList, (List<CarparkDiscountRecord>)dicountRecordList, dispatchTaskList, dispathServerTimeMills, regPlateTaskList);
        saveData.setUpdateList(updateList);
        this.setSaveDataValue(saveData, session);
        return saveData;
    }

    protected void setSaveDataValue(SavePassData saveData, PassSession session) {
        SavePassDataFilterInterceptor iner = (SavePassDataFilterInterceptor)session.getAttribute(SavePassDataFilterInterceptor.class.getName());
        if (iner != null) {
            iner.onSetSaveDataValue(saveData, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doSaveSessionData(PassSession session) throws Exception {
        String msg;
        RecordSaveService recordSaveService;
        CommonDaoService commonDaoService;
        LinkedList<CarparkDispatchTask> regPlateTaskList;
        long dispathServerTimeMills;
        LinkedList<CarparkDispatchTask> dispatchTaskList;
        List<CommonParam> updateList;
        List<CarparkDiscountRecord> dicountRecordList;
        List<CarparkTransaction> trasactionList;
        CarparkTransaction deductTansaction;
        List<CarparkPassRecord> passRecordList;
        block88: {
            String systemDefaultTempCartypeNo;
            SavePassData saveData = this.createSavePassData(session);
            passRecordList = saveData.getPassRecordList();
            deductTansaction = saveData.getDeductTansaction();
            trasactionList = saveData.getTrasactionList();
            dicountRecordList = saveData.getDicountRecordList();
            updateList = saveData.getUpdateList();
            LinkedList<CarparkDispatchTask> dispatchTaskList0 = saveData.getDispatchTaskList();
            if (dispatchTaskList0 == null) {
                dispatchTaskList0 = new LinkedList();
            }
            dispatchTaskList = dispatchTaskList0;
            dispathServerTimeMills = saveData.getDispathServerTimeMills();
            regPlateTaskList = saveData.getRegPlateTaskList();
            commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            Cost cost = (Cost)session.getAttribute("pass_cost");
            if (cost == null) {
                cost = new Cost();
                cost.setShouldCharged(Constants.MONEY_ZERO);
                cost.getActualCharge();
            }
            if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                String re = (String)session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH_REMARK");
                msg = re == null || re.length() == 0 ? "\u672a\u7ecf\u786e\u653e\u884c,\u4f46\u68c0\u6d4b\u5230\u8f66\u8f86\u901a\u8fc7\u95f8\u673a" : re;
            } else {
                String payx = "";
                if (cost.getCash().doubleValue() > 0.0) {
                    payx = "\u6536\u73b0\u91d1";
                } else if (cost.getDeduct_money().doubleValue() > 0.0) {
                    payx = "\u50a8\u503c\u8f66\u6263\u8d39";
                } else if (cost.getAlready_paid_method() != null && cost.getAlready_paid_scene() != null && cost.getAlready_paid().doubleValue() > 0.0) {
                    payx = cost.getAlready_paid_scene() == 5 ? (cost.getAlready_paid_method() == 6 ? "ETC\u6263\u8d39" : "\u65e0\u611f\u652f\u4ed8") : (cost.getAlready_paid_scene() == 2 ? (session.getAttribute("GUI_OK") != null ? "\u7535\u8111\u626b\u7801\u67aa" : "\u8f66\u9053\u626b\u7801\u67aa") : (cost.getAlready_paid_scene() == 3 ? (session.getAttribute("SELF_PAY_PASS") != null ? "\u8f66\u9053\u5904\u81ea\u52a9\u7f34\u8d39" : (cost.getAlready_paid_method() == 0 ? "\u4e2d\u592e\u6536\u8d39" : "\u573a\u5185\u81ea\u52a9\u7f34\u8d39")) : (cost.getAlready_paid_method() == 7 ? "\u5546\u5bb6\u4ee3\u4ed8" : "\u573a\u5185\u81ea\u52a9\u7f34\u8d39")));
                } else if (cost.getDiscountMoney().doubleValue() > 0.0) {
                    payx = "\u6298\u6263\u4f18\u60e0";
                }
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                    msg = "\u4eba\u5de5\u8f93\u5165\u8f66\u724c\u653e\u884c";
                    if (payx.length() > 0) {
                        msg = String.valueOf(msg) + "," + payx;
                    }
                } else if (session.getAttribute("CONFIRMDIALOG") != null || session.getAttribute("SESSION_WAITPING") != null) {
                    void var18_22;
                    String string = "";
                    if (session.getReadPassportNumberEvent() != null) {
                        if (session.getReadPassportNumberEvent().isUserScan()) {
                            String string2 = "\u8f66\u4e3b\u626b\u7801";
                        } else if (session.getPlateRecognizedEvent() != null) {
                            String string3 = "\u8f66\u724c\u8bc6\u522b";
                        } else {
                            String string4 = "";
                        }
                    } else {
                        String string5 = "";
                    }
                    msg = session.getAttribute("TIMEOUT_AUTO_PASS") != null ? String.valueOf(var18_22) + "\u5f39\u6846\u8d85\u65f6\u9ed8\u8ba4\u653e\u884c" : (session.getAttribute("CONTROL_BOX_OPEN_POLE") != null ? String.valueOf(var18_22) + "\u5f39\u6846\u9065\u63a7\u5668\u786e\u8ba4\u653e\u884c" : (session.getAttribute("THIRD_INVOKE_PASS") != null ? String.valueOf(var18_22) + "\u5f39\u6846APP\u786e\u8ba4\u653e\u884c" : (session.getAttribute("SELF_DISCOUNT_PASS") != null ? (payx.length() == 0 ? String.valueOf(var18_22) + "\u5f39\u6846\u81ea\u52a9\u6298\u6263\u653e\u884c" : String.valueOf(var18_22) + "\u5f39\u6846") : (session.getAttribute("GUI_OK") != null ? String.valueOf(var18_22) + "\u5f39\u6846\u503c\u73ed\u5458\u786e\u8ba4\u653e\u884c" : String.valueOf(var18_22) + "\u5f39\u6846"))));
                    if (payx.length() > 0) {
                        msg = String.valueOf(msg) + "," + payx;
                    }
                } else {
                    void var18_28;
                    String string = "";
                    if (session.getReadPassportNumberEvent() != null) {
                        if (session.getReadPassportNumberEvent().isUserScan()) {
                            String string6 = "\u8f66\u4e3b\u626b\u7801";
                        } else if (session.getPlateRecognizedEvent() != null) {
                            String string7 = "\u8f66\u724c\u8bc6\u522b";
                        } else {
                            String string8 = "";
                        }
                    } else {
                        String string9 = "";
                    }
                    msg = String.valueOf(var18_28) + "\u81ea\u52a8\u653e\u884c";
                    if (payx.length() > 0) {
                        msg = String.valueOf(msg) + "," + payx;
                    }
                }
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && (systemDefaultTempCartypeNo = (String)session.getAttribute("DEFAULT_SYSTEM_TEMP_CARTYPE_NO")) != null && systemDefaultTempCartypeNo.length() > 0 && session.getCarType() != null && session.getSessionState() == PassSession.SessionState.OPEN_DIALOG && !systemDefaultTempCartypeNo.equals(session.getCarType().getCar_type_no())) {
                try {
                    int arc;
                    String string = session.getPassPlate();
                    if (string == null || string.length() <= 6 || string.length() >= 10) break block88;
                    Object vrese = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MEND_CAR_TYPE_MERMERY_DAYS");
                    if (vrese == null || ((String)vrese).length() == 0) {
                        vrese = "180";
                    }
                    try {
                        arc = Integer.parseInt((String)vrese);
                        if (arc < 0) {
                            arc = 0;
                        } else if (arc > 365) {
                            arc = 365;
                        }
                    }
                    catch (Exception ex) {
                        arc = 0;
                    }
                    if (arc <= 0) break block88;
                    String lockkey = "handleMpdofyPlateCarType_" + string;
                    KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
                    Object lock = keyLockManager.getLock(lockkey);
                    Date opTime = ServiceUtil.getNow();
                    try {
                        Object object = lock;
                        synchronized (object) {
                            CarparkPlateCarType platecarType = (CarparkPlateCarType)commonDaoService.selectOne(new SearchParam().addEQ("plate_number", (Object)string), CarparkPlateCarType.class);
                            if (platecarType == null) {
                                platecarType = new CarparkPlateCarType();
                                platecarType.setCar_type_no(session.getCarType().getCar_type_no());
                                platecarType.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                                platecarType.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                long plateCarTypeid = appService.createLocalRecordSeq("ck_carpark_plate_car_type_seq");
                                platecarType.setId(plateCarTypeid);
                                platecarType.setLast_updated_time(opTime);
                                platecarType.setPlate_number(string);
                                commonDaoService.insert((Object)platecarType);
                            } else {
                                Date d = platecarType.getLast_updated_time();
                                if (d == null || d.getTime() <= opTime.getTime()) {
                                    CommonParam p = new CommonParam(commonDaoService.getTableName(CarparkPlateCarType.class));
                                    p.addEQ("plate_number", (Object)string);
                                    p.addUpdate("last_updated_time", (Object)opTime);
                                    p.addUpdate("car_type_no", (Object)session.getCarType().getCar_type_no());
                                    commonDaoService.update(p);
                                }
                            }
                        }
                    }
                    finally {
                        keyLockManager.releaseLock(lock);
                    }
                    HashMap<String, String> pMap = new HashMap<String, String>();
                    pMap.put("car_type_no", session.getCarType().getCar_type_no());
                    pMap.put("plate_number", string);
                    pMap.put("last_updated_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(opTime));
                    String json_data = GsonBuilder.create().toJson(pMap);
                    String serviceName = "transferDataService.syncLocalCartypeMer";
                    dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchTaskList(serviceName, json_data, "ALL_HOSTS"));
                }
                catch (Exception exception) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)exception);
                }
            }
        }
        try (SqlSession sqlsession = commonDaoService.openSqlSession();){
            try {
                Long l;
                if (passRecordList != null && !passRecordList.isEmpty()) {
                    for (CarparkPassRecord carparkPassRecord : passRecordList) {
                        if (msg != null) {
                            if (carparkPassRecord.getExit_time() != null) {
                                String exit_remark0 = carparkPassRecord.getExit_remark();
                                if (exit_remark0 != null && exit_remark0.length() > 0) {
                                    carparkPassRecord.setExit_remark(ServiceUtil.getDBString(String.valueOf(exit_remark0) + "," + msg, 100));
                                } else {
                                    carparkPassRecord.setExit_remark(msg);
                                }
                            } else {
                                String enter_remark0 = carparkPassRecord.getEnter_remark();
                                if (enter_remark0 != null && enter_remark0.length() > 0) {
                                    carparkPassRecord.setEnter_remark(ServiceUtil.getString(String.valueOf(enter_remark0) + "," + msg, 100));
                                } else {
                                    carparkPassRecord.setEnter_remark(msg);
                                }
                            }
                        }
                        commonDaoService.insert(sqlsession, (Object)carparkPassRecord);
                        recordSaveService.handlePresenceRecord(sqlsession, carparkPassRecord);
                        recordSaveService.onAddPassRecord(sqlsession, carparkPassRecord, false);
                    }
                }
                if (deductTansaction != null) {
                    recordSaveService.deductMoney(sqlsession, deductTansaction);
                }
                if (trasactionList != null && !trasactionList.isEmpty()) {
                    for (CarparkTransaction carparkTransaction : trasactionList) {
                        if (msg != null) {
                            String res = carparkTransaction.getTran_des();
                            if (res == null || res.length() == 0) {
                                carparkTransaction.setTran_des(msg);
                            } else {
                                carparkTransaction.setTran_des(ServiceUtil.getString(String.valueOf(res) + "," + msg, 200));
                            }
                        }
                        commonDaoService.insert(sqlsession, (Object)carparkTransaction);
                    }
                }
                if (dicountRecordList != null && !dicountRecordList.isEmpty()) {
                    for (CarparkDiscountRecord carparkDiscountRecord : dicountRecordList) {
                        commonDaoService.insert(sqlsession, (Object)carparkDiscountRecord);
                    }
                }
                if (updateList != null && !updateList.isEmpty()) {
                    for (CommonParam commonParam : updateList) {
                        commonDaoService.update(sqlsession, commonParam);
                    }
                }
                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                    for (CarparkDispatchTask carparkDispatchTask : dispatchTaskList) {
                        commonDaoService.insert(sqlsession, (Object)carparkDispatchTask);
                    }
                }
                if ((l = session.getSaveDataCacheId()) != null) {
                    commonDaoService.delete(sqlsession, new SearchParam(commonDaoService.getTableName(CarparkLocalPassDataCache.class)).addEQ("id", (Object)l));
                }
                try {
                    ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
                    if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                        int rema = ParkingSpace.getInstance().getRemainSpace(channelArea.getEnterAreas().get(0).getArea_no());
                        session.setAttribute("SAVE_PASS_BEFORE_REMIAN_SPACE", rema);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sqlsession.commit();
            }
            catch (Exception exception) {
                sqlsession.rollback();
                throw exception;
            }
        }
        if (session.getSaveDataCacheId() != null) {
            session.setSaveDataCacheId(null);
        }
        session.setAttribute("SAVED_PASSRECORD_LIST", passRecordList);
        session.setAttribute("SAVED_PASSRECORD_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
        if (session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null && session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
            try {
                PassSession.SessionStateChangeListener sessionStateChangeListener = (PassSession.SessionStateChangeListener)session.removeAttribute("DisplayVoiceServiceImpl.clearDisplayMessageSessionStateChangeListener");
                if (sessionStateChangeListener != null) {
                    sessionStateChangeListener.sessionStateChanged(session, PassSession.SessionState.OPEN_DIALOG, PassSession.SessionState.CANCELED);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        session.setSessionState(PassSession.SessionState.WAIT_CAR_LEAVE);
        if (regPlateTaskList != null && !regPlateTaskList.isEmpty()) {
            CarparkDispatchTask carparkDispatchTask;
            while ((carparkDispatchTask = regPlateTaskList.pollLast()) != null) {
                dispatchTaskList.offerFirst(carparkDispatchTask);
            }
        }
        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
            if (dispathServerTimeMills > 0L) {
                ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                            appService.asynTryRunDispatchTask(dispatchTaskList);
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                    }
                }, dispathServerTimeMills, TimeUnit.MILLISECONDS);
            } else {
                ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                applicationService.asynTryRunDispatchTask(dispatchTaskList);
            }
        }
    }

    public CarparkTransaction createArrearageTransaction(CarparkEscapeOrder r, Cost cost, BigDecimal tranMoney, int payMethod, PassSession session) {
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        CarparkTransaction t = new CarparkTransaction();
        long tranId = appService.createLocalRecordSeq("ck_carpark_transaction_seq");
        t.setId(tranId);
        t.setTansaction_no("C" + t.getId().toString());
        t.setTran_type(0);
        t.setService_type(0);
        t.setPlate_number(r.getPass_plate());
        t.setPassport_no(r.getPassport_no());
        t.setPassport_number(r.getPassport_number());
        t.setMedium_type(r.getMedium_type());
        t.setPass_type(r.getPass_type());
        t.setPassport_type_no(r.getPassport_type_no());
        t.setPassport_type_name(r.getPassport_type_name());
        t.setCar_type_no(r.getExit_car_type_no());
        t.setCar_type_name(r.getExit_car_type_name());
        t.setTran_money(tranMoney);
        t.setTran_time(ServiceUtil.getNow());
        t.setPay_method(payMethod);
        t.setPay_scene(0);
        t.setCharge_org(0);
        t.setPay_entry(0);
        t.setTran_area_no(r.getArea_no());
        t.setTran_area_name(r.getArea_name());
        t.setTran_user_no(r.getCar_owner_no());
        t.setTran_user_name(r.getCar_owner_name());
        t.setEnter_record_no(r.getEnter_record_no());
        t.setEnter_time(r.getEnter_time());
        t.setShould_charge(cost.getShouldCharged());
        t.setDiscount_money(cost.getDiscountMoney());
        t.setAlready_paid(cost.getAlready_paid());
        t.setPeriod_multi_free(cost.getPeriod_multi_free());
        t.setCreated_time(t.getTran_time());
        t.setCarpark_id(r.getCarpark_id());
        t.setProject_id(r.getProject_id());
        t.setExit_time(r.getExit_time());
        UserSession userSession = appService.getUserSession();
        if (userSession != null) {
            if (userSession.getDutyNumber() != null) {
                t.setDuty_no(userSession.getDutyNumber().getDuty_no());
            } else {
                t.setDuty_no("0");
            }
            if (userSession.getUser() != null) {
                t.setOperate_user_code(userSession.getUser().getUser_code());
                t.setOperate_user_name(userSession.getUser().getUser_name());
            } else {
                t.setOperate_user_code("admin");
                t.setOperate_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
            }
        } else {
            t.setDuty_no("0");
            t.setOperate_user_code("admin");
            t.setOperate_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
        }
        t.setTran_channel_no(session.getPassChannel().getChannelNo());
        t.setTran_channel_name(session.getPassChannel().getChannel().getChannel_name());
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost != null) {
            t.setHost_no(localHost.getHost_no());
            t.setHost_name(localHost.getHost_name());
        }
        t.setTran_des("\u505c\u8f66\u8d39\u8ffd\u7f34");
        if (t.getExit_time() != null) {
            t.setTran_des(String.valueOf(t.getTran_des()) + ",\u8ffd\u7f34\u8ba2\u5355(\u79bb\u573a)\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(t.getExit_time()));
        }
        t.setOrder_no("WLARAG_" + r.getExit_record_no());
        return t;
    }

    public static CarparkTransaction createCarparkTransaction(CarparkPassRecord r, Cost cost, BigDecimal tranMoney, int payMethod) {
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        CarparkTransaction t = new CarparkTransaction();
        long tranId = appService.createLocalRecordSeq("ck_carpark_transaction_seq");
        t.setId(tranId);
        t.setTansaction_no("C" + t.getId().toString());
        t.setTran_type(0);
        t.setService_type(0);
        t.setPlate_number(r.getPass_plate());
        t.setPassport_no(r.getPassport_no());
        t.setPassport_number(r.getPassport_number());
        t.setMedium_type(r.getMedium_type());
        t.setPass_type(r.getPass_type());
        t.setPassport_type_no(r.getPassport_type_no());
        t.setPassport_type_name(r.getPassport_type_name());
        t.setCar_type_no(r.getExit_car_type_no());
        t.setCar_type_name(r.getExit_car_type_name());
        t.setOrder_no(t.getTansaction_no());
        t.setTran_money(tranMoney);
        t.setTran_des("\u79bb\u573a\u7f34\u8d39");
        t.setTran_time(ServiceUtil.getNow());
        t.setPay_method(payMethod);
        t.setPay_scene(0);
        t.setCharge_org(0);
        t.setPay_entry(0);
        t.setTran_area_no(r.getArea_no());
        t.setTran_area_name(r.getArea_name());
        t.setTran_channel_no(r.getExit_channel_no());
        t.setTran_channel_name(r.getExit_channel_name());
        t.setTran_user_no(r.getCar_owner_no());
        t.setTran_user_name(r.getCar_owner_name());
        t.setDuty_no(r.getExit_duty_no());
        t.setEnter_record_no(r.getEnter_record_no());
        t.setEnter_time(r.getEnter_time());
        t.setOperate_user_code(r.getExit_duty_user_code());
        t.setOperate_user_name(r.getExit_duty_user_name());
        t.setShould_charge(cost.getShouldCharged());
        t.setDiscount_money(cost.getDiscountMoney());
        t.setAlready_paid(cost.getAlready_paid());
        t.setPeriod_multi_free(cost.getPeriod_multi_free());
        t.setHost_no(r.getExit_host_no());
        t.setHost_name(r.getExit_host_name());
        t.setCreated_time(t.getTran_time());
        t.setCarpark_id(r.getCarpark_id());
        t.setProject_id(r.getProject_id());
        t.setExit_time(r.getExit_time());
        try {
            if (t.getExit_time() != null && t.getExit_time().after(t.getTran_time())) {
                SimpleDateFormat v4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String v2 = v4.format(t.getTran_time());
                t.setTran_time(t.getExit_time());
                String v1 = "\u79bb\u573a\u7f34\u8d39,\u53ef\u80fd\u5b58\u5728\u5f39\u6846\u6536\u8d39\u65f6\u6539\u65f6\u95f4\u786e\u8ba4,\u5f53\u65f6\u7cfb\u7edf\u65f6\u95f4:" + v2;
                t.setTran_des(v1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public int getLanState(PassSession session) {
        List<Equipment> camearas;
        int lanState = 0;
        if (session.getReadPassportNumberEvent().isManualTrigger() && (camearas = session.getPassChannel().getPlateRegCameras()) != null && !camearas.isEmpty()) {
            boolean acc = true;
            for (Equipment e : camearas) {
                if (e.getEquipmentAction().isWorkingProperly()) continue;
                acc = false;
                break;
            }
            if (!acc) {
                lanState = 1;
            }
        }
        if (lanState == 0) {
            lanState = SavePassDataFilter.getLanState0();
        }
        return lanState;
    }

    public static int getLanState0() {
        int lanState;
        block14: {
            CarparkHost localHost;
            block15: {
                boolean discnectServer;
                block16: {
                    lanState = 0;
                    localHost = ServiceUtil.getServiceContext().getLocalHost();
                    if (localHost == null) break block14;
                    if (localHost.getHost_use() != 1) break block15;
                    boolean existDishost = false;
                    discnectServer = false;
                    Map<String, CarparkChannel> chMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
                    Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                    if (hostMap != null) {
                        block0: for (CarparkHost host : hostMap.values()) {
                            if (localHost.getHost_no().equals(host.getHost_no())) continue;
                            if (host.getHost_use() == 1) {
                                if (existDishost) continue;
                                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                                    if (ServiceUtil.getServiceContext().isHostOnline(host.getHost_no()) || chMap == null || chMap.isEmpty()) continue;
                                    for (CarparkChannel ch : chMap.values()) {
                                        if (ch.getManaged_host_no() != null && ch.getManaged_host_no().equals(host.getHost_no())) {
                                            if (ch.getSlave_managed_host_no() != null && ch.getSlave_managed_host_no().length() > 0 && hostMap.get(ch.getSlave_managed_host_no()) != null) {
                                                if (ServiceUtil.getServiceContext().isHostOnline(ch.getSlave_managed_host_no())) continue;
                                                existDishost = true;
                                                continue block0;
                                            }
                                            existDishost = true;
                                            continue block0;
                                        }
                                        if (ch.getSlave_managed_host_no() == null || !ch.getSlave_managed_host_no().equals(host.getHost_no())) continue;
                                        if (ch.getManaged_host_no() != null && ch.getManaged_host_no().length() > 0 && hostMap.get(ch.getManaged_host_no()) != null) {
                                            if (ServiceUtil.getServiceContext().isHostOnline(ch.getManaged_host_no())) continue;
                                            existDishost = true;
                                            continue block0;
                                        }
                                        existDishost = true;
                                        continue block0;
                                    }
                                    continue;
                                }
                                if (ServiceUtil.getServiceContext().isConected(host.getHost_no()) || ServiceUtil.getServiceContext().isConected(host.getHost_no()) || chMap == null || chMap.isEmpty()) continue;
                                for (CarparkChannel ch : chMap.values()) {
                                    if (ch.getManaged_host_no() == null || !ch.getManaged_host_no().equals(host.getHost_no())) continue;
                                    existDishost = true;
                                    continue block0;
                                }
                                continue;
                            }
                            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                                if (ServiceUtil.getServiceContext().isHostOnline(host.getHost_no())) continue;
                                discnectServer = true;
                                if (host.getHost_use() != 3) continue;
                                existDishost = true;
                                continue;
                            }
                            if (ServiceUtil.getServiceContext().isConected(host.getHost_no())) continue;
                            discnectServer = true;
                            if (host.getHost_use() != 3) continue;
                            existDishost = true;
                        }
                    }
                    if (!existDishost) break block16;
                    lanState = 3;
                    break block14;
                }
                if (!discnectServer) break block14;
                lanState = 2;
                break block14;
            }
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            if (hostMap != null) {
                Map<String, CarparkChannel> chMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
                for (CarparkHost host : hostMap.values()) {
                    if (localHost.getHost_no().equals(host.getHost_no()) || ServiceUtil.getServiceContext().isConected(host.getHost_no())) continue;
                    boolean existDishost = false;
                    if (chMap != null && !chMap.isEmpty()) {
                        for (CarparkChannel ch : chMap.values()) {
                            if (ch.getManaged_host_no() == null || !ch.getManaged_host_no().equals(host.getHost_no())) continue;
                            existDishost = true;
                            break;
                        }
                    }
                    if (!existDishost) continue;
                    lanState = 3;
                    break;
                }
            }
        }
        return lanState;
    }
}

