/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.pass.filter;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassFilter;
import com.wovoe.carpark.senseless.pay.WuhanChangSenselessPayer;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import java.util.HashMap;
import java.util.Map;

public class WuhanPlateCheckFilter
implements PassFilter {
    private static final String CAR_ENTER_CHANNEL_CHECK = "WUHAN_CAR_ENTER_CHANNEL_CHECK";
    private static final String SHARE_PASS_TYPE_NO = "WUHAN_SHARE_PASS_TYPE_NO";

    @Override
    public boolean doFilter(PassSession session) throws Exception {
        if (session.isTempSession()) {
            return true;
        }
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(session.getReadPassportNumberEvent().getPassportNumber())) {
            return true;
        }
        if (session.getSessionState() != PassSession.SessionState.PROCESSING) {
            return true;
        }
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        if (channelArea == null) {
            return true;
        }
        String plate = session.getPassPlate();
        if (plate == null || plate.length() != 7 && plate.length() != 8) {
            return true;
        }
        if (session.getPlateRecognizedEvent() == null) {
            return true;
        }
        if (!plate.equals(session.getPlateRecognizedEvent().getPlateNumber())) {
            return true;
        }
        String value = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(session.getPassportType().getPassport_type_no(), CAR_ENTER_CHANNEL_CHECK);
        if (value == null || value.length() == 0) {
            return true;
        }
        if (!"1".equals(value)) {
            return true;
        }
        if (!ServiceUtil.getServiceContext().isConnectedCloud()) {
            return true;
        }
        if (!ServiceUtil.getServiceContext().isSupportSenselessPay()) {
            return true;
        }
        Map<Integer, Map<String, String>> noSenceConfigMap0 = ServiceUtil.getServiceContext().getAllSenselessConfig();
        if (noSenceConfigMap0 == null || noSenceConfigMap0.isEmpty()) {
            return true;
        }
        if (!noSenceConfigMap0.containsKey(44)) {
            return true;
        }
        if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
            String RETURN_VALUE;
            String plateNo;
            block51: {
                String RETURN_CODE;
                DisplayVoiceService displayVoiceService;
                block50: {
                    CarparkPassportType passportType;
                    String shareValue;
                    Map<Object, Object> resultMap;
                    String carTypeName;
                    CarparkArea enterArea = channelArea.getEnterAreas().get(0);
                    if (enterArea.getArea_level() != 1) {
                        return true;
                    }
                    if (session.getAttribute("GUI_CONFIRM") != null || session.getAttribute("UNPAY_OR_UNCONFIRM_THROUGH") != null) {
                        return true;
                    }
                    plateNo = plate;
                    String plateType = null;
                    String plateType1 = PassChannel.getCarTypeString(plate, session.getPlateRecognizedEvent());
                    if (plateType1 != null && plateType1.length() > 0) {
                        if ("\u7eaf\u7535\u52a8\u5927\u8f66".equals(plateType1) || "\u6df7\u52a8\u5927\u8f66".equals(plateType1)) {
                            plateType = "51";
                        } else if ("\u7eaf\u7535\u52a8\u5c0f\u8f66".equals(plateType1) || "\u6df7\u52a8\u5c0f\u8f66".equals(plateType1) || "8\u4f4d\u6570\u8f66\u724c".equals(plateType1) || "\u7eff\u724c\u8f66".equals(plateType1)) {
                            plateType = "52";
                        } else if ("\u9ec4\u724c\u8f66".equals(plateType1)) {
                            plateType = "01";
                        }
                    }
                    if (plateType == null && (carTypeName = session.getCarType().getCar_type_name()) != null && (carTypeName.indexOf("\u5927\u8f66") != -1 || carTypeName.indexOf("\u5927\u578b\u8f66") != -1)) {
                        plateType = "01";
                    }
                    if (plateType == null) {
                        plateType = "02";
                    }
                    displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                    try {
                        displayVoiceService.displaySenselessPaying(session.getPassChannel(), plate, "\u6b63\u5728\u8bf7\u6c42\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u6821\u9a8c...");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("plateNo", plateNo);
                    paramMap.put("plateType", plateType);
                    CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
                    if (localhost == null) {
                        resultMap = new HashMap<String, String>();
                        resultMap.put("RETURN_CODE", "ERROR");
                        resultMap.put("RETURN_VALUE", "\u4e3b\u673a\u4e22\u5931");
                    } else if (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) {
                        resultMap = WuhanPlateCheckFilter.doServerWuhanPlateCheck(paramMap);
                    } else {
                        CarparkLocalConfig carparkLocalConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                        if (carparkLocalConfig.getCarpark_deploy_type() == 1) {
                            resultMap = WuhanPlateCheckFilter.doServerWuhanPlateCheck(paramMap);
                        } else {
                            CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
                            if (serverHost == null) {
                                resultMap = new HashMap();
                                resultMap.put("RETURN_CODE", "ERROR");
                                resultMap.put("RETURN_VALUE", "\u65e0\u6cd5\u627e\u5230\u505c\u8f66\u573a\u670d\u52a1\u5668");
                            } else {
                                RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
                                if (rpc == null) {
                                    resultMap = new HashMap();
                                    resultMap.put("RETURN_CODE", "ERROR");
                                    resultMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668");
                                } else {
                                    CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                                    resultMap = rpcService.wuhanPlateCheck(paramMap, new HashMap<String, Object>());
                                }
                            }
                        }
                    }
                    RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    RETURN_VALUE = (String)resultMap.get("RETURN_VALUE");
                    if (!"ALLOWPASS".equals(RETURN_CODE)) break block50;
                    ServiceLog.getLog().info((Object)("\u6b66\u6c49\u5e73\u53f0\u8fd4\u56de\uff1a" + plateNo + ", " + session.getPassportType().getPassport_type_name() + ", \u8f66\u8f86\u5141\u8bb8\u8fdb\u5165" + session.getPassChannel().getChannel().getChannel_name()));
                    if ("SHARECAR".equals(RETURN_VALUE) && (shareValue = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(session.getPassportType().getPassport_type_no(), SHARE_PASS_TYPE_NO)) != null && shareValue.length() > 0 && !"0".equals(shareValue) && !shareValue.equals(session.getPassportType().getPassport_type_no()) && (passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(shareValue)) != null) {
                        session.setPassportType(passportType);
                        session.getPassport().setPassport_type_no(passportType.getPassport_type_no());
                    }
                    return true;
                }
                if (!"FORBITPASS".equals(RETURN_CODE)) break block51;
                ServiceLog.getLog().info((Object)("\u6b66\u6c49\u5e73\u53f0\u8fd4\u56de\uff1a" + plateNo + ", " + session.getPassportType().getPassport_type_name() + ", \u8f66\u8f86\u7981\u6b62\u8fdb\u5165" + session.getPassChannel().getChannel().getChannel_name() + ", \u539f\u56e0\uff1a" + RETURN_VALUE));
                if (RETURN_VALUE == null || RETURN_VALUE.length() == 0) {
                    RETURN_VALUE = "\u6b66\u6c49\u667a\u6167\u505c\u8f66\u5e73\u53f0\u7981\u6b62\u6b64\u8f66\u8f86\u8fdb\u5165";
                }
                session.setAttribute("tipnoPermissionPassDetail", RETURN_VALUE);
                try {
                    displayVoiceService.noPermissionPass(session);
                }
                catch (Exception shareValue) {
                    // empty catch block
                }
                session.removeAttribute("tipnoPermissionPassDetail");
                String throwMsg = "\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u7981\u6b62\u4e86\u8f66\u8f86: " + plateNo + "\u5165\u573a\uff01\u8f66\u9053\uff1a " + session.getPassChannel().getChannel().getChannel_name();
                if (!"\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u7981\u6b62\u6b64\u8f66\u8f86\u8fdb\u5165".equals(RETURN_VALUE)) {
                    throwMsg = String.valueOf(throwMsg) + ", \u539f\u56e0: " + RETURN_VALUE;
                }
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, throwMsg, 4, 20000));
                return false;
            }
            try {
                ServiceLog.getLog().warn((Object)("\u8c03\u7528\u6b66\u6c49\u5e73\u53f0\u5224\u65ad\u662f\u5426\u5141\u8bb8\u5165\u573a\u5931\u8d25! \u8fd9\u5c06\u4e0d\u4f5c\u4e3a\u5224\u65ad\u4f9d\u636e\uff0c \u8f66\u724c: " + plateNo + ", " + session.getPassportType().getPassport_type_name() + ", \u8fdb\u573a\u8f66\u9053\uff1a" + session.getPassChannel().getChannel().getChannel_name() + ", \u539f\u56e0\uff1a" + RETURN_VALUE));
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u53bb\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u67e5\u8be2\u8f66\u8f86" + plate + "\u662f\u5426\u6709\u5165\u573a\u6743\u9650\u5f02\u5e38\uff01" + ex));
            }
        } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            CarparkPassportType passportType;
            String shareValue;
            Map areaPresenceRecordMap;
            CarparkPresenceRecord enterRecord;
            CarparkArea exitArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
            if (exitArea == null) {
                exitArea = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1);
            }
            if (exitArea.getArea_level() == 1 && (enterRecord = (CarparkPresenceRecord)(areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap")).get(exitArea.getArea_no())) != null && (shareValue = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(session.getPassportType().getPassport_type_no(), SHARE_PASS_TYPE_NO)) != null && shareValue.length() > 0 && !"0".equals(shareValue) && !shareValue.equals(session.getPassportType().getPassport_type_no()) && (passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(shareValue)) != null && shareValue.equals(enterRecord.getEnter_passport_type_no())) {
                session.setPassportType(passportType);
                session.getPassport().setPassport_type_no(passportType.getPassport_type_no());
            }
        } else {
            return true;
        }
        return true;
    }

    public static Map<String, Object> doServerWuhanPlateCheck(Map<String, Object> paramMap) {
        try {
            if (ServiceUtil.getServiceContext().getCloudContext() == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            if (ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            if (!ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            Map<String, String> config = ServiceUtil.getServiceContext().getSenselessConfig(44);
            if (config == null || config.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "CONFIG_ERROR");
                map.put("RETURN_VALUE", "\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u8bbe\u7f6e\u672a\u5b8c\u6210");
                return map;
            }
            String com_base_address = config.get("com_base_address");
            String platform_mch_id = config.get("platform_mch_id");
            String platform_secret_key = config.get("platform_secret_key");
            String parkpotId = config.get("parkpotId");
            if (com_base_address == null || com_base_address.length() == 0 || platform_mch_id == null || platform_mch_id.length() == 0 || platform_secret_key == null || platform_secret_key.length() == 0 || parkpotId == null || parkpotId.length() == 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "CONFIG_ERROR");
                map.put("RETURN_VALUE", "\u6b66\u6c49\u505c\u8f66\u5e73\u53f0\u914d\u7f6e\u672a\u5b8c\u6210");
                return map;
            }
            return WuhanChangSenselessPayer.checkPermission((String)paramMap.get("plateNo"), (String)paramMap.get("plateType"), config);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)"\u8c03\u7528\u6b66\u6c49\u5e73\u53f0\u5f02\u5e38", (Throwable)ex);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("RETURN_CODE", "ERROR");
            resultMap.put("RETURN_VALUE", "\u8c03\u7528\u5f02\u5e38");
            return resultMap;
        }
    }
}

